/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soehrr.business.domain.rpttpl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.sihc.soehrr.business.spread.command.BorderHlStyleCommand;
import kd.sdk.sihc.soehrr.business.spread.command.SaveSprJsonCommand;
import kd.sdk.sihc.soehrr.business.spread.command.abs.SpreadCommand;
import kd.sdk.sihc.soehrr.common.enums.AreaSettingEnum;
import kd.sdk.sihc.soehrr.common.enums.CallBackEnum;
import kd.sdk.sihc.soehrr.common.enums.CusExceptionEnum;
import kd.sdk.sihc.soehrr.common.enums.OperateEnum;
import kd.sdk.sihc.soehrr.common.report.dto.ReportCacheDto;
import kd.sdk.sihc.soehrr.common.report.invoker.CacheObjInvoker;
import kd.sdk.sihc.soehrr.common.report.invoker.ReportCacheInvoker;
import kd.sdk.sihc.soehrr.common.spread.RptAreaConf;
import kd.sdk.sihc.soehrr.common.spread.SheetManager;
import kd.sdk.sihc.soehrr.common.spread.SpreadModelParam;
import kd.sdk.sihc.soehrr.common.util.HrrQfilterUtils;
import kd.sihc.soehrr.business.domain.cache.RepCacheService;
import org.apache.commons.lang3.tuple.Pair;

public class RptTplService
extends HRBaseServiceHelper {
    private static final Log LOG = LogFactory.getLog(RptTplService.class);

    public RptTplService() {
        super("soehrr_rpttpl");
    }

    public void newNowEditEntry(DynamicObject rptTpl) {
        DynamicObjectCollection entryEntity = rptTpl.getDynamicObjectCollection("entryentity");
        DynamicObject nowEditEntry = this.getCurrentEntry(rptTpl);
        DynamicObject newVersionEntry = this.getNewVersionEntry(rptTpl);
        if (newVersionEntry != null && nowEditEntry.getLong("id") != newVersionEntry.getLong("id")) {
            nowEditEntry.set("isnowedit", (Object)false);
            nowEditEntry.set("isnewversion", (Object)true);
            newVersionEntry.set("isnewversion", (Object)false);
            nowEditEntry.set("auditdatetime", (Object)new Date());
        } else {
            nowEditEntry.set("isnowedit", (Object)false);
            nowEditEntry.set("isnewversion", (Object)true);
            nowEditEntry.set("auditdatetime", (Object)new Date());
        }
        DynamicObject newEntry = new DynamicObject(entryEntity.getDynamicObjectType());
        newEntry.set("isnewversion", (Object)false);
        newEntry.set("isnowedit", (Object)true);
        newEntry.set("samplejson_tag", (Object)nowEditEntry.getString("samplejson_tag"));
        newEntry.set("json_tag", (Object)nowEditEntry.getString("json_tag"));
        entryEntity.add((Object)newEntry);
        super.updateOne(rptTpl);
    }

    public long getCurrentEntryId(DynamicObject reportConf) {
        DynamicObject currentEntry = this.getCurrentEntry(reportConf);
        if (null == currentEntry) {
            return 0L;
        }
        return currentEntry.getLong("id");
    }

    public DynamicObject getCurrentEntry(DynamicObject reportConf) {
        if (null == reportConf) {
            return null;
        }
        DynamicObjectCollection entryEntity = reportConf.getDynamicObjectCollection("entryentity");
        for (DynamicObject entry : entryEntity) {
            boolean isCurrent = entry.getBoolean("isnowedit");
            if (!isCurrent) continue;
            return entry;
        }
        return null;
    }

    public DynamicObject getNewVersionEntry(DynamicObject reportConf) {
        if (null == reportConf) {
            return null;
        }
        DynamicObjectCollection entryEntity = reportConf.getDynamicObjectCollection("entryentity");
        for (DynamicObject entry : entryEntity) {
            boolean isCurrent = entry.getBoolean("isnewversion");
            if (!isCurrent) continue;
            return entry;
        }
        return null;
    }

    public String getCurrentJson(DynamicObject reportConf) {
        DynamicObject currentEntry = this.getCurrentEntry(reportConf);
        if (null == currentEntry) {
            return "";
        }
        return currentEntry.getString("json_tag");
    }

    public DynamicObject getEntryById(DynamicObject rptTpl, long rptEntryId) {
        if (null == rptTpl) {
            return null;
        }
        DynamicObjectCollection entryEntity = rptTpl.getDynamicObjectCollection("entryentity");
        for (DynamicObject entry : entryEntity) {
            if (entry.getLong("id") != rptEntryId) continue;
            return entry;
        }
        return null;
    }

    public void updRelationData(SpreadModelParam spreadModelParam, DynamicObject rptTpl, String mark) {
        SheetManager sheetManager = spreadModelParam.getSheetManager();
        try (TXHandle tx = TX.required();){
            try {
                CacheObjInvoker invoker = sheetManager.getInvoker();
                if (HRStringUtils.equals((String)mark, (String)"1")) {
                    rptTpl = RptTplService.getInstance().queryNowEntryEntity("json_tag", rptTpl.getLong("id"));
                    this.newNowEditEntry(rptTpl);
                    this.copyNewToEditVersion(rptTpl, invoker);
                }
                invoker.delete();
                invoker.add(rptTpl);
            }
            catch (Throwable ex) {
                tx.markRollback();
                LOG.error("ReportConfService.updRelationData transcation error", ex);
                throw new KDBizException(CusExceptionEnum.SAVE_ERROR.getName());
            }
        }
        RepCacheService.ins().customInitReportConfCache(spreadModelParam);
    }

    public void copyNewToEditVersion(DynamicObject rptTpl, CacheObjInvoker invoker) {
        DynamicObject editEntry = this.getCurrentEntry(rptTpl);
        long entryId = editEntry.getLong("id");
        List cacheDtoList = invoker.getCacheDtoList();
        ArrayList copyList = Lists.newArrayListWithExpectedSize((int)cacheDtoList.size());
        for (ReportCacheDto cacheDto : cacheDtoList) {
            ReportCacheDto editCacheDto = (ReportCacheDto)HRObjectUtils.cloneByStream((Object)cacheDto);
            editCacheDto.setRepEntryId(entryId);
            editCacheDto.setOperate(OperateEnum.ADD);
            editCacheDto.setId(0L);
            copyList.add(editCacheDto);
        }
        cacheDtoList.addAll(copyList);
    }

    public void copyNewToEditVersion(DynamicObject[] rptTpls) {
        ArrayList rptTplEntryIds = Lists.newArrayListWithExpectedSize((int)rptTpls.length);
        LinkedHashMap rptTplIdMapEntryId = Maps.newLinkedHashMapWithExpectedSize((int)rptTpls.length);
        LinkedHashMap rptTplIdMap = Maps.newLinkedHashMapWithExpectedSize((int)rptTpls.length);
        for (DynamicObject dynamicObject : rptTpls) {
            DynamicObject newVersionEntry = this.getNewVersionEntry(dynamicObject);
            long entryId = newVersionEntry.getLong("id");
            rptTplEntryIds.add(entryId);
            DynamicObject currentEntry = this.getCurrentEntry(dynamicObject);
            rptTplIdMapEntryId.put(dynamicObject.getLong("id"), currentEntry.getLong("id"));
            rptTplIdMap.put(dynamicObject.getLong("id"), dynamicObject);
        }
        List<ReportCacheDto> reportCacheDtos = RepCacheService.ins().queryRptTplConfByEntryIds(rptTplEntryIds);
        HashMap rptMapConfs = Maps.newHashMapWithExpectedSize((int)rptTpls.length);
        for (ReportCacheDto reportCacheDto : reportCacheDtos) {
            ReportCacheDto editCacheDto = (ReportCacheDto)HRObjectUtils.cloneByStream((Object)reportCacheDto);
            long rptTplId = editCacheDto.getReportId();
            Long entryId = (Long)rptTplIdMapEntryId.get(rptTplId);
            editCacheDto.setRepEntryId(entryId.longValue());
            editCacheDto.setOperate(OperateEnum.ADD);
            editCacheDto.setId(0L);
            List cacheDtosOfRpt = (List)rptMapConfs.get(rptTplId);
            if (Objects.isNull(cacheDtosOfRpt)) {
                cacheDtosOfRpt = Lists.newArrayListWithExpectedSize((int)10);
                cacheDtosOfRpt.add(editCacheDto);
                rptMapConfs.put(rptTplId, cacheDtosOfRpt);
                continue;
            }
            cacheDtosOfRpt.add(editCacheDto);
        }
        for (Map.Entry entry : rptMapConfs.entrySet()) {
            Long rptTplId = (Long)entry.getKey();
            DynamicObject rptTpl = (DynamicObject)rptTplIdMap.get(rptTplId);
            if (HRObjectUtils.isEmpty((Object)rptTpl)) continue;
            ReportCacheInvoker cacheObjInvoker = new ReportCacheInvoker((List)entry.getValue());
            cacheObjInvoker.add(rptTpl);
        }
    }

    public DynamicObject[] queryEnableByClassify(Long reportClassifyId) {
        QFilter enable = HrrQfilterUtils.enable();
        enable.and(HrrQfilterUtils.eqReportclassify((Long)reportClassifyId));
        enable.and(new QFilter("islocksample", "=", (Object)"1"));
        return super.query("tableno,rpttype", enable.toArray());
    }

    public DynamicObject loadEnableByNumber(String tableNumber) {
        Object[] rptTpls = this.loadEnableByNumbers(Lists.newArrayList((Object[])new String[]{tableNumber}));
        if (HRArrayUtils.isEmpty((Object[])rptTpls)) {
            return null;
        }
        return rptTpls[0];
    }

    public DynamicObject[] loadEnableByNumbers(Collection<String> tableNumbers) {
        QFilter qFilter = HrrQfilterUtils.inNumbers(tableNumbers);
        qFilter.and(new QFilter("islocksample", "=", (Object)"1"));
        return super.loadDynamicObjectArray(qFilter.toArray());
    }

    public DynamicObject queryFieldByNumber(String tableNumber, boolean isAudit, String ... fields) {
        QFilter nameFilter = new QFilter("number", "=", (Object)tableNumber);
        if (isAudit) {
            nameFilter.and(HrrQfilterUtils.enable());
            nameFilter.and(HrrQfilterUtils.isPublish());
        }
        return super.queryOne(String.join((CharSequence)",", fields), nameFilter.toArray());
    }

    public DynamicObject[] queryFieldByNumbers(Collection<String> tableNumbers, String ... fields) {
        QFilter nameFilter = HrrQfilterUtils.inNumbers(tableNumbers);
        if (HRArrayUtils.isNotEmpty((Object[])fields)) {
            return super.query(String.join((CharSequence)",", fields), nameFilter.toArray());
        }
        return super.query(nameFilter.toArray());
    }

    public Map<String, String> fetchSpreadJsonByNumbers(Set<String> tableNumbers) {
        DynamicObject[] rptTpls = this.loadEnableByNumbers(tableNumbers);
        LinkedHashMap addSpreadJsonMap = Maps.newLinkedHashMapWithExpectedSize((int)rptTpls.length);
        for (DynamicObject rptTpl : rptTpls) {
            String currentJson = this.getCurrentJson(rptTpl);
            addSpreadJsonMap.put(rptTpl.getString("number"), currentJson);
        }
        return addSpreadJsonMap;
    }

    public void deleteRptTplDtos(List<ReportCacheDto> deleteList) {
        ReportCacheInvoker invoker = new ReportCacheInvoker(deleteList);
        invoker.delete();
    }

    public List<ReportCacheDto> setCacheDtosDeleteByIds(Object[] primaryKeyValues) {
        DynamicObject[] rptTplList = this.loadDynamicObjectArray(primaryKeyValues);
        ArrayList dtoList = Lists.newArrayListWithExpectedSize((int)10);
        List<ReportCacheDto> reportCacheDtos = RepCacheService.ins().queryAllRptTplConfs(rptTplList);
        for (ReportCacheDto reportCacheDto : reportCacheDtos) {
            reportCacheDto.setOperate(OperateEnum.DELETE);
        }
        dtoList.addAll(reportCacheDtos);
        return dtoList;
    }

    public List<SpreadCommand> afterSaveBillCommands(SheetManager sheetManager) {
        ArrayList commands = Lists.newArrayListWithExpectedSize((int)2);
        List highlightAreas = sheetManager.getHighlightArea();
        if (HRCollUtil.isNotEmpty((Collection)highlightAreas)) {
            RptAreaConf clearAreaConf = sheetManager.areaConf(AreaSettingEnum.CLEAR);
            BorderHlStyleCommand styleCommand = new BorderHlStyleCommand(Pair.of((Object)clearAreaConf, (Object)highlightAreas));
            commands.add(styleCommand);
        }
        SaveSprJsonCommand saveCommand = new SaveSprJsonCommand(CallBackEnum.SAVE_SPREAD_DATA.getM());
        commands.add(saveCommand);
        return commands;
    }

    public DynamicObject queryNowEntryEntity(String tagFieldKey, long rptTplId) {
        StringBuilder fields = new StringBuilder(100);
        if (HRStringUtils.isEmpty((String)tagFieldKey)) {
            tagFieldKey = "json_tag";
        }
        fields.append(tagFieldKey).append(",");
        fields.append("isnewversion").append(",");
        fields.append("isnowedit").append(",");
        fields.append("auditdatetime").append(",");
        fields.append("seq").append(",");
        fields.append("reportclassify").append(",");
        fields.append("collecttype").append(",");
        fields.append("rpttype").append(",");
        fields.append("samplejson_tag");
        return this.queryOne(fields.toString(), rptTplId);
    }

    public DynamicObject[] queryNowEntryEntityByIds(String tagFieldKey, Collection<Long> rptTplIds) {
        StringBuilder fields = new StringBuilder(100);
        if (HRStringUtils.isEmpty((String)tagFieldKey)) {
            tagFieldKey = "json_tag";
        }
        fields.append(tagFieldKey).append(",");
        fields.append("isnewversion").append(",");
        fields.append("isnowedit").append(",");
        fields.append("auditdatetime").append(",");
        fields.append("seq").append(",");
        fields.append("reportclassify").append(",");
        fields.append("collecttype").append(",");
        fields.append("rpttype").append(",");
        fields.append("samplejson_tag");
        QFilter idFilter = new QFilter("id", "in", rptTplIds);
        return this.query(fields.toString(), idFilter.toArray());
    }

    public static RptTplService getInstance() {
        return Instance.INSTANCE;
    }

    private static class Instance {
        private static final RptTplService INSTANCE = new RptTplService();

        private Instance() {
        }
    }
}

