/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soehrr.business.domain.rpttpl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.sdk.sihc.soehrr.business.spread.SpreadClientInvoker;
import kd.sdk.sihc.soehrr.business.spread.command.DeleteColCommand;
import kd.sdk.sihc.soehrr.business.spread.command.DeleteRowCommand;
import kd.sdk.sihc.soehrr.business.spread.command.InsertColCommand;
import kd.sdk.sihc.soehrr.business.spread.command.InsertRowCommand;
import kd.sdk.sihc.soehrr.business.spread.command.SetSheetNameCommand;
import kd.sdk.sihc.soehrr.business.spread.helper.SpreadCommandHelper;
import kd.sdk.sihc.soehrr.business.spread.helper.SpreadJsonHelper;
import kd.sdk.sihc.soehrr.common.enums.AskExecuteEnum;
import kd.sdk.sihc.soehrr.common.report.CallBackFunction;
import kd.sdk.sihc.soehrr.common.spread.SpreadModelParam;
import kd.sdk.sihc.soehrr.common.util.GzipTools;
import kd.sihc.soehrr.business.domain.rpttplvar.RptTplVarService;
import kd.sihc.soehrr.common.spread.SpreadCBackParam;
import org.apache.commons.lang3.tuple.Pair;

public final class RptTplToolBarAskExecutor {
    private static final Log LOG = LogFactory.getLog(RptTplToolBarAskExecutor.class);
    private static final RptTplVarService rptTplVarService = RptTplVarService.getInstance();
    private static final Map<String, CallBackFunction<SpreadCBackParam, SpreadModelParam, IFormPlugin>> EXECUTOR_SERVICE = Maps.newHashMapWithExpectedSize((int)16);

    private RptTplToolBarAskExecutor() {
    }

    private static void uploadFile(SpreadCBackParam spreadCBackParam, SpreadModelParam spreadModelParam, IFormPlugin plugin) {
        IFormView view = spreadModelParam.getView();
        spreadModelParam.getSheetManager().removeSheetManager(view);
        String rptTplNumber = (String)spreadModelParam.getView().getModel().getValue("number");
        LOG.info("RptTplToolBarAskExecutor.uploadFile rptTplNumber = {}", (Object)rptTplNumber);
        new SetSheetNameCommand(new String[]{rptTplNumber}).invokeMethod(spreadModelParam);
        String compressSpreadJson = (String)spreadCBackParam.getSpreadParam();
        String uncompressJson = GzipTools.uncompressJson((String)compressSpreadJson);
        JSONObject spreadJsonObject = JSONObject.parseObject((String)uncompressJson, (Feature[])new Feature[]{Feature.OrderedField});
        SpreadCommandHelper.genSheetManagerByView((IFormView)view, (JSONObject)spreadJsonObject);
        List orderSheetNames = SpreadJsonHelper.getOrderSheetNames((JSONObject)spreadJsonObject);
        if (HRCollUtil.isNotEmpty((Collection)orderSheetNames) && orderSheetNames.size() > 1) {
            ArrayList index = Lists.newArrayListWithExpectedSize((int)(orderSheetNames.size() - 1));
            for (int i = 1; i < orderSheetNames.size(); ++i) {
                index.add(i);
            }
            SpreadClientInvoker.invokeDeleteSheets((IClientViewProxy)spreadModelParam.getProxy(), (String)spreadModelParam.getSpreadKey(), (Object)index);
        }
    }

    private static void deleteCol(SpreadCBackParam spreadCBackParam, SpreadModelParam spreadModelParam, IFormPlugin plugin) {
        ArrayList selectIndexList = (ArrayList)spreadCBackParam.getSpreadParam();
        rptTplVarService.updateVarDeleteCol(spreadModelParam, selectIndexList);
        DeleteColCommand deleteColCommand = new DeleteColCommand(selectIndexList.toArray(new Integer[0]));
        deleteColCommand.invokeMethod(spreadModelParam);
    }

    private static void deleteRow(SpreadCBackParam spreadCBackParam, SpreadModelParam spreadModelParam, IFormPlugin plugin) {
        ArrayList selectIndexList = (ArrayList)spreadCBackParam.getSpreadParam();
        rptTplVarService.updateVarDeleteRow(spreadModelParam, selectIndexList);
        DeleteRowCommand deleteRowCommand = new DeleteRowCommand(selectIndexList.toArray(new Integer[0]));
        deleteRowCommand.invokeMethod(spreadModelParam);
    }

    private static void insertCol(SpreadCBackParam spreadCBackParam, SpreadModelParam spreadModelParam, IFormPlugin plugin) {
        LinkedHashMap invokeParamsData = (LinkedHashMap)spreadCBackParam.getSpreadParam();
        int count = Integer.parseInt(String.valueOf(invokeParamsData.get("count")));
        Integer[] selectCols = spreadModelParam.getSelector().getSelectionsCols();
        rptTplVarService.updateVarInsertCol(spreadModelParam, Arrays.asList(selectCols), count);
        InsertColCommand insertColCommand = new InsertColCommand(Pair.of((Object)count, (Object)selectCols));
        insertColCommand.invokeMethod(spreadModelParam);
    }

    private static void insertRow(SpreadCBackParam spreadCBackParam, SpreadModelParam spreadModelParam, IFormPlugin plugin) {
        LinkedHashMap invokeParamsData = (LinkedHashMap)spreadCBackParam.getSpreadParam();
        Integer[] selectRows = spreadModelParam.getSelector().getSelectionsRows();
        int count = Integer.parseInt(String.valueOf(invokeParamsData.get("count")));
        rptTplVarService.updateVarInsertRow(spreadModelParam, Arrays.asList(selectRows), count);
        InsertRowCommand insertRowCommand = new InsertRowCommand(Pair.of((Object)count, (Object)selectRows));
        insertRowCommand.invokeMethod(spreadModelParam);
    }

    public void invokeMethod(SpreadCBackParam spreadCBackParam, SpreadModelParam spreadModelParam, IFormPlugin plugin) {
        String methodName = spreadCBackParam.getMethodName();
        CallBackFunction<SpreadCBackParam, SpreadModelParam, IFormPlugin> function = EXECUTOR_SERVICE.get(methodName);
        if (Objects.isNull(function)) {
            return;
        }
        function.accept((Object)spreadCBackParam, (Object)spreadModelParam, (Object)plugin);
    }

    public static RptTplToolBarAskExecutor ins() {
        return Instance.INSTANCE;
    }

    static {
        EXECUTOR_SERVICE.put(AskExecuteEnum.INSERT_ROW.getM(), (CallBackFunction<SpreadCBackParam, SpreadModelParam, IFormPlugin>)((CallBackFunction)RptTplToolBarAskExecutor::insertRow));
        EXECUTOR_SERVICE.put(AskExecuteEnum.INSERT_COL.getM(), (CallBackFunction<SpreadCBackParam, SpreadModelParam, IFormPlugin>)((CallBackFunction)RptTplToolBarAskExecutor::insertCol));
        EXECUTOR_SERVICE.put(AskExecuteEnum.DELETE_ROW.getM(), (CallBackFunction<SpreadCBackParam, SpreadModelParam, IFormPlugin>)((CallBackFunction)RptTplToolBarAskExecutor::deleteRow));
        EXECUTOR_SERVICE.put(AskExecuteEnum.DELETE_COL.getM(), (CallBackFunction<SpreadCBackParam, SpreadModelParam, IFormPlugin>)((CallBackFunction)RptTplToolBarAskExecutor::deleteCol));
        EXECUTOR_SERVICE.put(AskExecuteEnum.UPLOAD_FILE.getM(), (CallBackFunction<SpreadCBackParam, SpreadModelParam, IFormPlugin>)((CallBackFunction)RptTplToolBarAskExecutor::uploadFile));
    }

    private static class Instance {
        private static final RptTplToolBarAskExecutor INSTANCE = new RptTplToolBarAskExecutor();

        private Instance() {
        }
    }
}

