/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soehrr.business.domain.rpttplarea;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.sihc.soehrr.business.spread.command.ClearAreaCommand;
import kd.sdk.sihc.soehrr.business.spread.command.SetAreaCommand;
import kd.sdk.sihc.soehrr.business.spread.command.SetFormalCommand;
import kd.sdk.sihc.soehrr.common.enums.AreaSettingEnum;
import kd.sdk.sihc.soehrr.common.enums.CollectTypeEnum;
import kd.sdk.sihc.soehrr.common.enums.ExcelFormulaEnum;
import kd.sdk.sihc.soehrr.common.enums.OperateEnum;
import kd.sdk.sihc.soehrr.common.report.dto.AreaSettingDto;
import kd.sdk.sihc.soehrr.common.report.dto.ReportCacheDto;
import kd.sdk.sihc.soehrr.common.report.invoker.CacheObjInvoker;
import kd.sdk.sihc.soehrr.common.report.invoker.ReportCacheInvoker;
import kd.sdk.sihc.soehrr.common.spread.Cell;
import kd.sdk.sihc.soehrr.common.spread.SheetManager;
import kd.sdk.sihc.soehrr.common.spread.SpreadModelParam;
import kd.sdk.sihc.soehrr.common.spread.SpreadSelector;
import kd.sdk.sihc.soehrr.common.util.ExcelUtils;
import kd.sdk.sihc.soehrr.common.util.HrrQfilterUtils;
import kd.sdk.sihc.soehrr.common.util.MapInitHelper;
import kd.sihc.soehrr.business.domain.cache.QueryInitCache;
import kd.sihc.soehrr.business.domain.cache.RepCacheService;
import kd.sihc.soehrr.business.domain.rpttpl.RptTplService;

public class RptTplAreaService
extends HRBaseServiceHelper
implements QueryInitCache {
    @Override
    public DynamicObject[] loadByRptEntryIds(List<Long> rptEntryIds) {
        return this.loadDynamicObjectArray(new QFilter("repentryid", "in", rptEntryIds).toArray());
    }

    public DynamicObject[] loadByRptEntryIds(List<Long> rptEntryIds, List<AreaSettingEnum> areaSettingEnums) {
        QFilter entryIdsFilter = new QFilter("repentryid", "in", rptEntryIds);
        List areaTypes = areaSettingEnums.stream().map(ase -> String.valueOf(ase.getValue())).collect(Collectors.toList());
        entryIdsFilter.and(new QFilter("areatype", "in", areaTypes));
        return this.loadDynamicObjectArray(entryIdsFilter.toArray());
    }

    @Override
    public List<DynamicObject> queryByRepConfId(long reportConfId, long currentEntryId) {
        QFilter[] qFilters = HrrQfilterUtils.eqReportConf((long)reportConfId, (long)currentEntryId);
        ArrayList filterList = Lists.newArrayList(Arrays.asList(qFilters));
        filterList.add(new QFilter("areatype", "!=", (Object)String.valueOf(AreaSettingEnum.SYS_AUTO_NUM.getValue())));
        DynamicObject[] areas = this.loadDynamicObjectArray(filterList.toArray(new QFilter[0]));
        return Arrays.asList(areas);
    }

    @Override
    public String getCacheClass() {
        return AreaSettingDto.class.getName();
    }

    public void extendCalArea(SpreadModelParam spreadModelParam) {
        SheetManager sheetManager = spreadModelParam.getSheetManager();
        CacheObjInvoker invoker = sheetManager.getInvoker();
        List<AreaSettingDto> allCalArea = RepCacheService.ins().getAllCalArea(invoker);
        if (HRCollUtil.isNotEmpty(allCalArea)) {
            ArrayList calAreas = Lists.newArrayListWithExpectedSize((int)10);
            for (AreaSettingDto areaSettingDto : allCalArea) {
                SpreadSelector selector = areaSettingDto.convert2Selector();
                calAreas.add(selector);
            }
            new SetAreaCommand(MapInitHelper.ofMap((Object)sheetManager.areaConf(AreaSettingEnum.CAL), (Object)calAreas)).invokeMethod(spreadModelParam);
        }
    }

    public void clearTotalSummaryArea(SpreadModelParam spreadParam, Object newValue) {
        SheetManager sheetManager = spreadParam.getSheetManager();
        CacheObjInvoker invoker = sheetManager.getInvoker();
        List<AreaSettingDto> totalSummaries = RepCacheService.ins().getExistAreaByType(invoker, AreaSettingEnum.TOTAL_SUMMARY);
        ArrayList selectors = Lists.newArrayListWithExpectedSize((int)10);
        ArrayList clearCells = Lists.newArrayListWithExpectedSize((int)10);
        for (AreaSettingDto totalSummary : totalSummaries) {
            if (totalSummary.getOperate() == OperateEnum.DELETE) continue;
            totalSummary.setOperate(OperateEnum.DELETE);
            SpreadSelector selector = totalSummary.convert2Selector();
            selectors.add(selector);
            List cells = selector.toCellList();
            clearCells.addAll(cells);
        }
        sheetManager.setSheetCache(spreadParam.getView());
        this.updateFillToDynamicArea(spreadParam, String.valueOf(newValue));
        new SetAreaCommand(MapInitHelper.ofMap((Object)sheetManager.areaConf(AreaSettingEnum.DYNAMIC_SUMMARY), (Object)selectors)).invokeMethod(spreadParam);
        if (HRCollUtil.isNotEmpty((Collection)clearCells)) {
            new SetFormalCommand((List)clearCells).invokeMethod(spreadParam);
        }
    }

    public void updateFillToDynamicArea(SpreadModelParam spreadModelParam, String newCollectType) {
        DynamicObject rptTpl;
        CacheObjInvoker invoker = spreadModelParam.getSheetManager().getInvoker();
        AreaSettingDto fillOrTotalArea = RepCacheService.ins().getFillOrTotalArea(invoker);
        if (Objects.isNull(fillOrTotalArea)) {
            return;
        }
        fillOrTotalArea.setOperate(OperateEnum.DELETE);
        AreaSettingEnum newSettingEnum = null;
        if (HRStringUtils.equals((String)newCollectType, (String)CollectTypeEnum.SUM.getType())) {
            newSettingEnum = AreaSettingEnum.FILL;
        } else if (HRStringUtils.equals((String)newCollectType, (String)CollectTypeEnum.LIST.getType())) {
            newSettingEnum = AreaSettingEnum.DYNAMIC_SUMMARY;
        }
        IFormView view = spreadModelParam.getView();
        Boolean isCopy = (Boolean)view.getFormShowParameter().getCustomParam("iscopy");
        if (Objects.nonNull(isCopy) && isCopy.booleanValue()) {
            rptTpl = view.getModel().getDataEntity(true);
        } else {
            Object pkValue = spreadModelParam.getView().getModel().getDataEntity(true).getPkValue();
            rptTpl = RptTplService.getInstance().queryNowEntryEntity(null, (Long)pkValue);
        }
        AreaSettingDto newAreaDto = new AreaSettingDto(fillOrTotalArea.convert2Selector(), rptTpl, newSettingEnum);
        invoker.setCacheDto((ReportCacheDto)newAreaDto);
        spreadModelParam.getSheetManager().setSheetCache(spreadModelParam.getView());
    }

    public void drawTotalSummaryAreaFormula(SpreadModelParam spreadModelParam) {
        SheetManager sheetManager = spreadModelParam.getSheetManager();
        CacheObjInvoker invoker = sheetManager.getInvoker();
        AreaSettingDto fillOrTotalArea = RepCacheService.ins().getFillOrTotalArea(invoker);
        SpreadSelector fillSelector = fillOrTotalArea.convert2Selector();
        SpreadSelector totalSummarySelector = spreadModelParam.getSelector();
        int startRow = 0;
        int endRow = 0;
        int direct = this.totalSummaryDirect(invoker, totalSummarySelector);
        if (direct == 1) {
            startRow = totalSummarySelector.getStartRow() + 1;
            endRow = fillSelector.getEndRow();
        } else if (direct == 0) {
            startRow = fillSelector.getStartRow();
            endRow = totalSummarySelector.getStartRow() - 1;
        }
        ArrayList formulaCells = Lists.newArrayListWithExpectedSize((int)totalSummarySelector.getSpanCol());
        for (int col = totalSummarySelector.getStartCol(); col <= totalSummarySelector.getEndCol(); ++col) {
            Cell formulaCell = new Cell(totalSummarySelector.getStartRow(), col);
            String formula = ExcelFormulaEnum.SUM.getFormula();
            StringBuilder formulaBuilder = new StringBuilder(100);
            String preFormula = formula.substring(0, formula.length() - 1);
            formulaBuilder.append(preFormula);
            formulaBuilder.append(ExcelUtils.xy2Pos((int)col, (int)startRow));
            formulaBuilder.append(":");
            formulaBuilder.append(ExcelUtils.xy2Pos((int)col, (int)endRow));
            formulaBuilder.append(")");
            formulaCell.setFormula(formulaBuilder.toString());
            Cell sheetManagerCell = sheetManager.getCell(totalSummarySelector.getStartRow(), col);
            sheetManagerCell.setFormula(formulaBuilder.toString());
            formulaCells.add(formulaCell);
        }
        sheetManager.setSheetCache(spreadModelParam.getView());
        new SetFormalCommand((List)formulaCells).invokeMethod(spreadModelParam);
    }

    public int totalSummaryDirect(CacheObjInvoker invoker, SpreadSelector totalSummarySelector) {
        AreaSettingDto fillOrTotalArea = RepCacheService.ins().getFillOrTotalArea(invoker);
        SpreadSelector fillSelector = fillOrTotalArea.convert2Selector();
        if (fillSelector.getStartRow() == totalSummarySelector.getStartRow()) {
            return 1;
        }
        if (fillSelector.getEndRow() == totalSummarySelector.getEndRow()) {
            return 0;
        }
        return -1;
    }

    public List<AreaSettingDto> loadByRptTplEntryIds(Collection<Long> rptTplEntryIds, List<AreaSettingEnum> areaSettingEnums) {
        QFilter rptEntryFilter = new QFilter("repentryid", "in", rptTplEntryIds);
        List areaTypes = areaSettingEnums.stream().map(set -> String.valueOf(set.getValue())).collect(Collectors.toList());
        if (HRCollUtil.isNotEmpty(areaTypes)) {
            rptEntryFilter.and(new QFilter("areatype", "in", areaTypes));
        }
        DynamicObject[] areaDies = this.loadDynamicObjectArray(rptEntryFilter.toArray());
        ArrayList result = Lists.newArrayListWithExpectedSize((int)areaDies.length);
        for (DynamicObject area : areaDies) {
            AreaSettingDto areaSettingDto = new AreaSettingDto();
            areaSettingDto.dyConvert2Dto(area);
            result.add(areaSettingDto);
        }
        return result;
    }

    public List<AreaSettingDto> getAreaByEntryAndType(ReportCacheInvoker cacheInvoker, long rptTplPkValue, Long rptEntryId, AreaSettingEnum enums) {
        List<AreaSettingDto> existAreaByType = RepCacheService.ins().getExistAreaByType((CacheObjInvoker)cacheInvoker, enums);
        ArrayList result = Lists.newArrayListWithExpectedSize((int)10);
        for (AreaSettingDto areaSettingDto : existAreaByType) {
            if (areaSettingDto.getReportId() != rptTplPkValue || areaSettingDto.getRepEntryId() != rptEntryId.longValue()) continue;
            result.add(areaSettingDto);
        }
        return result;
    }

    @Override
    public DynamicObject[] queryByRptTplId(List<Long> rptTplIds) {
        return super.loadDynamicObjectArray(new QFilter[]{new QFilter("reportconfid", "in", rptTplIds)});
    }

    @Override
    public void refreshCopyNumber(List<ReportCacheDto> cacheDtoList, SpreadModelParam spreadModelParam, DynamicObject oldRptTpl, String newRptTplNumber) {
        SheetManager sheetManager = spreadModelParam.getSheetManager();
        ArrayList updateFormulas = Lists.newArrayListWithExpectedSize((int)10);
        for (ReportCacheDto cacheDto : cacheDtoList) {
            AreaSettingDto areaSettingDto;
            if (!(cacheDto instanceof AreaSettingDto) || (areaSettingDto = (AreaSettingDto)cacheDto).getAreaSetting() != AreaSettingEnum.CAL) continue;
            String oldRptTplNumber = oldRptTpl.getString("number");
            SpreadSelector selector = areaSettingDto.convert2Selector();
            Cell cell = sheetManager.getCell(selector.getStartRow(), selector.getStartCol());
            String formula = cell.getFormula();
            if (HRStringUtils.isEmpty((String)formula) || !formula.contains(oldRptTplNumber)) continue;
            String newFormula = formula.replaceAll(oldRptTplNumber + "!", newRptTplNumber + "!");
            cell.setFormula(newFormula);
            updateFormulas.add(cell);
        }
        if (HRCollUtil.isNotEmpty((Collection)updateFormulas)) {
            new SetFormalCommand((List)updateFormulas).invokeMethod(spreadModelParam);
        }
    }

    public void clearAreaByType(SpreadModelParam spreadParam, AreaSettingEnum areaSetting) {
        SheetManager sheetManager = spreadParam.getSheetManager();
        List<AreaSettingDto> existAreaByTypes = RepCacheService.ins().getExistAreaByType(sheetManager.getInvoker(), areaSetting);
        if (HRCollUtil.isEmpty(existAreaByTypes)) {
            return;
        }
        ArrayList fillSelectors = Lists.newArrayListWithExpectedSize((int)10);
        ArrayList clearSelectors = Lists.newArrayListWithExpectedSize((int)10);
        AreaSettingDto fillOrTotalArea = RepCacheService.ins().getFillOrTotalArea(sheetManager.getInvoker());
        for (AreaSettingDto existArea : existAreaByTypes) {
            existArea.setOperate(OperateEnum.DELETE);
            SpreadSelector selector = existArea.convert2Selector();
            if (selector.checkIsInArea(fillOrTotalArea.convert2Selector())) {
                fillSelectors.add(selector);
                continue;
            }
            clearSelectors.add(selector);
        }
        if (HRCollUtil.isNotEmpty((Collection)clearSelectors)) {
            new ClearAreaCommand((List)clearSelectors).invokeMethod(spreadParam);
        }
        if (HRCollUtil.isNotEmpty((Collection)fillSelectors)) {
            new SetAreaCommand(MapInitHelper.ofMap((Object)sheetManager.areaConf(fillOrTotalArea.getAreaSetting()), (Object)fillSelectors)).invokeMethod(spreadParam);
        }
        sheetManager.setSheetCache(spreadParam.getView());
    }

    public RptTplAreaService() {
        super("soehrr_rpttplarea");
    }

    public static RptTplAreaService ins() {
        return Instance.INSTANCE;
    }

    private static class Instance {
        private static final RptTplAreaService INSTANCE = new RptTplAreaService();

        private Instance() {
        }
    }
}

