/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soehrr.business.domain.rpttplarea;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.sihc.soehrr.business.spread.command.SetAreaCommand;
import kd.sdk.sihc.soehrr.common.enums.AreaSettingEnum;
import kd.sdk.sihc.soehrr.common.enums.OperateEnum;
import kd.sdk.sihc.soehrr.common.report.autogetnum.Rank;
import kd.sdk.sihc.soehrr.common.report.dto.AutoAreaSettingDto;
import kd.sdk.sihc.soehrr.common.report.dto.ReportCacheDto;
import kd.sdk.sihc.soehrr.common.report.invoker.CacheObjInvoker;
import kd.sdk.sihc.soehrr.common.spread.SpreadModelParam;
import kd.sdk.sihc.soehrr.common.spread.SpreadSelector;
import kd.sdk.sihc.soehrr.common.util.HrrQfilterUtils;
import kd.sihc.soehrr.business.domain.cache.QueryInitCache;
import org.apache.commons.lang3.tuple.Pair;

public class RptTplAutoAreaService
extends HRBaseServiceHelper
implements QueryInitCache {
    @Override
    public void refreshCopyNumber(List<ReportCacheDto> cacheDtoList, SpreadModelParam spreadModelParam, DynamicObject oldRptTpl, String newRptTplNumber) {
    }

    @Override
    public DynamicObject[] loadByRptEntryIds(List<Long> rptEntryIds) {
        QFilter and = new QFilter("repentryid", "in", rptEntryIds).and(new QFilter("areatype", "=", (Object)String.valueOf(AreaSettingEnum.SYS_AUTO_NUM.getValue())));
        return this.loadDynamicObjectArray(and.toArray());
    }

    @Override
    public List<DynamicObject> queryByRepConfId(long reportConfId, long currentEntryId) {
        QFilter[] qFilters = HrrQfilterUtils.eqReportConf((long)reportConfId, (long)currentEntryId);
        ArrayList filterList = Lists.newArrayList(Arrays.asList(qFilters));
        filterList.add(new QFilter("areatype", "=", (Object)String.valueOf(AreaSettingEnum.SYS_AUTO_NUM.getValue())));
        DynamicObject[] areas = this.loadDynamicObjectArray(filterList.toArray(new QFilter[0]));
        return Arrays.asList(areas);
    }

    @Override
    public String getCacheClass() {
        return AutoAreaSettingDto.class.getName();
    }

    @Override
    public DynamicObject[] queryByRptTplId(List<Long> rptTplId) {
        QFilter and = new QFilter("reportconfid", "in", rptTplId).and(new QFilter("areatype", "=", (Object)String.valueOf(AreaSettingEnum.SYS_AUTO_NUM.getValue())));
        return super.loadDynamicObjectArray(new QFilter[]{and});
    }

    public void updateAutoAreaData(@NotNull SpreadModelParam param, List<AutoAreaSettingDto> autoGetNumAreas, Map<String, AutoAreaSettingDto> updateDtoMap) {
        Collection<AutoAreaSettingDto> values = updateDtoMap.values();
        List updateAutoAreaList = values.stream().collect(Collectors.toList());
        CacheObjInvoker invoker = param.getSheetManager().getInvoker();
        block0: for (AutoAreaSettingDto autoGetNumArea : autoGetNumAreas) {
            String areaPoint = autoGetNumArea.getAreaPoint();
            if (!updateDtoMap.containsKey(areaPoint)) continue;
            AutoAreaSettingDto newDto = updateDtoMap.get(areaPoint);
            if (autoGetNumArea.getOperate() == OperateEnum.ADD) {
                List cacheDtoList = invoker.getCacheDtoList();
                cacheDtoList.removeIf(dto -> dto instanceof AutoAreaSettingDto && HRStringUtils.equals((String)areaPoint, (String)((AutoAreaSettingDto)dto).getAreaPoint()) && dto.getEntityId().equals(newDto.getEntityId()) && dto.getOperate() == OperateEnum.ADD);
                continue;
            }
            List queries = invoker.query("soehrr_rpttplarea_auto");
            for (AutoAreaSettingDto query : queries) {
                if (!HRStringUtils.equals((String)query.getAreaPoint(), (String)areaPoint)) continue;
                query.setOperate(OperateEnum.DELETE);
                continue block0;
            }
        }
        HashMap spreadParam = Maps.newHashMapWithExpectedSize((int)16);
        List selectorList = updateAutoAreaList.stream().map(dto -> {
            SpreadSelector selector = new SpreadSelector(dto.getAreaPoint());
            return selector;
        }).collect(Collectors.toList());
        spreadParam.put(param.getSheetManager().areaConf(AreaSettingEnum.SYS_AUTO_NUM), selectorList);
        SetAreaCommand setAreaCommand = new SetAreaCommand((Map)spreadParam);
        setAreaCommand.invokeMethod(param.getProxy(), param.getSpreadKey());
    }

    public Map<SpreadSelector, AutoAreaSettingDto> splitAreaByAuto(SpreadSelector spreadSelector, AutoAreaSettingDto autoNumArea) {
        List colIndexList = autoNumArea.getColIndexList();
        List rowDims = autoNumArea.getRowDims();
        List<Pair<Integer, Integer>> colRangeList = this.groupAreaRange(spreadSelector.getSpanCol(), colIndexList);
        List<Pair<Integer, Integer>> rowRangeList = this.groupAreaRange(spreadSelector.getSpanRow(), rowDims);
        HashMap result = Maps.newHashMapWithExpectedSize((int)16);
        int initCol = spreadSelector.getStartCol();
        int initRow = spreadSelector.getStartRow();
        for (Pair<Integer, Integer> colPair : colRangeList) {
            Integer startCol = (Integer)colPair.getLeft();
            Integer endCol = (Integer)colPair.getRight();
            int spanCol = endCol - startCol + 1;
            ArrayList splitColIndex = Lists.newArrayListWithExpectedSize((int)spanCol);
            for (int index = startCol - initCol; index < spanCol; ++index) {
                splitColIndex.add(colIndexList.get(index));
            }
            for (Pair<Integer, Integer> rowPair : rowRangeList) {
                Integer startRow = (Integer)rowPair.getLeft();
                Integer endRow = (Integer)rowPair.getRight();
                int spanRow = endRow - startRow + 1;
                ArrayList splitRowDim = Lists.newArrayListWithExpectedSize((int)spanRow);
                for (int index = startRow - initRow; index < spanRow; ++index) {
                    splitRowDim.add(rowDims.get(index));
                }
                SpreadSelector newSelector = new SpreadSelector(startRow.intValue(), startCol.intValue(), endRow.intValue(), endCol.intValue());
                AutoAreaSettingDto splitAutoAreaDto = (AutoAreaSettingDto)HRObjectUtils.cloneByStream((Object)autoNumArea);
                splitAutoAreaDto.setRowDims((List)splitRowDim);
                splitAutoAreaDto.setColIndexList((List)splitColIndex);
                splitAutoAreaDto.setAreaPoint(newSelector.getAreaPointStr());
                result.put(newSelector, splitAutoAreaDto);
            }
        }
        return result;
    }

    private List<Pair<Integer, Integer>> groupAreaRange(int spanColOrRow, List<? extends Rank> rankList) {
        ArrayList rangeList = Lists.newArrayListWithExpectedSize((int)10);
        int temp = -1;
        int tempStart = 0;
        int tempEnd = 0;
        boolean add = false;
        for (int index = 0; index < rankList.size(); ++index) {
            Rank rowOrCol = rankList.get(index);
            if (rowOrCol == null) {
                if (!add) continue;
                rangeList.add(Pair.of((Object)tempStart, (Object)tempEnd));
                add = false;
                tempStart = 0;
                tempEnd = 0;
                temp = -1;
                continue;
            }
            int col = rowOrCol.getRank();
            if (temp == -1) {
                temp = col;
                tempStart = col;
                tempEnd = col;
                add = true;
                continue;
            }
            if (col != temp + 1) continue;
            temp = col;
            tempEnd = col;
            add = true;
        }
        if (add) {
            rangeList.add(Pair.of((Object)tempStart, (Object)tempEnd));
        }
        return rangeList;
    }

    public RptTplAutoAreaService() {
        super("soehrr_rpttplarea_auto");
    }

    public static RptTplAutoAreaService ins() {
        return Instance.INSTANCE;
    }

    private static class Instance {
        private static final RptTplAutoAreaService INSTANCE = new RptTplAutoAreaService();

        private Instance() {
        }
    }
}

