/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soehrr.business.domain.rpttplvalidatort;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.sihc.soehrr.common.enums.OperateEnum;
import kd.sdk.sihc.soehrr.common.report.dto.RepValidatorDto;
import kd.sdk.sihc.soehrr.common.report.dto.ReportCacheDto;
import kd.sdk.sihc.soehrr.common.spread.Cell;
import kd.sdk.sihc.soehrr.common.spread.SheetManager;
import kd.sdk.sihc.soehrr.common.spread.SpreadModelParam;
import kd.sdk.sihc.soehrr.common.spread.SpreadSelector;
import kd.sdk.sihc.soehrr.common.util.HrrQfilterUtils;
import kd.sihc.soehrr.business.domain.cache.QueryInitCache;
import kd.sihc.soehrr.common.check.ExpressionSplitor;

public class RptTplValidatorService
extends HRBaseServiceHelper
implements QueryInitCache {
    public DynamicObject queryByNumber(String number) {
        return super.loadDynamicObject(HrrQfilterUtils.eqNumber((String)number));
    }

    @Override
    public List<DynamicObject> queryByRepConfId(long reportConfId, long currentEntryId) {
        QFilter[] qFilters = HrrQfilterUtils.eqReportConf((long)reportConfId, (long)currentEntryId);
        DynamicObject[] repValidators = this.loadDynamicObjectArray(qFilters);
        return Arrays.asList(repValidators);
    }

    @Override
    public void refreshCopyNumber(List<ReportCacheDto> cacheDtoList, SpreadModelParam spreadModelParam, DynamicObject oldRptTpl, String newRptTplNumber) {
        for (ReportCacheDto cacheDto : cacheDtoList) {
            String tarValue;
            if (!(cacheDto instanceof RepValidatorDto)) continue;
            RepValidatorDto validatorDto = (RepValidatorDto)cacheDto;
            String oldRptTplNumber = oldRptTpl.getString("number");
            String expression = validatorDto.getExpression();
            if (expression.contains(oldRptTplNumber)) {
                String newExpression = expression.replaceAll(oldRptTplNumber + "!", newRptTplNumber + "!");
                validatorDto.setExpression(newExpression);
            }
            if (!(tarValue = validatorDto.getTarvalue()).contains(oldRptTplNumber)) continue;
            String newTarValue = tarValue.replaceAll(oldRptTplNumber + "!", newRptTplNumber + "!");
            validatorDto.setTarvalue(newTarValue);
        }
    }

    @Override
    public DynamicObject[] loadByRptEntryIds(List<Long> rptEntryIds) {
        QFilter entryFilter = new QFilter("repentryid", "in", rptEntryIds);
        return this.loadDynamicObjectArray(entryFilter.toArray());
    }

    public Set<String> getExpressionSheetNumbers(RepValidatorDto validatorDto) {
        HashSet rptTplNumbers = Sets.newHashSetWithExpectedSize((int)16);
        String expression = validatorDto.getExpression();
        List sheetAndCells = ExpressionSplitor.splitItem((String)expression);
        for (String sheetAndCell : sheetAndCells) {
            if (HRStringUtils.isEmpty((String)sheetAndCell)) continue;
            String[] sheetCellArr = sheetAndCell.split("!");
            rptTplNumbers.add(sheetCellArr[0].trim());
        }
        return rptTplNumbers;
    }

    public Set<String> getExpressionSheetNumbers(DynamicObject verRule) {
        RepValidatorDto validatorDto = new RepValidatorDto();
        validatorDto.dyConvert2Dto(verRule);
        return this.getExpressionSheetNumbers(validatorDto);
    }

    @Override
    public String getCacheClass() {
        return RepValidatorDto.class.getName();
    }

    @Override
    public DynamicObject[] queryByRptTplId(List<Long> rptTplId) {
        return super.loadDynamicObjectArray(new QFilter[]{new QFilter("reportconfid", "in", rptTplId)});
    }

    public void clearValidators(SpreadModelParam spreadParam) {
        SpreadSelector delSelector = spreadParam.getSelector();
        SheetManager sheetManager = spreadParam.getSheetManager();
        List verRulesDto = sheetManager.getAllSheetRuleByEntity("soehrr_rpttplverrule");
        for (RepValidatorDto repValidatorDto : verRulesDto) {
            Cell cell = repValidatorDto.getCell();
            SpreadSelector cellSelector = cell.toSelector();
            if (!cellSelector.checkIsInArea(delSelector)) continue;
            repValidatorDto.setOperate(OperateEnum.DELETE);
        }
        sheetManager.setSheetCache(spreadParam.getView());
    }

    public RptTplValidatorService() {
        super("soehrr_rpttplverrule");
    }

    public static RptTplValidatorService getInstance() {
        return Instance.INSTANCE;
    }

    private static class Instance {
        private static final RptTplValidatorService INSTANCE = new RptTplValidatorService();

        private Instance() {
        }
    }
}

