/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soehrr.business.domain.rpttplvar;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.sihc.soehrr.business.spread.command.UpdCellsValCommand;
import kd.sdk.sihc.soehrr.common.enums.AreaSettingEnum;
import kd.sdk.sihc.soehrr.common.enums.OperateEnum;
import kd.sdk.sihc.soehrr.common.report.TipContent;
import kd.sdk.sihc.soehrr.common.report.dto.AreaSettingDto;
import kd.sdk.sihc.soehrr.common.report.dto.RepRuntimeVar;
import kd.sdk.sihc.soehrr.common.report.dto.ReportCacheDto;
import kd.sdk.sihc.soehrr.common.report.invoker.CacheObjInvoker;
import kd.sdk.sihc.soehrr.common.spread.Cell;
import kd.sdk.sihc.soehrr.common.spread.DataTableManager;
import kd.sdk.sihc.soehrr.common.spread.SheetManager;
import kd.sdk.sihc.soehrr.common.spread.SpreadModelParam;
import kd.sdk.sihc.soehrr.common.spread.SpreadSelector;
import kd.sdk.sihc.soehrr.common.util.HrrQfilterUtils;
import kd.sihc.soehrr.business.domain.cache.QueryInitCache;
import kd.sihc.soehrr.business.domain.cache.RepCacheService;

public class RptTplVarService
extends HRBaseServiceHelper
implements QueryInitCache {
    private HRBaseServiceHelper repRuntimeVarDao = new HRBaseServiceHelper("soehrr_rpttplvar");

    public DynamicObject[] queryByClassify(long classifyId) {
        QFilter classifyFilter = new QFilter("reportclassify", "=", (Object)classifyId);
        classifyFilter.and(HrrQfilterUtils.enable());
        return super.loadDynamicObjectArray(classifyFilter.toArray());
    }

    public DynamicObject queryByNumber(String number) {
        return super.loadDynamicObject(HrrQfilterUtils.eqNumber((String)number));
    }

    @Override
    public List<DynamicObject> queryByRepConfId(long reportConfId, long currentEntryId) {
        QFilter[] qFilters = HrrQfilterUtils.eqReportConf((long)reportConfId, (long)currentEntryId);
        DynamicObject[] runtimeVars = this.repRuntimeVarDao.loadDynamicObjectArray(qFilters);
        return Arrays.asList(runtimeVars);
    }

    public List<RepRuntimeVar> queryDtoByRepConfId(long reportConfId, long currentEntryId) {
        List<DynamicObject> vars = this.queryByRepConfId(reportConfId, currentEntryId);
        ArrayList result = Lists.newArrayListWithExpectedSize((int)vars.size());
        for (DynamicObject var : vars) {
            RepRuntimeVar runtimeVar = new RepRuntimeVar();
            runtimeVar.dyConvert2Dto(var);
            result.add(runtimeVar);
        }
        return result;
    }

    public List<DynamicObject> queryByRepConfIds(List<Long> repentryIds) {
        DynamicObject[] vars = this.repRuntimeVarDao.query("id,reportvar,point,reportconfid", new QFilter[]{new QFilter("repentryid", "in", repentryIds)});
        return Arrays.asList(vars);
    }

    @Override
    public String getCacheClass() {
        return RepRuntimeVar.class.getName();
    }

    @Override
    public DynamicObject[] queryByRptTplId(List<Long> rptTplId) {
        return this.repRuntimeVarDao.loadDynamicObjectArray(new QFilter[]{new QFilter("reportconfid", "in", rptTplId)});
    }

    @Override
    public void refreshCopyNumber(List<ReportCacheDto> cacheDtoList, SpreadModelParam spreadModelParam, DynamicObject oldRptTpl, String newRptTplNumber) {
    }

    public List<RepRuntimeVar> getReportCacheData(long reportConfId, long currentEntryId) {
        List<DynamicObject> runtimeVars = this.queryByRepConfId(reportConfId, currentEntryId);
        if (HRCollUtil.isEmpty(runtimeVars)) {
            return Collections.emptyList();
        }
        ArrayList varList = Lists.newArrayListWithExpectedSize((int)runtimeVars.size());
        for (DynamicObject runtimeVar : runtimeVars) {
            RepRuntimeVar var = new RepRuntimeVar();
            var.dyConvert2Dto(runtimeVar);
            varList.add(var);
        }
        return varList;
    }

    @Override
    public DynamicObject[] loadByRptEntryIds(List<Long> rptEntryIds) {
        return this.repRuntimeVarDao.loadDynamicObjectArray(new QFilter("repentryid", "in", rptEntryIds).toArray());
    }

    public void changeOfInsertVar(DynamicObject classifyVar, @NotNull SpreadModelParam spreadModelParam) {
        SheetManager sheet = spreadModelParam.getSheetManager();
        String varName = "#{" + classifyVar.getString("name") + "}";
        IFormView view = spreadModelParam.getView();
        IFormView rptTplview = spreadModelParam.getView().getParentView();
        SpreadSelector spreadSelector = spreadModelParam.getSelector();
        TipContent content = RptTplVarService.getInstance().canInsertVar(spreadModelParam);
        if (!content.isSuccess()) {
            spreadModelParam.getView().showTipNotification(content.getTip());
            return;
        }
        if (HRStringUtils.isNotEmpty((String)varName)) {
            boolean hasVar;
            HashMap cellParam = Maps.newHashMapWithExpectedSize((int)1);
            Cell cell = sheet.getCell(spreadSelector.getStartRow(), spreadSelector.getStartCol());
            if (Objects.isNull(cell)) {
                cell = new Cell();
                cell.setRowAndCol(spreadSelector.getStartRow(), spreadSelector.getStartCol());
            }
            if (hasVar = RepCacheService.ins().cellHasRuntimeVar(sheet, cell)) {
                rptTplview.showTipNotification(ResManager.loadKDString((String)"\u4e00\u4e2a\u5355\u5143\u683c\u53ea\u5141\u8bb8\u63d2\u5165\u4e00\u4e2a\u53d8\u91cf\u3002", (String)"ReportConfFormHelper_0", (String)"sihc-soehrr-business", (Object[])new Object[0]));
                view.sendFormAction(rptTplview);
                return;
            }
            RepRuntimeVar reportVar = new RepRuntimeVar(cell, rptTplview.getModel().getDataEntity(true), classifyVar);
            Object cellValue = cell.getValue();
            varName = (HRObjectUtils.isEmpty((Object)cellValue) ? "" : cellValue) + varName;
            cell.setValue((Object)varName);
            sheet.getInvoker().setCacheDto((ReportCacheDto)reportVar);
            sheet.setSheetCache(view.getPageCache());
            cellParam.put(spreadSelector, varName);
            UpdCellsValCommand command = new UpdCellsValCommand((Map)cellParam);
            command.invokeMethod(spreadModelParam.getProxy(), spreadModelParam.getSpreadKey());
        }
    }

    public TipContent canInsertVar(SpreadModelParam spreadModelParam) {
        AreaSettingDto dyArea;
        SpreadSelector dySelector;
        SheetManager sheetManager = spreadModelParam.getSheetManager();
        List<AreaSettingDto> dynamicSummaryAreas = RepCacheService.ins().getExistAreaByType(sheetManager.getInvoker(), AreaSettingEnum.DYNAMIC_SUMMARY);
        SpreadSelector tarSelector = spreadModelParam.getSelector();
        if (HRCollUtil.isNotEmpty(dynamicSummaryAreas) && tarSelector.checkIsInArea(dySelector = (dyArea = dynamicSummaryAreas.get(0)).convert2Selector()) && tarSelector.getStartCol() != dySelector.getStartCol()) {
            return TipContent.error((String)ResManager.loadKDString((String)"\u7f57\u5217\u6c47\u603b\u65f6\uff0c\u53ea\u6709\u52a8\u6001\u7f57\u5217\u533a\u4e2d\u9996\u5217\u5141\u8bb8\u63d2\u5165\u53d8\u91cf\u3002", (String)"RptTplVarService_0", (String)"sihc-soehrr-business", (Object[])new Object[0]));
        }
        return TipContent.success();
    }

    public void clearAllVarsForSpread(List<RepRuntimeVar> vars, SpreadModelParam spreadParam) {
        HashMap param = Maps.newHashMapWithExpectedSize((int)vars.size());
        for (RepRuntimeVar var : vars) {
            String strValue;
            Cell cell = var.getCell();
            SheetManager sheetManager = spreadParam.getSheetManager();
            Cell sheetManagerCell = sheetManager.getCell(cell.getRow(), cell.getCol());
            Object cellValue = sheetManagerCell.getValue();
            if (!(cellValue instanceof String) || !HRStringUtils.isNotEmpty((String)((String)cellValue)) || !(strValue = (String)cellValue).contains("#{") || strValue.lastIndexOf("}") <= strValue.indexOf("#{")) continue;
            strValue = strValue.substring(0, strValue.indexOf("#{")) + strValue.substring(strValue.lastIndexOf("}") + 1);
            param.put(sheetManagerCell.toSelector(), strValue);
            new UpdCellsValCommand((Map)param).invokeMethod(spreadParam);
        }
    }

    public void updateVarDeleteRow(SpreadModelParam spreadModelParam, List<Integer> selectIndexList) {
        SheetManager sheetManager = spreadModelParam.getSheetManager();
        DataTableManager selectDataTable = sheetManager.getSelectDataTable();
        CacheObjInvoker invoker = sheetManager.getInvoker();
        List allVars = invoker.getAllEnableByEntityId("soehrr_rpttplvar");
        int count = 0;
        for (Integer index : selectIndexList) {
            if ((index = Integer.valueOf(index - count)) < 0) {
                index = 0;
            }
            selectDataTable.deleteRow(index.intValue());
            ++count;
        }
        selectDataTable.refreshTable();
        block1: for (RepRuntimeVar var : allVars) {
            if (var.getOperate() == OperateEnum.DELETE) continue;
            Cell varCell = var.getCell();
            int row = varCell.getRow();
            int col = varCell.getCol();
            int delCount = 0;
            for (Integer index : selectIndexList) {
                if (row == (index = Integer.valueOf(index - delCount))) {
                    var.setOperate(OperateEnum.DELETE);
                    continue block1;
                }
                if (row > index) {
                    var.setOperate(OperateEnum.ADD);
                    varCell.setRowAndCol(--row, col);
                    var.updateRowAndCol(varCell);
                }
                ++delCount;
            }
        }
        spreadModelParam.getSheetManager().setSheetCache(spreadModelParam.getView());
    }

    public void updateVarInsertRow(SpreadModelParam spreadModelParam, List<Integer> selectIndexList, int count) {
        SheetManager sheetManager = spreadModelParam.getSheetManager();
        DataTableManager selectDataTable = sheetManager.getSelectDataTable();
        CacheObjInvoker invoker = sheetManager.getInvoker();
        List allVars = invoker.getAllEnableByEntityId("soehrr_rpttplvar");
        for (Integer index : selectIndexList) {
            for (int i = 0; i < count; ++i) {
                selectDataTable.insertRow(index + i);
            }
        }
        selectDataTable.refreshTable();
        for (RepRuntimeVar var : allVars) {
            if (var.getOperate() == OperateEnum.DELETE) continue;
            Cell varCell = var.getCell();
            int row = varCell.getRow();
            int col = varCell.getCol();
            for (Integer index : selectIndexList) {
                for (int i = 0; i < count; ++i) {
                    int key = index + i;
                    if (row < key) continue;
                    var.setOperate(OperateEnum.ADD);
                    varCell.setRowAndCol(++row, col);
                    var.updateRowAndCol(varCell);
                }
            }
        }
        spreadModelParam.getSheetManager().setSheetCache(spreadModelParam.getView());
    }

    public void updateVarInsertCol(SpreadModelParam spreadModelParam, List<Integer> selectIndexList, int count) {
        SheetManager sheetManager = spreadModelParam.getSheetManager();
        DataTableManager selectDataTable = sheetManager.getSelectDataTable();
        CacheObjInvoker invoker = spreadModelParam.getSheetManager().getInvoker();
        List allVars = invoker.getAllEnableByEntityId("soehrr_rpttplvar");
        for (Integer index : selectIndexList) {
            for (int i = 0; i < count; ++i) {
                selectDataTable.insertCol(index + i);
            }
        }
        selectDataTable.refreshTable();
        for (RepRuntimeVar var : allVars) {
            if (var.getOperate() == OperateEnum.DELETE) continue;
            Cell varCell = var.getCell();
            int row = varCell.getRow();
            int col = varCell.getCol();
            for (Integer index : selectIndexList) {
                for (int i = 0; i < count; ++i) {
                    int key = index + i;
                    if (col < key) continue;
                    varCell.setRowAndCol(row, ++col);
                    var.updateRowAndCol(varCell);
                    var.setOperate(OperateEnum.ADD);
                }
            }
        }
        spreadModelParam.getSheetManager().setSheetCache(spreadModelParam.getView());
    }

    public void updateVarDeleteCol(SpreadModelParam spreadModelParam, List<Integer> selectIndexList) {
        SheetManager sheetManager = spreadModelParam.getSheetManager();
        DataTableManager selectDataTable = sheetManager.getSelectDataTable();
        CacheObjInvoker invoker = sheetManager.getInvoker();
        List allVars = invoker.getAllEnableByEntityId("soehrr_rpttplvar");
        int count = 0;
        for (Integer index : selectIndexList) {
            if ((index = Integer.valueOf(index - count)) < 0) {
                index = 0;
            }
            selectDataTable.deleteCol(index.intValue());
            ++count;
        }
        selectDataTable.refreshTable();
        block1: for (RepRuntimeVar var : allVars) {
            if (var.getOperate() == OperateEnum.DELETE) continue;
            Cell varCell = var.getCell();
            int row = varCell.getRow();
            int col = varCell.getCol();
            int delCount = 0;
            for (Integer index : selectIndexList) {
                if (col == (index = Integer.valueOf(index - delCount))) {
                    var.setOperate(OperateEnum.DELETE);
                    continue block1;
                }
                if (col > index) {
                    varCell.setRowAndCol(row, --col);
                    var.updateRowAndCol(varCell);
                    var.setOperate(OperateEnum.ADD);
                }
                ++delCount;
            }
        }
        spreadModelParam.getSheetManager().setSheetCache(spreadModelParam.getView());
    }

    public boolean isMatchVar(String val) {
        String regex = "#\\{.+?\\}";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(val);
        return matcher.find();
    }

    public List<RepRuntimeVar> parseSampleVar(SheetManager sheetManager, DynamicObject rptTpl) {
        DynamicObject reportClassify = rptTpl.getDynamicObject("reportclassify");
        DynamicObject[] classifyVars = RptTplVarService.getInstance().queryByClassify((Long)reportClassify.getPkValue());
        DynamicObject[] commonVars = RptTplVarService.getInstance().queryByClassify(0L);
        List<DynamicObject> vars = Arrays.asList(commonVars);
        vars.addAll(Arrays.asList(classifyVars));
        Map<String, DynamicObject> varMap = vars.stream().collect(Collectors.toMap(var -> "#{" + var.getString("name") + "}", var -> var, (k, v) -> v));
        DataTableManager selectDataTable = sheetManager.getSelectDataTable();
        List table = selectDataTable.getTable();
        ArrayList result = Lists.newArrayListWithExpectedSize((int)10);
        for (List row : table) {
            for (Cell cell : row) {
                String varStr;
                DynamicObject classifyVar;
                boolean matchVar;
                Object cellValue;
                if (cell == null || Objects.isNull(cellValue = cell.getValue()) || !(matchVar = this.isMatchVar(String.valueOf(cellValue))) || HRObjectUtils.isEmpty((Object)(classifyVar = varMap.get(varStr = String.valueOf(cellValue))))) continue;
                RepRuntimeVar reportVar = new RepRuntimeVar(cell, rptTpl, classifyVar);
                result.add(reportVar);
            }
        }
        return result;
    }

    public RptTplVarService() {
        super("soehrr_rptclassifyvar");
    }

    public static RptTplVarService getInstance() {
        return Instance.INSTANCE;
    }

    private static class Instance {
        private static final RptTplVarService INSTANCE = new RptTplVarService();

        private Instance() {
        }
    }
}

