/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soehrr.business.domain.spantable;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.sihc.soehrr.business.spread.SpreadClientInvoker;
import kd.sdk.sihc.soehrr.business.spread.command.SetFormalCommand;
import kd.sdk.sihc.soehrr.business.spread.helper.SpreadJsonHelper;
import kd.sdk.sihc.soehrr.common.enums.RptTypeEnum;
import kd.sdk.sihc.soehrr.common.spread.Cell;
import kd.sdk.sihc.soehrr.common.spread.SheetManager;
import kd.sdk.sihc.soehrr.common.spread.SpreadModelParam;
import kd.sdk.sihc.soehrr.common.util.GzipTools;
import kd.sihc.soehrr.business.domain.rpttpl.RptTplService;
import kd.sihc.soehrr.common.utils.SoeHrrPageUtils;
import org.apache.commons.collections.CollectionUtils;

public final class FormulaFormHelper {
    private static final Log LOG = LogFactory.getLog(FormulaFormHelper.class);

    private FormulaFormHelper() {
    }

    public static void initDropDownList(long nowReportId, String srcSheetNumber, IFormView view) {
        Long customParam = (Long)view.getFormShowParameter().getCustomParam("reportclassify");
        DynamicObject[] rptTpls = RptTplService.getInstance().queryEnableByClassify(customParam);
        ArrayList comboItems = Lists.newArrayListWithExpectedSize((int)10);
        ComboItem nowItem = new ComboItem();
        nowItem.setValue(srcSheetNumber);
        nowItem.setId(String.valueOf(nowReportId));
        nowItem.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5f53\u524d\u8868", (String)"SetFormulaPlugin_1", (String)"sihc-soehrr-formplugin", (Object[])new Object[0])));
        String defaultValue = nowItem.getValue();
        comboItems.add(nowItem);
        for (DynamicObject rptTpl : rptTpls) {
            String rptTplType;
            long reportId = (Long)rptTpl.getPkValue();
            if (reportId == nowReportId || HRStringUtils.equals((String)(rptTplType = rptTpl.getString("rpttype")), (String)RptTypeEnum.DETAIL.getType())) continue;
            ComboItem item = new ComboItem();
            item.setValue(rptTpl.getString("number") + ":" + reportId);
            OrmLocaleValue name = (OrmLocaleValue)rptTpl.getLocaleString("name");
            String localeValue = name.getLocaleValue();
            item.setCaption(new LocaleString(localeValue));
            item.setId(String.valueOf(reportId));
            comboItems.add(item);
        }
        ComboEdit comboEdit = (ComboEdit)view.getControl("tarreport");
        comboEdit.setComboItems((List)comboItems);
        view.getModel().setValue("tarreport", (Object)defaultValue);
    }

    public static void addSheetByTableNo(String tableName, SpreadModelParam spreadParam, IFormView view) {
        IFormView formulaView = spreadParam.getView();
        String curNumber = (String)formulaView.getFormShowParameter().getCustomParam("number");
        String srcSpreadJson = SoeHrrPageUtils.getSpreadJsonByPView((IFormView)formulaView.getParentView());
        if (HRStringUtils.equals((String)tableName, (String)curNumber)) {
            String newSrcSpread = SpreadJsonHelper.displaySelSheet((String)srcSpreadJson, (String)tableName);
            SoeHrrPageUtils.setSpreadJsonByPView((IFormView)formulaView.getParentView(), (String)newSrcSpread);
            view.getFormShowParameter().setCustomParam("newSheetName", (Object)tableName);
            view.getFormShowParameter().setCustomParam("firstChoice", (Object)"1");
            view.cacheFormShowParameter();
            SpreadClientInvoker.invokeSetSpreadJsonMethod((IClientViewProxy)spreadParam.getProxy(), (String)spreadParam.getSpreadKey(), (Object)newSrcSpread);
        } else {
            DynamicObject rptTpl = RptTplService.getInstance().loadEnableByNumber(tableName);
            DynamicObject newVersionEntry = RptTplService.getInstance().getCurrentEntry(rptTpl);
            String tarCurrentJson = newVersionEntry.getString("json_tag");
            if (HRStringUtils.isEmpty((String)tarCurrentJson)) {
                return;
            }
            String newSheetName = rptTpl.getString("number");
            String newSrcSpread = SpreadJsonHelper.addTarSheetToSrcSheets((String)tarCurrentJson, (String)srcSpreadJson, (String)newSheetName);
            SoeHrrPageUtils.setSpreadJsonByPView((IFormView)formulaView.getParentView(), (String)newSrcSpread);
            view.getFormShowParameter().setCustomParam("firstChoice", (Object)"1");
            view.getFormShowParameter().setCustomParam("newSheetName", (Object)newSheetName);
            view.cacheFormShowParameter();
            SpreadClientInvoker.invokeSetSpreadJsonMethod((IClientViewProxy)spreadParam.getProxy(), (String)spreadParam.getSpreadKey(), (Object)newSrcSpread);
        }
    }

    public static String getSpanSheetNumber(String dropDownName) {
        if (HRStringUtils.isEmpty((String)dropDownName) || HRStringUtils.equals((String)dropDownName, (String)"0")) {
            return "Sheet1";
        }
        if (dropDownName.indexOf(":") > 0) {
            dropDownName = dropDownName.substring(0, dropDownName.lastIndexOf(":"));
        }
        return dropDownName;
    }

    public static long getSpanSheetId(String dropDownName) {
        if (HRStringUtils.isEmpty((String)dropDownName) || HRStringUtils.equals((String)dropDownName, (String)"0")) {
            return 0L;
        }
        if (dropDownName.indexOf(":") > 0) {
            return Long.parseLong(dropDownName.substring(dropDownName.lastIndexOf(":") + 1));
        }
        return 0L;
    }

    public static String parseFormulaAddRptSheet(List<JSONObject> formulas, String spreadJson, SpreadModelParam param) {
        HashSet tableNumbers = Sets.newHashSetWithExpectedSize((int)16);
        String rptTplNumber = (String)param.getView().getModel().getValue("number");
        if (CollectionUtils.isNotEmpty(formulas)) {
            formulas.forEach(jsonObject -> {
                String[] formulaSplit;
                String formula = jsonObject.getString("f");
                String replacedFormula = formula.replace("'", "");
                if (replacedFormula.contains("(") && replacedFormula.contains(")")) {
                    replacedFormula = replacedFormula.substring(replacedFormula.indexOf("(") + 1, replacedFormula.lastIndexOf(")"));
                }
                for (String formulaCase : formulaSplit = replacedFormula.split(",")) {
                    String[] datas;
                    String parseRtpTplNumber;
                    if (!formulaCase.contains("!") || HRStringUtils.equals((String)(parseRtpTplNumber = (datas = formulaCase.split("!"))[0]), (String)rptTplNumber) || HRStringUtils.isEmpty((String)parseRtpTplNumber)) continue;
                    tableNumbers.add(parseRtpTplNumber);
                }
            });
        }
        LOG.info("FormulaFormHelper.parseFormulaAddRptSheet add tableNumbers = {}", (Object)tableNumbers);
        Map<String, String> addSpreadJsonMap = RptTplService.getInstance().fetchSpreadJsonByNumbers(tableNumbers);
        String newCompressSpreadJson = SpreadJsonHelper.addRptsToSrcSpread(addSpreadJsonMap, (String)spreadJson, null);
        return newCompressSpreadJson;
    }

    public static void updateSheetFormula(SpreadModelParam spreadParam, String formulas) {
        String uncompressJson = GzipTools.uncompressJson((String)formulas);
        List formulaArray = JSONArray.parseArray((String)uncompressJson, JSONObject.class);
        SheetManager sheetManager = spreadParam.getSheetManager();
        for (JSONObject formulaMap : formulaArray) {
            Cell cell = sheetManager.getCell(formulaMap.getInteger("r").intValue(), formulaMap.getInteger("c").intValue());
            cell.setFormula(formulaMap.getString("f"));
        }
        sheetManager.setSheetCache(spreadParam.getView());
    }

    public static void getFormulaForSaveSheet(SpreadModelParam param, String formulas, IFormPlugin plugin) {
        String spreadJson = SoeHrrPageUtils.getSpreadJsonByPView((IFormView)param.getView());
        String newCellStr = (String)param.getView().getFormShowParameter().getCustomParam("cell");
        Cell newCell = (Cell)GzipTools.deSerializedBytes((String)newCellStr);
        SheetManager sheetManager = param.getSheetManager();
        String uncompressJson = GzipTools.uncompressJson((String)formulas);
        LOG.info("FormulaFormHelper.getFormulaForSaveSheet formulas = {}", (Object)uncompressJson);
        List formulaArray = JSONArray.parseArray((String)uncompressJson, JSONObject.class);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("r", (Object)newCell.getRow());
        jsonObject.put("c", (Object)newCell.getCol());
        jsonObject.put("f", (Object)newCell.getFormula());
        boolean replaced = false;
        for (JSONObject formulaMap : formulaArray) {
            if (formulaMap.getInteger("r").intValue() != newCell.getRow() || formulaMap.getInteger("c").intValue() != newCell.getCol()) continue;
            formulaMap.put("f", (Object)newCell.getFormula());
            replaced = true;
            break;
        }
        if (!replaced) {
            formulaArray.add(jsonObject);
        }
        LOG.info("FormulaFormHelper.getFormulaForSaveSheet has formulaArray? = {}", (Object)formulaArray);
        String newCompressSpreadJson = FormulaFormHelper.parseFormulaAddRptSheet(formulaArray, spreadJson, param);
        SpreadClientInvoker.invokeSetSpreadJsonMethod((IClientViewProxy)param.getProxy(), (String)param.getSpreadKey(), (Object)newCompressSpreadJson);
        ArrayList formulaCells = Lists.newArrayListWithExpectedSize((int)formulaArray.size());
        for (JSONObject formulaMap : formulaArray) {
            Cell cell = sheetManager.getCell(formulaMap.getInteger("r").intValue(), formulaMap.getInteger("c").intValue());
            cell.setFormula(formulaMap.getString("f"));
            formulaCells.add(cell);
        }
        sheetManager.setSheetCache(param.getView());
        SetFormalCommand command = new SetFormalCommand((List)formulaCells);
        command.invokeMethod(param);
        SoeHrrPageUtils.setSpreadJsonByPView((IFormView)param.getView(), null);
        param.getView().getFormShowParameter().setCustomParam("cell", null);
        param.getView().cacheFormShowParameter();
    }
}

