/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soehrr.business.listener;

import java.util.Collections;
import kd.bos.form.IFormView;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.sihc.soehrr.business.spread.command.SetFormalCommand;
import kd.sdk.sihc.soehrr.common.enums.ExcelFormulaEnum;
import kd.sdk.sihc.soehrr.common.spread.Cell;
import kd.sdk.sihc.soehrr.common.spread.SheetManager;
import kd.sdk.sihc.soehrr.common.spread.SpreadModelParam;
import kd.sdk.sihc.soehrr.common.spread.SpreadSelector;
import kd.sdk.sihc.soehrr.common.spread.notify.NotifyEvent;
import kd.sdk.sihc.soehrr.common.spread.notify.NotifyListener;
import kd.sdk.sihc.soehrr.common.util.ExcelUtils;
import kd.sdk.sihc.soehrr.common.util.GzipTools;

public class AfterSetFormulaSelectListener
implements NotifyListener {
    private SpreadModelParam spreadModelParam;

    public AfterSetFormulaSelectListener(SpreadModelParam spreadModelParam) {
        this.spreadModelParam = spreadModelParam;
    }

    public void doNotify(NotifyEvent event) {
        SheetManager sheetManager = (SheetManager)event.getSource();
        SpreadSelector selector = (SpreadSelector)event.getParam();
        IFormView formView = this.spreadModelParam.getView();
        String cellStr = (String)formView.getFormShowParameter().getCustomParam("cell");
        if (cellStr == null) {
            return;
        }
        Cell cell = (Cell)GzipTools.deSerializedBytes((String)cellStr);
        String value = cell.valueToString();
        if (HRStringUtils.isEmpty((String)value) && this.isNotFormula(value)) {
            return;
        }
        String formulaBody = this.changeSelectPointToFormula(selector);
        String resultFormula = this.assembleFormula(formulaBody, value);
        Cell sheetCell = sheetManager.getCell(cell.getRow(), cell.getCol());
        sheetCell.setFormula(resultFormula);
        SetFormalCommand command = new SetFormalCommand(Collections.singletonList(sheetCell));
        command.invokeMethod(this.spreadModelParam);
        sheetManager.setSheetCache(formView);
        formView.getFormShowParameter().setCustomParam("cell", null);
        formView.cacheFormShowParameter();
    }

    private boolean isNotFormula(String value) {
        ExcelFormulaEnum[] values;
        for (ExcelFormulaEnum excelFormulaEnum : values = ExcelFormulaEnum.values()) {
            if (!excelFormulaEnum.name().equals(value)) continue;
            return false;
        }
        return true;
    }

    private String assembleFormula(String formulaBody, String pageFormula) {
        pageFormula = pageFormula.substring(0, pageFormula.length() - 1);
        pageFormula = pageFormula + formulaBody + ")";
        return pageFormula;
    }

    private String changeSelectPointToFormula(SpreadSelector selector) {
        String excelPoint1 = ExcelUtils.xy2Pos((int)selector.getStartCol(), (int)selector.getStartRow());
        String excelPoint2 = ExcelUtils.xy2Pos((int)selector.getEndCol(), (int)selector.getEndRow());
        String formula = excelPoint1;
        if (!HRStringUtils.equals((String)excelPoint1, (String)excelPoint2)) {
            formula = formula + ":" + excelPoint2;
            return formula;
        }
        return excelPoint1;
    }
}

