/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soehrr.business.listener;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.sdk.sihc.soehrr.business.spread.command.BorderHlStyleCommand;
import kd.sdk.sihc.soehrr.business.spread.command.GetSpreadJsonCommand;
import kd.sdk.sihc.soehrr.business.spread.command.SetAreaCommand;
import kd.sdk.sihc.soehrr.common.enums.AreaSettingEnum;
import kd.sdk.sihc.soehrr.common.enums.CallBackEnum;
import kd.sdk.sihc.soehrr.common.report.dto.AreaSettingDto;
import kd.sdk.sihc.soehrr.common.report.dto.ReportCacheDto;
import kd.sdk.sihc.soehrr.common.spread.SheetManager;
import kd.sdk.sihc.soehrr.common.spread.SpreadModelParam;
import kd.sdk.sihc.soehrr.common.spread.SpreadSelector;
import kd.sdk.sihc.soehrr.common.spread.notify.NotifyEvent;
import kd.sdk.sihc.soehrr.common.spread.notify.NotifyListener;
import kd.sihc.soehrr.business.domain.cache.RepCacheService;
import org.apache.commons.lang3.tuple.Pair;

public class BeforeSelectHighlightListener
implements NotifyListener {
    private IFormView formView;
    private String spreadKey;
    private IClientViewProxy proxy;

    public BeforeSelectHighlightListener(IFormView formView, String spreadKey) {
        this.formView = formView;
        this.spreadKey = spreadKey;
        this.proxy = (IClientViewProxy)formView.getService(IClientViewProxy.class);
    }

    public void doNotify(NotifyEvent event) {
        SheetManager sheetManager = (SheetManager)event.getSource();
        SpreadSelector selector = (SpreadSelector)event.getParam();
        AreaSettingDto relationDto = sheetManager.getRelationDto();
        if (relationDto == null) {
            this.showRelationArea(selector, sheetManager);
            return;
        }
        if (selector.getSpanRow() != 1 && selector.getSpanCol() != 1) {
            sheetManager.clearRelation(this.formView);
            this.formView.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u884c\u6216\u5355\u5217\u8bbe\u4e3a\u76ee\u6807\u533a\u3002", (String)"BeforeSelectHighlightListener_1", (String)"sihc-soehrr-business", (Object[])new Object[0]));
            return;
        }
        SpreadModelParam modelParam = new SpreadModelParam();
        modelParam.setSelector(selector);
        modelParam.setSheetManager(sheetManager);
        modelParam.setSpreadKey(this.spreadKey);
        modelParam.setView(this.formView);
        SpreadSelector relationSelector = relationDto.convert2Selector();
        if (relationSelector.checkIsIntersectArea(selector)) {
            sheetManager.clearRelation(this.formView);
            this.formView.showErrorNotification(ResManager.loadKDString((String)"\u76ee\u6807\u533a\u57df\u4e0d\u5141\u8bb8\u4e0e\u6e90\u533a\u57df\u76f8\u4ea4\u3002", (String)"BeforeSelectHighlightListener_0", (String)"sihc-soehrr-business", (Object[])new Object[0]));
            return;
        }
        String areaPointStr = selector.getAreaPointStr();
        relationDto.setOtherAreaPoint(areaPointStr);
        sheetManager.getInvoker().setCacheDto((ReportCacheDto)relationDto);
        sheetManager.clearRelation(this.formView);
        LinkedHashMap param = Maps.newLinkedHashMapWithExpectedSize((int)16);
        param.put(sheetManager.areaConf(relationDto.getAreaSetting()), Collections.singletonList(relationSelector));
        SetAreaCommand command = new SetAreaCommand((Map)param);
        command.invokeMethod(this.proxy, this.spreadKey);
    }

    private void showRelationArea(SpreadSelector selector, SheetManager sheetManager) {
        selector = selector.getLeftTopPoint();
        List<Object> cacheDtoList = RepCacheService.ins().getDataAreaBySetting(sheetManager.getInvoker());
        cacheDtoList = cacheDtoList.stream().filter(dto -> Lists.newArrayList((Object[])new AreaSettingEnum[]{AreaSettingEnum.LAST_GET_NUM, AreaSettingEnum.SYS_AUTO_NUM, AreaSettingEnum.LYEAR_GET_NUM}).contains(dto.getAreaSetting())).collect(Collectors.toList());
        boolean noClickOther = true;
        for (AreaSettingDto areaSettingDto : cacheDtoList) {
            SpreadSelector tarSelector = areaSettingDto.convert2Selector();
            if (!selector.checkIsInArea(tarSelector)) continue;
            GetSpreadJsonCommand getSpreadJsonCommand = new GetSpreadJsonCommand(CallBackEnum.LAST_GETNUM_GETJSON.getM());
            getSpreadJsonCommand.invokeMethod(this.proxy, this.spreadKey);
            noClickOther = false;
            break;
        }
        if (noClickOther && Objects.nonNull(sheetManager.getHighlightArea())) {
            List highlightAreas = sheetManager.getHighlightArea();
            BorderHlStyleCommand borderHlStyleCommand = new BorderHlStyleCommand(Pair.of((Object)sheetManager.areaConf(AreaSettingEnum.CLEAR), (Object)highlightAreas));
            borderHlStyleCommand.invokeMethod(this.proxy, this.spreadKey);
            sheetManager.clearHighlightArea(this.formView);
        }
    }
}

