/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soehrr.business.listener.filltask;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.spread.SpreadPostDataInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.sihc.soehrr.business.spread.command.GetSpreadJsonCommand;
import kd.sdk.sihc.soehrr.common.enums.CallBackEnum;
import kd.sdk.sihc.soehrr.common.report.dto.RepValidatorDto;
import kd.sdk.sihc.soehrr.common.spread.SpreadModelParam;
import kd.sdk.sihc.soehrr.common.spread.notify.NotifyEvent;
import kd.sdk.sihc.soehrr.common.spread.notify.NotifyListener;
import kd.sdk.sihc.soehrr.common.util.GzipTools;
import kd.sihc.soehrr.business.application.report.ReportVerParam;
import kd.sihc.soehrr.business.domain.collecttask.FillTaskHelper;
import kd.sihc.soehrr.common.check.ExpressionSplitor;

public class FillTaskUpdCellListener
implements NotifyListener {
    private static final Log LOG = LogFactory.getLog(FillTaskUpdCellListener.class);
    private static final String VER_RULE_KEY = "ruleMapCellVerCacheKey";
    private SpreadModelParam spreadModelParam;

    public FillTaskUpdCellListener(SpreadModelParam spreadParam) {
        this.spreadModelParam = spreadParam;
    }

    public void doNotify(NotifyEvent event) {
        IFormView fillTaskView = this.spreadModelParam.getView();
        String entityId = fillTaskView.getEntityId();
        SpreadPostDataInfo param = (SpreadPostDataInfo)event.getParam();
        List values = param.getValues();
        String sheetName = FillTaskHelper.getActiveSheetName(fillTaskView);
        List<String> orderSheetNames = FillTaskHelper.getOrderSheetNames(fillTaskView);
        List allSheetsVerRules = this.spreadModelParam.getSheetManager().getAllSheetRuleByEntity("soehrr_rpttplverrule");
        Map<String, List<String>> sheetNumberMapCells = this.getAllSheetCells(allSheetsVerRules, fillTaskView);
        boolean doCheck = false;
        for (LinkedHashMap map : values) {
            List clickVerParams;
            String cacheKey;
            Integer r = (Integer)map.get("r");
            Integer c = (Integer)map.get("c");
            List<String> needCheckSheets = sheetNumberMapCells.get(r + ":" + c);
            Object v = map.get("v");
            LOG.info("FillTaskUpdCellListener.doNotify sheetName={},r = {},c = {},v = {}", new Object[]{sheetName, r, c, v});
            if (HRCollUtil.isEmpty(needCheckSheets) || !needCheckSheets.contains(sheetName)) continue;
            doCheck = true;
            ReportVerParam reportVerParam = new ReportVerParam(sheetName, String.join((CharSequence)",", orderSheetNames), r, c, v);
            IPageCache pageCache = fillTaskView.getPageCache();
            String verParamStr = pageCache.get(cacheKey = ReportVerParam.class.getName() + fillTaskView.getPageId());
            if (HRStringUtils.isNotEmpty((String)verParamStr)) {
                clickVerParams = (List)GzipTools.deSerializedBytes((String)verParamStr);
                clickVerParams.add(reportVerParam);
                pageCache.put(cacheKey, GzipTools.toByteSerialized((Object)clickVerParams));
                continue;
            }
            clickVerParams = Lists.newArrayList((Object[])new ReportVerParam[]{reportVerParam});
            pageCache.put(cacheKey, GzipTools.toByteSerialized((Object)clickVerParams));
        }
        if (doCheck) {
            fillTaskView.cacheFormShowParameter();
            GetSpreadJsonCommand command = new GetSpreadJsonCommand(CallBackEnum.FILLTASK_CHECK_CELL.getM());
            command.invokeMethod(this.spreadModelParam);
        }
        event.setCancel(true);
        LOG.info(entityId);
    }

    public Map<String, List<String>> getAllSheetCells(List<RepValidatorDto> allSheetsVerRules, IFormView fillTaskView) {
        String verRuleStr = fillTaskView.getPageCache().get(VER_RULE_KEY);
        if (HRStringUtils.isNotEmpty((String)verRuleStr)) {
            LOG.info("FillTaskUpdCellListener.getAllSheetCells has sheetNumberMapCells direct return");
            Map sheetNumberMapCells = (Map)GzipTools.deSerializedBytes((String)verRuleStr);
            return sheetNumberMapCells;
        }
        HashMap sheetNumberMapCells = Maps.newHashMapWithExpectedSize((int)allSheetsVerRules.size());
        for (RepValidatorDto verRule : allSheetsVerRules) {
            String checkExpression = verRule.getExpression();
            List sheetAndCells = ExpressionSplitor.splitItem((String)checkExpression);
            for (String sheetAndCell : sheetAndCells) {
                if (HRStringUtils.isEmpty((String)sheetAndCell)) continue;
                String[] sheetCellArr = sheetAndCell.split("!");
                String srcSheetNumber = sheetCellArr[0].trim();
                String cellNumPoint = sheetCellArr[1].trim();
                List sheetNumbers = (List)sheetNumberMapCells.get(cellNumPoint);
                if (HRCollUtil.isEmpty((Collection)sheetNumbers)) {
                    sheetNumbers = Lists.newArrayListWithExpectedSize((int)10);
                    sheetNumbers.add(srcSheetNumber);
                    sheetNumberMapCells.put(cellNumPoint, sheetNumbers);
                    continue;
                }
                sheetNumbers.add(srcSheetNumber);
            }
        }
        fillTaskView.getPageCache().put(VER_RULE_KEY, GzipTools.toByteSerialized((Object)sheetNumberMapCells));
        return sheetNumberMapCells;
    }
}

