/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soehrr.business.listener.formula;

import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.sihc.soehrr.common.spread.SpreadSelector;
import kd.sdk.sihc.soehrr.common.spread.notify.NotifyEvent;
import kd.sdk.sihc.soehrr.common.spread.notify.NotifyListener;
import kd.sdk.sihc.soehrr.common.util.ExcelUtils;
import kd.sihc.soehrr.business.domain.spantable.FormulaFormHelper;

public class AfterSelectListener
implements NotifyListener {
    private IFormView formView;

    public AfterSelectListener(IFormView formView) {
        this.formView = formView;
    }

    public void doNotify(NotifyEvent event) {
        String srcSheetNumber;
        SpreadSelector selector = (SpreadSelector)event.getParam();
        FormShowParameter formShowParameter = this.formView.getFormShowParameter();
        String rptTplId = (String)formShowParameter.getCustomParam("soehrr_rpttpl");
        String tabTableId = this.formView.getPageCache().get("cacheTabTable");
        String firstChoice = (String)formShowParameter.getCustomParam("firstChoice");
        if (HRStringUtils.isNotEmpty((String)firstChoice)) {
            formShowParameter.setCustomParam("firstChoice", null);
            this.formView.cacheFormShowParameter();
            return;
        }
        boolean isMainTable = rptTplId.contains(tabTableId);
        String formulaBody = this.changeSelectPointToFormula(selector);
        String pageFormula = (String)this.formView.getModel().getValue("formula");
        if (HRStringUtils.isEmpty((String)pageFormula)) {
            return;
        }
        String resultFormula = this.assembleFormula(isMainTable, formulaBody, pageFormula);
        if (resultFormula.contains(srcSheetNumber = (String)formShowParameter.getCustomParam("number"))) {
            srcSheetNumber = srcSheetNumber + "!";
            resultFormula = resultFormula.replaceAll(srcSheetNumber, "");
        }
        this.formView.getModel().setValue("formula", (Object)resultFormula);
    }

    private String assembleFormula(boolean isMainTable, String formulaBody, String pageFormula) {
        int dis = pageFormula.lastIndexOf(")") - pageFormula.indexOf("(");
        boolean hasFormulaBody = false;
        if (dis > 1) {
            hasFormulaBody = true;
        }
        pageFormula = pageFormula.substring(0, pageFormula.length() - 1);
        String sheetName = (String)this.formView.getModel().getValue("tarreport");
        sheetName = FormulaFormHelper.getSpanSheetNumber(sheetName);
        if (isMainTable) {
            if (HRStringUtils.isNotEmpty((String)formulaBody)) {
                pageFormula = pageFormula + (hasFormulaBody ? "," : "") + sheetName + "!";
            }
            pageFormula = pageFormula + formulaBody + ")";
        } else {
            pageFormula = HRStringUtils.isNotEmpty((String)formulaBody) ? pageFormula + (hasFormulaBody ? "," : "") + sheetName + "!" + formulaBody + ")" : pageFormula + ")";
        }
        return pageFormula;
    }

    private String changeSelectPointToFormula(SpreadSelector selector) {
        String excelPoint1 = ExcelUtils.xy2Pos((int)selector.getStartCol(), (int)selector.getStartRow());
        String excelPoint2 = ExcelUtils.xy2Pos((int)selector.getEndCol(), (int)selector.getEndRow());
        String formula = excelPoint1;
        if (!HRStringUtils.equals((String)excelPoint1, (String)excelPoint2)) {
            formula = formula + ":" + excelPoint2;
            return formula;
        }
        return excelPoint1;
    }
}

