/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soehrr.business.queryservice;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.sdk.sihc.soehrr.common.util.HrrQfilterUtils;

public class RptTplQueryService {
    private static final Log LOGGER = LogFactory.getLog(RptTplQueryService.class);
    private static final HRBaseServiceHelper rptArea = new HRBaseServiceHelper("soehrr_rpttplarea");
    private static final HRBaseServiceHelper soehrrRpttpl = new HRBaseServiceHelper("soehrr_rpttpl");
    private static final String rptTplFields = "id,name,number,reportclassify,periodtype,collecttype,entryentity.json_tag,entryentity.isnowedit,entryentity.isnewversion,entryentity.auditdatetime";
    private static final HRBaseServiceHelper soehrrBelongperiod = new HRBaseServiceHelper("soehrr_belongperiod");

    public DynamicObject[] getRptByNumbers(List<String> numbers) {
        return soehrrRpttpl.query(rptTplFields, new QFilter[]{new QFilter("number", "in", numbers)});
    }

    public DynamicObject[] queryRptTpl(List<Long> rptIds) {
        return soehrrRpttpl.query("id,periodtype,belongperiod,isnewversion", new QFilter("id", "in", rptIds).toArray());
    }

    public DynamicObject[] queryRptTplByClass(Long classId, Long orgId) {
        QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"soehrr_rpttpl", (Long)orgId);
        return soehrrRpttpl.query("id,periodtype,modifytime,isnewversion", new QFilter("reportclassify", "=", (Object)classId).and(HrrQfilterUtils.isPublish()).and("enable", "=", (Object)"1").and(baseDataFilter).toArray());
    }

    public DynamicObject[] queryRptTplByClasses(List<Long> classIds) {
        return soehrrRpttpl.query(rptTplFields, new QFilter("reportclassify", "in", classIds).toArray());
    }

    public DynamicObject[] queryRptTplArea(List<Long> repTplIds, List<String> areaTypes) {
        QFilter filter = new QFilter("repentryid", "in", repTplIds);
        if (!HRObjectUtils.isEmpty(areaTypes)) {
            filter.and(new QFilter("areatype", "in", areaTypes));
        }
        return rptArea.query("id,reportconfid,repentryid,areapoint,areatype,analyseobject,srcareapoint", new QFilter[]{filter});
    }

    public DynamicObject queryBelongPeriod(Long id) {
        return soehrrBelongperiod.queryOne("id,name,periodtype", new QFilter("periodtype", "=", (Object)id));
    }

    public Map<String, String> queryNameByNumber(List<String> numbers) {
        Object[] dynamicObjects = soehrrRpttpl.queryOriginalArray("number,name", new QFilter("number", "in", numbers).toArray());
        HashMap map = Maps.newHashMapWithExpectedSize((int)1);
        if (!HRArrayUtils.isEmpty((Object[])dynamicObjects)) {
            for (Object object : dynamicObjects) {
                map.put(object.getString("number"), object.getString("name"));
            }
        }
        return map;
    }

    public Map<String, String> queryImportDataNameByNumber(List<String> numbers) {
        Object[] dynamicObjects = soehrrRpttpl.queryOriginalArray("number,name", new QFilter("number", "in", numbers).and(new QFilter("rpttype", "=", (Object)"1").or(new QFilter("rpttype", "=", (Object)"0").and("collecttype", "=", (Object)"0"))).toArray());
        HashMap map = Maps.newHashMapWithExpectedSize((int)1);
        if (!HRArrayUtils.isEmpty((Object[])dynamicObjects)) {
            for (Object object : dynamicObjects) {
                map.put(object.getString("number"), object.getString("name"));
            }
        }
        return map;
    }

    public Map<String, String> queryImportDataTypeByNumber(List<String> numbers) {
        Object[] dynamicObjects = soehrrRpttpl.queryOriginalArray("number,name,rpttype", new QFilter("number", "in", numbers).and(new QFilter("rpttype", "=", (Object)"1").or(new QFilter("rpttype", "=", (Object)"0").and("collecttype", "=", (Object)"0"))).toArray());
        HashMap map = Maps.newHashMapWithExpectedSize((int)1);
        if (!HRArrayUtils.isEmpty((Object[])dynamicObjects)) {
            for (Object object : dynamicObjects) {
                map.put(object.getString("number"), object.getString("rpttype"));
            }
        }
        return map;
    }
}

