/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soehrr.business.task;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.sihc.soehrr.common.util.HrrQfilterUtils;
import kd.sihc.soehrr.business.domain.collecttask.CollectTaskFormService;
import kd.sihc.soehrr.business.domain.collecttask.CollectTaskService;
import kd.sihc.soehrr.business.domain.cyccollecttask.CycCollService;
import kd.sihc.soehrr.business.domain.report.ReportService;
import kd.sihc.soehrr.business.domain.rpttpl.RptTplService;
import kd.sihc.soehrr.business.servicehelper.ServiceFactory;
import kd.sihc.soehrr.business.task.service.CycGenCollectTaskService;
import kd.sihc.soehrr.common.entity.cyccollecttask.CollectRptTplOrgs;
import kd.sihc.soehrr.common.entity.cyccollecttask.EnableCollectTask;
import kd.sihc.soehrr.common.utils.SoehrrCommonUtils;
import org.apache.commons.lang3.tuple.Pair;

public class CycGenCollectTask
extends AbstractTask {
    private static final Log LOG = LogFactory.getLog(CycGenCollectTask.class);
    private CycCollService cycCollService = ServiceFactory.getService(CycCollService.class);
    private CollectTaskFormService collectTaskFormService = ServiceFactory.getService(CollectTaskFormService.class);
    private HRBaseServiceHelper queryDisDateEntryHelper = HRBaseServiceHelper.create((String)"soehrr_querydisdate");
    private HRBaseServiceHelper autoCollRecordHelper = HRBaseServiceHelper.create((String)"soehrr_autocollrecord");
    private CollectTaskService collectTaskService = CollectTaskService.ins();

    public void execute(RequestContext requestContext, Map<String, Object> param) throws KDException {
        List<Pair<DynamicObject, EnableCollectTask>> collectTaskPairCycTask;
        Object[] queryTaskEntries;
        String paramDateStr = (String)param.get("executeDate");
        String cycCollectTaskIdStr = (String)param.get("cycCollectTaskId");
        Date executeDate = new Date();
        if (HRStringUtils.isNotEmpty((String)paramDateStr)) {
            try {
                executeDate = HRDateTimeUtils.parseDate((String)paramDateStr, (String)"yyyy-MM-dd HH:mm:ss");
            }
            catch (ParseException ex) {
                LOG.error("CycGenCollectTask parse dateStr is error", (Throwable)ex);
            }
        }
        long cycCollectTaskId = 0L;
        if (HRStringUtils.isNotEmpty((String)cycCollectTaskIdStr)) {
            cycCollectTaskId = Long.parseLong(cycCollectTaskIdStr);
        }
        if (HRArrayUtils.isEmpty((Object[])(queryTaskEntries = this.queryInDateEntries(executeDate, cycCollectTaskId)))) {
            LOG.info("CycGenCollectTask.execute queryTaskEntries is null");
            return;
        }
        List<EnableCollectTask> enableCollectTasks = this.convertCanGenCycCollectTasks((DynamicObject[])queryTaskEntries);
        LOG.info("CycGenCollectTask.execute collectTask size = {}, datas is {}", (Object)enableCollectTasks.size(), enableCollectTasks);
        if (HRCollUtil.isEmpty(enableCollectTasks)) {
            LOG.info("CycGenCollectTask.execute enableCollectTasks is null");
            return;
        }
        this.checkCanGenFillTask(enableCollectTasks);
        try (TXHandle txHandle = TX.required();){
            try {
                collectTaskPairCycTask = this.genCollectTaskByCycTask(enableCollectTasks);
            }
            catch (Throwable th) {
                txHandle.markRollback();
                throw th;
            }
        }
        for (Object queryTaskEntry : queryTaskEntries) {
            queryTaskEntry.set("isdone", (Object)"1");
        }
        this.queryDisDateEntryHelper.save((DynamicObject[])queryTaskEntries);
        LOG.info("CycGenCollectTask.execute genCollectTask is done....");
        this.addAutoRecordAndFile(collectTaskPairCycTask);
    }

    private List<Pair<DynamicObject, EnableCollectTask>> genCollectTaskByCycTask(List<EnableCollectTask> enableCollectTasks) {
        DynamicObject collectTask;
        ArrayList collectTaskPairCycTask = Lists.newArrayListWithExpectedSize((int)enableCollectTasks.size());
        ArrayList autoCollRecords = Lists.newArrayListWithExpectedSize((int)enableCollectTasks.size());
        for (EnableCollectTask enableCollectTask : enableCollectTasks) {
            String genCollectTaskName;
            String collectTaskNumber;
            int genStatus = enableCollectTask.getGenStatus();
            collectTask = this.collectTaskService.generateEmptyDynamicObject();
            List rptTplMapOrgs = enableCollectTask.getRptTplMapOrgs();
            DynamicObject cycTask = enableCollectTask.getCycCollectTask();
            List rptTplNames = rptTplMapOrgs.stream().map(ro -> ro.getRptTpl().getString("name")).collect(Collectors.toList());
            LOG.info("CycGenCollectTask.genCollectTaskByCycTask genStatus = {} , cycCollectTaskName = {} , rptTplNames = {}", new Object[]{genStatus, cycTask.getString("name"), rptTplNames});
            boolean exist = CodeRuleServiceHelper.isExist((String)"soehrr_collecttask", (DynamicObject)collectTask, null);
            if (exist) {
                collectTaskNumber = genStatus == 0 ? CodeRuleServiceHelper.getNumber((String)"soehrr_collecttask", (DynamicObject)collectTask, null) : CodeRuleServiceHelper.readNumber((String)"soehrr_collecttask", (DynamicObject)collectTask, null);
                genCollectTaskName = collectTaskNumber.replaceAll("DCT", cycTask.getString("name"));
            } else {
                String suffix = "-" + HRDateTimeUtils.format((Date)new Date(), (String)"yyyy-MM-dd") + "-" + SoehrrCommonUtils.genThreeRandom();
                collectTaskNumber = cycTask.getString("number") + suffix;
                genCollectTaskName = cycTask.getString("name") + "-" + HRDateTimeUtils.format((Date)new Date(), (String)"yyyy-MM-dd") + "-" + SoehrrCommonUtils.genThreeRandom();
            }
            collectTask.set("number", (Object)collectTaskNumber);
            collectTask.set("name", (Object)genCollectTaskName);
            if (genStatus == 0) {
                autoCollRecords.add(this.genAutoPubCollectRecord(enableCollectTask, collectTask));
                continue;
            }
            DynamicObjectCollection taskConfs = cycTask.getDynamicObjectCollection("taskfillobjs");
            collectTask.set("org", (Object)cycTask.getDynamicObject("org"));
            collectTask.set("disunit", (Object)cycTask.getDynamicObject("disunit"));
            collectTask.set("reportclassify", (Object)cycTask.getDynamicObject("reportclassify"));
            collectTask.set("year", (Object)enableCollectTask.getBelongYear());
            collectTask.set("starttime", (Object)enableCollectTask.getFillStartDate());
            collectTask.set("endtime", (Object)enableCollectTask.getFillEndDate());
            collectTask.set("desc", (Object)cycTask.getString("description"));
            collectTask.set("tasksource", (Object)"1");
            collectTask.set("cyctask", (Object)enableCollectTask.getCycCollectTask());
            collectTask.set("ismsg", (Object)"0");
            collectTask.set("creator", (Object)1L);
            collectTask.set("modifier", (Object)1L);
            collectTask.set("status", (Object)"A");
            DynamicObjectCollection fillUnits = this.filterFillUnit(taskConfs);
            DynamicObjectCollection exeUnits = collectTask.getDynamicObjectCollection("exeunits");
            exeUnits.clear();
            DynamicObjectCollection collection = new DynamicObjectCollection();
            for (DynamicObject fillUnit : fillUnits) {
                DynamicObject exeUnit = exeUnits.addNew();
                exeUnit.set("fbasedataid", (Object)fillUnit);
                collection.add((Object)exeUnit);
            }
            collectTask.set("exeunits", (Object)collection);
            DynamicObjectCollection taskFillObjects = collectTask.getDynamicObjectCollection("taskfillobjs");
            this.setFillTaskEntry(taskFillObjects, enableCollectTask);
            collectTask.set("ifinform", (Object)"1");
            collectTask.set("starttime", (Object)enableCollectTask.getFillStartDate());
            collectTask.set("endtime", (Object)enableCollectTask.getFillEndDate());
            collectTaskPairCycTask.add(Pair.of((Object)collectTask, (Object)enableCollectTask));
            OperateOption option = OperateOption.create();
            option.setVariableValue("skipCheckDataPermission", String.valueOf(true));
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)"publish", (String)"soehrr_collecttask", (DynamicObject[])new DynamicObject[]{collectTask}, (OperateOption)option);
            if (!operationResult.isSuccess()) {
                String errMsg = ((IOperateInfo)operationResult.getAllErrorOrValidateInfo().get(0)).getMessage();
                enableCollectTask.setErrorMsg(errMsg);
                enableCollectTask.setGenStatus(0);
                LOG.error("CycGenCollectTask.genCollectTaskByCycTask has error {}", (Object)operationResult.getMessage());
                continue;
            }
            List successPkIds = operationResult.getSuccessPkIds();
            try {
                CycGenCollectTaskService cycGenCollectTaskService = new CycGenCollectTaskService();
                cycGenCollectTaskService.sendMsg(successPkIds);
            }
            catch (Exception ex) {
                LOG.info("CycGenCollectTask.sendMsg has error,", (Object)ex);
            }
        }
        for (Pair taskPair : collectTaskPairCycTask) {
            EnableCollectTask enableCollectTask = (EnableCollectTask)taskPair.getRight();
            collectTask = (DynamicObject)taskPair.getLeft();
            autoCollRecords.add(this.genAutoPubCollectRecord(enableCollectTask, collectTask));
        }
        this.autoCollRecordHelper.save(autoCollRecords.toArray(new DynamicObject[0]));
        return collectTaskPairCycTask;
    }

    private void addAutoRecordAndFile(List<Pair<DynamicObject, EnableCollectTask>> collectTaskPairCycTask) {
        if (HRCollUtil.isEmpty(collectTaskPairCycTask)) {
            return;
        }
        for (Pair<DynamicObject, EnableCollectTask> taskPair : collectTaskPairCycTask) {
            EnableCollectTask enableCollectTask = (EnableCollectTask)taskPair.getRight();
            DynamicObject collectTask = (DynamicObject)taskPair.getLeft();
            if (HRObjectUtils.isEmpty((Object)collectTask)) continue;
            this.copyFile(enableCollectTask.getCycCollectTask(), collectTask);
        }
    }

    private void setFillTaskEntry(DynamicObjectCollection taskFillObjects, EnableCollectTask enableCollectTask) {
        List rptTplMapOrgs = enableCollectTask.getRptTplMapOrgs();
        for (CollectRptTplOrgs rptTplMapOrg : rptTplMapOrgs) {
            DynamicObject taskFillEntry = new DynamicObject(taskFillObjects.getDynamicObjectType());
            DynamicObject rptTpl = rptTplMapOrg.getRptTpl();
            taskFillEntry.set("rpttpl", (Object)rptTpl);
            DynamicObjectCollection fillUnits = taskFillEntry.getDynamicObjectCollection("fillunits");
            fillUnits.clear();
            List adminOrgList = rptTplMapOrg.getAdminOrgList();
            adminOrgList.forEach(adminOrg -> {
                DynamicObject fillUnit = fillUnits.addNew();
                fillUnit.set("fbasedataid", adminOrg);
            });
            taskFillEntry.set("periodtype", (Object)rptTpl.getDynamicObject("periodtype"));
            taskFillEntry.set("belongperiod", (Object)rptTplMapOrg.getBelongPeriod());
            taskFillEntry.set("datastarttime", (Object)rptTplMapOrg.getDataStartTime());
            taskFillEntry.set("dataendtime", (Object)rptTplMapOrg.getDataEndTime());
            taskFillEntry.set("repentryid", (Object)RptTplService.getInstance().getNewVersionEntry(rptTpl).getLong("id"));
            taskFillObjects.add((Object)taskFillEntry);
        }
    }

    private DynamicObject genAutoPubCollectRecord(EnableCollectTask enableCollectTask, DynamicObject collectTask) {
        DynamicObject autoCollRecord = this.autoCollRecordHelper.generateEmptyDynamicObject();
        int genStatus = enableCollectTask.getGenStatus();
        autoCollRecord.set("genstatus", (Object)genStatus);
        autoCollRecord.set("cyctask", enableCollectTask.getCycCollectTask().getPkValue());
        autoCollRecord.set("name", (Object)collectTask.getString("name"));
        autoCollRecord.set("number", (Object)collectTask.getString("number"));
        String errorMsg = enableCollectTask.getErrorMsg();
        if (HRStringUtils.isNotEmpty((String)errorMsg)) {
            autoCollRecord.set("description", (Object)errorMsg);
        }
        return autoCollRecord;
    }

    public DynamicObjectCollection filterFillUnit(DynamicObjectCollection taskSettingEntry) {
        ArrayList invokeUnits = Lists.newArrayListWithExpectedSize((int)taskSettingEntry.size());
        HashSet invokeUnitIds = Sets.newHashSetWithExpectedSize((int)16);
        for (DynamicObject dynamicObject2 : taskSettingEntry) {
            DynamicObjectCollection fillUnits = dynamicObject2.getDynamicObjectCollection("fillunits");
            for (DynamicObject fillUnit : fillUnits) {
                invokeUnits.add(fillUnit);
                invokeUnitIds.add(fillUnit.getLong("fbasedataid_id"));
            }
        }
        Map<Long, DynamicObject> idInfoMap = invokeUnits.stream().collect(Collectors.toMap(dynamicObject -> dynamicObject.getLong("fbasedataid_id"), dynamicObject -> dynamicObject, (k1, k2) -> k1));
        DynamicObjectCollection distinctFillUnits = new DynamicObjectCollection();
        invokeUnitIds.forEach(obj -> distinctFillUnits.add((Object)((DynamicObject)idInfoMap.get(obj)).getDynamicObject("fbasedataid")));
        return distinctFillUnits;
    }

    private void checkCanGenFillTask(List<EnableCollectTask> enableCollectTasks) {
        HashSet allFillUnits = Sets.newHashSetWithExpectedSize((int)16);
        HashSet years = Sets.newHashSetWithExpectedSize((int)16);
        HashSet rptTplIds = Sets.newHashSetWithExpectedSize((int)16);
        HashSet belongPeriods = Sets.newHashSetWithExpectedSize((int)16);
        for (EnableCollectTask enableCollectTask : enableCollectTasks) {
            DynamicObject cycTask = enableCollectTask.getCycCollectTask();
            DynamicObjectCollection taskConfs = cycTask.getDynamicObjectCollection("taskfillobjs");
            DynamicObjectCollection fillUnits = this.filterFillUnit(taskConfs);
            allFillUnits.addAll(fillUnits.stream().map(unit -> unit.getLong("id")).collect(Collectors.toList()));
            years.add(enableCollectTask.getBelongYear());
            List rtIds = enableCollectTask.getRptTplMapOrgs().stream().map(CollectRptTplOrgs::getRptTplId).collect(Collectors.toList());
            rptTplIds.addAll(rtIds);
            List belongPeriodId = enableCollectTask.getRptTplMapOrgs().stream().map(ect -> ect.getBelongPeriod().getLong("id")).collect(Collectors.toList());
            belongPeriods.addAll(belongPeriodId);
        }
        List<Pair<DynamicObject, DynamicObject>> reportMapFills = ReportService.ins().queryByFillUnits(allFillUnits, years, rptTplIds, belongPeriods);
        for (EnableCollectTask enableCollectTask : enableCollectTasks) {
            List rptTplMapOrgs = enableCollectTask.getRptTplMapOrgs();
            this.setGenStatusByReport(enableCollectTask, rptTplMapOrgs, reportMapFills);
        }
    }

    private void setGenStatusByReport(EnableCollectTask enableCollectTask, List<CollectRptTplOrgs> rptTplMapOrgs, List<Pair<DynamicObject, DynamicObject>> reportMapFills) {
        int allFillTaskSize;
        int allSuccess = allFillTaskSize = enableCollectTask.allFillTaskSize();
        for (Pair<DynamicObject, DynamicObject> reportMapFill : reportMapFills) {
            List fillUnits;
            List confOrgIds;
            DynamicObject report = (DynamicObject)reportMapFill.getLeft();
            long exeUnit = report.getDynamicObject("exeunit").getLong("id");
            long repRptTplId = report.getDynamicObject("rpttpl").getLong("id");
            CollectRptTplOrgs byRptTpl = this.getRptTplOrg(repRptTplId, rptTplMapOrgs);
            if (Objects.isNull(byRptTpl) || !(confOrgIds = (fillUnits = byRptTpl.getAdminOrgList()).stream().map(fu -> fu.getLong("id")).collect(Collectors.toList())).contains(exeUnit)) continue;
            --allFillTaskSize;
            fillUnits.removeIf(org -> org.getLong("id") == exeUnit);
            if (HRStringUtils.isEmpty((String)enableCollectTask.getErrorMsg())) {
                String msg = ResManager.loadKDString((String)"\u90e8\u5206\u62a5\u8868\u5b58\u5728\u76f8\u540c\u586b\u62a5\u62a5\u8868\u6570\u636e", (String)"CycGenCollectTask_0", (String)"sihc-soehrr-business", (Object[])new Object[0]);
                enableCollectTask.setErrorMsg(msg);
            }
            if (!fillUnits.isEmpty()) continue;
            enableCollectTask.getRptTplMapOrgs().removeIf(collectRptTplOrgs -> collectRptTplOrgs.getRptTplId() == repRptTplId);
            enableCollectTask.setErrorMsg(ResManager.loadKDString((String)"\u6240\u6709\u4efb\u52a1\u914d\u7f6e\u4e2d\u7684\u62a5\u8868\u5747\u5b58\u5728\u76f8\u540c\u586b\u62a5\u62a5\u8868\u6570\u636e", (String)"CycGenCollectTask_0", (String)"sihc-soehrr-business", (Object[])new Object[0]));
        }
        int cycTaskStatus = allFillTaskSize == 0 ? 0 : (allFillTaskSize == allSuccess ? 2 : 1);
        enableCollectTask.setGenStatus(cycTaskStatus);
    }

    private CollectRptTplOrgs getRptTplOrg(long repRptTplId, List<CollectRptTplOrgs> rptTplMapOrgs) {
        for (CollectRptTplOrgs rptTplMapOrg : rptTplMapOrgs) {
            if (rptTplMapOrg.getRptTplId() != repRptTplId) continue;
            return rptTplMapOrg;
        }
        return null;
    }

    private void copyFile(DynamicObject cycTask, DynamicObject collectTask) {
        List attachmentDatas = AttachmentServiceHelper.getAttachments((String)cycTask.getDynamicObjectType().getName(), (Object)cycTask.getLong("id"), (String)"attachmentpanelap", (boolean)false);
        if (!attachmentDatas.isEmpty()) {
            for (Map attachmentMap : attachmentDatas) {
                attachmentMap.put("visible", "1001");
                Timestamp lastModified = (Timestamp)attachmentMap.get("lastModified");
                attachmentMap.put("lastModified", lastModified.getTime());
                attachmentMap.put("url", this.collectTaskFormService.getPathfromDownloadUrl(String.valueOf(attachmentMap.get("url"))));
            }
            AttachmentServiceHelper.upload((String)"soehrr_collecttask", (Object)collectTask.getLong("id"), (String)"attachmentpanelap", (List)attachmentDatas);
        }
    }

    private List<EnableCollectTask> convertCanGenCycCollectTasks(DynamicObject[] queryTaskEntries) {
        Map<Long, List<DynamicObject>> cycTaskGroups = Arrays.stream(queryTaskEntries).collect(Collectors.groupingBy(qt -> qt.getLong("cid")));
        QFilter qFilter = new QFilter("id", "in", cycTaskGroups.keySet()).and(HrrQfilterUtils.enable());
        DynamicObject[] cycCollectTasks = this.cycCollService.query("org,disunit,reportclassify,rpttpl,fillunits,description,ismsg", qFilter.toArray());
        Map<Long, DynamicObject> idMapTask = Arrays.stream(cycCollectTasks).collect(Collectors.toMap(cct -> cct.getLong("id"), cct -> cct, (ky, va) -> va));
        ArrayList result = Lists.newArrayListWithExpectedSize((int)10);
        for (Map.Entry<Long, DynamicObject> entry : idMapTask.entrySet()) {
            HashMap sameStartEndMemo = Maps.newHashMapWithExpectedSize((int)16);
            Long cycCollectTaskId = entry.getKey();
            DynamicObject cycCollectTask = entry.getValue();
            List<DynamicObject> disDateEntries = cycTaskGroups.get(cycCollectTaskId);
            DynamicObjectCollection taskConfList = cycCollectTask.getDynamicObjectCollection("taskfillobjs");
            if (HRCollUtil.isEmpty(disDateEntries)) continue;
            for (DynamicObject dateEntry : disDateEntries) {
                EnableCollectTask enableCollectTask;
                Date startDate = dateEntry.getDate("startdateval");
                Date endDate = dateEntry.getDate("enddateval");
                int belongYear = dateEntry.getInt("belongyear");
                String memoKey = startDate.getTime() + "_" + endDate.getTime() + "_" + belongYear;
                if (sameStartEndMemo.containsKey(memoKey)) {
                    enableCollectTask = (EnableCollectTask)sameStartEndMemo.get(memoKey);
                    enableCollectTask.setRptOrgByTask(taskConfList, dateEntry);
                    continue;
                }
                enableCollectTask = new EnableCollectTask();
                sameStartEndMemo.put(memoKey, enableCollectTask);
                enableCollectTask.setCycCollectTask(cycCollectTask);
                enableCollectTask.setFillStartDate(startDate);
                enableCollectTask.setFillEndDate(endDate);
                enableCollectTask.setBelongYear(dateEntry.getString("belongyear"));
                enableCollectTask.setRptOrgByTask(taskConfList, dateEntry);
            }
            result.addAll(sameStartEndMemo.values());
        }
        return result;
    }

    private DynamicObject[] queryInDateEntries(Date executeDate, long cycCollectTaskId) {
        QFilter between = new QFilter("startdateval", "<=", (Object)executeDate);
        between.and(new QFilter("enddateval", ">", (Object)executeDate));
        if (cycCollectTaskId != 0L) {
            between.and(new QFilter("cid", "=", (Object)cycCollectTaskId));
        }
        between.and(new QFilter("isdone", "=", (Object)"0"));
        return this.queryDisDateEntryHelper.loadDynamicObjectArray(between.toArray());
    }
}

