/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soehrr.business.task;

import com.google.common.collect.Sets;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.sihc.soehrr.common.util.HrrQfilterUtils;
import kd.sihc.soehrr.business.domain.cyccollecttask.CycCollService;
import kd.sihc.soehrr.business.servicehelper.ServiceFactory;

public class GenNewYearDisDateTask
extends AbstractTask {
    private static final Log LOG = LogFactory.getLog(GenNewYearDisDateTask.class);
    private CycCollService cycCollService = ServiceFactory.getService(CycCollService.class);

    public void execute(RequestContext requestContext, Map<String, Object> param) throws KDException {
        DynamicObject[] cycTasks;
        String yearStr = (String)param.get("year");
        int year = HRStringUtils.isEmpty((String)yearStr) ? HRDateTimeUtils.getYear((Date)new Date()) : Integer.parseInt(yearStr);
        int preYear = year - 1;
        LOG.info("GenNewYearDisDateTask.execute year = {}, preYear = {}", (Object)year, (Object)preYear);
        for (DynamicObject cycTask : cycTasks = this.cycCollService.loadDynamicObjectArray(HrrQfilterUtils.all().toArray())) {
            DynamicObjectCollection disDateEntryEntity = cycTask.getDynamicObjectCollection("entryentity");
            List nowYearEntryEntity = disDateEntryEntity.stream().filter(entry -> entry.getInt("belongyear") == year).collect(Collectors.toList());
            if (HRCollUtil.isNotEmpty(nowYearEntryEntity)) {
                LOG.info("GenNewYearDisDateTask.execute cycTaskNumber = {}, year = {} is already gened", (Object)cycTask.getString("number"), (Object)year);
                continue;
            }
            List preYearEntryEntity = disDateEntryEntity.stream().filter(entry -> entry.getInt("belongyear") == preYear).collect(Collectors.toList());
            if (HRCollUtil.isEmpty(preYearEntryEntity)) {
                LOG.info("GenNewYearDisDateTask.execute preYearEntryEntity is null can gen nowYear");
                continue;
            }
            for (DynamicObject nowEntry : preYearEntryEntity) {
                DynamicObject newYearEntry = disDateEntryEntity.addNew();
                HRDynamicObjectUtils.copy((DynamicObject)nowEntry, (DynamicObject)newYearEntry, (Set)Sets.newHashSet((Object[])new String[]{"belongyear"}));
                newYearEntry.set("belongyear", (Object)year);
                Date dataStartTime = newYearEntry.getDate("datastarttimeval");
                Date dataEndTime = newYearEntry.getDate("dataendtimeval");
                Date startDate = newYearEntry.getDate("startdateval");
                Date endDate = newYearEntry.getDate("enddateval");
                newYearEntry.set("datastarttimeval", (Object)HRDateTimeUtils.addYear((Date)dataStartTime, (int)1));
                newYearEntry.set("dataendtimeval", (Object)HRDateTimeUtils.addYear((Date)dataEndTime, (int)1));
                newYearEntry.set("startdateval", (Object)HRDateTimeUtils.addYear((Date)startDate, (int)1));
                newYearEntry.set("enddateval", (Object)HRDateTimeUtils.addYear((Date)endDate, (int)1));
            }
        }
        this.cycCollService.save(cycTasks);
        LOG.info("GenNewYearDisDateTask.execute update year end");
    }
}

