/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soehrr.business.task;

import com.alibaba.fastjson.JSONObject;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.DatePattern;
import kd.hr.hbp.common.util.DateUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sihc.soebs.business.domain.message.ReminderMessageService;
import kd.sihc.soebs.common.constants.dto.message.MessageContentDO;

public class UpdateTaskStatusTask
extends AbstractTask {
    private static final HRBaseServiceHelper FILLTASK = new HRBaseServiceHelper("soehrr_filltask");
    private static final Log LOG = LogFactory.getLog(UpdateTaskStatusTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        Calendar rightNowDate = Calendar.getInstance();
        rightNowDate.setTime(new Date());
        rightNowDate.add(7, -2);
        Date minDate = rightNowDate.getTime();
        String minDateStr = DateUtils.getDate((Date)minDate).substring(0, 10) + " 00:00:00";
        String maxDateStr = DateUtils.getDate((Date)new Date()).substring(0, 10) + " 23:59:59";
        try {
            minDate = DateUtils.parseDate((String)minDateStr, (DatePattern)DatePattern.YYYY_MM_DD_HH_MM_SS);
            Date maxDate = DateUtils.parseDate((String)maxDateStr, (DatePattern)DatePattern.YYYY_MM_DD_HH_MM_SS);
            QFilter dateQFilter = new QFilter("starttime", ">=", (Object)minDate).and("starttime", "<=", (Object)maxDate).and("taskstatus", "=", (Object)"E").and("billstatus", "=", (Object)"A");
            DynamicObject[] needUpdateTask = FILLTASK.query("id,taskstatus,msgcontent_tag,modifytime", dateQFilter.toArray());
            List msgcontentList = Arrays.stream(needUpdateTask).filter(dynamicObject -> HRStringUtils.isNotEmpty((String)dynamicObject.getString("msgcontent_tag"))).map(dynamicObject -> dynamicObject.getString("msgcontent_tag")).collect(Collectors.toList());
            ArrayList messageContentDOList = new ArrayList(10);
            for (String msgcontent : msgcontentList) {
                List list = JSONObject.parseArray((String)msgcontent, MessageContentDO.class);
                if (list == null || list.size() <= 0) continue;
                messageContentDOList.addAll(list);
            }
            if (messageContentDOList.size() > 0) {
                ReminderMessageService.batchSendMessage(messageContentDOList);
            }
            for (DynamicObject task : needUpdateTask) {
                task.set("taskstatus", (Object)"A");
                task.set("msgcontent_tag", null);
                task.set("modifytime", (Object)new Date());
            }
            FILLTASK.update(needUpdateTask);
        }
        catch (ParseException e) {
            LOG.error("UpdateTaskStatusTask Parse Date Fail", (Throwable)e);
        }
    }
}

