/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soehrr.business.task.service;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.kingdee.bos.qing.util.MapUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.api.MessageChannels;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sihc.soebs.business.application.service.tempmanage.ITempManageParser;
import kd.sihc.soebs.business.domain.message.ReminderMessageService;
import kd.sihc.soebs.business.domain.tempmanage.impl.EmailMessageImpl;
import kd.sihc.soebs.business.domain.tempmanage.impl.OtherMessageImpl;
import kd.sihc.soebs.business.queryservice.TempManageQueryService;
import kd.sihc.soebs.common.constants.dto.message.MessageContentDO;
import kd.sihc.soehrr.business.domain.collecttask.CollectTaskService;
import kd.sihc.soehrr.business.domain.cyccollecttask.CycCollService;
import kd.sihc.soehrr.business.external.hrmp.HrmpExternalService;
import kd.sihc.soehrr.business.queryservice.FillTaskQueryService;
import kd.sihc.soehrr.business.servicehelper.ServiceFactory;
import kd.sihc.soehrr.common.entity.cyccollecttask.MessageTemplateDO;

public class CycGenCollectTaskService {
    private static final Log LOG = LogFactory.getLog(CycGenCollectTaskService.class);
    private CycCollService cycCollService = ServiceFactory.getService(CycCollService.class);
    private CollectTaskService collectTaskService = CollectTaskService.ins();
    private FillTaskQueryService fillTaskQueryService = ServiceFactory.getService(FillTaskQueryService.class);
    private static final TempManageQueryService TEMP_MANAGE_QUERY_SERVICE = ServiceFactory.getService(TempManageQueryService.class);
    private static final HRBaseServiceHelper EMPLOYEE = HRBaseServiceHelper.create((String)"hrpi_employee");
    private HRBaseServiceHelper adminOrgHelper = new HRBaseServiceHelper("haos_adminorghr");
    private Map<String, String> LABEL_VARIABLE_MAP = Maps.newHashMap();

    public void sendMsg(List<Object> collectTaskIdList) {
        List collectTaskIds = collectTaskIdList.stream().map(dy -> (Long)dy).collect(Collectors.toList());
        DynamicObject[] collectTaskInfo = this.collectTaskService.query("id,disunit,cyctask,starttime,endtime,reportclassify,year", new QFilter("id", "in", collectTaskIds).toArray());
        Map<Long, Long> idCycMap = Arrays.stream(collectTaskInfo).collect(Collectors.toMap(dynamicObject -> dynamicObject.getLong("id"), dynamicObject -> dynamicObject.getLong("cyctask_id"), (k1, k2) -> k1));
        List cycTaskIds = Arrays.stream(collectTaskInfo).map(dynamicObject -> dynamicObject.getLong("cyctask_id")).collect(Collectors.toList());
        List<Long> collectIdList = Arrays.stream(collectTaskInfo).map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toList());
        DynamicObject[] fillTaskInfoList = this.fillTaskQueryService.queryALlFillTasksByCollectId(collectIdList);
        Map coIdFillInfoMap = Arrays.stream(fillTaskInfoList).collect(Collectors.groupingBy(dynamicObject -> dynamicObject.getLong("solution"), Collectors.toList()));
        DynamicObject[] cycTaskInfo = this.cycCollService.query("id,msgcontent_tag", new QFilter("id", "in", cycTaskIds).toArray());
        Map<Long, String> idMsgMap = Arrays.stream(cycTaskInfo).collect(Collectors.toMap(dynamicObject -> dynamicObject.getLong("id"), dynamicObject -> dynamicObject.getString("msgcontent_tag"), (k1, k2) -> k1));
        ArrayList<MessageContentDO> messageContentDOList = new ArrayList<MessageContentDO>(10);
        for (DynamicObject taskInfo : collectTaskInfo) {
            List fillTaskInfo = coIdFillInfoMap.get(taskInfo.getLong("id"));
            String msg = idMsgMap.get(idCycMap.get(taskInfo.getLong("id")));
            if (HRStringUtils.isEmpty((String)msg)) continue;
            for (DynamicObject fillTask : fillTaskInfo) {
                this.generationMessage(taskInfo, fillTask, msg, messageContentDOList);
            }
        }
        if (messageContentDOList.size() > 0) {
            ReminderMessageService.batchSendMessage(messageContentDOList);
        }
    }

    private void generationMessage(DynamicObject collectTask, DynamicObject fillTask, String message, List<MessageContentDO> messageContentDOList) {
        MessageTemplateDO messageTemplateDO = (MessageTemplateDO)JSONObject.parseObject((String)message, MessageTemplateDO.class);
        String emailTemplate = messageTemplateDO.getEmailContent();
        String smsTemplate = messageTemplateDO.getSmsContent();
        String sysTemplate = messageTemplateDO.getSystemContent();
        Long usesceneId = messageTemplateDO.getUsesceneId();
        String tempNumber = messageTemplateDO.getTempNumber();
        String emailTitle = messageTemplateDO.getEmailTitle();
        boolean email = messageTemplateDO.getEMAIL();
        boolean sms = messageTemplateDO.getSMS();
        boolean sys = messageTemplateDO.getSYS();
        Map recieverInfo = messageTemplateDO.getRecieverInfo();
        List reciever = (List)recieverInfo.get(fillTask.getLong("exeunit_id"));
        DynamicObject[] employeeArr = EMPLOYEE.query("id,person", new QFilter("id", "in", (Object)reciever).toArray());
        Map<Long, List<Map<String, Object>>> perContact = this.getPerContactInfoMap(employeeArr);
        Set<Long> personIdSet = MapUtils.isNotEmpty(perContact) ? perContact.keySet() : null;
        Map<Long, Long> perSysIdMap = this.getPerSysIdMap(personIdSet);
        for (DynamicObject employee : employeeArr) {
            OtherMessageImpl otherMessageParser;
            if (email) {
                EmailMessageImpl emailMessageParser = new EmailMessageImpl();
                this.setSendMessageListInfoForCycle((ITempManageParser)emailMessageParser, employee, perSysIdMap, perContact, messageContentDOList, emailTemplate, MessageChannels.EMAIL, collectTask, fillTask, usesceneId, tempNumber, emailTitle);
            }
            if (sms) {
                otherMessageParser = new OtherMessageImpl();
                this.setSendMessageListInfoForCycle((ITempManageParser)otherMessageParser, employee, perSysIdMap, perContact, messageContentDOList, smsTemplate, MessageChannels.SMS, collectTask, fillTask, usesceneId, tempNumber, emailTitle);
            }
            if (sys) {
                otherMessageParser = new OtherMessageImpl();
                this.setSendMessageListInfoForCycle((ITempManageParser)otherMessageParser, employee, perSysIdMap, perContact, messageContentDOList, sysTemplate, MessageChannels.MC, collectTask, fillTask, usesceneId, tempNumber, emailTitle);
            }
            for (MessageContentDO messageContentDO : messageContentDOList) {
                if (messageContentDO.getMessageContent().contains("{disunit}")) {
                    DynamicObject disUnit = collectTask.getDynamicObject("disunit");
                    messageContentDO.setMessageContent(messageContentDO.getMessageContent().replace("{disunit}", disUnit.getString("name")));
                }
                if (messageContentDO.getMessageContent().contains("{collectName}")) {
                    messageContentDO.setMessageContent(messageContentDO.getMessageContent().replace("{collectName}", collectTask.getLocaleString("name").getLocaleValue()));
                }
                if (messageContentDO.getMessageContent().contains("{mstartdate}")) {
                    String startTime = HRDateTimeUtils.format((Date)collectTask.getDate("starttime"), (String)"yyyy-MM-dd");
                    messageContentDO.setMessageContent(messageContentDO.getMessageContent().replace("{mstartdate}", startTime));
                }
                if (messageContentDO.getMessageContent().contains("{menddate}")) {
                    String endTime = HRDateTimeUtils.format((Date)collectTask.getDate("endtime"), (String)"yyyy-MM-dd");
                    messageContentDO.setMessageContent(messageContentDO.getMessageContent().replace("{menddate}", endTime));
                }
                if (!messageContentDO.getMessageContent().contains("{belongyear}")) continue;
                String year = collectTask.getString("year");
                messageContentDO.setMessageContent(messageContentDO.getMessageContent().replace("{belongyear}", year));
            }
        }
    }

    private void setSendMessageListInfoForCycle(ITempManageParser messageParser, DynamicObject employee, Map<Long, Long> perSysIdMap, Map<Long, List<Map<String, Object>>> perContact, List<MessageContentDO> messageContentDOList, String template, MessageChannels mesChannel, DynamicObject collectTask, DynamicObject fillTask, Long usesceneId, String tempNumber, String emailTitle) {
        Object perName = employee.get("person.name");
        Map<String, Object> customParams = this.getPreviewNeedMapForCycle(perName, collectTask, emailTitle);
        this.LABEL_VARIABLE_MAP = this.constructLabelVariablesMap(usesceneId);
        String content = messageParser.parseMessage(template, customParams, this.LABEL_VARIABLE_MAP, null);
        Object phone = perContact.get(employee.getLong("person.id")) != null ? perContact.get(employee.getLong("person.id")).get(0).get("phone") : null;
        Object busEmail = perContact.get(employee.getLong("person.id")) != null ? perContact.get(employee.getLong("person.id")).get(0).get("busemail") : null;
        Long sysId = perSysIdMap != null ? perSysIdMap.get(employee.getLong("person.id")) : Long.valueOf(0L);
        String systemTitle = perName + ResManager.loadKDString((String)"\u7684\u6570\u636e\u586b\u62a5\u4efb\u52a1\u901a\u77e5", (String)"MsgSendPlugin_21", (String)"sihc-soehrr-formplugin", (Object[])new Object[0]);
        MessageContentDO messageContentDO = new MessageContentDO();
        messageContentDO.setBoType("soehrr_filltask");
        messageContentDO.setMessageChannel(mesChannel);
        messageContentDO.setEmailTitle(emailTitle);
        messageContentDO.setMessageContent(content);
        messageContentDO.setBusObjId(Collections.singletonList(fillTask.getLong("id")));
        messageContentDO.setReceiverEmail(busEmail != null ? busEmail.toString() : null);
        messageContentDO.setReceiverPhone(phone != null ? phone.toString() : null);
        messageContentDO.setSystemId(sysId);
        messageContentDO.setSystemTitle(systemTitle);
        customParams.put("templatenumber", tempNumber);
        messageContentDO.setCustomParams(customParams);
        messageContentDOList.add(messageContentDO);
    }

    private Map<Long, List<Map<String, Object>>> getPerContactInfoMap(DynamicObject[] employeeArr) {
        List perIdList = Arrays.stream(employeeArr).map(certDyn -> certDyn.get("person.id") != null ? certDyn.getString("person.id") : null).collect(Collectors.toList());
        perIdList.remove("null");
        HashMap<String, Object> param = new HashMap<String, Object>(3);
        param.put("searchType", Lists.newArrayList((Object[])new String[]{"003"}));
        param.put("identifyIdType", "PERID");
        param.put("identifyId", perIdList);
        Map<String, Map<String, Object>> employeeInfo = HrmpExternalService.queryEmployeeInfo(param);
        Map<Long, List<Map<String, Object>>> perContact = this.getTargetResult(employeeInfo, "hrpi_percontact");
        return perContact;
    }

    public Map<Long, List<Map<String, Object>>> getTargetResult(Map<String, Map<String, Object>> result, String targetName) {
        if (CollectionUtils.isEmpty(result)) {
            return Maps.newHashMap();
        }
        HashMap targetResultMap = Maps.newHashMap();
        result.forEach((personIdStr, map) -> {
            if (null == map) {
                return;
            }
            Long personId = Long.parseLong(personIdStr);
            Object target = map.get(targetName);
            if (null == target) {
                return;
            }
            List targetMapList = (List)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString(target), ArrayList.class);
            targetResultMap.put(personId, targetMapList);
        });
        return targetResultMap;
    }

    private Map<Long, Long> getPerSysIdMap(Set<Long> personIdSet) {
        if (personIdSet != null) {
            HashMap<Long, Long> perSysMap = new HashMap<Long, Long>(personIdSet.size());
            ArrayList<Long> pIds = new ArrayList<Long>(personIdSet);
            HashMap<String, List<Long>> idMaps = new HashMap<String, List<Long>>(16);
            idMaps.put("person", pIds);
            Map<String, Map<Long, Map<String, Long>>> userMap = HrmpExternalService.getUserIdByPersonInfo(idMaps);
            Map<Long, Map<String, Long>> userInfoMap = userMap.get("data");
            for (Long pId : pIds) {
                Map<String, Long> personInfoMap;
                if (userInfoMap == null || (personInfoMap = userInfoMap.get(pId)) == null) continue;
                Long userId = personInfoMap.get("user");
                perSysMap.put(pId, userId);
            }
            return perSysMap;
        }
        return null;
    }

    private Map<String, String> constructLabelVariablesMap(Long useSceneId) {
        DynamicObject[] tempVariables = TEMP_MANAGE_QUERY_SERVICE.getTempVariables(useSceneId);
        HashMap<String, String> map = new HashMap<String, String>(tempVariables.length);
        for (DynamicObject tempVariable : tempVariables) {
            map.put(tempVariable.getString("fieldname"), tempVariable.getString("name"));
        }
        return map;
    }

    private Map<String, Object> getPreviewNeedMapForCycle(Object perName, DynamicObject collectTask, String emailTitle) {
        HashMap<String, Object> customParams = new HashMap<String, Object>(16);
        customParams.put("replaceVar", "1");
        customParams.put("emailtheme", emailTitle);
        customParams.put("notifiername", perName);
        customParams.put("disunit", "{disunit}");
        customParams.put("colltaskname", "{collectName}");
        customParams.put("starttime", "{mstartdate}");
        customParams.put("endtime", "{menddate}");
        customParams.put("year", "{belongyear}");
        customParams.put("reportclassify", collectTask.getDynamicObject("reportclassify").getString("name"));
        return customParams;
    }

    public DynamicObject[] queryAdminOrgIsEnable(Collection<Long> adminOrgIds) {
        return this.adminOrgHelper.query("enable", new QFilter[]{new QFilter("id", "in", adminOrgIds)});
    }
}

