/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soehrr.opplugin.cyccollecttask.validator;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.hr.hbp.common.model.AuthorizedOrgResult;
import kd.sihc.soehrr.business.application.report.CollectTaskApplicationService;
import kd.sihc.soehrr.business.domain.cyccollecttask.CycCollService;
import kd.sihc.soehrr.business.servicehelper.ServiceFactory;

public class CycCollectEnableValidator
extends AbstractValidator {
    private CycCollService cycCollService = (CycCollService)ServiceFactory.getService(CycCollService.class);
    private CollectTaskApplicationService collectTaskApplicationService = (CollectTaskApplicationService)ServiceFactory.getService(CollectTaskApplicationService.class);

    public void validate() {
        if (!"enable".equals(this.getOperateKey())) {
            return;
        }
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        if (dataEntities.length > 1) {
            this.addErrorMessage(dataEntities[0], ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u5355\u6761\u6570\u636e\u64cd\u4f5c\u3002", (String)"CycCollectTaskOp_0", (String)"sihc-soehrr-opplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject dataEntity = dataEntities[0].getDataEntity();
        DynamicObject cycCollectTask = this.cycCollService.loadSingle(dataEntity.getPkValue());
        AuthorizedOrgResult authorizedOrgResult = this.collectTaskApplicationService.getUserAdminOrgs("soehrr_cyccollecttask", "disunit");
        if (authorizedOrgResult.isHasAllOrgPerm()) {
            return;
        }
        List hasPermOrgs = authorizedOrgResult.getHasPermOrgs();
        DynamicObjectCollection taskConfEntry = cycCollectTask.getDynamicObjectCollection("taskfillobjs");
        HashSet fillUnitOrgIds = Sets.newHashSetWithExpectedSize((int)16);
        HashMap orgIdNameMap = Maps.newHashMapWithExpectedSize((int)16);
        for (DynamicObject taskConf : taskConfEntry) {
            DynamicObjectCollection fillUnits = taskConf.getDynamicObjectCollection("fillunits");
            List unitIdList = fillUnits.stream().map(dynamicObject -> dynamicObject.getLong("fbasedataid_id")).collect(Collectors.toList());
            fillUnitOrgIds.addAll(unitIdList);
            Map<Long, DynamicObject> mapping = fillUnits.stream().collect(Collectors.toMap(dynamicObject -> dynamicObject.getLong("fbasedataid_id"), dynamicObject -> dynamicObject.getDynamicObject("fbasedataid"), (k1, k2) -> k1));
            orgIdNameMap.putAll(mapping);
        }
        for (Long fillUnitOrgId : fillUnitOrgIds) {
            if (hasPermOrgs.contains(fillUnitOrgId)) continue;
            DynamicObject org = (DynamicObject)orgIdNameMap.get(fillUnitOrgId);
            String message = String.format(Locale.ROOT, ResManager.loadKDString((String)"%1$s\uff1a%2$s\u6743\u9650\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u8c03\u6574\u3002", (String)"CycCollectTaskValidator_0", (String)"sihc-soehrr-formplugin", (Object[])new Object[0]), org.getString("number"), org.getString("name"));
            this.addErrorMessage(dataEntities[0], message);
        }
    }
}

