/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soehrr.opplugin.validator.collecttask;

import java.text.ParseException;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.DatePattern;
import kd.hr.hbp.common.util.DateUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.sihc.soecadm.business.servicehelper.ServiceFactory;
import kd.sihc.soehrr.business.application.report.CollectTaskApplicationService;

public class CollectTaskPublishValidator
extends AbstractValidator {
    private final HRBaseServiceHelper soehrrReport = new HRBaseServiceHelper("soehrr_report");
    private final HRBaseServiceHelper soehrrCollecttask = new HRBaseServiceHelper("soehrr_collecttask");
    private final CollectTaskApplicationService collectTaskApplicationService = (CollectTaskApplicationService)ServiceFactory.getService(CollectTaskApplicationService.class);
    private static final Log LOG = LogFactory.getLog(CollectTaskPublishValidator.class);

    public void validate() {
        ExtendedDataEntity[] dataEntities = this.dataEntities;
        DynamicObject dataEntity = dataEntities[0].getDataEntity();
        DynamicObject collectTaskInfo = !HRStringUtils.isEmpty((String)dataEntity.getString("ifinform")) ? dataEntity : this.soehrrCollecttask.loadDynamicObject(new QFilter("id", "=", (Object)dataEntity.getLong("id")));
        DynamicObjectCollection exeUnits = collectTaskInfo.getDynamicObjectCollection("exeunits");
        if (!"A".equals(collectTaskInfo.getString("status"))) {
            this.addErrorMessage(dataEntities[0], ResManager.loadKDString((String)"\u4ec5\u5f85\u53d1\u5e03\u7684\u91c7\u96c6\u4efb\u52a1\u5141\u8bb8\u53d1\u5e03\u3002", (String)"CollectTaskPublishValidator_0", (String)"sihc-soehrr-opplugin", (Object[])new Object[0]));
            return;
        }
        if (!this.checkFillStartDateBeforeNow()) {
            return;
        }
        if (!this.checkFillTimeAfterDataEndTime()) {
            return;
        }
        DynamicObject rptClass = collectTaskInfo.getDynamicObject("reportclassify");
        boolean isCycrpt = rptClass.getBoolean("iscycrpt");
        if (isCycrpt) {
            DynamicObjectCollection taskFillObjEntry = collectTaskInfo.getDynamicObjectCollection("taskfillobjs");
            long disUnitId = collectTaskInfo.getLong("disunit_id");
            List unitIds = exeUnits.stream().map(dynamicObject -> dynamicObject.getLong("fbasedataid_id")).collect(Collectors.toList());
            QFilter filter = new QFilter("exeunit", "in", unitIds).and("year", "=", (Object)collectTaskInfo.getString("year")).and("reportstatus", "!=", (Object)"C").and("disunit", "=", (Object)disUnitId);
            DynamicObject[] reportInfo = this.soehrrReport.loadDynamicObjectArray(filter.toArray());
            for (DynamicObject entryInfo : taskFillObjEntry) {
                this.valideUnique(entryInfo, reportInfo);
            }
        }
    }

    private boolean checkFillTimeAfterDataEndTime() {
        ExtendedDataEntity[] dataEntities = this.dataEntities;
        DynamicObject dataEntity = dataEntities[0].getDataEntity();
        DynamicObjectCollection taskFillObjEntry = dataEntity.getDynamicObjectCollection("taskfillobjs");
        Date startTime = dataEntity.getDate("starttime");
        try {
            Date startDate = DateUtils.parseDate((String)DateUtils.getDate((Date)startTime), (DatePattern)DatePattern.YYYY_MM_DD);
            for (DynamicObject taskInfo : taskFillObjEntry) {
                Date dataEndTime = DateUtils.parseDate((String)DateUtils.getDate((Date)((Date)taskInfo.get("dataendtime"))), (DatePattern)DatePattern.YYYY_MM_DD);
                if (!dataEndTime.after(startDate)) continue;
                this.addErrorMessage(dataEntities[0], ResManager.loadKDString((String)"\u57fa\u672c\u4fe1\u606f\u4e2d\u201c\u586b\u62a5\u5f00\u59cb\u65e5\u671f\u201d\u5e94\u665a\u4e8e\u4efb\u52a1\u914d\u7f6e\u5206\u5f55\u4e2d\u201c\u6570\u636e\u622a\u6b62\u65e5\u671f\u201d\u5217\u6700\u665a\u65e5\u671f\u3002", (String)"CollectTaskPlugin_15", (String)"sihc-soehrr-formplugin", (Object[])new Object[0]));
                return false;
            }
        }
        catch (Exception ex) {
            LOG.error("checkFillTimeAfterDataEndTime Parse Date Fail", (Throwable)ex);
        }
        return true;
    }

    private boolean checkFillStartDateBeforeNow() {
        ExtendedDataEntity[] dataEntities = this.dataEntities;
        DynamicObject dataEntity = dataEntities[0].getDataEntity();
        Date startTime = dataEntity.getDate("starttime");
        Date nowDate = HRDateTimeUtils.getNowDate();
        try {
            startTime = HRDateTimeUtils.parseDate((String)HRDateTimeUtils.format((Date)startTime, (String)"yyyy-MM-dd"));
            if (startTime.before(nowDate)) {
                this.addErrorMessage(dataEntities[0], ResManager.loadKDString((String)"\u586b\u62a5\u5f00\u59cb\u65e5\u671f\u65e9\u4e8e\u5f53\u524d\u65e5\u671f\uff0c\u8bf7\u4fee\u6539\u3002", (String)"CollectTaskPlugin_30", (String)"sihc-soehrr-formplugin", (Object[])new Object[0]));
                return false;
            }
        }
        catch (ParseException ex) {
            LOG.error("checkFillStartDateBeforeNow Parse Date Fail", (Throwable)ex);
        }
        return true;
    }

    private void valideUnique(DynamicObject entryInfo, DynamicObject[] reportInfo) {
        DynamicObjectCollection fillUnits = entryInfo.getDynamicObjectCollection("fillunits");
        for (DynamicObject fillUnit : fillUnits) {
            for (DynamicObject report : reportInfo) {
                if (report.getLong("exeunit_id") != fillUnit.getLong("fbasedataid_id") || report.getLong("belongperiod_id") != entryInfo.getLong("belongperiod_id") || entryInfo.getLong("rpttpl_id") != report.getLong("rpttpl_id")) continue;
                String message = String.format(ResManager.loadKDString((String)"%1$s%2$s%3$s\u5df2\u5b58\u5728%4$s\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u53d1\u5e03\u3002", (String)"CollectTaskPlugin_17", (String)"sihc-soehrr-formplugin", (Object[])new Object[0]), fillUnit.getDynamicObject("fbasedataid").getLocaleString("name").getLocaleValue(), report.getString("year") + ResManager.loadKDString((String)"\u5e74", (String)"CollectTaskPlugin_28", (String)"sihc-soehrr-formplugin", (Object[])new Object[0]), report.getDynamicObject("belongperiod").getLocaleString("name").getLocaleValue(), report.getDynamicObject("rpttpl").getLocaleString("name").getLocaleValue());
                this.addErrorMessage(this.dataEntities[0], message);
            }
        }
    }
}

