/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soehrr.opplugin.validator.collecttask;

import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.DatePattern;
import kd.hr.hbp.common.util.DateUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.sdk.sihc.soecadm.business.servicehelper.ServiceFactory;
import kd.sihc.soehrr.business.application.report.CollectTaskApplicationService;

public class CollectTaskSaveValidator
extends AbstractValidator {
    private final CollectTaskApplicationService collectTaskApplicationService = (CollectTaskApplicationService)ServiceFactory.getService(CollectTaskApplicationService.class);
    private static final Log LOG = LogFactory.getLog(CollectTaskSaveValidator.class);

    public void validate() {
        ExtendedDataEntity[] dataEntities = this.dataEntities;
        DynamicObject dataEntity = dataEntities[0].getDataEntity();
        StringBuilder errMsg = new StringBuilder();
        boolean numberFlag = false;
        boolean errFlag = false;
        boolean orgFlag = false;
        boolean disUnitFlag = false;
        if (HRObjectUtils.isEmpty((Object)dataEntity.getString("number"))) {
            errFlag = true;
            numberFlag = true;
        }
        if (HRObjectUtils.isEmpty((Object)dataEntity.getDynamicObject("org"))) {
            errFlag = true;
            orgFlag = true;
        }
        if (HRObjectUtils.isEmpty((Object)dataEntity.getDynamicObject("disunit"))) {
            errFlag = true;
            disUnitFlag = true;
        }
        if (errFlag) {
            errMsg.append(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199", (String)"CollectTaskPlugin_4", (String)"sihc-soehrr-formplugin", (Object[])new Object[0]));
            if (numberFlag) {
                errMsg.append(ResManager.loadKDString((String)"\u201c\u7f16\u7801\u201d", (String)"CollectTaskPlugin_18", (String)"sihc-soehrr-formplugin", (Object[])new Object[0]));
            }
            if (orgFlag) {
                errMsg.append(ResManager.loadKDString((String)"\u201c\u4eba\u4e8b\u7ba1\u7406\u7ec4\u7ec7\u201d", (String)"CollectTaskPlugin_5", (String)"sihc-soehrr-formplugin", (Object[])new Object[0]));
            }
            if (disUnitFlag) {
                if (orgFlag) {
                    errMsg.append(ResManager.loadKDString((String)"\u3001\u201c\u53d1\u5e03\u5355\u4f4d\u201d\u3002", (String)"CollectTaskPlugin_6", (String)"sihc-soehrr-formplugin", (Object[])new Object[0]));
                } else {
                    errMsg.append(ResManager.loadKDString((String)"\u201c\u53d1\u5e03\u5355\u4f4d\u201d\u3002", (String)"CollectTaskPlugin_7", (String)"sihc-soehrr-formplugin", (Object[])new Object[0]));
                }
            }
            this.addErrorMessage(dataEntities[0], errMsg.toString());
            return;
        }
        DynamicObjectCollection exeUnits = dataEntity.getDynamicObjectCollection("exeunits");
        if (!this.checkFillTimeAfterDataEndTime()) {
            return;
        }
    }

    private boolean checkFillTimeAfterDataEndTime() {
        ExtendedDataEntity[] dataEntities = this.dataEntities;
        DynamicObject dataEntity = dataEntities[0].getDataEntity();
        DynamicObjectCollection taskFillObjEntry = dataEntity.getDynamicObjectCollection("taskfillobjs");
        Date startTime = dataEntity.getDate("starttime");
        try {
            Date startDate = DateUtils.parseDate((String)DateUtils.getDate((Date)startTime), (DatePattern)DatePattern.YYYY_MM_DD);
            for (DynamicObject taskInfo : taskFillObjEntry) {
                Date dataEndTime = DateUtils.parseDate((String)DateUtils.getDate((Date)((Date)taskInfo.get("dataendtime"))), (DatePattern)DatePattern.YYYY_MM_DD);
                if (!dataEndTime.after(startDate)) continue;
                this.addErrorMessage(dataEntities[0], ResManager.loadKDString((String)"\u57fa\u672c\u4fe1\u606f\u4e2d\u201c\u586b\u62a5\u5f00\u59cb\u65e5\u671f\u201d\u5e94\u665a\u4e8e\u4efb\u52a1\u914d\u7f6e\u5206\u5f55\u4e2d\u201c\u6570\u636e\u622a\u6b62\u65e5\u671f\u201d\u5217\u6700\u665a\u65e5\u671f\u3002", (String)"CollectTaskPlugin_15", (String)"sihc-soehrr-formplugin", (Object[])new Object[0]));
                return false;
            }
        }
        catch (Exception e) {
            LOG.error("checkFillTimeAfterDataEndTime Parse Date Fail", (Throwable)e);
        }
        return true;
    }
}

