/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soehrr.opplugin.validator.rpttpl;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sihc.soehrr.common.check.ExpressionSplitor;
import kd.sihc.soehrr.common.check.ExpressionValidator;

public class SetValValidator
extends AbstractValidator {
    public void validate() {
        for (ExtendedDataEntity configData : this.getDataEntities()) {
            DynamicObject dataEntity = configData.getDataEntity();
            DynamicObjectCollection rules = dataEntity.getDynamicObjectCollection("entryentity");
            boolean hasNullRuleName = false;
            if (!Objects.nonNull(rules) || rules.size() <= 0) continue;
            for (DynamicObject rule : rules) {
                if (rule.getString("mname") != null) continue;
                hasNullRuleName = true;
            }
            if (hasNullRuleName) {
                this.addErrorMessage(configData, ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u540d\u79f0\u201d\u3002", (String)"SetValValidator_0", (String)"sihc-soehrr-opplugin", (Object[])new Object[0]));
                continue;
            }
            boolean mustRule = false;
            for (DynamicObject rule : rules) {
                mustRule = this.validRule(configData, rule, mustRule);
            }
            if (mustRule) continue;
            for (DynamicObject rule : rules) {
                this.validExpressionRule(configData, rule);
            }
        }
    }

    private void validExpressionRule(ExtendedDataEntity configData, DynamicObject rule) {
        DynamicObject ruleMasterData = (DynamicObject)rule.getDynamicObjectCollection("subentryentity").get(0);
        String expression = ruleMasterData.getString("tarvalue");
        List expressions = ExpressionSplitor.splitItem((String)expression);
        for (String item : expressions) {
            if (!HRStringUtils.isNotEmpty((String)item)) continue;
            expression = expression.replace(item, "1");
        }
        boolean validExpression = ExpressionValidator.isValidExpression((String)expression);
        if (!validExpression) {
            String errInfo = String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u7684\u6821\u6838\u516c\u5f0f\u683c\u5f0f\u6709\u8bef\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u3002", (String)"SetValValidator_8", (String)"sihc-soehrr-opplugin", (Object[])new Object[0]), rule.get("mname"));
            this.addErrorMessage(configData, errInfo);
        }
    }

    private boolean validRule(ExtendedDataEntity configData, DynamicObject rule, boolean mustRule) {
        ArrayList<String> errorsTips = new ArrayList<String>(16);
        DynamicObject ruleMasterData = (DynamicObject)rule.getDynamicObjectCollection("subentryentity").get(0);
        if (HRStringUtils.isEmpty((String)ruleMasterData.getString("checklevel"))) {
            errorsTips.add(ResManager.loadKDString((String)"\u201c\u6821\u6838\u7ea7\u522b\u201d", (String)"SetValValidator_2", (String)"sihc-soehrr-opplugin", (Object[])new Object[0]));
        }
        if (HRStringUtils.isEmpty((String)ruleMasterData.getString("point"))) {
            errorsTips.add(ResManager.loadKDString((String)"\u201c\u6e90\u533a\u57df\u201d", (String)"SetValValidator_3", (String)"sihc-soehrr-opplugin", (Object[])new Object[0]));
        }
        if (HRStringUtils.isEmpty((String)ruleMasterData.getString("comparator"))) {
            errorsTips.add(ResManager.loadKDString((String)"\u201c\u6821\u6838\u6761\u4ef6\u201d", (String)"SetValValidator_4", (String)"sihc-soehrr-opplugin", (Object[])new Object[0]));
        }
        if (HRStringUtils.isEmpty((String)ruleMasterData.getString("tarreport"))) {
            errorsTips.add(ResManager.loadKDString((String)"\u201c\u76ee\u6807\u8868\u201d", (String)"SetValValidator_5", (String)"sihc-soehrr-opplugin", (Object[])new Object[0]));
        }
        if (HRStringUtils.isEmpty((String)ruleMasterData.getString("tarvalue"))) {
            errorsTips.add(ResManager.loadKDString((String)"\u201c\u6821\u6838\u516c\u5f0f\u201d", (String)"SetValValidator_6", (String)"sihc-soehrr-opplugin", (Object[])new Object[0]));
        }
        if (errorsTips.size() > 0) {
            String errInfo = String.format(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c%s\u201d\u7684%s\u3002", (String)"SetValValidator_7", (String)"sihc-soehrr-opplugin", (Object[])new Object[0]), rule.get("mname"), String.join((CharSequence)"\u3001", errorsTips));
            this.addErrorMessage(configData, errInfo);
            mustRule = true;
        }
        return mustRule;
    }
}

