/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.business.cal;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ObjectConverter;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.user.UserConfigServiceHelper;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.cache.IHRAppCache;
import kd.sit.hcsi.business.cal.SocialInsuranceCalHelper;
import kd.sit.hcsi.business.cal.errInfo.CalApiResultErrInfoEnum;
import kd.sit.hcsi.business.cal.service.ICalService;
import kd.sit.hcsi.business.cal.service.SinSurCalLaunchMsgHelper;
import kd.sit.hcsi.business.cal.service.SocialCalCertService;
import kd.sit.hcsi.business.cal.service.SocialInsuranceCalService;
import kd.sit.hcsi.common.vo.LaunchCalculateVo;
import kd.sit.sitbp.business.servicehelper.MutexServiceHelper;
import kd.sit.sitbp.common.entity.social.PreCalCfgDTO;

public class SocialInsuranceCalCheckThread
implements Runnable {
    private final Long sinsurPeriodId;
    private final DynamicObject sinsurPeriod;
    private final Set<Long> welfarePayerIdSet;
    private final Set<Long> welfareTypeIdSet;
    private final IHRAppCache appCache;
    private final String cacheUUID;
    private final SinSurCalLaunchMsgHelper msgHelper = new SinSurCalLaunchMsgHelper();
    private static final Log LOGGER = LogFactory.getLog(SocialInsuranceCalCheckThread.class);

    public SocialInsuranceCalCheckThread(String cacheUUID, Long sinsurPeriodId, Set<Long> welfarePayerIdSet, Set<Long> welfareTypeIdSet) {
        this.welfarePayerIdSet = welfarePayerIdSet;
        this.welfareTypeIdSet = welfareTypeIdSet;
        this.sinsurPeriodId = sinsurPeriodId;
        this.cacheUUID = cacheUUID;
        HashSet<Long> sinsurPeriodIdSet = new HashSet<Long>(1);
        sinsurPeriodIdSet.add(sinsurPeriodId);
        Map<Long, DynamicObject> periodMap = SocialInsuranceCalHelper.getValidPeriodMap(sinsurPeriodIdSet);
        DynamicObject period = periodMap.get(sinsurPeriodId);
        this.sinsurPeriod = period != null ? period : null;
        this.appCache = HRAppCache.get((String)("socialCalParam_" + cacheUUID));
    }

    @Override
    public void run() {
        LOGGER.info("start to check cal");
        ArrayList<DynamicObject> allHisFileList = new ArrayList<DynamicObject>(10);
        DynamicObject[] curentFiles = SocialInsuranceCalHelper.getCurrentFiles(SocialInsuranceCalHelper.getDayDate(this.sinsurPeriod.getDate("enddate")), this.welfarePayerIdSet, allHisFileList, "2");
        boolean isDependonOnTheoryPayer = SocialInsuranceCalHelper.isDependonOnTheoryPayer();
        String welfarePayerIdKey = isDependonOnTheoryPayer ? "welfarepayertheory.id" : "welfarepayer.id";
        Map<Long, List<DynamicObject>> currentFileMap = Arrays.stream(curentFiles).collect(Collectors.groupingBy(currentFile -> currentFile.getLong(welfarePayerIdKey)));
        ArrayList<Map<String, Object>> resultMaps = new ArrayList<Map<String, Object>>(currentFileMap.size());
        for (Map.Entry<Long, List<DynamicObject>> entry : currentFileMap.entrySet()) {
            HashMap<String, Object> resultMapTemp = new HashMap<String, Object>(16);
            boolean isCertInvalid = SocialInsuranceCalHelper.checkCertInvalidForView(entry.getValue().toArray(new DynamicObject[entry.getValue().size()]), resultMapTemp);
            resultMaps.add(resultMapTemp);
            if (!isCertInvalid) continue;
            this.appCache.put("resultMap", resultMapTemp);
            this.appCache.put("isCheckCertFail", (Object)Boolean.TRUE);
            return;
        }
        Map<String, Object> resultMap = this.dealResultMap(resultMaps);
        this.appCache.put("resultMap", resultMap);
        this.appCache.put("hasCheckCert", (Object)Boolean.TRUE);
        Map<Long, List<DynamicObject>> hisFileMap = allHisFileList.stream().collect(Collectors.groupingBy(hisFile -> hisFile.getLong(welfarePayerIdKey)));
        DynamicObject[] welfarePayers = SocialInsuranceCalHelper.getWelfarePayers(this.welfarePayerIdSet);
        Map<Long, DynamicObject> welfarePayerMap = Arrays.stream(welfarePayers).collect(Collectors.toMap(welfarePayer -> welfarePayer.getLong("id"), welfarePayer -> welfarePayer));
        ArrayList<Long> calTaskIdList = new ArrayList<Long>(this.welfarePayerIdSet.size());
        List welfarePayerIdOrderList = this.welfarePayerIdSet.stream().sorted().collect(Collectors.toList());
        HashMap calTaskToFileMap = new HashMap(this.welfarePayerIdSet.size());
        String sinsurPeriodName = this.sinsurPeriod.getString("name");
        int fileCount = 0;
        for (int index = 0; index < welfarePayerIdOrderList.size(); ++index) {
            Long welfarePayerId = (Long)welfarePayerIdOrderList.get(index);
            List<DynamicObject> hisFileList = hisFileMap.get(welfarePayerId);
            DynamicObject welfarePayer2 = welfarePayerMap.get(welfarePayerId);
            String welfarePayerName = welfarePayer2.getString("name");
            int addSuccessCount = 0;
            int addFailCount = 1;
            if (CollectionUtils.isEmpty(hisFileList)) {
                String errMsg = CalApiResultErrInfoEnum.NOT_EXISTS_FILE_FOR_PERIOD_AND_COMPANY_COMBINED.getErrInfo(welfarePayerName, sinsurPeriodName);
                this.msgHelper.addMessage(this.cacheUUID, errMsg);
                this.updateProgress(addSuccessCount, addFailCount);
                if (index != welfarePayerIdOrderList.size() - 1 || CollectionUtils.isEmpty(calTaskIdList)) continue;
                SocialInsuranceCalHelper.cacheProgressInfoAndOpenFloatingBall((String)this.appCache.get("pageId", String.class), this.cacheUUID, fileCount, "donothing_launchcal", calTaskIdList.size());
                continue;
            }
            HashSet<String> errorNameSet = new HashSet<String>(16);
            Date endDate = SocialInsuranceCalHelper.getDayDate(this.sinsurPeriod.getDate("enddate"));
            Map<Long, PreCalCfgDTO> preCalCfgDTOMap = SocialInsuranceCalHelper.getPreCalCfgDTOMap(hisFileList, endDate, errorNameSet);
            if (preCalCfgDTOMap.size() == 0) {
                StringBuilder welfarePayerNameBuilder = new StringBuilder();
                for (String errorName : errorNameSet) {
                    if (welfarePayerNameBuilder.length() > 0) {
                        welfarePayerNameBuilder.append('\u3001');
                    }
                    welfarePayerNameBuilder.append(errorName);
                }
                String errMsg = CalApiResultErrInfoEnum.NOT_EXISTS_STANDARD_FOR_PERIOD_AND_COMPANY_COMBINED.getErrInfo(welfarePayerNameBuilder.toString(), sinsurPeriodName);
                this.msgHelper.addMessage(this.cacheUUID, errMsg);
                this.updateProgress(addSuccessCount, addFailCount);
                LOGGER.info("checkStandar fail");
                if (index != welfarePayerIdOrderList.size() - 1 || CollectionUtils.isEmpty(calTaskIdList)) continue;
                SocialInsuranceCalHelper.cacheProgressInfoAndOpenFloatingBall((String)this.appCache.get("pageId", String.class), this.cacheUUID, fileCount, "donothing_launchcal", calTaskIdList.size());
                continue;
            }
            DynamicObject calTaskDy = SocialInsuranceCalHelper.checkAndCreateTask(welfarePayer2, hisFileList.size(), this.sinsurPeriod, this.welfareTypeIdSet, null, this.cacheUUID);
            if (calTaskDy != null) {
                Long calTaskId = calTaskDy.getLong("id");
                calTaskIdList.add(calTaskId);
                calTaskToFileMap.put(calTaskId, hisFileList.stream().map(hisFile -> hisFile.getLong("id")).collect(Collectors.toSet()));
                fileCount += hisFileList.size();
                ++addSuccessCount;
                --addFailCount;
            }
            if (index == welfarePayerIdOrderList.size() - 1 && !CollectionUtils.isEmpty(calTaskIdList)) {
                SocialInsuranceCalHelper.cacheProgressInfoAndOpenFloatingBall((String)this.appCache.get("pageId", String.class), this.cacheUUID, fileCount, "donothing_launchcal", calTaskIdList.size());
            }
            this.updateProgress(addSuccessCount, addFailCount);
        }
        this.appCache.put("calType", (Object)"2");
        this.appCache.put("fileCount", (Object)fileCount);
        this.appCache.put("totalTaskCount", (Object)this.welfarePayerIdSet.size());
        this.appCache.put("successTaskCount", (Object)calTaskIdList.size());
        this.appCache.put("failTaskCount", (Object)(this.welfarePayerIdSet.size() - calTaskIdList.size()));
        if (CollectionUtils.isEmpty(calTaskIdList)) {
            return;
        }
        this.appCache.put("calTaskIdList", calTaskIdList);
        for (Long calTaskId : calTaskIdList) {
            MutexServiceHelper.require((String)"hcsi_sinsurtask", (String)String.valueOf(calTaskId), (String)"donothing_launchcal");
        }
        this.saveScheme();
        LOGGER.info("start to cal");
        HashMap<String, Object> extendParams = new HashMap<String, Object>(1);
        extendParams.put("calTaskToFileMap", calTaskToFileMap);
        extendParams.put("recordId", this.cacheUUID);
        ICalService calService = SocialInsuranceCalService.calServiceFactory((String)this.appCache.get("pageId", String.class), null, null, "2", new LinkedHashSet<Long>(calTaskIdList), extendParams);
        if (calService != null) {
            calService.updatePersonAndCal();
        }
    }

    private Map<String, Object> dealResultMap(List<Map<String, Object>> resultMaps) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        for (Map<String, Object> map : resultMaps) {
            if (resultMap.size() == 0) {
                resultMap.putAll(map);
                continue;
            }
            Object infoTypeTemp = map.get("infotype");
            Object infoType = resultMap.get("infotype");
            if (SocialCalCertService.INFOLEVELMAP.get(infoTypeTemp) > SocialCalCertService.INFOLEVELMAP.get(infoType)) {
                resultMap.put("infotype", infoTypeTemp);
                resultMap.put("messageList", map.getOrDefault("messageList", new ArrayList(10)));
            }
            String showMessageType = (String)resultMap.get("showMessageType");
            String showMessageTypeTemp = (String)map.get("showMessageType");
            if (Integer.parseInt(showMessageTypeTemp) <= Integer.parseInt(showMessageType)) continue;
            resultMap.put("showMessageType", showMessageTypeTemp);
        }
        return resultMap;
    }

    private void saveScheme() {
        LOGGER.info("start to save scheme");
        LaunchCalculateVo calculateVo = new LaunchCalculateVo();
        calculateVo.setPeriodId(this.sinsurPeriodId.longValue());
        HashSet adaptWelfarePayerIds = Sets.newHashSetWithExpectedSize((int)this.welfarePayerIdSet.size());
        for (Long ele : this.welfarePayerIdSet) {
            adaptWelfarePayerIds.add(ObjectConverter.convert((Object)ele, Long.class, (boolean)true));
        }
        calculateVo.setWelfarePayers((Set)adaptWelfarePayerIds);
        HashSet adaptWelfareTypeIdSet = Sets.newHashSetWithExpectedSize((int)this.welfareTypeIdSet.size());
        for (Long ele : this.welfareTypeIdSet) {
            adaptWelfareTypeIdSet.add(ObjectConverter.convert((Object)ele, Long.class, (boolean)true));
        }
        calculateVo.setWelfareTypes((Set)adaptWelfareTypeIdSet);
        UserConfigServiceHelper.setSetting((long)RequestContext.get().getCurrUserId(), (String)"LaunchCalculatePluginLastSelection", (String)SerializationUtils.toJsonString((Object)calculateVo));
    }

    private void updateProgress(int addSuccessCount, int addFailCount) {
        int successCount = (Integer)this.appCache.get("successCount", Integer.class) + addSuccessCount;
        int failCount = (Integer)this.appCache.get("failCount", Integer.class) + addFailCount;
        this.appCache.put("successCount", (Object)successCount);
        this.appCache.put("failCount", (Object)failCount);
    }
}

