/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.business.cal;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.hr.hbp.business.bgtask.HRBackgroundTaskHelper;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.sdk.sit.hcsi.common.entity.cal.InsuredStandard;
import kd.sdk.sit.hcsi.common.entity.cal.InsuredSumItem;
import kd.sdk.sit.hcsi.common.events.cal.OnGetInsuredStandardListEvent;
import kd.sdk.sit.hcsi.formplugin.cal.detail.ICalPersonListDisplayPlugin;
import kd.sit.hcsi.business.cal.detail.point.DefaultCalPersonListDisplayPlugin;
import kd.sit.hcsi.business.cal.errInfo.CalApiResultErrInfoEnum;
import kd.sit.hcsi.business.cal.mq.BatchSocialCalPublisher;
import kd.sit.hcsi.business.cal.service.DisplaySchemeService;
import kd.sit.hcsi.business.cal.service.SinSurCalLaunchMsgHelper;
import kd.sit.hcsi.business.cal.service.SocialCalCertService;
import kd.sit.hcsi.business.cal.service.SocialInsuranceCalFilterHelper;
import kd.sit.hcsi.business.caladjust.errinfo.HCSIErrInfoEnum;
import kd.sit.sitbp.business.coderule.CodeRuleHelper;
import kd.sit.sitbp.business.servicehelper.SITPermissionServiceHelper;
import kd.sit.sitbp.business.servicehelper.SITShowFormServiceHelper;
import kd.sit.sitbp.common.cache.ISITAppCache;
import kd.sit.sitbp.common.cache.SITAppCache;
import kd.sit.sitbp.common.cal.enums.CalRuleEnum;
import kd.sit.sitbp.common.constants.SITBaseConstants;
import kd.sit.sitbp.common.entity.social.CalSocialDetailDTO;
import kd.sit.sitbp.common.entity.social.CalTaskBatchDTO;
import kd.sit.sitbp.common.entity.social.CalTaskProgressInfoDTO;
import kd.sit.sitbp.common.entity.social.InsuredParamConfigDTO;
import kd.sit.sitbp.common.entity.social.InsuredParamConfigResultDTO;
import kd.sit.sitbp.common.entity.social.InsuredStandardDTO;
import kd.sit.sitbp.common.entity.social.InsuredStandardTableDTO;
import kd.sit.sitbp.common.entity.social.PreCalCfgDTO;
import kd.sit.sitbp.common.entity.social.StandardDimensionResultDTO;
import kd.sit.sitbp.common.enums.DataRoundEnum;
import kd.sit.sitbp.common.enums.InsurTypeAttrEnum;
import kd.sit.sitbp.common.enums.SitDataTypeEnum;
import kd.sit.sitbp.common.model.Pair;
import kd.sit.sitbp.common.util.SITListUtil;
import kd.sit.sitbp.common.util.SITStringUtils;
import org.apache.commons.collections.map.HashedMap;

public class SocialInsuranceCalHelper {
    private static final Log log = LogFactory.getLog(SocialInsuranceCalHelper.class);
    private static final String[] VALID_DATA_STATUSES = new String[]{"1", "0", "2"};
    public static final String RECORD_ID = "recordId";
    public static final String BATCH_ID = "batchId";
    public static final String TASK_ID = "taskId";
    public static final String TASK_IDS = "taskIds";
    public static final String PERIOD_ID = "periodId";
    public static final String WELFARE_PAYER_IDS = "welfarePayerIds";
    public static final String IS_LAUNCH_CALCULATE = "isLaunchCalculate";
    public static final String LAUNCHCAL_CALLBACK_ID = "launchcal_callback_id";
    public static final String AUDIT_CALLBACK_ID = "audit_callback_id";
    public static final String AUDIT_PROGRESS_CALLBACK_ID = "audit_progress_callback_id";
    public static final String CAL_PROGRESS_CALLBACK_ID = "cal_progress_callback_id";
    public static final String DISPLAYSCH_ID = "displaySchId";
    public static final String LABLE_PERIOD = "periodname";
    public static final String LABLE_PERIOD_ID = "periodid";
    public static final String LABLE_WELFARE = "welfarename";
    public static final String LABLE_WELFARE_ID = "welfareid";
    public static final String LABLE_TASKNUMBER = "tasknumber";
    private static final String LOCK_KEY = "caltask_lock_{0}_{1}";
    public static final String IS_SECOND_DELETE_BATCH = "isBatchOpCompleted";
    public static final Integer TOTAL_BATCH_SIZE = 2000;
    public static final HRBaseServiceHelper COMPANY_AND_DIM_REF_HELPER = new HRBaseServiceHelper("sitbs_coanddimref");
    public static final HRBaseServiceHelper STANDARD_HELPER = new HRBaseServiceHelper("sitbs_sinsurstd");
    public static final HRBaseServiceHelper SINSURTASK_HELPER = new HRBaseServiceHelper("hcsi_sinsurtask");
    public static final HRBaseServiceHelper REPORT_HELPER = new HRBaseServiceHelper("hcsi_sinsurgenrecord");
    public static final HRBaseServiceHelper CAL_PERSON_HELPER = new HRBaseServiceHelper("hcsi_calperson");
    protected static final HRBaseServiceHelper SINSUR_FILE_HELPER = new HRBaseServiceHelper("hcsi_sinsurfile");
    private static final Set<Long> PAY_BASE_ITEM_PROP_ID_SET = new HashSet<Long>(4);
    private static final Set<String> DATA_SOURCE_FETCH_SET = new HashSet<String>(3);
    private static final Set<String> DATA_SOURCE_CAL_SET = new HashSet<String>(3);

    private SocialInsuranceCalHelper() {
    }

    public static ListShowParameter getCalTableListForm(Long taskId) {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setFormId("hcsi_calpersonlist");
        showParameter.setBillFormId("hcsi_calperson");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCustomParam(TASK_ID, (Object)taskId);
        Long displaySchId = DisplaySchemeService.getDisplaySchemaIdByTaskId(taskId);
        if (displaySchId != null) {
            showParameter.setCustomParam(DISPLAYSCH_ID, (Object)displaySchId);
        }
        HRBaseServiceHelper calTaskHelper = new HRBaseServiceHelper("hcsi_sinsurtask");
        String props = "number,sinsurperiod,welfarepayer";
        QFilter idFilter = new QFilter("id", "=", (Object)taskId);
        DynamicObject sinSurTaskDy = calTaskHelper.queryOne(props, new QFilter[]{idFilter});
        if (sinSurTaskDy == null) {
            return null;
        }
        showParameter.setCustomParam(LABLE_WELFARE, (Object)sinSurTaskDy.getString("welfarepayer.name"));
        showParameter.setCustomParam(LABLE_WELFARE_ID, (Object)sinSurTaskDy.getString("welfarepayer.id"));
        showParameter.setCustomParam(LABLE_PERIOD, (Object)sinSurTaskDy.getString("sinsurperiod.name"));
        showParameter.setCustomParam(LABLE_PERIOD_ID, (Object)sinSurTaskDy.getString("sinsurperiod.id"));
        showParameter.setCustomParam(LABLE_TASKNUMBER, (Object)sinSurTaskDy.getString("number"));
        return showParameter;
    }

    public static List<Long> getStandardVIdsBy(Long taskId) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hcsi_sinsurtask");
        DynamicObject insuranceTaskDy = helper.queryOne("mulsinsurstd", (Object)taskId);
        return SocialInsuranceCalHelper.getStandardVIdsInTask(insuranceTaskDy);
    }

    public static List<Long> getStandardVIdsInTask(DynamicObject insuranceTaskDy) {
        return Optional.ofNullable(insuranceTaskDy).map(taskDy -> taskDy.getDynamicObjectCollection("mulsinsurstd")).map(baseDataDys -> baseDataDys.stream().map(baseDataDy -> baseDataDy.getLong("fbasedataid.id")).collect(Collectors.toList())).orElseGet(() -> Collections.emptyList());
    }

    public static List<InsuredStandard> getInsuranceItemInfoGroupByTask(Long insurTaskId) {
        return SocialInsuranceCalHelper.getInsuranceItemAndCombinedItemInfoGroupByTask(insurTaskId, false);
    }

    public static List<InsuredStandard> getInsuranceItemAndCombinedItemInfoGroupByTask(Long insurTaskId, boolean withCombineItem) {
        return SocialInsuranceCalHelper.getInsuranceItemAndCombinedItemInfoGroupByTasks(Collections.singletonList(insurTaskId), withCombineItem).getOrDefault(insurTaskId, new ArrayList(0));
    }

    public static Map<Long, List<InsuredStandard>> getInsuranceItemAndCombinedItemInfoGroupByTasks(Collection<Long> insurTaskIds, boolean withCombineItem) {
        if (insurTaskIds == null || insurTaskIds.isEmpty()) {
            return new LinkedHashMap<Long, List<InsuredStandard>>(0);
        }
        DynamicObject[] insuranceTaskDys = SINSURTASK_HELPER.loadDynamicObjectArray((Object[])insurTaskIds.toArray(new Long[0]));
        if (insuranceTaskDys == null || insuranceTaskDys.length == 0) {
            return insurTaskIds.stream().collect(Collectors.toMap(insurTaskId -> insurTaskId, insurTaskId -> new ArrayList(0), (oldVal, newVal) -> oldVal, LinkedHashMap::new));
        }
        return SocialInsuranceCalHelper.getInsuranceItemInfoGroupByTask(Arrays.asList(insuranceTaskDys), withCombineItem);
    }

    public static Map<Long, List<InsuredStandard>> getInsuranceItemInfoGroupByTask(Collection<DynamicObject> insuranceTaskDys, boolean withCombineItem) {
        if (insuranceTaskDys == null || insuranceTaskDys.size() == 0) {
            return new LinkedHashMap<Long, List<InsuredStandard>>(0);
        }
        LinkedHashMap<Long, Collection<Long>> insuranceItemsGroupByTask = new LinkedHashMap<Long, Collection<Long>>(insuranceTaskDys.size());
        for (DynamicObject insuranceTaskDy : insuranceTaskDys) {
            Long insurTaskId = insuranceTaskDy.getLong("id");
            if (HRObjectUtils.isEmpty((Object)insuranceTaskDy) || !insuranceTaskDy.containsProperty("mulinsuranceitem")) {
                insuranceItemsGroupByTask.put(insurTaskId, new LinkedHashSet(0));
                continue;
            }
            Set<Long> insuranceItemIds = SocialInsuranceCalHelper.getMulBaseDataIdsInTask(insuranceTaskDy, "mulinsuranceitem");
            insuranceItemsGroupByTask.put(insurTaskId, insuranceItemIds);
        }
        return SocialInsuranceCalHelper.getInsuranceItemInfoGroupByTask(insuranceItemsGroupByTask, withCombineItem);
    }

    public static Set<Long> getMulBaseDataIdsInTask(DynamicObject insuranceTaskDy, String baseDataKey) {
        Set insuranceItemIds = Optional.ofNullable(insuranceTaskDy).filter(taskDy -> taskDy.containsProperty(baseDataKey)).map(taskDy -> taskDy.getDynamicObjectCollection(baseDataKey)).map(baseDataDys -> baseDataDys.stream().map(baseDataDy -> baseDataDy.getLong("fbasedataid.id")).collect(Collectors.toSet())).orElseGet(() -> new LinkedHashSet(0));
        return insuranceItemIds;
    }

    public static Map<Long, List<InsuredStandard>> getInsuranceItemInfoGroupByTask(Map<Long, Collection<Long>> taskIdAndRefItemIds, boolean withCombineItem) {
        if (taskIdAndRefItemIds == null) {
            return new LinkedHashMap<Long, List<InsuredStandard>>(0);
        }
        Set<Long> allItemIds = taskIdAndRefItemIds.values().stream().flatMap(items -> Optional.ofNullable(items).orElseGet(() -> new HashSet(0)).stream()).collect(Collectors.toSet());
        Map<Long, InsuredStandard> sortedItemInfo = SocialInsuranceCalHelper.getItemInfo(allItemIds);
        LinkedHashMap<Long, List<InsuredStandard>> sortedInsuranceItemIdsByTask = new LinkedHashMap<Long, List<InsuredStandard>>(taskIdAndRefItemIds.size());
        taskIdAndRefItemIds.forEach((taskId, itemIds) -> {
            if (itemIds == null || itemIds.isEmpty()) {
                sortedInsuranceItemIdsByTask.put((Long)taskId, new ArrayList(0));
            } else {
                Set tmpItemIds = itemIds instanceof Set ? (Set)itemIds : new HashSet(itemIds);
                sortedItemInfo.values().stream().filter(insuredStandard -> insuredStandard != null && tmpItemIds.contains(insuredStandard.getInsuredItemId())).forEach(insuredStandard -> sortedInsuranceItemIdsByTask.computeIfAbsent((Long)taskId, key -> new ArrayList(10)).add(insuredStandard));
            }
        });
        if (withCombineItem) {
            SocialInsuranceCalHelper.handleCombineItems(sortedInsuranceItemIdsByTask);
        }
        return sortedInsuranceItemIdsByTask;
    }

    public static Map<Long, InsuredStandard> getItemInfo(Collection<Long> insuranceItemIds) {
        if (insuranceItemIds == null) {
            return Collections.emptyMap();
        }
        QFilter filter = new QFilter("id", "in", insuranceItemIds);
        DynamicObjectCollection insuranceItemDys = new HRBaseServiceHelper("sitbs_insuranceitem").queryOriginalCollection("id,name,datatype.id,group.currency.amtprecision,dataprecision.scale,dataround.id,insurancetypeattr.datasrc", filter.toArray(), "group.number asc,number asc");
        if (insuranceItemDys == null) {
            return new LinkedHashMap<Long, InsuredStandard>(0);
        }
        LinkedHashMap<Long, InsuredStandard> itemInfo = new LinkedHashMap<Long, InsuredStandard>(insuranceItemDys.size());
        for (DynamicObject insuranceItemDy : insuranceItemDys) {
            Long itemId = insuranceItemDy.getLong("id");
            String insuredItemName = insuranceItemDy.getString("name");
            Long dataTypeId = insuranceItemDy.getLong("datatype.id");
            int precision = SitDataTypeEnum.AMOUNT.getId() == insuranceItemDy.getLong("datatype.id") ? insuranceItemDy.getInt("group.currency.amtprecision") : insuranceItemDy.getInt("dataprecision.scale");
            InsuredStandard insuredStandard = new InsuredStandard(itemId, insuredItemName, dataTypeId);
            long dataRound = insuranceItemDy.getLong("dataround.id");
            insuredStandard.setDataRound(Integer.valueOf(DataRoundEnum.roundById((long)dataRound)));
            insuredStandard.setScale(Integer.valueOf(precision));
            insuredStandard.setDataSrc(insuranceItemDy.getString("insurancetypeattr.datasrc"));
            itemInfo.put(itemId, insuredStandard);
        }
        return itemInfo;
    }

    private static void handleCombineItems(Map<Long, List<InsuredStandard>> orderedInsuredItemGroupByTask) {
        if (orderedInsuredItemGroupByTask == null) {
            return;
        }
        List<InsuredStandard> sumItemList = SocialInsuranceCalHelper.getInsuredSumItemList();
        for (Map.Entry<Long, List<InsuredStandard>> entry : orderedInsuredItemGroupByTask.entrySet()) {
            ArrayList<InsuredStandard> dataList = new ArrayList<InsuredStandard>(10);
            dataList.addAll(sumItemList);
            dataList.addAll((Collection)entry.getValue());
            entry.setValue(dataList);
        }
    }

    public static ListShowParameter getSinsurGenDetailForm(Long reportId) {
        ListShowParameter showParameter = new ListShowParameter();
        QFilter qFilter = new QFilter("sinsurgenrecord", "=", (Object)reportId);
        showParameter.setFormId("bos_list");
        showParameter.setBillFormId("hcsi_sinsurgendetail");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCustomParam("reportId", (Object)reportId);
        showParameter.getListFilterParameter().getQFilters().add(qFilter);
        return showParameter;
    }

    public static FormShowParameter getLaunchCalForm() {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("hcsi_launchcalculate");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCloseCallBack(new CloseCallBack("kd.sit.hcsi.formplugin.web.cal.task.SocialInsuranceTaskList", LAUNCHCAL_CALLBACK_ID));
        return formShowParameter;
    }

    public static FormShowParameter getLoadingCalProgressForm(String recordId, boolean isLaunchCalculate) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("hcsi_loadingcalculation");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam(RECORD_ID, (Object)recordId);
        formShowParameter.setCustomParam(IS_LAUNCH_CALCULATE, (Object)isLaunchCalculate);
        formShowParameter.setCloseCallBack(new CloseCallBack("kd.sit.hcsi.formplugin.web.cal.task.SocialInsuranceTaskList", CAL_PROGRESS_CALLBACK_ID));
        return formShowParameter;
    }

    public static void andStatusFilter(QFilter qFilter) {
        qFilter.and("enable", "=", (Object)"1");
        qFilter.and("status", "=", (Object)"C");
        QFilter dataStatusFilter = new QFilter("datastatus", "in", (Object)VALID_DATA_STATUSES);
        qFilter.and(dataStatusFilter);
    }

    public static PreCalCfgDTO getStandardDTOByOnePeriodAndOneWelfarePayer(Date periodEndDate, Long companyId) {
        Map<Long, DynamicObject> stdBoIdMap = SocialInsuranceCalHelper.getStdBoIdAndStdVDyMap(periodEndDate, companyId);
        PreCalCfgDTO preCalCfgDTO = SocialInsuranceCalHelper.generateStandardDTO(stdBoIdMap.values());
        SocialInsuranceCalHelper.generateParamCFGDTO(preCalCfgDTO);
        preCalCfgDTO.setWelfarePayerId(companyId);
        return preCalCfgDTO;
    }

    public static Map<Long, DynamicObject> getStdBoIdAndStdVDyMap(Date periodEndDate, Long companyId) {
        Map<Long, DynamicObject> stdBoIdMap = SocialInsuranceCalHelper.getInsuranceStandardIdsInCompanyRefStandard(companyId, periodEndDate);
        if (stdBoIdMap.isEmpty()) {
            return Collections.emptyMap();
        }
        Object[] stdVDys = SocialInsuranceCalHelper.getStdVDys(stdBoIdMap.keySet(), periodEndDate);
        if (HRArrayUtils.isEmpty((Object[])stdVDys)) {
            return Collections.emptyMap();
        }
        Arrays.stream(stdVDys).forEach(stdVDy -> stdBoIdMap.put(stdVDy.getLong("boid"), (DynamicObject)stdVDy));
        stdBoIdMap.values().removeIf(Objects::isNull);
        return stdBoIdMap;
    }

    public static DynamicObject[] getStdVDys(Collection<Long> stdBoIds, Date periodEndDate) {
        QFilter stdFilter = new QFilter("boid", "in", stdBoIds);
        SocialInsuranceCalHelper.getDateFilter(stdFilter, periodEndDate);
        stdFilter.and("iscurrentversion", "=", (Object)Boolean.FALSE);
        stdFilter.and("status", "=", (Object)"C");
        stdFilter.and("datastatus", "in", (Object)VALID_DATA_STATUSES);
        return STANDARD_HELPER.loadDynamicObjectArray(stdFilter.toArray());
    }

    private static Map<Long, DynamicObject> getInsuranceStandardIdsInCompanyRefStandard(Long companyId, Date periodEndDate) {
        DynamicObject[] companyRefStdDys = SocialInsuranceCalHelper.getCompanyRefStdDy(Collections.singletonList(companyId), periodEndDate);
        if (companyRefStdDys == null || companyRefStdDys.length == 0) {
            return Collections.emptyMap();
        }
        DynamicObjectCollection mulStdDys = companyRefStdDys[0].getDynamicObjectCollection("mulsinsurstd");
        LinkedHashMap<Long, DynamicObject> stdBoIdMap = new LinkedHashMap<Long, DynamicObject>(mulStdDys.size());
        mulStdDys.forEach(baseData -> {
            DynamicObject cfr_ignored_0 = stdBoIdMap.put(baseData.getLong("fbasedataid.id"), null);
        });
        return stdBoIdMap;
    }

    public static DynamicObject[] getCompanyRefStdDy(Collection<Long> companyIds, Date periodEndDate) {
        QFilter refFilter = new QFilter("welfarepayer.id", "in", companyIds);
        SocialInsuranceCalHelper.getDateFilter(refFilter, periodEndDate);
        refFilter.and("iscurrentversion", "=", (Object)Boolean.FALSE);
        SocialInsuranceCalHelper.andStatusFilter(refFilter);
        return COMPANY_AND_DIM_REF_HELPER.query("welfarepayer.id,mulsinsurstd", refFilter.toArray());
    }

    private static void getDateFilter(QFilter filter, Date endDate) {
        filter.and("bsed", "<=", (Object)endDate);
        filter.and("bsled", ">=", (Object)endDate);
    }

    public static Date getDayDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    private static PreCalCfgDTO generateStandardDTO(Collection<DynamicObject> sInsurStdvDys) {
        PreCalCfgDTO preCalCfgDTO = new PreCalCfgDTO();
        for (DynamicObject sinsurStdvDy : sInsurStdvDys) {
            InsuredStandardDTO insuredStandardDTO = new InsuredStandardDTO();
            Long stdvId = sinsurStdvDy.getLong("id");
            Long stdId = sinsurStdvDy.getLong("boid");
            HashMap insuredStandardTableMap = Maps.newHashMapWithExpectedSize((int)16);
            DynamicObjectCollection stdEntryEntity = sinsurStdvDy.getDynamicObjectCollection("stdentryentity");
            for (DynamicObject typeDy : stdEntryEntity) {
                DynamicObjectCollection subentryentity = typeDy.getDynamicObjectCollection("subentryentity");
                HashBasedTable dimensionResultTable = HashBasedTable.create();
                HashSet<Long> insuredItemIdSet = new HashSet<Long>(16);
                InsuredStandardTableDTO insuredStandardTableDTO = new InsuredStandardTableDTO();
                Long insurTypeId = typeDy.getLong("insurtype.id");
                String insurTypeName = typeDy.getString("insurtype.name");
                Boolean isstddim = typeDy.getBoolean("isstddim");
                String stddim = typeDy.getString("stddim");
                SocialInsuranceCalHelper.getSubEntityInfoOfStd(subentryentity, (HashBasedTable<Long, Long, Map<Long, StandardDimensionResultDTO>>)dimensionResultTable, insuredItemIdSet);
                insuredStandardTableDTO.setInsuredTypeId(insurTypeId);
                insuredStandardTableDTO.setInsuredTypeName(insurTypeName);
                insuredStandardTableDTO.setStandardDimension(isstddim);
                insuredStandardTableDTO.setStandardDimensionType(new HashSet<String>(Arrays.asList(stddim.split(","))));
                insuredStandardTableDTO.setDimensionResultTable(dimensionResultTable);
                insuredStandardTableMap.put(insurTypeId, insuredStandardTableDTO);
                insuredStandardTableDTO.setInsuredItemIdSet(insuredItemIdSet);
                preCalCfgDTO.getInsuredParamConfigMap().put(insurTypeId, new InsuredParamConfigDTO());
            }
            insuredStandardDTO.setVid(stdvId);
            insuredStandardDTO.setId(stdId);
            insuredStandardDTO.setName(sinsurStdvDy.getString("name"));
            insuredStandardDTO.setInsuredStandardTableMap((Map)insuredStandardTableMap);
            preCalCfgDTO.getInsuredStandardMap().put(stdId, insuredStandardDTO);
        }
        return preCalCfgDTO;
    }

    private static void getSubEntityInfoOfStd(DynamicObjectCollection subentryentity, HashBasedTable<Long, Long, Map<Long, StandardDimensionResultDTO>> dimensionResultTable, Set<Long> insuredItemIdSet) {
        for (DynamicObject itemDy : subentryentity) {
            Long categoryId;
            StandardDimensionResultDTO standardDimensionResultDTO = new StandardDimensionResultDTO();
            Long registerTypeId = itemDy.getLong("registertype.id");
            Map itemIdStdDimensionMap = (Map)dimensionResultTable.get((Object)registerTypeId, (Object)(categoryId = Long.valueOf(itemDy.getLong("category.id"))));
            if (itemIdStdDimensionMap == null) {
                itemIdStdDimensionMap = Maps.newHashMapWithExpectedSize((int)16);
            }
            Long insurItemId = itemDy.getLong("insuritem.id");
            Long itemPropId = itemDy.getLong("insuritem.insurancetypeattr.id");
            BigDecimal itemValue = null;
            String itemValueStr = itemDy.getString("itemvalue");
            if (SITStringUtils.isNotEmpty((String)itemValueStr)) {
                itemValue = itemDy.getBigDecimal("itemvalue");
                if (InsurTypeAttrEnum.PAY_PROPORTION_OF_EMPLOYEE.getId().equals(itemPropId) || InsurTypeAttrEnum.PAY_PROPORTION_OF_COMPANY.getId().equals(itemPropId)) {
                    itemValue = itemValue.divide(BigDecimal.valueOf(100L));
                }
            }
            String roundType = itemDy.getString("roundtype");
            standardDimensionResultDTO.setInsuredItemId(insurItemId);
            if (itemValue != null) {
                standardDimensionResultDTO.setItemValue(itemValue);
            }
            standardDimensionResultDTO.setRoundType(roundType);
            itemIdStdDimensionMap.put(insurItemId, standardDimensionResultDTO);
            dimensionResultTable.put((Object)registerTypeId, (Object)categoryId, (Object)itemIdStdDimensionMap);
            insuredItemIdSet.add(insurItemId);
        }
    }

    public static void generateParamCFGDTO(PreCalCfgDTO preCalCfgDTO) {
        Set typeIds = preCalCfgDTO.getInsuredParamConfigMap().keySet();
        HRBaseServiceHelper cfgHelper = new HRBaseServiceHelper("sitbs_sinsurstdcfg");
        QFilter cfgFilters = new QFilter("insurtype.id", "in", typeIds);
        cfgFilters.and("status", "=", (Object)"C");
        cfgFilters.and("enable", "=", (Object)"1");
        cfgFilters.and("iscurrentversion", "=", (Object)"1");
        DynamicObject[] cfgDys = cfgHelper.loadDynamicObjectArray(cfgFilters.toArray());
        if (cfgDys == null || cfgDys.length == 0) {
            return;
        }
        for (DynamicObject cfgDy : cfgDys) {
            String dataSource;
            LinkedHashMap paramConfigResultMap = Maps.newLinkedHashMapWithExpectedSize((int)16);
            Long insureTypeId = cfgDy.getLong("insurtype.id");
            InsuredParamConfigDTO insuredParamConfigDTO = preCalCfgDTO.getInsuredParamConfigMap().computeIfAbsent(insureTypeId, key -> new InsuredParamConfigDTO());
            Long insureCurrencyId = cfgDy.getLong("insurtype.currency.id");
            DynamicObjectCollection rentryentity = cfgDy.getDynamicObjectCollection("rentryentity");
            LinkedList resultDys = Lists.newLinkedList();
            HashMap propIdItemIdMap = Maps.newHashMapWithExpectedSize((int)16);
            for (DynamicObject resultDy : rentryentity) {
                if (!PAY_BASE_ITEM_PROP_ID_SET.contains(resultDy.getLong("insuritem.insurancetypeattr.id"))) continue;
                resultDys.add(resultDy);
            }
            for (DynamicObject resultDy : rentryentity) {
                dataSource = resultDy.getString("datasrc");
                if (PAY_BASE_ITEM_PROP_ID_SET.contains(resultDy.getLong("insuritem.insurancetypeattr.id")) || !DATA_SOURCE_FETCH_SET.contains(dataSource)) continue;
                resultDys.add(resultDy);
            }
            for (DynamicObject resultDy : rentryentity) {
                dataSource = resultDy.getString("datasrc");
                if (!DATA_SOURCE_CAL_SET.contains(dataSource)) continue;
                resultDys.add(resultDy);
            }
            for (DynamicObject resultDy : resultDys) {
                InsuredParamConfigResultDTO insuredParamConfigResultDTO = new InsuredParamConfigResultDTO();
                Long insureItemId = resultDy.getLong("insuritem.id");
                Long insurancePropId = resultDy.getLong("insuritem.insurancetypeattr.id");
                Long dataTypeId = resultDy.getLong("insuritem.datatype.id");
                String dataSource2 = resultDy.getString("datasrc");
                String calRule = resultDy.getString("calrule");
                String calRuleStr = "";
                if (DATA_SOURCE_FETCH_SET.contains(dataSource2)) {
                    propIdItemIdMap.put(insurancePropId, insureItemId);
                    calRuleStr = "0";
                } else {
                    calRuleStr = SocialInsuranceCalHelper.getCalRuleStr(calRule, propIdItemIdMap);
                }
                insuredParamConfigResultDTO.setName(resultDy.getString("insuritem.name"));
                insuredParamConfigResultDTO.setInsuredItemId(insureItemId);
                insuredParamConfigResultDTO.setInsuranceProId(insurancePropId);
                insuredParamConfigResultDTO.setDataTypeId(dataTypeId);
                insuredParamConfigResultDTO.setDataSource(dataSource2);
                insuredParamConfigResultDTO.setCalRule(calRuleStr);
                insuredParamConfigResultDTO.setUseRoundType("1".equals(resultDy.getString("isuseroundtype")));
                paramConfigResultMap.put(insureItemId, insuredParamConfigResultDTO);
            }
            insuredParamConfigDTO.setName(cfgDy.getString("name"));
            insuredParamConfigDTO.setInsuredTypeId(insureTypeId);
            insuredParamConfigDTO.setCurrencyId(insureCurrencyId);
            insuredParamConfigDTO.setParamConfigResultMap(paramConfigResultMap);
            insuredParamConfigDTO.setId(Long.valueOf(cfgDy.getLong("sourcevid")));
        }
    }

    public static String getCalRuleStr(String calRule, Map<Long, Long> seqItemIdMap) {
        StringBuilder strB = new StringBuilder();
        Long personBase = seqItemIdMap.getOrDefault(InsurTypeAttrEnum.PAY_BASE_OF_EMPLOYEE.getId(), 0L);
        Long companyBase = seqItemIdMap.getOrDefault(InsurTypeAttrEnum.PAY_BASE_OF_COMPANY.getId(), 0L);
        Long personRate = seqItemIdMap.getOrDefault(InsurTypeAttrEnum.PAY_PROPORTION_OF_EMPLOYEE.getId(), 0L);
        Long companyRate = seqItemIdMap.getOrDefault(InsurTypeAttrEnum.PAY_PROPORTION_OF_COMPANY.getId(), 0L);
        Long personFixed = seqItemIdMap.getOrDefault(InsurTypeAttrEnum.PAY_FIXED_OF_EMPLOYEE.getId(), 0L);
        Long companyFixed = seqItemIdMap.getOrDefault(InsurTypeAttrEnum.PAY_FIXED_OF_COMPANY.getId(), 0L);
        CalRuleEnum calRuleEnum = CalRuleEnum.getEnumBySeq((String)calRule);
        switch (calRuleEnum) {
            case PBASE_PRATE_PFIXED: {
                strB.append(personBase).append('*').append(personRate).append('+').append(personFixed);
                break;
            }
            case CBASE_CRATE_CFIXED: {
                strB.append(companyBase).append('*').append(companyRate).append('+').append(companyFixed);
                break;
            }
            case PBASE_PRATE: {
                strB.append(personBase).append('*').append(personRate);
                break;
            }
            case CBASE_CRATE: {
                strB.append(companyBase).append('*').append(companyRate);
                break;
            }
            case PFIXED: {
                strB.append(personFixed);
                break;
            }
            case CFIXED: {
                strB.append(companyFixed);
                break;
            }
            default: {
                strB.append(' ');
            }
        }
        return strB.toString();
    }

    public static void writeBatchFileAndStdOnCache(ISITAppCache isitAppCache, Map<String, CalTaskBatchDTO> batchIdBatchDTOMap, Long taskId, Collection<PreCalCfgDTO> preCalCfgDTOs) {
        isitAppCache.put(String.valueOf(taskId), (Object)SerializationUtils.serializeToBase64(new ArrayList<PreCalCfgDTO>(preCalCfgDTOs)));
        for (Map.Entry<String, CalTaskBatchDTO> batchIdBatchDTOEntry : batchIdBatchDTOMap.entrySet()) {
            isitAppCache.put(batchIdBatchDTOEntry.getKey(), (Object)SerializationUtils.serializeToBase64((Object)batchIdBatchDTOEntry.getValue()));
        }
    }

    public static void cacheProgressInfoAndOpenFloatingBall(String pageId, String recordId, int fileTotalAdd, String opKey, int taskNums) {
        ISITAppCache isitAppCache = SITAppCache.get((String)recordId);
        CalTaskProgressInfoDTO progressInfo = new CalTaskProgressInfoDTO();
        progressInfo.setTaskNum(taskNums);
        progressInfo.setTotal(fileTotalAdd);
        progressInfo.setStatus(1);
        progressInfo.setStartTime(new Date());
        isitAppCache.put("opKey", (Object)opKey);
        String floatingTaskId = SocialInsuranceCalHelper.openFloatingBall(pageId, fileTotalAdd, recordId);
        if (floatingTaskId != null) {
            isitAppCache.put("floatingTaskId", (Object)floatingTaskId);
        }
        isitAppCache.put(String.format(Locale.ROOT, "CalTaskProgress_%s", recordId), (Object)progressInfo);
    }

    private static String openFloatingBall(String pageId, int fileTotalAdd, String recordId) {
        String floatingTaskId = null;
        if (pageId != null && fileTotalAdd > 0) {
            HashMap<String, String> params = new HashMap<String, String>(2);
            params.put(RECORD_ID, recordId);
            floatingTaskId = HRBackgroundTaskHelper.getInstance().createBaskgroundTask("sit_hcsi_calsocialdetail", HCSIErrInfoEnum.CAL_PERSON_FLOATING_BALL_NAME.getErrInfo(), true, pageId, params);
        }
        return floatingTaskId;
    }

    public static void publishMsgByPublisher(String recordId, List<String> batchStrIds) {
        try {
            for (String batchStrId : batchStrIds) {
                HashMap<String, Object> param = new HashMap<String, Object>(3);
                param.put(RECORD_ID, recordId);
                param.put(BATCH_ID, batchStrId);
                BatchSocialCalPublisher.publishBatchCalMsg(param);
            }
        }
        catch (Exception e) {
            log.error(MessageFormat.format("\u6863\u6848\u64cd\u4f5c\u7f16\u53f7\u5373recordId\u4e3a{0}\u7684\u6279\u6b21\u51fa\u73b0\u5f02\u5e38", recordId), (Throwable)e);
        }
    }

    public static List<Long> getIdsBySelectedRows(ListSelectedRowCollection selectedRows) {
        Object[] primaryKeyValues = selectedRows.getPrimaryKeyValues();
        return Arrays.stream(primaryKeyValues).map(id -> Long.valueOf(id.toString())).collect(Collectors.toList());
    }

    public static Map<Long, Long> genTaskIdReportIdMap(Collection<DynamicObject> taskDys) {
        HashMap taskIdReportIdMap = Maps.newHashMapWithExpectedSize((int)taskDys.size());
        long[] reportIds = DB.genLongIds((String)"hcsi_sinsurgenrecord", (int)taskDys.size());
        int index = 0;
        for (DynamicObject taskDy : taskDys) {
            long taskId = taskDy.getLong("id");
            long reportId = reportIds[index];
            taskIdReportIdMap.put(taskId, reportId);
            ++index;
        }
        return taskIdReportIdMap;
    }

    public static DynamicObject createReportByOneTask(Long reportId, DynamicObject calTaskDy, Integer totalNum) {
        MainEntityType genRecordType = EntityMetadataCache.getDataEntityType((String)"hcsi_sinsurgenrecord");
        DynamicObject calReportDy = (DynamicObject)genRecordType.createInstance();
        calReportDy.set("id", (Object)reportId);
        String reportNumber = String.valueOf(System.currentTimeMillis());
        calReportDy.set("number", (Object)reportNumber);
        calReportDy.set("sinsurtask", (Object)calTaskDy);
        calReportDy.set("genstatus", (Object)"0");
        calReportDy.set("sinsurperiod", (Object)calTaskDy.getLong("sinsurperiod.id"));
        calReportDy.set("welfarepayer", (Object)calTaskDy.getLong("welfarePayer.id"));
        Date currDate = new Date();
        calReportDy.set("starttime", (Object)currDate);
        calReportDy.set("createtime", (Object)currDate);
        calReportDy.set("creator", (Object)RequestContext.get().getCurrUserId());
        calReportDy.set("filecount", (Object)totalNum);
        return calReportDy;
    }

    public static boolean errorShowStyle(IFormView view, List<String> errorList, int totalNum, String operateName, String title, String color) {
        if (totalNum == 1 && errorList.size() == 1) {
            if ("red".equals(color)) {
                view.showErrorNotification(errorList.get(0));
            } else {
                view.showTipNotification(errorList.get(0));
            }
        } else if (totalNum > 1 && errorList.size() >= 1) {
            FormShowParameter parameters = SITShowFormServiceHelper.getOperationResultParameter((String)operateName, (String)title, errorList);
            view.showForm(parameters);
        }
        return errorList.size() != totalNum;
    }

    public static Map<String, CalTaskBatchDTO> getBatchIdBatchDTOMap(Map<Long, CalSocialDetailDTO> fileIdAndDetailDtoMap, DynamicObject taskDy, Long reportId, List<String> batchStrIds, Map<Long, Long> fileToWelfarePayerMap) {
        long periodId = taskDy.getLong("sinsurperiod.id");
        long taskId = taskDy.getLong("id");
        Date periodEndDate = SocialInsuranceCalHelper.getDayDate(taskDy.getDate("sinsurperiod.enddate"));
        HashMap batchIdBatchDTOForOneTaskMap = Maps.newHashMapWithExpectedSize((int)16);
        HashMap fileDTOBatchMap = Maps.newHashMapWithExpectedSize((int)16);
        int count = 0;
        for (Map.Entry<Long, CalSocialDetailDTO> fileIdDetailDTOEntry : fileIdAndDetailDtoMap.entrySet()) {
            boolean onBound;
            boolean beforeNewBatch = count % TOTAL_BATCH_SIZE == TOTAL_BATCH_SIZE - 1;
            boolean onNewBatch = count % TOTAL_BATCH_SIZE == 0;
            int bound = fileIdAndDetailDtoMap.size() - 1;
            boolean bl = onBound = count == bound;
            if (onNewBatch) {
                fileDTOBatchMap = Maps.newHashMapWithExpectedSize((int)16);
            }
            fileDTOBatchMap.put(fileIdDetailDTOEntry.getKey(), fileIdDetailDTOEntry.getValue());
            if (onBound || beforeNewBatch) {
                String batchId = UUID.randomUUID().toString();
                CalTaskBatchDTO calTaskBatchDTO = new CalTaskBatchDTO();
                calTaskBatchDTO.setBatchId(batchId);
                calTaskBatchDTO.setInsuredPeriodId(Long.valueOf(periodId));
                calTaskBatchDTO.setPeriodEndDate(periodEndDate);
                calTaskBatchDTO.setInsuredFileIdDetailMap((Map)fileDTOBatchMap);
                HashMap<Long, Set> welfarePayerToFileMap = new HashMap<Long, Set>(16);
                for (Long fileId : fileDTOBatchMap.keySet()) {
                    Long welfarePayerId = fileToWelfarePayerMap.get(fileId);
                    Set fileIdSet = welfarePayerToFileMap.computeIfAbsent(welfarePayerId, key -> new HashSet(16));
                    fileIdSet.add(fileId);
                }
                calTaskBatchDTO.setWelfarePayerToFileMap(welfarePayerToFileMap);
                calTaskBatchDTO.setSocialTaskId(Long.valueOf(taskId));
                calTaskBatchDTO.setReportId(reportId);
                batchIdBatchDTOForOneTaskMap.put(batchId, calTaskBatchDTO);
                batchStrIds.add(batchId);
            }
            ++count;
        }
        return batchIdBatchDTOForOneTaskMap;
    }

    public static void viewCalReport(IFormView view) {
        Long taskId = (Long)view.getFormShowParameter().getCustomParam(TASK_ID);
        ListShowParameter reportShowParameter = new ListShowParameter();
        QFilter reportFilter = new QFilter("sinsurtask.id", "in", (Object)taskId);
        reportShowParameter.setFormId("bos_list");
        reportShowParameter.setBillFormId("hcsi_sinsurgenrecord");
        reportShowParameter.getListFilterParameter().getQFilters().add(reportFilter);
        reportShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        view.showForm((FormShowParameter)reportShowParameter);
    }

    public static void viewAllCalReport(IFormView view) {
        ListShowParameter reportShowParameter = new ListShowParameter();
        reportShowParameter.setBillFormId("hcsi_sinsurgenrecord");
        reportShowParameter.setFormId("bos_list");
        reportShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        view.showForm((FormShowParameter)reportShowParameter);
    }

    public static DynamicObject[] getCurrentFileBoIdByOneWelfarePayer(Set<Long> fileIds) {
        QFilter sinsurFileFilter = new QFilter("id", "in", fileIds);
        SocialInsuranceCalHelper.andStatusFilter(sinsurFileFilter);
        String selectPor = "boid,person.personindexid,person.number,person.name,boid,sinsurstatus,welfarepayer.id,welfarepayertheory.id,welfarepayer.name,welfarepayertheory.name";
        return SINSUR_FILE_HELPER.query(selectPor, sinsurFileFilter.toArray());
    }

    public static DynamicObject[] queryHisFileByOnePeriodAndOneWelfarePayer(Date periodEndDate, Set<Long> welfarePayerIdSet, QFilter authorizedDataRuleQFilter) {
        QFilter filter = SocialInsuranceCalHelper.isDependonOnTheoryPayer() ? new QFilter("welfarepayertheory", "in", welfarePayerIdSet) : new QFilter("welfarepayer", "in", welfarePayerIdSet);
        filter.and("iscurrentversion", "=", (Object)Boolean.FALSE);
        filter.and("sinsurstatus", "=", (Object)"normal");
        filter.and(authorizedDataRuleQFilter);
        SocialInsuranceCalHelper.getDateFilter(filter, periodEndDate);
        SocialInsuranceCalHelper.andStatusFilter(filter);
        return SINSUR_FILE_HELPER.query("id,boid,welfarepayer.id,welfarepayertheory.id,welfarepayer.name,welfarepayertheory.name", filter.toArray());
    }

    public static Map<Long, CalSocialDetailDTO> updateTaskReportAndCalPerson(DynamicObject taskDy, Long reportId, List<DynamicObject> fileVDys, String calType) {
        Long taskId = taskDy.getLong("id");
        QFilter detailFilter = new QFilter("sinsurtask.id", "=", (Object)taskId);
        int totalNum = CAL_PERSON_HELPER.count("hcsi_calperson", detailFilter.toArray());
        QFilter authorizedDataRuleQFilter = SocialInsuranceCalHelper.getAuthorizedDataRuleQFilterOf("hcsi_calperson", calType);
        detailFilter.and(authorizedDataRuleQFilter);
        detailFilter.and("calstatus", "in", (Object)new String[]{"0", "1"});
        DynamicObjectCollection deleteDetails = CAL_PERSON_HELPER.queryOriginalCollection("id,sinsurfilev.boid", detailFilter.toArray());
        Set oldFileIdSet = deleteDetails.stream().map(deleteDetail -> deleteDetail.getLong("sinsurfilev.boid")).collect(Collectors.toSet());
        int deleteNum = deleteDetails.size();
        QFilter auditFilter = new QFilter("calstatus", "=", (Object)"2");
        auditFilter.and(new QFilter("sinsurtask.id", "in", (Object)taskId));
        DynamicObject[] auditPersonDys = CAL_PERSON_HELPER.query("sinsurfilev.boid,pushstatus", auditFilter.toArray());
        Set pushStatusSet = Arrays.stream(auditPersonDys).map(personDy -> personDy.getString("pushstatus")).collect(Collectors.toSet());
        Set auditedFileBoids = Arrays.stream(auditPersonDys).map(auditPersonDy -> auditPersonDy.getLong("sinsurfilev.boid")).collect(Collectors.toSet());
        List<DynamicObject> unauditedFilevForTask = fileVDys.stream().filter(fileVDy -> !auditedFileBoids.contains(fileVDy.getLong("boid"))).collect(Collectors.toList());
        HashSet<Long> newFileIdSet = new HashSet<Long>(unauditedFilevForTask.size());
        Set<Long> welfarePayerIdSet = SocialInsuranceCalHelper.updateCompanyOfTaskAndGetNewFileBoId(taskDy, unauditedFilevForTask, newFileIdSet);
        oldFileIdSet.removeAll(newFileIdSet);
        int addNum = unauditedFilevForTask.size();
        totalNum = totalNum + addNum - deleteNum;
        taskDy.set("personcount", (Object)totalNum);
        taskDy.set("modifier", (Object)RequestContext.get().getCurrUserId());
        taskDy.set("modifytime", (Object)new Date());
        DynamicObject reportDy = SocialInsuranceCalHelper.createReportByOneTask(reportId, taskDy, addNum);
        if (addNum == 0) {
            reportDy.set("genstatus", (Object)"1");
            reportDy.set("endtime", (Object)new Date());
            reportDy.set("genduration", (Object)SocialInsuranceCalHelper.getTimeStr(reportDy.getDate("starttime"), reportDy.getDate("endtime")));
            if (auditPersonDys.length > 0) {
                taskDy.set("taskstatus", (Object)"2");
            }
            if (pushStatusSet.size() == 1 && pushStatusSet.contains("pushed")) {
                taskDy.set("pushstatus", (Object)"2");
            }
        } else {
            taskDy.set("pushstatus", (Object)"0");
            taskDy.set("taskstatus", (Object)"0");
        }
        boolean saveSuccess = true;
        try (TXHandle txHandle = TX.required();){
            try {
                QFilter adjDataFilter = new QFilter("sinsurfile", "in", oldFileIdSet);
                adjDataFilter.and("sinsurtask", "=", (Object)taskDy.getLong("id"));
                HRBaseServiceHelper adjHelper = new HRBaseServiceHelper("hcsi_sinsuradjdata");
                adjHelper.deleteByFilter(adjDataFilter.toArray());
                adjHelper.setEntityName("hcsi_sinsuradjrec");
                adjHelper.deleteByFilter(adjDataFilter.toArray());
                CAL_PERSON_HELPER.deleteByFilter(detailFilter.toArray());
                SINSURTASK_HELPER.saveOne(taskDy);
                REPORT_HELPER.saveOne(reportDy);
            }
            catch (Exception e) {
                txHandle.markRollback();
                log.error("SocialInsuranceCalHelper.updateTaskReportAndCalPerson: update failed, ", (Throwable)e);
                saveSuccess = false;
            }
        }
        HashMap fileIdDetailDTOFitTaskMap = Maps.newHashMapWithExpectedSize((int)fileVDys.size());
        if (saveSuccess) {
            SocialInsuranceCalHelper.getFileIdDetailDTOFitTaskMap(unauditedFilevForTask, fileIdDetailDTOFitTaskMap);
        }
        if (deleteNum > 0 && fileIdDetailDTOFitTaskMap.isEmpty()) {
            fileIdDetailDTOFitTaskMap = null;
        }
        return fileIdDetailDTOFitTaskMap;
    }

    private static Set<Long> updateCompanyOfTaskAndGetNewFileBoId(DynamicObject taskDy, List<DynamicObject> unauditedFilevForTask, Set<Long> newFileIdSet) {
        Pair<String, String> companyFieldForTaskAndFile = SocialInsuranceCalHelper.getCompanyFieldForTaskAndFile();
        DynamicObjectCollection welfarePayers = taskDy.getDynamicObjectCollection((String)companyFieldForTaskAndFile.getKey());
        Set<Long> welfarePayerIdSet = welfarePayers.stream().map(welfarePayer -> welfarePayer.getLong("fbasedataid_id")).collect(Collectors.toSet());
        for (DynamicObject file : unauditedFilevForTask) {
            Long welfarePayerId = file.getLong((String)companyFieldForTaskAndFile.getValue());
            if (welfarePayerIdSet.add(welfarePayerId)) {
                welfarePayers.addNew().set("fbasedataid_id", (Object)welfarePayerId);
            }
            newFileIdSet.add(file.getLong("boid"));
        }
        return welfarePayerIdSet;
    }

    public static Map<Long, CalSocialDetailDTO> updateCalPersonAndTaskAndReport(DynamicObject taskDy, Long reportId, List<DynamicObject> fileVDys) {
        HashSet<Long> updateFileBoIds = new HashSet<Long>(fileVDys.size());
        Set<Long> newCompanyIds = SocialInsuranceCalHelper.updateCompanyOfTaskAndGetNewFileBoId(taskDy, fileVDys, updateFileBoIds);
        int addNum = fileVDys.size();
        DynamicObject reportDy = SocialInsuranceCalHelper.createReportByOneTask(reportId, taskDy, addNum);
        taskDy.set("pushstatus", (Object)"0");
        taskDy.set("taskstatus", (Object)"0");
        QFilter calPersonFilter = SocialInsuranceCalHelper.getUpdateCalPersonFilter(taskDy, updateFileBoIds);
        boolean saveSuccess = true;
        try (TXHandle txHandle = TX.required();){
            try {
                CAL_PERSON_HELPER.deleteByFilter(calPersonFilter.toArray());
                SINSURTASK_HELPER.saveOne(taskDy);
                REPORT_HELPER.saveOne(reportDy);
            }
            catch (Exception e) {
                txHandle.markRollback();
                log.error("SocialInsuranceCalHelper.updateCalPersonAndTaskAndReport: update failed, ", (Throwable)e);
                saveSuccess = false;
            }
        }
        HashMap fileIdDetailDTOFitTaskMap = Maps.newHashMapWithExpectedSize((int)fileVDys.size());
        if (saveSuccess) {
            SocialInsuranceCalHelper.getFileIdDetailDTOFitTaskMap(fileVDys, fileIdDetailDTOFitTaskMap);
        }
        return fileIdDetailDTOFitTaskMap;
    }

    private static void getFileIdDetailDTOFitTaskMap(List<DynamicObject> unauditedFilevForTask, Map<Long, CalSocialDetailDTO> fileIdDetailDTOFitTaskMap) {
        for (DynamicObject filevDy : unauditedFilevForTask) {
            Long fileId = filevDy.getLong("boid");
            Long filevId = filevDy.getLong("id");
            CalSocialDetailDTO calSocialDetailDTO = new CalSocialDetailDTO(filevId);
            fileIdDetailDTOFitTaskMap.put(fileId, calSocialDetailDTO);
        }
    }

    private static QFilter getUpdateCalPersonFilter(DynamicObject taskDy, Set<Long> updateFileBoIds) {
        QFilter detailFilter = new QFilter("sinsurtask.id", "=", (Object)taskDy.getLong("id"));
        detailFilter.and("sinsurfilev.boid", "in", updateFileBoIds);
        return detailFilter;
    }

    public static Pair<String, String> getCompanyFieldForTaskAndFile() {
        String welfarePayerKeyForTask;
        String welfarePayerIdKeyForFile;
        if (!SocialInsuranceCalHelper.isDependonOnTheoryPayer()) {
            welfarePayerIdKeyForFile = "welfarepayertheory.id";
            welfarePayerKeyForTask = "theorywelfarepayer";
        } else {
            welfarePayerIdKeyForFile = "welfarepayer.id";
            welfarePayerKeyForTask = "actualwelfarepayer";
        }
        return new Pair((Object)welfarePayerKeyForTask, (Object)welfarePayerIdKeyForFile);
    }

    public static void updateCompanyInsuranceItemBy(DynamicObject sinsurTaskDy, Set<Long> newCompanyIds, int stockDataNum) {
        if (HRObjectUtils.isEmpty((Object)sinsurTaskDy)) {
            return;
        }
        if (stockDataNum > 2000) {
            SINSURTASK_HELPER.saveOne(sinsurTaskDy);
            return;
        }
        long taskId = sinsurTaskDy.getLong("id");
        HashSet<Long> itemIds = new HashSet<Long>(16);
        String selectSql = "SELECT DISTINCT T1.FINSURANCEITEMID itemid FROM T_HCSI_CALPERSONENTRY T1 INNER JOIN T_HCSI_CALPERSON T2 ON T1.FID = T2.FID AND T2.FSINSURTASKID = ?";
        try (DataSet dataSet = HRDBUtil.queryDataSet((String)"SinsurCalPersonResultUpdateTask", (DBRoute)SITBaseConstants.DB_ROUTE_SIT, (String)selectSql, (Object[])new Object[]{taskId});){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                Long insuranceItemId = row.getLong("itemid");
                if (Long.valueOf(0L).equals(insuranceItemId)) continue;
                itemIds.add(insuranceItemId);
            }
        }
        Set<Long> sumCompanyIds = newCompanyIds;
        if (sumCompanyIds == null) {
            sumCompanyIds = new HashSet<Long>(16);
        }
        String companyField = SocialInsuranceCalHelper.isDependonOnTheoryPayer() ? "FWELFAREPAYERID" : "FWELFAREPAYERTHEORYID";
        selectSql = "SELECT DISTINCT T1." + companyField + " companyid FROM T_HCSI_SINSURFILE T1 INNER JOIN T_HCSI_CALPERSON T2 ON T1.FID = T2.FSINSURFILEVID AND T2.FSINSURTASKID = ?";
        try (DataSet dataSet = HRDBUtil.queryDataSet((String)"SinsurCalPersonResultUpdateTask", (DBRoute)SITBaseConstants.DB_ROUTE_SIT, (String)selectSql, (Object[])new Object[]{taskId});){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                Long companyId = row.getLong("companyid");
                if (Long.valueOf(0L).equals(companyId)) continue;
                sumCompanyIds.add(companyId);
            }
        }
        SocialInsuranceCalHelper.addTaskMulBaseData(sinsurTaskDy, "mulinsuranceitem", itemIds);
        Pair<String, String> companyFieldForTaskAndFile = SocialInsuranceCalHelper.getCompanyFieldForTaskAndFile();
        SocialInsuranceCalHelper.addTaskMulBaseData(sinsurTaskDy, (String)companyFieldForTaskAndFile.getKey(), sumCompanyIds);
        SINSURTASK_HELPER.saveOne(sinsurTaskDy);
    }

    private static void addTaskMulBaseData(DynamicObject sinsurTaskDy, String fieldKey, Set<Long> mulPkIds) {
        DynamicObjectCollection sinsurItemDys = sinsurTaskDy.getDynamicObjectCollection(fieldKey);
        sinsurItemDys.clear();
        mulPkIds.forEach(mulPkId -> sinsurItemDys.addNew().set("fbasedataid_id", mulPkId));
    }

    public static List<String> writeCache(ISITAppCache isitAppCache, Map<Long, CalSocialDetailDTO> fileIdAndDetailDtoMap, Collection<PreCalCfgDTO> preCalCfgDTOs, DynamicObject taskDy, Long reportId, Map<Long, Long> taskToFileToWelfarePayerMap) {
        ArrayList batchStrIds = Lists.newArrayListWithExpectedSize((int)10);
        Map<String, CalTaskBatchDTO> batchIdBatchDTOForOneTaskMap = SocialInsuranceCalHelper.getBatchIdBatchDTOMap(fileIdAndDetailDtoMap, taskDy, reportId, batchStrIds, taskToFileToWelfarePayerMap);
        SocialInsuranceCalHelper.writeBatchFileAndStdOnCache(isitAppCache, batchIdBatchDTOForOneTaskMap, taskDy.getLong("id"), preCalCfgDTOs);
        return batchStrIds;
    }

    public static String getTimeStr(Date calStartTime, Date calEndTime) {
        if (calStartTime == null || calEndTime == null) {
            return "";
        }
        long diff = calEndTime.getTime() - calStartTime.getTime();
        if (diff < 0L) {
            return "";
        }
        long day = diff / 86400000L;
        long hour = diff / 3600000L - day * 24L;
        long min = diff / 60000L - day * 24L * 60L - hour * 60L;
        long sd = diff / 1000L - day * 24L * 60L * 60L - hour * 60L * 60L - min * 60L;
        StringBuilder sb = new StringBuilder();
        if (day != 0L) {
            sb.append(day).append(ResManager.loadKDString((String)"\u5929", (String)"SocialInsuranceCalHelper_20", (String)"sit-hcsi-business", (Object[])new Object[0]));
        }
        if (hour > 0L) {
            sb.append(hour).append(ResManager.loadKDString((String)"\u5c0f\u65f6", (String)"SocialInsuranceCalHelper_21", (String)"sit-hcsi-business", (Object[])new Object[0]));
        }
        if (min > 0L) {
            sb.append(min).append(ResManager.loadKDString((String)"\u5206\u949f", (String)"SocialInsuranceCalHelper_22", (String)"sit-hcsi-business", (Object[])new Object[0]));
        }
        sb.append(sd).append(ResManager.loadKDString((String)"\u79d2", (String)"SocialInsuranceCalHelper_23", (String)"sit-hcsi-business", (Object[])new Object[0]));
        return sb.toString();
    }

    public static void setWelfarePayerF7Filter(ListShowParameter param, String entityName) {
        QFilter qFilter = SocialInsuranceCalHelper.welfarePayerDataAuthFilter(entityName);
        param.getListFilterParameter().setFilter(qFilter);
    }

    public static QFilter welfarePayerDataAuthFilter(String entityName) {
        Set welfarePayerIds;
        QFilter qFilter = new QFilter("status", "=", (Object)"C");
        qFilter.and("enable", "=", (Object)"1");
        HasPermOrgResult permOrgs = SITPermissionServiceHelper.getPermOrgs((String)"31", (String)"2AXKDRPJUQ77", (String)entityName, (String)"47150e89000000ac");
        if (!permOrgs.hasAllOrgPerm()) {
            qFilter.and("org", "in", (Object)permOrgs.getHasPermOrgs());
        }
        if ((welfarePayerIds = SITPermissionServiceHelper.getWelfarePayerSetByPermItem((String)"2AXKDRPJUQ77", (String)entityName)) != null) {
            qFilter.and("id", "in", (Object)welfarePayerIds);
        }
        return qFilter;
    }

    public static QFilter getAuthorizedDataRuleQFilterOf(String entityNumber, String calType) {
        boolean needGetAuthorizedDataRuleQFilter;
        QFilter authorizedDataRuleQFilter = new QFilter("1", "=", (Object)1);
        boolean bl = needGetAuthorizedDataRuleQFilter = !(!"hcsi_sinsurfile".equals(entityNumber) && !"hcsi_calperson".equals(entityNumber) || !"2".equals(calType) && !"4".equals(calType));
        if (needGetAuthorizedDataRuleQFilter) {
            List authorizedDataRuleQFilters = SITPermissionServiceHelper.getAuthorizedDataRuleQFilter((String)"2AXKDRPJUQ77", (String)entityNumber, (String)"47150e89000000ac");
            if (authorizedDataRuleQFilters == null) {
                authorizedDataRuleQFilter = new QFilter("1", "!=", (Object)1);
            } else {
                for (QFilter filter : authorizedDataRuleQFilters) {
                    authorizedDataRuleQFilter.and(filter);
                }
            }
        }
        return authorizedDataRuleQFilter;
    }

    public static List<InsuredStandard> callExtPointForItemInfo(OnGetInsuredStandardListEvent evt) {
        HRPluginProxy proxy = HRPlugInProxyFactory.create((Object)new DefaultCalPersonListDisplayPlugin(), ICalPersonListDisplayPlugin.class, (String)"kd.sdk.sit.hcsi.formplugin.cal.detail.ICalPersonListDisplayPlugin#onGetInsuredStandardList", null);
        proxy.callReplaceIfPresent(plugin -> {
            plugin.onGetInsuredStandardList(evt);
            return null;
        });
        List<InsuredStandard> insuredStandards = evt.getInsuredStandards();
        if (insuredStandards == null || insuredStandards.isEmpty()) {
            insuredStandards = SocialInsuranceCalHelper.queryInsuredItemByIds(evt.getInsureItemIds());
        }
        if (insuredStandards == null) {
            return new ArrayList<InsuredStandard>(10);
        }
        return insuredStandards;
    }

    public static List<InsuredStandard> getInsuredSumItemList() {
        List<InsuredSumItem> sumItemList = SocialInsuranceCalHelper.assembleSumItemList();
        ArrayList<InsuredStandard> standardList = new ArrayList<InsuredStandard>(sumItemList.size());
        for (InsuredSumItem sumItem : sumItemList) {
            InsuredStandard standard = new InsuredStandard(sumItem.getSumItemId(), sumItem.getSumItemName(), sumItem.getDataTypeId(), "2");
            standardList.add(standard);
        }
        return standardList;
    }

    public static List<InsuredSumItem> assembleSumItemList() {
        QFilter filter = new QFilter("enable", "=", (Object)"1");
        filter.and("status", "=", (Object)"C");
        filter.and("iscurrentversion", "=", (Object)"1");
        return SocialInsuranceCalHelper.getSumItemList(filter);
    }

    public static List<InsuredStandard> getInsuredSumItemList(QFilter filter) {
        List<InsuredSumItem> sumItemList = SocialInsuranceCalHelper.getSumItemList(filter);
        ArrayList<InsuredStandard> standardList = new ArrayList<InsuredStandard>(sumItemList.size());
        for (InsuredSumItem sumItem : sumItemList) {
            InsuredStandard standard = new InsuredStandard(sumItem.getSumItemId(), sumItem.getSumItemName(), sumItem.getDataTypeId(), "2");
            standardList.add(standard);
        }
        return standardList;
    }

    public static List<InsuredSumItem> getSumItemList(QFilter filter) {
        ArrayList sumItemList = Lists.newArrayListWithExpectedSize((int)10);
        HRBaseServiceHelper helper = new HRBaseServiceHelper("sitbs_sumitem");
        DynamicObject[] objects = helper.query("id,number,name,insuranceitem.id,index", new QFilter[]{filter}, "index asc");
        if (objects == null || objects.length == 0) {
            return new ArrayList<InsuredSumItem>(0);
        }
        for (DynamicObject object : objects) {
            long itemId = object.getLong("id");
            String itemName = object.getString("name");
            DynamicObjectCollection entryentity = object.getDynamicObjectCollection("entryentity");
            List<Object> insuranceItemIdList = new ArrayList(10);
            if (entryentity != null && entryentity.size() > 0) {
                insuranceItemIdList = entryentity.stream().map(single -> single.getLong("insuranceitem.id")).collect(Collectors.toList());
            }
            InsuredSumItem insuredSumItem = new InsuredSumItem(Long.valueOf(itemId), itemName, insuranceItemIdList, Long.valueOf(SitDataTypeEnum.AMOUNT.getId()));
            sumItemList.add(insuredSumItem);
        }
        return sumItemList;
    }

    public static void assembleSumItemData(List<InsuredSumItem> sumItemList, Map<String, Object> detailMap, DynamicObject detailDy, DynamicObjectCollection resultCol, String type) {
        if (SITListUtil.isEmpty((List)resultCol)) {
            return;
        }
        if (sumItemList.size() == 0) {
            return;
        }
        Map<Long, List> sumItemEntryMap = sumItemList.stream().collect(Collectors.toMap(InsuredSumItem::getSumItemId, InsuredSumItem::getItemIdList));
        Map resultMap = resultCol.stream().collect(Collectors.toMap(key -> key.getLong("insuranceitem.id"), Function.identity()));
        for (Map.Entry<Long, List> entry : sumItemEntryMap.entrySet()) {
            Long sumItemId = entry.getKey();
            BigDecimal value = BigDecimal.ZERO;
            List insuranceItemIdList = entry.getValue();
            for (Long itemId : insuranceItemIdList) {
                String singleValue;
                DynamicObject itemObj = (DynamicObject)resultMap.get(itemId);
                if (itemObj == null || itemObj.getBoolean("isnull") || !SITStringUtils.isNotEmpty((String)(singleValue = itemObj.getString("amountvalue")))) continue;
                value = value.add(new BigDecimal(singleValue));
            }
            if (SITStringUtils.equals((String)"1", (String)type)) {
                detailDy.set(String.valueOf(sumItemId), (Object)value.setScale(2, 4));
                continue;
            }
            detailMap.put(String.valueOf(sumItemId), value.setScale(2, 4));
        }
    }

    public static List<InsuredStandard> queryInsuredItemByIds(List<Long> insureItemIds) {
        if (insureItemIds == null || insureItemIds.isEmpty()) {
            return new ArrayList<InsuredStandard>(0);
        }
        QFilter filter = new QFilter("id", "in", insureItemIds);
        return SocialInsuranceCalHelper.getInsureItemData(filter);
    }

    public static List<InsuredStandard> getInsureItemData(QFilter filter) {
        DynamicObject[] itemDys;
        ArrayList result = Lists.newArrayListWithExpectedSize((int)10);
        HRBaseServiceHelper helper = new HRBaseServiceHelper("sitbs_insuranceitem");
        for (DynamicObject itemDy : itemDys = helper.query("id, name, datatype.id, dataprecision.scale,group.currency.amtprecision", new QFilter[]{filter})) {
            InsuredStandard insuredStandard = new InsuredStandard(Long.valueOf(itemDy.getLong("id")), itemDy.getString("name"), Long.valueOf(itemDy.getLong("datatype.id")), "1");
            if (SitDataTypeEnum.AMOUNT.getId() == itemDy.getLong("datatype.id")) {
                insuredStandard.setScale(Integer.valueOf(itemDy.getInt("group.currency.amtprecision")));
            } else {
                insuredStandard.setScale(Integer.valueOf(itemDy.getInt("dataprecision.scale")));
            }
            result.add(insuredStandard);
        }
        return result;
    }

    public static List<DynamicObject> getInsureItemDyObjList(List<Long> insureItemIds) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("sitbs_insuranceitem");
        QFilter filter = new QFilter("id", "in", insureItemIds);
        DynamicObjectCollection insuranceItemDys = helper.queryOriginalCollection("id, name, datatype.id, dataprecision.scale,dataround.id", new QFilter[]{filter});
        if (insuranceItemDys == null) {
            return new ArrayList<DynamicObject>(0);
        }
        return insuranceItemDys;
    }

    public static QFilter getDataRuleQFilter(String permitId) {
        List qFilters;
        if (StringUtils.isEmpty((Object)permitId)) {
            permitId = "47150e89000000ac";
        }
        QFilter qFilter = new QFilter("1", "=", (Object)1);
        HasPermOrgResult permOrgs = SITPermissionServiceHelper.getPermOrgs((String)"31", (String)"2AXKDRPJUQ77", (String)"hcsi_calperson", (String)permitId);
        if (!permOrgs.hasAllOrgPerm()) {
            qFilter.and("org.id", "in", (Object)permOrgs.getHasPermOrgs());
        }
        if ((qFilters = SITPermissionServiceHelper.getAuthorizedDataRuleQFilter((String)"2AXKDRPJUQ77", (String)"hcsi_calperson", (String)permitId)) != null) {
            qFilters.forEach(arg_0 -> ((QFilter)qFilter).and(arg_0));
        }
        return qFilter;
    }

    public static boolean isBatchOpCompleted(OperateOption option) {
        return option != null && Boolean.parseBoolean(option.getVariableValue("batchop_completed", String.valueOf(false)));
    }

    public static void removeSecondDeleteBatchKey(FormOperate formOperate, Collection<String> opKeys) {
        Map variables;
        if (formOperate != null && opKeys.contains(formOperate.getOperateKey()) && (variables = formOperate.getOption().getVariables()) != null) {
            variables.remove(IS_SECOND_DELETE_BATCH);
        }
    }

    public static List<Long> getAllChineseWelfareTypeIdList() {
        return SocialInsuranceCalHelper.getChineseWelfareTypeIdList(null);
    }

    public static List<Long> getChineseWelfareTypeIdList(Collection<Long> ids) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("sitbs_welfaretype");
        QFilter filter = new QFilter("country.id", "=", (Object)1000001L);
        filter.and(new QFilter("status", "=", (Object)"C"));
        filter.and(new QFilter("enable", "=", (Object)"1"));
        if (!org.apache.commons.collections.CollectionUtils.isEmpty(ids)) {
            filter.and(new QFilter("id", "in", ids));
        }
        DynamicObject[] welfareTypes = helper.queryOriginalArray("id", new QFilter[]{filter});
        return Arrays.stream(welfareTypes).map(welfareType -> welfareType.getLong("id")).collect(Collectors.toList());
    }

    public static boolean checkWelfareTypeOverlap(Set<Long> welfareTypeIdSet, DynamicObjectCollection usedWelfareTypes, StringBuilder messageBuilder) {
        boolean isOverlap = false;
        for (DynamicObject welfaretype : usedWelfareTypes) {
            if (!welfareTypeIdSet.contains(welfaretype.getLong("fbasedataid.id"))) continue;
            if (messageBuilder != null) {
                if (messageBuilder.length() > 0) {
                    messageBuilder.append('\u3001');
                }
                messageBuilder.append(welfaretype.getString("fbasedataid.name"));
            }
            isOverlap = true;
        }
        return isOverlap;
    }

    public static Map<Long, Set<Long>> getInsuredItemForTsak(Set<Long> taskIdSet) {
        HashMap<Long, Set<Long>> insuredItemMap = new HashMap<Long, Set<Long>>(taskIdSet.size());
        HashSet<Long> targetTaskIdSet = new HashSet<Long>(taskIdSet.size());
        ISITAppCache appCache = SITAppCache.get((String)"insuredItemForTask");
        for (Long taskId : taskIdSet) {
            Set cacheInsuredItemIdSet = (Set)appCache.get(String.valueOf(taskId), Set.class);
            if (cacheInsuredItemIdSet != null) {
                HashSet<Long> insuredItemIdSet = new HashSet<Long>(cacheInsuredItemIdSet.size());
                for (Object itemId : cacheInsuredItemIdSet) {
                    if (itemId instanceof Integer) {
                        insuredItemIdSet.add(Long.valueOf(((Integer)itemId).intValue()));
                        continue;
                    }
                    insuredItemIdSet.add((Long)itemId);
                }
                insuredItemMap.put(taskId, insuredItemIdSet);
                continue;
            }
            targetTaskIdSet.add(taskId);
        }
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hcsi_sinsurtask");
        DynamicObject[] insuranceTaskDys = helper.loadDynamicObjectArray(new QFilter[]{new QFilter("id", "in", targetTaskIdSet)});
        if (insuranceTaskDys == null || insuranceTaskDys.length == 0) {
            return insuredItemMap;
        }
        HashSet welfareTypeIdSet = new HashSet(16);
        HashMap taskToWelfareTypeMap = new HashMap(insuranceTaskDys.length);
        for (DynamicObject insuranceTaskDy : insuranceTaskDys) {
            Set idSet = insuranceTaskDy.getDynamicObjectCollection("welfaretype").stream().map(welfareType -> welfareType.getLong("fbasedataid.id")).collect(Collectors.toSet());
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(idSet)) {
                welfareTypeIdSet.addAll(idSet);
                taskToWelfareTypeMap.put(insuranceTaskDy.getLong("id"), idSet);
                continue;
            }
            appCache.put(String.valueOf(insuranceTaskDy.getLong("id")), new HashSet(0));
        }
        if (org.apache.commons.collections.CollectionUtils.isEmpty(welfareTypeIdSet)) {
            return insuredItemMap;
        }
        helper.setEntityName("sitbs_insuranceitem");
        DynamicObjectCollection items = helper.queryOriginalCollection("id,group.id", new QFilter[]{new QFilter("group", "in", welfareTypeIdSet)});
        HashMap<Long, Set> welfareTypeToItemMap = new HashMap<Long, Set>(welfareTypeIdSet.size());
        for (DynamicObject item : items) {
            Long typeId = item.getLong("group.id");
            Set itemIdSet = welfareTypeToItemMap.computeIfAbsent(typeId, key -> new HashSet(16));
            itemIdSet.add(item.getLong("id"));
        }
        for (Map.Entry taskToWelfareTypeEntry : taskToWelfareTypeMap.entrySet()) {
            Long taskId = (Long)taskToWelfareTypeEntry.getKey();
            Set welfareTypeSet = (Set)taskToWelfareTypeEntry.getValue();
            Set itemForTaskSet = insuredItemMap.computeIfAbsent(taskId, key -> new HashSet());
            for (Long welfareType2 : welfareTypeSet) {
                Set itemIdSet = (Set)welfareTypeToItemMap.get(welfareType2);
                if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)itemIdSet)) continue;
                itemForTaskSet.addAll(itemIdSet);
            }
            appCache.put(String.valueOf(taskId), (Object)itemForTaskSet);
        }
        return insuredItemMap;
    }

    public static boolean isDependonOnTheoryPayer() {
        boolean isDependonOnTheoryPayer = false;
        try {
            Map paramMap = (Map)HRMServiceHelper.invokeBizService((String)"swc", (String)"hsbs", (String)"IHSBSSalaryParameterService", (String)"getSalaryParam", (Object[])new Object[]{1823372353397155840L});
            if (paramMap != null) {
                isDependonOnTheoryPayer = SITStringUtils.equals((String)"1", (String)((String)paramMap.get("welfarepayerdependon")));
            }
        }
        catch (Exception var2) {
            log.error("invokeBizService error cause by\uff1a{}", (Object)var2.getMessage());
        }
        return isDependonOnTheoryPayer;
    }

    public static Map<Long, DynamicObject> getValidPeriodMap(Collection<Long> periodIds) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(periodIds)) {
            return new HashMap<Long, DynamicObject>(0);
        }
        QFilter filter = new QFilter("id", "in", periodIds);
        filter.and("enable", "=", (Object)"1");
        filter.and("status", "=", (Object)"C");
        filter.and("periodtype", "=", (Object)1010L);
        DynamicObject[] periodDys = new HRBaseServiceHelper("sitbs_sinsurperiod").loadDynamicObjectArray(filter.toArray());
        Map<Long, DynamicObject> periodIdAndInfoMap = Arrays.stream(periodDys).collect(Collectors.toMap(periodDy -> periodDy.getLong("id"), periodDy -> periodDy));
        return periodIdAndInfoMap;
    }

    public static DynamicObject[] getCurrentFiles(Date periodEndDate, Set<Long> insuredCompanyIdSet, List<DynamicObject> hisFileList, String calType) {
        QFilter authorizedDataRuleQFilter = SocialInsuranceCalHelper.getAuthorizedDataRuleQFilterOf("hcsi_sinsurfile", calType);
        log.info("\u67e5\u8be2\u6863\u6848\u7248\u672c\u65b9\u6cd5\u7ed3\u675f\uff0c\u65f6\u95f4{}\uff0c\u53c2\u4fdd\u5355\u4f4dId{}\uff0c\u671f\u95f4\u7ed3\u675f\u65e5\u671f:{}", new Object[]{new Date(), insuredCompanyIdSet, periodEndDate});
        DynamicObject[] hisFileArray = SocialInsuranceCalHelper.queryHisFileByOnePeriodAndOneWelfarePayer(periodEndDate, insuredCompanyIdSet, authorizedDataRuleQFilter);
        return SocialInsuranceCalHelper.separateSInsurFiles(hisFileArray, hisFileList);
    }

    public static DynamicObject[] getCurrentFilesBy(Collection<Long> sinsurFileBoIds, Date periodEndDate, List<DynamicObject> hisFileList) {
        QFilter filter = new QFilter("iscurrentversion", "=", (Object)Boolean.FALSE);
        filter.and("sinsurstatus", "=", (Object)"normal");
        filter.and("boid", "in", sinsurFileBoIds);
        SocialInsuranceCalHelper.getDateFilter(filter, periodEndDate);
        SocialInsuranceCalHelper.andStatusFilter(filter);
        DynamicObject[] hisFileArray = SINSUR_FILE_HELPER.query("id,boid,welfarepayer.id,welfarepayertheory.id,welfarepayer.name,welfarepayertheory.name", filter.toArray());
        return SocialInsuranceCalHelper.separateSInsurFiles(hisFileArray, hisFileList);
    }

    public static DynamicObject[] separateSInsurFiles(DynamicObject[] hisFileArray, List<DynamicObject> hisFileList) {
        DynamicObject[] currentFileArray;
        HashMap<Long, DynamicObject> boIdHisFileMap = new HashMap<Long, DynamicObject>(hisFileArray.length);
        for (DynamicObject hisFileDy : hisFileArray) {
            boIdHisFileMap.put(hisFileDy.getLong("boid"), hisFileDy);
        }
        log.info("SocialInsuranceCalHelper.separateSInsurFiles: end time is {}.", (Object)new Date());
        for (DynamicObject currentFile : currentFileArray = SocialInsuranceCalHelper.getCurrentFileBoIdByOneWelfarePayer(boIdHisFileMap.keySet())) {
            DynamicObject hisFile = (DynamicObject)boIdHisFileMap.get(currentFile.getLong("id"));
            if (hisFile == null) continue;
            hisFileList.add(hisFile);
        }
        return currentFileArray;
    }

    public static DynamicObject[] getWelfarePayers(Set<Long> welfarePayerIdSet) {
        QFilter filter = new QFilter("id", "in", welfarePayerIdSet);
        filter.and("enable", "=", (Object)"1");
        filter.and("status", "=", (Object)"C");
        HRBaseServiceHelper taskHelper = new HRBaseServiceHelper("sitbs_welfarepayer");
        DynamicObject[] welfarePayers = taskHelper.queryOriginalArray("id,org.id,name", filter.toArray());
        return welfarePayers;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static DynamicObject checkAndCreateTask(DynamicObject welfarePayer, int fileCount, DynamicObject sinsurPeriod, Set<Long> welfareTypeIdSet, ApiResult apiResult, String cacheUUID) {
        Long sinsurPeriodId = sinsurPeriod.getLong("id");
        Long welfarePayerId = welfarePayer.getLong("id");
        String lockKey = MessageFormat.format(LOCK_KEY, String.valueOf(sinsurPeriodId), String.valueOf(welfarePayerId));
        DynamicObject calTaskDy = null;
        try (DLock lock = DLock.create((String)lockKey);){
            if (!lock.tryLock(60000L)) return calTaskDy;
            HRBaseServiceHelper taskHelper = new HRBaseServiceHelper("hcsi_sinsurtask");
            QFilter qFilter = new QFilter("welfarepayer", "=", (Object)welfarePayerId);
            qFilter.and("sinsurperiod", "=", (Object)sinsurPeriodId);
            DynamicObject[] taskDys = taskHelper.query("welfarepayer,welfaretype,sinsurperiod", qFilter.toArray());
            if (taskDys != null && taskDys.length > 0) {
                boolean isOverlap = false;
                String sinsurPeriodName = sinsurPeriod.getString("name");
                String welfarePayerName = welfarePayer.getString("name");
                StringBuilder overlapTypeBuilder = new StringBuilder();
                for (DynamicObject taskDy : taskDys) {
                    DynamicObjectCollection taskWelfareTypes = taskDy.getDynamicObjectCollection("welfaretype");
                    if (!SocialInsuranceCalHelper.checkWelfareTypeOverlap(welfareTypeIdSet, taskWelfareTypes, overlapTypeBuilder)) continue;
                    isOverlap = true;
                }
                if (isOverlap) {
                    String errorMsg = CalApiResultErrInfoEnum.EXISTS_TASK_FOR_PERIOD_AND_COMPANY_COMBINED.getErrInfo(sinsurPeriodName, welfarePayerName, overlapTypeBuilder);
                    if (cacheUUID != null) {
                        new SinSurCalLaunchMsgHelper().addMessage(cacheUUID, errorMsg);
                    } else if (apiResult != null) {
                        SocialInsuranceCalFilterHelper.setApiResult(apiResult, errorMsg, CalApiResultErrInfoEnum.EXISTS_TASK_FOR_PERIOD_AND_COMPANY_COMBINED, "error", sinsurPeriodId, welfarePayerId);
                    }
                    DynamicObject dynamicObject = null;
                    return dynamicObject;
                }
            }
            if ((calTaskDy = SocialInsuranceCalHelper.generateCalTaskDy(fileCount, sinsurPeriod, apiResult, cacheUUID, welfarePayer)) == null) {
                DynamicObject isOverlap = null;
                return isOverlap;
            }
            DynamicObjectCollection welfarePayers = SocialInsuranceCalHelper.isDependonOnTheoryPayer() ? calTaskDy.getDynamicObjectCollection("theorywelfarepayer") : calTaskDy.getDynamicObjectCollection("actualwelfarepayer");
            welfarePayers.addNew().set("fbasedataid_id", (Object)welfarePayerId);
            calTaskDy.set("org", (Object)welfarePayer.getLong("org.id"));
            if (!CollectionUtils.isEmpty(welfareTypeIdSet)) {
                DynamicObjectCollection welfareType = calTaskDy.getDynamicObjectCollection("welfaretype");
                for (Long welfareTypeId : welfareTypeIdSet) {
                    if (welfareTypeId instanceof Integer) {
                        welfareType.addNew().set("fbasedataid_id", (Object)((Integer)((Object)welfareTypeId)));
                        continue;
                    }
                    welfareType.addNew().set("fbasedataid_id", (Object)welfareTypeId);
                }
            }
            new HRBaseServiceHelper("hcsi_sinsurtask").saveOne(calTaskDy);
            return calTaskDy;
        }
        catch (Exception exception) {
            log.error("SocialInsuranceCalHelper.checkAndCreateTask create dlock error", (Throwable)exception);
            if (cacheUUID != null) {
                new SinSurCalLaunchMsgHelper().addMessage(cacheUUID, HCSIErrInfoEnum.COMMON_SYS_ERROR.getErrInfo());
                return calTaskDy;
            }
            if (apiResult == null) return calTaskDy;
            SocialInsuranceCalFilterHelper.setApiResult(apiResult, HCSIErrInfoEnum.COMMON_SYS_ERROR.getErrInfo(), CalApiResultErrInfoEnum.SYSTEM_ERROR, "error", sinsurPeriodId, welfarePayerId);
        }
        return calTaskDy;
    }

    private static DynamicObject generateCalTaskDy(int fileCount, DynamicObject sinsurPeriod, ApiResult apiResult, String cacheUUID, DynamicObject welfarePayer) {
        Long welfarePayerId = welfarePayer.getLong("id");
        String welfarePayerName = welfarePayer.getString("name");
        Long sinsurPeriodId = sinsurPeriod.getLong("id");
        MainEntityType calTaskType = EntityMetadataCache.getDataEntityType((String)"hcsi_sinsurtask");
        DynamicObject calTaskDy = (DynamicObject)calTaskType.createInstance();
        calTaskDy.set("taskstatus", (Object)"0");
        calTaskDy.set("creator", (Object)RequestContext.get().getCurrUserId());
        calTaskDy.set("createtime", (Object)new Date());
        calTaskDy.set("personcount", (Object)fileCount);
        calTaskDy.set("id", (Object)DB.genLongId((String)"t_hcsi_sinsurtask"));
        calTaskDy.set("sinsurperiod", (Object)sinsurPeriod);
        calTaskDy.set("welfarepayer", (Object)welfarePayerId);
        calTaskDy.set("pushstatus", (Object)"0");
        calTaskDy.set("pushcount", (Object)0);
        try {
            String number = CodeRuleHelper.getNumber((DynamicObject)calTaskDy, null);
            calTaskDy.set("number", (Object)number);
        }
        catch (Exception exception) {
            log.error("SocialInsuranceCalHelper.checkAndCreateTask: ", (Throwable)exception);
            String codeRuleInfo = CodeRuleHelper.getCodeRuleExceptionInfo((Exception)exception);
            if (codeRuleInfo == null) {
                codeRuleInfo = HCSIErrInfoEnum.COMMON_CODE_RULE_ERROR.getErrInfo();
            }
            codeRuleInfo = welfarePayerName + "\uff1a" + codeRuleInfo;
            if (cacheUUID != null) {
                new SinSurCalLaunchMsgHelper().addMessage(cacheUUID, codeRuleInfo);
            } else if (apiResult != null) {
                SocialInsuranceCalFilterHelper.setApiResult(apiResult, codeRuleInfo, CalApiResultErrInfoEnum.CODE_RULE_GEN_ERROR, "error", sinsurPeriodId, welfarePayerId);
            }
            return null;
        }
        return calTaskDy;
    }

    public static boolean checkCertInvalidForView(DynamicObject[] currentFileArray, Map<String, Object> resultMap) {
        if (currentFileArray.length == 0) {
            return false;
        }
        long beginTime = System.currentTimeMillis();
        log.info("SocialInsuranceCalHelper.checkCertInvalidForView: begin to check cert, current time is {}", (Object)System.currentTimeMillis());
        SocialCalCertService certService = new SocialCalCertService();
        boolean isCertInvalid = !certService.checkCert(currentFileArray, "hcsi_sinsurtask");
        Map<String, Object> result = certService.getResultMsg();
        if (result != null && result.size() > 0) {
            resultMap.putAll(certService.getResultMsg());
        }
        long cost = System.currentTimeMillis() - beginTime;
        log.info("SocialInsuranceCalHelper.checkCertInvalidForView: end to check cert, cost time is {}", (Object)cost);
        return isCertInvalid;
    }

    public static void updateSinsurTaskCalStatus(Collection<Long> taskIds) {
        DynamicObject[] sinsurTasks;
        if (org.apache.commons.collections.CollectionUtils.isEmpty(taskIds)) {
            return;
        }
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hcsi_calperson");
        DynamicObjectCollection calPersons = helper.queryOriginalCollection("sinsurtask.id,calstatus", new QFilter[]{new QFilter("sinsurtask", "in", taskIds)});
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)calPersons)) {
            return;
        }
        HashedMap taskIdToTaskStatusSetMap = new HashedMap(taskIds.size());
        for (DynamicObject calPerson : calPersons) {
            Set statusSet = taskIdToTaskStatusSetMap.computeIfAbsent(calPerson.getLong("sinsurtask.id"), key -> new HashSet(3));
            statusSet.add(calPerson.getString("calstatus"));
        }
        helper.setEntityName("hcsi_sinsurtask");
        for (DynamicObject sinsurTask : sinsurTasks = helper.query("id,taskstatus", new QFilter[]{new QFilter("id", "in", taskIdToTaskStatusSetMap.keySet())})) {
            Set statusSet = (Set)taskIdToTaskStatusSetMap.get(sinsurTask.getLong("id"));
            if (statusSet.size() == 1 && statusSet.contains("2")) {
                sinsurTask.set("taskstatus", (Object)"2");
                continue;
            }
            sinsurTask.set("taskstatus", (Object)"0");
        }
        helper.save(sinsurTasks);
    }

    public static Map<Long, PreCalCfgDTO> getPreCalCfgDTOMap(List<DynamicObject> hisFileList, Date endDate, Set<String> errorNameSet) {
        if (hisFileList == null) {
            return new HashMap<Long, PreCalCfgDTO>(0);
        }
        HashMap<Long, PreCalCfgDTO> preCalCfgDTOMap = new HashMap<Long, PreCalCfgDTO>(16);
        HashMap<Long, String> welfarePayerNameMap = new HashMap<Long, String>(16);
        for (DynamicObject dynamicObject : hisFileList) {
            welfarePayerNameMap.put(dynamicObject.getLong("welfarepayer.id"), dynamicObject.getString("welfarepayer.name"));
        }
        for (Map.Entry entry : welfarePayerNameMap.entrySet()) {
            Long companyId = (Long)entry.getKey();
            PreCalCfgDTO preCalCfgDTO = SocialInsuranceCalHelper.getStandardDTOByOnePeriodAndOneWelfarePayer(endDate, companyId);
            if (preCalCfgDTO.getInsuredStandardMap() != null && !preCalCfgDTO.getInsuredStandardMap().isEmpty()) {
                preCalCfgDTOMap.put(companyId, preCalCfgDTO);
                continue;
            }
            errorNameSet.add((String)entry.getValue());
        }
        return preCalCfgDTOMap;
    }

    static {
        PAY_BASE_ITEM_PROP_ID_SET.add(InsurTypeAttrEnum.PAY_BASE_TOP_OF_EMPLOYEE.getId());
        PAY_BASE_ITEM_PROP_ID_SET.add(InsurTypeAttrEnum.PAY_BASE_BOTTOM_OF_EMPLOYEE.getId());
        PAY_BASE_ITEM_PROP_ID_SET.add(InsurTypeAttrEnum.PAY_BASE_TOP_OF_COMPANY.getId());
        PAY_BASE_ITEM_PROP_ID_SET.add(InsurTypeAttrEnum.PAY_BASE_BOTTOM_OF_COMPANY.getId());
        DATA_SOURCE_FETCH_SET.add("T");
        DATA_SOURCE_FETCH_SET.add("P");
        DATA_SOURCE_FETCH_SET.add("U");
        DATA_SOURCE_CAL_SET.add("C");
        DATA_SOURCE_CAL_SET.add("R");
    }
}

