/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.business.cal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.cache.IHRAppCache;
import kd.sit.hcsi.business.cal.SocialInsuranceCalHelper;
import kd.sit.hcsi.business.cal.errInfo.CalApiResultErrInfoEnum;
import kd.sit.hcsi.business.cal.service.ICalService;
import kd.sit.hcsi.business.cal.service.SinSurCalLaunchMsgHelper;
import kd.sit.hcsi.business.cal.service.SocialInsuranceCalService;
import kd.sit.hcsi.business.caladjust.errinfo.HCSIErrInfoEnum;
import kd.sit.hcsi.common.enums.SocialOperationEnum;
import kd.sit.sitbp.business.helper.SITLogServiceHelper;
import kd.sit.sitbp.business.servicehelper.MutexServiceHelper;
import kd.sit.sitbp.business.servicehelper.SITPermissionServiceHelper;
import kd.sit.sitbp.common.entity.social.PreCalCfgDTO;

public class SocialInsuranceCalPersonCheckThread
implements Runnable {
    private String opKey;
    private Long calTaskId;
    private DynamicObject taskDy;
    private Collection<Long> calPersonIds;
    private Date periodEndDate;
    private IHRAppCache appCache;
    private final String cacheUUID;
    private final SinSurCalLaunchMsgHelper msgHelper = new SinSurCalLaunchMsgHelper();
    private static final Log LOGGER = LogFactory.getLog(SocialInsuranceCalPersonCheckThread.class);
    private RequestContext requestContext;

    public SocialInsuranceCalPersonCheckThread(String cacheUUID, Long calTaskId, Collection<Long> calPersonIds, RequestContext requestContext) {
        this.calTaskId = calTaskId;
        this.cacheUUID = cacheUUID;
        this.calPersonIds = calPersonIds == null ? new ArrayList(0) : calPersonIds;
        this.appCache = HRAppCache.get((String)("socialCalParam_" + cacheUUID));
        this.taskDy = SocialInsuranceCalHelper.SINSURTASK_HELPER.queryOriginalOne("id,number,welfarepayer.id,welfarepayer.name,sinsurperiod.id,sinsurperiod.name,sinsurperiod.enddate,taskstatus", new QFilter("id", "=", (Object)calTaskId).toArray());
        this.periodEndDate = SocialInsuranceCalHelper.getDayDate(this.taskDy.getDate("sinsurperiod.enddate"));
        this.opKey = SocialOperationEnum.OP_CAL_PERSON_RECAL.getOperationKey();
        this.appCache.put("calType", (Object)"5");
        this.requestContext = requestContext;
    }

    @Override
    public void run() {
        try {
            RequestContext.copyAndSet((RequestContext)this.requestContext);
            this.checkData();
        }
        catch (Exception ex) {
            LOGGER.error("SocialInsuranceCalPersonCheckThread.run, checkData error:", (Throwable)ex);
            this.msgHelper.addMessage(this.cacheUUID, HCSIErrInfoEnum.COMMON_SYS_ERROR.getErrInfo());
            String operateName = MutexServiceHelper.getOperateName((String)"hcsi_calperson", (String)this.opKey);
            SITLogServiceHelper.addLog((String)"hcsi", (String)"hcsi_calperson", (String)operateName, (String)HCSIErrInfoEnum.COMMON_OPERATE_FAILED.getErrInfo(operateName));
            this.failProgress();
            this.releaseLock();
        }
    }

    private void checkData() {
        ArrayList<DynamicObject> hisFiles;
        DynamicObject[] currentFiles;
        LOGGER.info("SocialInsuranceCalPersonCheckThread.checkData: start to check person data.");
        if (this.checkTaskHaveBeenClosed(this.taskDy)) {
            return;
        }
        List<DynamicObject> calPersonDys = this.filerAuthedCalPersonDys();
        if (calPersonDys.isEmpty()) {
            return;
        }
        List<Long> sinsurFileBoIds = calPersonDys.stream().map(calPersonDy -> calPersonDy.getLong("sinsurfilev.boid")).collect(Collectors.toList());
        if (this.checkFileInvalid(sinsurFileBoIds, currentFiles = SocialInsuranceCalHelper.getCurrentFilesBy(sinsurFileBoIds, this.periodEndDate, hisFiles = new ArrayList<DynamicObject>(10)), hisFiles)) {
            return;
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        HashMap calTaskToFileMap = new HashMap(10);
        if (SocialInsuranceCalHelper.checkCertInvalidForView(currentFiles, resultMap)) {
            this.appCache.put("resultMap", resultMap);
            this.appCache.put("isCheckCertFail", (Object)Boolean.TRUE);
            this.failProgress();
            this.releaseLock();
            return;
        }
        this.appCache.put("resultMap", resultMap);
        this.continueProgress();
        if (this.checkSInsurStd(hisFiles)) {
            return;
        }
        calTaskToFileMap.put(this.calTaskId, hisFiles.stream().map(hisFile -> hisFile.getLong("id")).collect(Collectors.toSet()));
        int fileCount = hisFiles.size();
        SocialInsuranceCalHelper.cacheProgressInfoAndOpenFloatingBall((String)this.appCache.get("pageId", String.class), this.cacheUUID, fileCount, this.opKey, 1);
        this.continueProgress();
        int successTaskCount = fileCount < this.calPersonIds.size() ? fileCount : this.calPersonIds.size();
        this.appCache.put("fileCount", (Object)fileCount);
        this.appCache.put("totalTaskCount", (Object)this.calPersonIds.size());
        this.appCache.put("successTaskCount", (Object)successTaskCount);
        this.appCache.put("failTaskCount", (Object)(this.calPersonIds.size() - successTaskCount));
        this.appCache.put("calTaskIdList", Collections.singletonList(this.calTaskId));
        LOGGER.info("SocialInsuranceCalPersonCheckThread.checkData: start to recal person");
        HashMap<String, Object> extendParams = new HashMap<String, Object>(1);
        extendParams.put("calTaskToFileMap", calTaskToFileMap);
        extendParams.put("recordId", this.cacheUUID);
        ICalService calService = SocialInsuranceCalService.calServiceFactory((String)this.appCache.get("pageId", String.class), null, null, "5", new LinkedHashSet<Long>(calTaskToFileMap.keySet()), extendParams);
        if (calService != null) {
            calService.updatePersonAndCal();
        }
        String operateName = MutexServiceHelper.getOperateName((String)"hcsi_calperson", (String)this.opKey);
        SITLogServiceHelper.addLog((String)"hcsi", (String)"hcsi_calperson", (String)operateName, (String)HCSIErrInfoEnum.COMMON_OPERATE_SUCCESSFULLY.getErrInfo(operateName));
    }

    private boolean checkFileInvalid(List<Long> srcFileBoIds, DynamicObject[] currentFiles, List<DynamicObject> hisFiles) {
        if (currentFiles == null || currentFiles.length == 0 || hisFiles == null || hisFiles.isEmpty()) {
            this.msgHelper.addMessage(this.cacheUUID, CalApiResultErrInfoEnum.CAL_PERSON_FILE_STOPPED.getErrInfo());
            this.failProgress();
            this.releaseLock();
            return true;
        }
        if (hisFiles.size() < srcFileBoIds.size()) {
            this.msgHelper.addMessage(this.cacheUUID, CalApiResultErrInfoEnum.CAL_PERSON_FILE_PARTED_STOPPED.getErrInfo(this.calPersonIds.size(), srcFileBoIds.size() - hisFiles.size()));
        }
        this.continueProgress();
        return false;
    }

    private List<DynamicObject> filerAuthedCalPersonDys() {
        List authorizedDataRuleQFilter = SITPermissionServiceHelper.getAuthorizedDataRuleQFilterByOpKey((String)"2AXKDRPJUQ77", (String)"hcsi_calperson", (String)this.opKey);
        QFilter filter = new QFilter("calstatus", "in", (Object)new String[]{"0", "1"});
        filter.and("id", "in", this.calPersonIds);
        if (authorizedDataRuleQFilter == null) {
            filter.and("1", "!=", (Object)1);
        } else {
            authorizedDataRuleQFilter.forEach(arg_0 -> ((QFilter)filter).and(arg_0));
        }
        String selectCalPerson = "id,sinsurfilev.boid";
        Object calPersonDys = SocialInsuranceCalHelper.CAL_PERSON_HELPER.queryOriginalCollection(selectCalPerson, filter.toArray());
        if (calPersonDys == null || calPersonDys.isEmpty()) {
            this.msgHelper.addMessage(this.cacheUUID, CalApiResultErrInfoEnum.CAL_PERSON_HAS_NO_RIGHT.getErrInfo());
            this.failProgress();
            this.releaseLock();
            calPersonDys = Collections.emptyList();
        } else if (calPersonDys.size() < this.calPersonIds.size()) {
            this.msgHelper.addMessage(this.cacheUUID, CalApiResultErrInfoEnum.CAL_PERSON_HAS_EXCLUDE.getErrInfo(this.calPersonIds.size(), this.calPersonIds.size() - calPersonDys.size()));
            this.failProgress();
        }
        this.continueProgress();
        return calPersonDys;
    }

    private boolean checkTaskHaveBeenClosed(DynamicObject calTask) {
        if ("1".equals(calTask.getString("taskstatus"))) {
            String errorMsg = CalApiResultErrInfoEnum.CAL_PERSON_CLOSED.getErrInfo();
            this.msgHelper.addMessage(this.cacheUUID, errorMsg);
            this.failProgress();
            this.releaseLock();
            return true;
        }
        this.continueProgress();
        return false;
    }

    private boolean checkSInsurStd(List<DynamicObject> hisFileList) {
        HashSet<String> errorNameSet;
        Map<Long, PreCalCfgDTO> preCalCfgDTOMap;
        if (!CollectionUtils.isEmpty(hisFileList) && (preCalCfgDTOMap = SocialInsuranceCalHelper.getPreCalCfgDTOMap(hisFileList, this.periodEndDate, errorNameSet = new HashSet<String>(16))).size() == 0) {
            StringBuilder welfarePayerNameBuilder = new StringBuilder();
            for (String errorName : errorNameSet) {
                if (welfarePayerNameBuilder.length() > 0) {
                    welfarePayerNameBuilder.append('\u3001');
                }
                welfarePayerNameBuilder.append(errorName);
            }
            String errMsg = CalApiResultErrInfoEnum.CAL_PERSON_STANDARD_ERROR.getErrInfo(welfarePayerNameBuilder.toString());
            LOGGER.info("SocialInsuranceCalPersonCheckThread.checkSInsurStd: checkStandar fail");
            this.msgHelper.addMessage(this.cacheUUID, errMsg);
            this.failProgress();
            this.releaseLock();
            return true;
        }
        return false;
    }

    private void continueProgress() {
        this.updateProgress(20, 0);
    }

    private void failProgress() {
        this.updateProgress(0, 100);
    }

    private void updateProgress(int addSuccessCount, int addFailCount) {
        int successCount = (Integer)this.appCache.get("successCount", Integer.class) + addSuccessCount;
        int failCount = (Integer)this.appCache.get("failCount", Integer.class) + addFailCount;
        this.appCache.put("successCount", (Object)successCount);
        this.appCache.put("failCount", (Object)failCount);
    }

    private void releaseLock() {
        MutexServiceHelper.release((String)"hcsi_sinsurtask", (String)String.valueOf(this.calTaskId), (String)this.opKey);
    }
}

