/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.business.cal;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.cache.IHRAppCache;
import kd.sit.hcsi.business.cal.SocialInsuranceCalHelper;
import kd.sit.hcsi.business.cal.errInfo.CalApiResultErrInfoEnum;
import kd.sit.hcsi.business.cal.service.ICalService;
import kd.sit.hcsi.business.cal.service.SinSurCalLaunchMsgHelper;
import kd.sit.hcsi.business.cal.service.SocialInsuranceCalService;
import kd.sit.sitbp.business.servicehelper.MutexServiceHelper;
import kd.sit.sitbp.common.entity.social.PreCalCfgDTO;

public class SocialInsuranceUpdateCalCheckThread
implements Runnable {
    private List<Long> calTaskIdList;
    private Set<Long> welfarePayerIdSet;
    private Map<Long, Date> sinsurPeriodEndDateMap;
    private Map<Long, DynamicObject> calTaskMap;
    private IHRAppCache appCache;
    private final String cacheUUID;
    private final SinSurCalLaunchMsgHelper msgHelper = new SinSurCalLaunchMsgHelper();
    private static final Log LOGGER = LogFactory.getLog(SocialInsuranceUpdateCalCheckThread.class);

    public SocialInsuranceUpdateCalCheckThread(String cacheUUID, List<Long> calTaskIdList) {
        this.calTaskIdList = calTaskIdList;
        this.cacheUUID = cacheUUID;
        this.appCache = HRAppCache.get((String)("socialCalParam_" + cacheUUID));
        HRBaseServiceHelper taskHelper = new HRBaseServiceHelper("hcsi_sinsurtask");
        QFilter filter = new QFilter("id", "in", calTaskIdList);
        DynamicObject[] tasks = taskHelper.queryOriginalArray("id,number,welfarepayer.id,welfarepayer.name,sinsurperiod.id,sinsurperiod.name,sinsurperiod.enddate,taskstatus", new QFilter[]{filter});
        this.welfarePayerIdSet = new HashSet<Long>(tasks.length);
        this.calTaskMap = new HashMap<Long, DynamicObject>(tasks.length);
        this.sinsurPeriodEndDateMap = new HashMap<Long, Date>(tasks.length);
        for (DynamicObject task : tasks) {
            this.welfarePayerIdSet.add(task.getLong("welfarepayer.id"));
            this.calTaskMap.put(task.getLong("id"), task);
            this.sinsurPeriodEndDateMap.put(task.getLong("sinsurperiod.id"), SocialInsuranceCalHelper.getDayDate(task.getDate("sinsurperiod.enddate")));
        }
    }

    @Override
    public void run() {
        LOGGER.info("start to check update cal");
        HashBasedTable currentFileTable = HashBasedTable.create();
        HashBasedTable hisFileTable = HashBasedTable.create();
        boolean isDependonOnTheoryPayer = SocialInsuranceCalHelper.isDependonOnTheoryPayer();
        String welfarePayerIdKey = isDependonOnTheoryPayer ? "welfarepayertheory.id" : "welfarepayer.id";
        for (Map.Entry<Long, Date> entry : this.sinsurPeriodEndDateMap.entrySet()) {
            Long sinsurPeriodId = entry.getKey();
            ArrayList<DynamicObject> allHisFileList = new ArrayList<DynamicObject>(10);
            DynamicObject[] currentFiles = SocialInsuranceCalHelper.getCurrentFiles(entry.getValue(), this.welfarePayerIdSet, allHisFileList, "2");
            this.collectSInsurFiles((Table<Long, Long, List<DynamicObject>>)currentFileTable, welfarePayerIdKey, sinsurPeriodId, currentFiles);
            this.collectSInsurFiles((Table<Long, Long, List<DynamicObject>>)hisFileTable, welfarePayerIdKey, sinsurPeriodId, allHisFileList.toArray(new DynamicObject[0]));
        }
        HashSet<Long> needDeleteTaskSet = new HashSet<Long>(this.calTaskIdList.size());
        Map<Long, Set<Long>> auditFileIdSetMap = this.collectAuditFileIdSetMap(needDeleteTaskSet);
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        ArrayList<Long> successTaskIdList = new ArrayList<Long>(this.calTaskIdList.size());
        ArrayList<Long> failTaskIdList = new ArrayList<Long>(this.calTaskIdList.size());
        HashMap calTaskToFileMap = new HashMap(this.calTaskIdList.size());
        int fileCount = 0;
        for (int index = 0; index < this.calTaskIdList.size(); ++index) {
            int addFailCount;
            int addSuccessCount;
            DynamicObject calTask;
            Long calTaskId = this.calTaskIdList.get(index);
            if (this.checkTaskHaveBeenClosed(successTaskIdList, failTaskIdList, fileCount, index, calTaskId, calTask = this.calTaskMap.get(calTaskId), addSuccessCount = 0, addFailCount = 1)) continue;
            Long sinsurPeriodId = calTask.getLong("sinsurperiod.id");
            Long welfarePayerId = calTask.getLong("welfarepayer.id");
            String sinsurPeriodName = calTask.getString("sinsurperiod.name");
            String welfarePayerName = calTask.getString("welfarepayer.name");
            List<DynamicObject> currentFileList = (List<DynamicObject>)currentFileTable.get((Object)sinsurPeriodId, (Object)welfarePayerId);
            List<DynamicObject> hisFileList = (List<DynamicObject>)hisFileTable.get((Object)sinsurPeriodId, (Object)welfarePayerId);
            Set fileIdSet = auditFileIdSetMap.getOrDefault(calTaskId, new HashSet(0));
            if (!CollectionUtils.isEmpty((Collection)currentFileList)) {
                currentFileList = currentFileList.stream().filter(file -> !fileIdSet.contains(file.getLong("id"))).collect(Collectors.toList());
            }
            if (!CollectionUtils.isEmpty((Collection)hisFileList)) {
                hisFileList = hisFileList.stream().filter(file -> !fileIdSet.contains(file.getLong("boid"))).collect(Collectors.toList());
            }
            if (CollectionUtils.isEmpty((Collection)hisFileList)) {
                if (!needDeleteTaskSet.contains(calTaskId)) {
                    String errMsg = CalApiResultErrInfoEnum.NOT_EXISTS_FILE_FOR_TASK.getErrInfo(calTask.getString("number"), welfarePayerName, sinsurPeriodName);
                    this.msgHelper.addMessage(this.cacheUUID, errMsg);
                    failTaskIdList.add(calTaskId);
                    if (index == this.calTaskIdList.size() - 1 && !CollectionUtils.isEmpty(successTaskIdList)) {
                        SocialInsuranceCalHelper.cacheProgressInfoAndOpenFloatingBall((String)this.appCache.get("pageId", String.class), this.cacheUUID, fileCount, "donothing_updatecal", successTaskIdList.size());
                    }
                    this.updateProgress(addSuccessCount, addFailCount);
                    continue;
                }
                currentFileList = new ArrayList(0);
                hisFileList = new ArrayList(0);
            }
            if (SocialInsuranceCalHelper.checkCertInvalidForView(currentFileList.toArray(new DynamicObject[currentFileList.size()]), resultMap)) {
                this.appCache.put("resultMap", resultMap);
                this.appCache.put("isCheckCertFail", (Object)Boolean.TRUE);
                this.releaseLock(this.calTaskIdList);
                return;
            }
            this.appCache.put("resultMap", resultMap);
            if (this.checkSInsurStd(successTaskIdList, failTaskIdList, fileCount, index, calTaskId, calTask, addSuccessCount, addFailCount, sinsurPeriodId, sinsurPeriodName, hisFileList)) continue;
            calTaskToFileMap.put(calTaskId, hisFileList.stream().map(hisFile -> hisFile.getLong("id")).collect(Collectors.toSet()));
            successTaskIdList.add(calTaskId);
            fileCount += hisFileList.size();
            if (index == this.calTaskIdList.size() - 1 && !CollectionUtils.isEmpty(successTaskIdList)) {
                SocialInsuranceCalHelper.cacheProgressInfoAndOpenFloatingBall((String)this.appCache.get("pageId", String.class), this.cacheUUID, fileCount, "donothing_updatecal", successTaskIdList.size());
            }
            this.updateProgress(++addSuccessCount, --addFailCount);
        }
        if (!CollectionUtils.isEmpty(failTaskIdList)) {
            this.releaseLock(failTaskIdList);
        }
        this.appCache.put("calType", (Object)"4");
        this.appCache.put("fileCount", (Object)fileCount);
        this.appCache.put("totalTaskCount", (Object)this.calTaskIdList.size());
        this.appCache.put("successTaskCount", (Object)successTaskIdList.size());
        this.appCache.put("failTaskCount", (Object)(this.calTaskIdList.size() - successTaskIdList.size()));
        if (!CollectionUtils.isEmpty(successTaskIdList)) {
            this.appCache.put("calTaskIdList", successTaskIdList);
        }
        LOGGER.info("end to check update cal");
        if (CollectionUtils.isEmpty(successTaskIdList)) {
            return;
        }
        LOGGER.info("start to update cal");
        HashMap<String, Object> extendParams = new HashMap<String, Object>(1);
        extendParams.put("calTaskToFileMap", calTaskToFileMap);
        extendParams.put("recordId", this.cacheUUID);
        ICalService calService = SocialInsuranceCalService.calServiceFactory((String)this.appCache.get("pageId", String.class), null, null, "4", new LinkedHashSet<Long>(calTaskToFileMap.keySet()), extendParams);
        if (calService != null) {
            calService.updatePersonAndCal();
        }
    }

    private void collectSInsurFiles(Table<Long, Long, List<DynamicObject>> sInsurFileTable, String welfarePayerIdKey, Long sinsurPeriodId, DynamicObject[] sInsurFiles) {
        if (sInsurFiles == null || sInsurFiles.length == 0) {
            return;
        }
        for (DynamicObject sInsurFile : sInsurFiles) {
            Long welfarePayerId = sInsurFile.getLong(welfarePayerIdKey);
            ArrayList<DynamicObject> tmpFileList = (ArrayList<DynamicObject>)sInsurFileTable.get((Object)sinsurPeriodId, (Object)welfarePayerId);
            if (tmpFileList == null) {
                tmpFileList = new ArrayList<DynamicObject>(10);
                sInsurFileTable.put((Object)sinsurPeriodId, (Object)welfarePayerId, tmpFileList);
            }
            tmpFileList.add(sInsurFile);
        }
    }

    private boolean checkTaskHaveBeenClosed(List<Long> successTaskIdList, List<Long> failTaskIdList, int fileCount, int index, Long calTaskId, DynamicObject calTask, int addSuccessCount, int addFailCount) {
        if ("1".equals(calTask.getString("taskstatus"))) {
            String errorMsg = CalApiResultErrInfoEnum.CAL_TASK_CLOSED.getErrInfo(calTask.getString("number"));
            this.msgHelper.addMessage(this.cacheUUID, errorMsg);
            failTaskIdList.add(calTaskId);
            if (index == this.calTaskIdList.size() - 1 && !CollectionUtils.isEmpty(successTaskIdList)) {
                SocialInsuranceCalHelper.cacheProgressInfoAndOpenFloatingBall((String)this.appCache.get("pageId", String.class), this.cacheUUID, fileCount, "donothing_updatecal", successTaskIdList.size());
            }
            this.updateProgress(addSuccessCount, addFailCount);
            return true;
        }
        return false;
    }

    private boolean checkSInsurStd(List<Long> successTaskIdList, List<Long> failTaskIdList, int fileCount, int index, Long calTaskId, DynamicObject calTask, int addSuccessCount, int addFailCount, Long sinsurPeriodId, String sinsurPeriodName, List<DynamicObject> hisFileList) {
        if (!CollectionUtils.isEmpty(hisFileList)) {
            HashSet<String> errorNameSet = new HashSet<String>(16);
            Date endDate = this.sinsurPeriodEndDateMap.get(sinsurPeriodId);
            Map<Long, PreCalCfgDTO> preCalCfgDTOMap = SocialInsuranceCalHelper.getPreCalCfgDTOMap(hisFileList, endDate, errorNameSet);
            if (preCalCfgDTOMap.size() == 0) {
                StringBuilder welfarePayerNameBuilder = new StringBuilder();
                for (String errorName : errorNameSet) {
                    if (welfarePayerNameBuilder.length() > 0) {
                        welfarePayerNameBuilder.append('\u3001');
                    }
                    welfarePayerNameBuilder.append(errorName);
                }
                String errMsg = CalApiResultErrInfoEnum.NOT_EXISTS_STANDARD_FOR_TASK.getErrInfo(calTask.getString("number"), welfarePayerNameBuilder.toString(), sinsurPeriodName);
                LOGGER.info("checkStandar fail");
                this.msgHelper.addMessage(this.cacheUUID, errMsg);
                this.updateProgress(addSuccessCount, addFailCount);
                failTaskIdList.add(calTaskId);
                if (index == this.calTaskIdList.size() - 1 && !CollectionUtils.isEmpty(successTaskIdList)) {
                    SocialInsuranceCalHelper.cacheProgressInfoAndOpenFloatingBall((String)this.appCache.get("pageId", String.class), this.cacheUUID, fileCount, "donothing_updatecal", successTaskIdList.size());
                }
                return true;
            }
        }
        return false;
    }

    private void updateProgress(int addSuccessCount, int addFailCount) {
        int successCount = (Integer)this.appCache.get("successCount", Integer.class) + addSuccessCount;
        int failCount = (Integer)this.appCache.get("failCount", Integer.class) + addFailCount;
        this.appCache.put("successCount", (Object)successCount);
        this.appCache.put("failCount", (Object)failCount);
    }

    private Map<Long, Set<Long>> collectAuditFileIdSetMap(Set<Long> needDeleteTaskSet) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hcsi_calperson");
        QFilter filter = new QFilter("sinsurtask.id", "in", this.calTaskIdList);
        DynamicObjectCollection calPersons = helper.queryOriginalCollection("sinsurtask.id,sinsurfilev.boid,calstatus", new QFilter[]{filter});
        if (CollectionUtils.isEmpty((Collection)calPersons)) {
            return new HashMap<Long, Set<Long>>(0);
        }
        HashMap<Long, Set<Long>> auditFileIdSetMap = new HashMap<Long, Set<Long>>(this.calTaskIdList.size());
        for (DynamicObject calPerson : calPersons) {
            if ("2".equals(calPerson.getString("calstatus"))) {
                Set fileIdSet = auditFileIdSetMap.computeIfAbsent(calPerson.getLong("sinsurtask.id"), key -> new HashSet(16));
                fileIdSet.add(calPerson.getLong("sinsurfilev.boid"));
                continue;
            }
            needDeleteTaskSet.add(calPerson.getLong("sinsurtask.id"));
        }
        return auditFileIdSetMap;
    }

    private void releaseLock(Collection<Long> taskIdSet) {
        taskIdSet.forEach(taskId -> MutexServiceHelper.release((String)"hcsi_sinsurtask", (String)String.valueOf(taskId), (String)"donothing_updatecal"));
    }
}

