/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.business.cal;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.sit.hcsi.business.cal.SocialTaskAuditOrUnauditThread;
import kd.sit.sitbp.business.threadpool.SITThreadPoolFactory;
import kd.sit.sitbp.common.util.SITListUtil;

public class SocialTaskAuditOrUnauditService {
    private static final Log logger = LogFactory.getLog(SocialTaskAuditOrUnauditService.class);
    private String recordId;
    private String opKey;
    private static final int batchSize = 500;
    private List<DynamicObject> detailDys;
    private Map<String, List<String>> failFileNumbers;
    private static final String KEY_SOCIAL_TASK_AUDIT_PROGRESS = "SocialTaskAuditProgress_%s";

    public SocialTaskAuditOrUnauditService(List<DynamicObject> detailDys, String recordId, String opKey) {
        this.detailDys = detailDys;
        this.recordId = recordId;
        this.opKey = opKey;
        this.failFileNumbers = Maps.newHashMapWithExpectedSize((int)16);
    }

    public Map<String, List<String>> auditOrUnauditDetailByMultiThread() {
        List detailDysSplits = SITListUtil.split(this.detailDys, (int)500);
        CountDownLatch countDownLatch = new CountDownLatch(detailDysSplits.size());
        RequestContext requestContext = RequestContext.get();
        Object lock = new Object();
        detailDysSplits.forEach(detailSplit -> {
            SocialTaskAuditOrUnauditThread socialTaskAuditOrUnauditThread = new SocialTaskAuditOrUnauditThread(requestContext, countDownLatch, (List<DynamicObject>)detailSplit, this.recordId, this.opKey, this.failFileNumbers, lock);
            SITThreadPoolFactory.getSocialCalThreadPool().execute((Runnable)socialTaskAuditOrUnauditThread);
        });
        try {
            boolean success = countDownLatch.await(5 * detailDysSplits.size(), TimeUnit.SECONDS);
            logger.info("SocialTaskAuditOrUnauditService.auditOrUnauditDetailByMultiThread, opKey is {}, result is {}", (Object)this.opKey, (Object)success);
        }
        catch (InterruptedException e) {
            logger.error("Details audit error:", (Object)this.opKey, (Object)e);
        }
        return this.failFileNumbers;
    }
}

