/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.business.cal;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.sit.hcsi.business.cal.SocialTaskAuditProgressDTO;
import kd.sit.hcsi.business.cal.service.SocialInsuranceCalService;
import kd.sit.sitbp.common.cache.ISITAppCache;
import kd.sit.sitbp.common.cache.SITAppCache;

public class SocialTaskAuditOrUnauditThread
implements Runnable {
    private static final Log logger = LogFactory.getLog(SocialTaskAuditOrUnauditThread.class);
    private RequestContext requestContext;
    private CountDownLatch countDownLatch;
    private List<DynamicObject> detailSplit;
    private String recordId;
    private String opKey;
    private Map<String, List<String>> failFileNumbers;
    private Object lock;
    public static final String KEY_SOCIAL_TASK_AUDIT_PROGRESS = "SocialTaskAuditProgress_%s";

    public SocialTaskAuditOrUnauditThread(RequestContext requestContext, CountDownLatch countDownLatch, List<DynamicObject> detailSplit, String recordId, String opKey, Map<String, List<String>> failFileNumbers, Object lock) {
        this.requestContext = requestContext;
        this.countDownLatch = countDownLatch;
        this.detailSplit = detailSplit;
        this.recordId = recordId;
        this.opKey = opKey;
        this.failFileNumbers = failFileNumbers;
        this.lock = lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            DynamicObjectCollection detailCollection = new DynamicObjectCollection();
            ArrayList batchSuccessFilevIds = Lists.newArrayListWithExpectedSize((int)10);
            HashMap batchFailFileNumbers = Maps.newHashMapWithExpectedSize((int)16);
            SocialInsuranceCalService service = new SocialInsuranceCalService();
            service.addAuditOrUnauditFailListAndSave(this.opKey, this.detailSplit.toArray(new DynamicObject[0]), detailCollection, batchFailFileNumbers, batchSuccessFilevIds);
            Object object = this.lock;
            synchronized (object) {
                int failNum = 0;
                for (Map.Entry entry : batchFailFileNumbers.entrySet()) {
                    List failFileNum = (List)entry.getValue();
                    failNum += failFileNum.size();
                }
                SocialTaskAuditProgressDTO socialTaskAuditProgressDTO = this.getSocialTaskAuditProgressDTO();
                if (socialTaskAuditProgressDTO != null) {
                    socialTaskAuditProgressDTO.setFail(socialTaskAuditProgressDTO.getFail() + failNum);
                    socialTaskAuditProgressDTO.setSuccess(socialTaskAuditProgressDTO.getSuccess() + batchSuccessFilevIds.size());
                    this.writeDTOOnAppCache(socialTaskAuditProgressDTO);
                }
                this.addAllBatchFailFilevIds(batchFailFileNumbers);
            }
        }
        catch (Exception e) {
            logger.error("Social Task Audit/Unaudit Thread Exception:", (Throwable)e);
        }
        finally {
            this.countDownLatch.countDown();
        }
    }

    private SocialTaskAuditProgressDTO getSocialTaskAuditProgressDTO() {
        ISITAppCache appCache = SITAppCache.get((String)this.recordId);
        return (SocialTaskAuditProgressDTO)appCache.get(String.format(Locale.ROOT, KEY_SOCIAL_TASK_AUDIT_PROGRESS, this.recordId), SocialTaskAuditProgressDTO.class);
    }

    private void writeDTOOnAppCache(SocialTaskAuditProgressDTO socialTaskAuditProgressDTO) {
        ISITAppCache appCache = SITAppCache.get((String)this.recordId);
        appCache.put(String.format(Locale.ROOT, KEY_SOCIAL_TASK_AUDIT_PROGRESS, this.recordId), (Object)socialTaskAuditProgressDTO);
    }

    private void addAllBatchFailFilevIds(Map<String, List<String>> batchFailFileNumbers) {
        for (Map.Entry<String, List<String>> entry : batchFailFileNumbers.entrySet()) {
            String key = entry.getKey();
            List<String> value = entry.getValue();
            List<String> list = this.failFileNumbers.get(key);
            if (list == null) {
                this.failFileNumbers.put(key, value);
                continue;
            }
            list.addAll(value);
            this.failFileNumbers.put(key, list);
        }
    }
}

