/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.business.cal.export;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.sdk.sit.hcsi.common.entity.cal.InsuredStandard;
import kd.sit.sitbp.business.helper.listpage.ColumnEntity;
import kd.sit.sitbp.common.enums.SitDataTypeEnum;

public class ExportDetailHelper {
    public static List<ColumnEntity> sortColumns(Map<String, ColumnEntity> columnEntityGroupByListFieldKey, Map<String, Boolean> userListColumnsVisibleMap) {
        ArrayList<ColumnEntity> sortedColumns = new ArrayList<ColumnEntity>(userListColumnsVisibleMap.size());
        ColumnEntity columnEntity = columnEntityGroupByListFieldKey.get("fseq");
        if (columnEntity != null) {
            sortedColumns.add(columnEntity);
            columnEntityGroupByListFieldKey.remove("fseq");
        }
        for (Map.Entry<String, Boolean> entry : userListColumnsVisibleMap.entrySet()) {
            String fieldKey = entry.getKey();
            columnEntity = columnEntityGroupByListFieldKey.remove(fieldKey);
            if (columnEntity == null || !Boolean.TRUE.equals(entry.getValue())) continue;
            sortedColumns.add(columnEntity);
        }
        sortedColumns.addAll(columnEntityGroupByListFieldKey.values());
        return sortedColumns;
    }

    public static Map<String, ColumnEntity> mergeColumnEntity(Map<String, ColumnEntity> columnEntityGroupByListFieldKey, List<InsuredStandard> insuranceItemDtos) {
        Optional.ofNullable(insuranceItemDtos).ifPresent(items -> items.stream().map(ExportDetailHelper::convertDynamicItemToColumnEntity).forEach(columnEntity -> columnEntityGroupByListFieldKey.put(columnEntity.getListFieldKey(), (ColumnEntity)columnEntity)));
        return columnEntityGroupByListFieldKey;
    }

    public static ColumnEntity convertDynamicItemToColumnEntity(InsuredStandard insuredStandard) {
        ColumnEntity columnEntity = new ColumnEntity();
        columnEntity.setListFieldKey(String.valueOf(insuredStandard.getInsuredItemId()));
        columnEntity.setListFieldName(insuredStandard.getInsuredItemName());
        Long dataTypeId = insuredStandard.getDataTypeId();
        columnEntity.setDataType(SitDataTypeEnum.getEnumById((long)dataTypeId).getDataType());
        columnEntity.setDisplayFormatString("0");
        columnEntity.setComboListColumn(Boolean.FALSE);
        columnEntity.setScale(insuredStandard.getScale());
        return columnEntity;
    }
}

