/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.business.cal.export;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.data.BusinessDataReader;
import kd.bos.data.BusinessDataWriter;
import kd.bos.data.ExportLogHelper;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.form.IFormView;
import kd.bos.lang.Lang;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.privacy.PrivacyCenterServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sdk.sit.hcsi.common.entity.cal.InsuredStandard;
import kd.sdk.sit.hcsi.common.entity.cal.InsuredSumItem;
import kd.sit.hcsi.business.cal.SocialInsuranceCalHelper;
import kd.sit.hcsi.business.cal.export.ExportDetailExtServiceHelper;
import kd.sit.hcsi.business.cal.export.ExportDetailHelper;
import kd.sit.hcsi.business.cal.service.DisplaySchemeService;
import kd.sit.hcsi.business.caladjust.errinfo.HCSIErrInfoEnum;
import kd.sit.hcsi.common.enums.SocialOperationEnum;
import kd.sit.hcsi.common.util.ConvertUtils;
import kd.sit.sitbp.business.handler.BaseProcessHandler;
import kd.sit.sitbp.business.helper.excel.ExcelHelper;
import kd.sit.sitbp.business.helper.excel.model.ExportResult;
import kd.sit.sitbp.business.helper.excel.model.HeadCellInfo;
import kd.sit.sitbp.business.helper.excel.model.SheetInfo;
import kd.sit.sitbp.business.helper.excel.model.WorkbookInfo;
import kd.sit.sitbp.business.helper.excel.model.WorkbookInfoGenerator;
import kd.sit.sitbp.business.helper.listpage.ColumnEntity;
import kd.sit.sitbp.business.helper.listpage.ListPageHelper;
import kd.sit.sitbp.business.servicehelper.MutexServiceHelper;
import kd.sit.sitbp.business.servicehelper.SitDataServiceHelper;
import kd.sit.sitbp.common.api.DataBatch;
import kd.sit.sitbp.common.api.DataItem;
import kd.sit.sitbp.common.api.ProcessHandler;
import kd.sit.sitbp.common.constants.SITEntityConstants;
import kd.sit.sitbp.common.enums.SInsuranceInfoEnum;
import kd.sit.sitbp.common.enums.SitDataTypeEnum;
import kd.sit.sitbp.common.util.BaseResult;
import kd.sit.sitbp.common.util.BatchResult;
import kd.sit.sitbp.common.util.GlobalParam;
import kd.sit.sitbp.common.util.SITDateTimeUtils;
import kd.sit.sitbp.common.util.SITStringUtils;
import kd.sit.sitbp.common.util.async.enums.MultiThreadCase;
import kd.sit.sitbp.common.util.async.model.assign.AssignDataBatch;
import kd.sit.sitbp.common.util.async.model.assign.AssignMultiThreadTask;
import org.apache.poi.ss.usermodel.Workbook;

public class SocialDetailDownLoadTask
extends AssignMultiThreadTask<Map<String, Object>>
implements SITEntityConstants {
    private Log logger = LogFactory.getLog(SocialDetailDownLoadTask.class);
    protected static final Pattern PATTERN = Pattern.compile("[^(0-9)]");
    protected WorkbookInfo workbookInfo;
    protected Map<String, List<String>> propMap;
    protected Set<String> ignoreProp;
    protected Map<String, IDataEntityProperty> desensitizeMap;
    protected Map<String, Map<String, String>> combMapMap;
    protected ExportResult exportResult;
    private List<Long> socialTaskIds;
    protected Object exportLogId;
    private Map<String, Map<String, Object>> sumValueMap = new HashMap<String, Map<String, Object>>(16);
    protected IFormView view;
    private Map<String, DynamicObject> socialTaskMap;
    private Map<String, List<InsuredStandard>> insuredItemGroupByTask;
    private Map<String, Set<String>> sumFieldsMap = new HashMap<String, Set<String>>(16);
    protected String selectProperties = "";
    protected Map<Long, Map<String, Object>> taskDisplaySchInfoMap = new HashMap<Long, Map<String, Object>>(16);
    private Map<String, Long> socialTaskDisSchRelMap;
    protected List<ColumnEntity> columnEntities;

    public SocialDetailDownLoadTask(List<Long> socialTaskIds, IFormView view) {
        this.socialTaskIds = socialTaskIds;
        this.view = view;
        this.setHandleCase(MultiThreadCase.BY_ACTION);
    }

    public SocialDetailDownLoadTask(List<Long> socialTaskIds, IFormView view, Map<String, Long> socialTaskDisSchRelMap) {
        this.socialTaskIds = socialTaskIds;
        this.view = view;
        if (socialTaskDisSchRelMap == null) {
            socialTaskDisSchRelMap = new HashMap<String, Long>(0);
        }
        this.socialTaskDisSchRelMap = socialTaskDisSchRelMap;
        this.setHandleCase(MultiThreadCase.BY_ACTION);
    }

    protected ProcessHandler openProcessHandler() {
        this.processHandler = new BaseProcessHandler();
        HashMap<String, Object> cond = new HashMap<String, Object>(2);
        HashMap fieldVal = new HashMap(2);
        cond.put("fieldVal", fieldVal);
        cond.put("callback", "downloadClose");
        HashMap<String, String> labelVal = new HashMap<String, String>(2);
        cond.put("labelVal", labelVal);
        labelVal.put("title", ResManager.loadKDString((String)"\u6b63\u5728\u5bfc\u51fa\u793e\u4fdd\u660e\u7ec6\uff0c\u5b8c\u6210\u540e\u5c06\u81ea\u52a8\u4e0b\u8f7d", (String)"SocialDetailDownLoadTask_1", (String)"sit-hcsi-business", (Object[])new Object[0]));
        this.processHandler.open(this.view, HCSIErrInfoEnum.COMMON_EXPORT_PROGRESS_TITLE.getErrInfo(), cond);
        return this.processHandler;
    }

    protected BaseResult<?> beforePrepareDataBatch() {
        this.exportResult = new ExportResult(Integer.valueOf(0));
        HashMap<Long, Map<String, Object>> taskSchInfoMap = new HashMap<Long, Map<String, Object>>(this.socialTaskIds.size());
        Map<Long, List<InsuredStandard>> tmpInsuredItemGroupByTask = this.getTaskAndInsuanceItemGroupByTask(taskSchInfoMap);
        Map userListColumnsVisibleMap = ListPageHelper.getUserListColumnsVisibleMap((String)"hcsi_calperson", (boolean)false);
        this.columnEntities = ListPageHelper.getColumnEntitiesOf((String)"hcsi_calperson");
        Map columnEntityGroupByListFieldKey = this.columnEntities.stream().collect(Collectors.toMap(ColumnEntity::getListFieldKey, columnEntity -> columnEntity, (oldVal, newVal) -> oldVal, LinkedHashMap::new));
        List selectPropertyList = this.columnEntities.stream().map(ColumnEntity::getListFieldKey).filter(listFieldKey -> !"fseq".equals(listFieldKey)).collect(Collectors.toList());
        if (selectPropertyList.size() > 0) {
            this.selectProperties = String.join((CharSequence)",", selectPropertyList) + ",";
        }
        this.logger.info("taskSchInfoMap size is {}", (Object)taskSchInfoMap.size());
        this.insuredItemGroupByTask = new LinkedHashMap<String, List<InsuredStandard>>(tmpInsuredItemGroupByTask.size());
        Map displaySchInfoMap = null;
        List<ColumnEntity> columnEntityList = null;
        HashMap<String, List<ColumnEntity>> sortedColumnEntitiesGroupByTask = new HashMap<String, List<ColumnEntity>>(tmpInsuredItemGroupByTask.size());
        for (Map.Entry<Long, List<InsuredStandard>> entry : tmpInsuredItemGroupByTask.entrySet()) {
            this.logger.info("before visible filter, item size is {}", (Object)entry.getValue().size());
            displaySchInfoMap = (Map)taskSchInfoMap.get(entry.getKey());
            if (displaySchInfoMap != null) {
                this.logger.info("task use displayschema,taskId = {}", (Object)entry.getKey());
                this.insuredItemGroupByTask.put(String.valueOf(entry.getKey()), entry.getValue());
                columnEntityList = this.getDisplaySchColumnList(displaySchInfoMap, columnEntityGroupByListFieldKey, entry);
                sortedColumnEntitiesGroupByTask.put(String.valueOf(entry.getKey()), columnEntityList);
            } else {
                entry.getValue().removeIf(insuredStandard -> Boolean.FALSE.equals(userListColumnsVisibleMap.get(String.valueOf(insuredStandard.getInsuredItemId()))));
                this.logger.info("after visible filter, item size is {}", (Object)entry.getValue().size());
                this.insuredItemGroupByTask.put(String.valueOf(entry.getKey()), entry.getValue());
                Map<String, ColumnEntity> currColumnEntityGroupByListFieldKey = ExportDetailHelper.mergeColumnEntity(new LinkedHashMap<String, ColumnEntity>(columnEntityGroupByListFieldKey), entry.getValue());
                List<ColumnEntity> sortedColumnEntities = ExportDetailExtServiceHelper.sortColumns(currColumnEntityGroupByListFieldKey, new LinkedHashMap<String, Boolean>(userListColumnsVisibleMap));
                sortedColumnEntitiesGroupByTask.put(String.valueOf(entry.getKey()), sortedColumnEntities);
            }
            Set fields = entry.getValue().stream().filter(insuredStandard -> insuredStandard.getDataTypeId() != null && SitDataTypeEnum.AMOUNT.getId() == insuredStandard.getDataTypeId().longValue()).map(insuredStandard -> String.valueOf(insuredStandard.getInsuredItemId())).collect(Collectors.toSet());
            this.logger.info("after type filter, item size is {}", (Object)entry.getValue().size());
            this.sumFieldsMap.put(String.valueOf(entry.getKey()), fields);
        }
        String date = SITDateTimeUtils.format((Date)new Date(), (String)"MM/dd HH:mm:ss");
        date = PATTERN.matcher(date).replaceAll("").trim();
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        params.put("fileName", HCSIErrInfoEnum.CAL_PERSON_EXPORT_FILE_NAME.getErrInfo(date));
        params.put("socialTaskMap", this.socialTaskMap);
        params.put("socialTaskItemMap", sortedColumnEntitiesGroupByTask);
        this.workbookInfo = WorkbookInfoGenerator.generateWith((String)"socialDetailExport", params);
        this.propMap = this.workbookInfo != null ? this.workbookInfo.getSheetInfoList().stream().collect(Collectors.toMap(SheetInfo::getDataKey, sheetInfo -> sheetInfo.getHeadCellBar().getContentHeadCellInfoList().stream().map(HeadCellInfo::getValueProp).collect(Collectors.toList()))) : null;
        this.desensitizeMap = SitDataServiceHelper.generateDesensitizeMap((EntityType)EntityMetadataCache.getDataEntityType((String)"hcsi_calperson"), selectPropertyList);
        this.ignoreProp = Sets.newHashSet((Object[])new String[]{"fseq"});
        List props = this.columnEntities.stream().filter(ColumnEntity::getComboListColumn).map(ColumnEntity::getListFieldKey).collect(Collectors.toList());
        this.combMapMap = SitDataServiceHelper.resolveCombAndBooleanValues((String)"hcsi_calperson", props, (boolean)true);
        this.combMapMap.put("sinsurfilev.isescrowstaff", this.getBooleanValue());
        Map<String, String> sinsurstatusMap = this.combMapMap.get("sinsurstatus");
        this.combMapMap.put("sinsurfilev.sinsurstatus", sinsurstatusMap);
        this.exportLogId = ExportLogHelper.create((Object)"", (String)"hcsi_calperson", (int)this.getTotalSize(), (String)"1");
        return BaseResult.success(null);
    }

    private Map<String, String> getBooleanValue() {
        HashMap<String, String> valueMap = new HashMap<String, String>(2);
        valueMap.put(Boolean.FALSE.toString(), SInsuranceInfoEnum.COMMON_NO.getErrInfo());
        valueMap.put(Boolean.TRUE.toString(), SInsuranceInfoEnum.COMMON_YES.getErrInfo());
        return valueMap;
    }

    protected List<Map<String, Object>> queryData(String key, List<?> ids) {
        DynamicObject[] detailArrays;
        long beginTime = System.currentTimeMillis();
        HRBaseServiceHelper socialDetailHelper = new HRBaseServiceHelper("hcsi_calperson");
        QFilter filter = new QFilter("id", "in", ids);
        ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>(ids.size());
        Map<String, Object> displaySchInfoMap = this.taskDisplaySchInfoMap.get(Long.valueOf(key));
        String fields = null;
        String orderBy = "sinsurfilev.number asc";
        List<InsuredSumItem> sumItemList = null;
        if (displaySchInfoMap == null) {
            fields = this.selectProperties;
            sumItemList = SocialInsuranceCalHelper.assembleSumItemList();
        } else {
            String schOrder = (String)displaySchInfoMap.get("orderBy");
            if (SITStringUtils.isNotEmpty((String)schOrder)) {
                orderBy = schOrder;
            }
            fields = (String)displaySchInfoMap.get("selectProperties");
            Set sumItemIdSet = (Set)displaySchInfoMap.get("sumItemIdSet");
            QFilter sumItemFilter = new QFilter("id", "in", (Object)sumItemIdSet);
            sumItemList = SocialInsuranceCalHelper.getSumItemList(sumItemFilter);
        }
        for (DynamicObject detail : detailArrays = socialDetailHelper.query(fields + "id,insuranceitem.id,numvalue,amountvalue,isnull,currency.id,storagetype", new QFilter[]{filter}, orderBy)) {
            dataList.add(this.packageData(sumItemList, key, detail));
        }
        this.calSumValue(key, dataList);
        this.logger.info(" queryData key is {}, cost time : {}", (Object)key, (Object)(System.currentTimeMillis() - beginTime));
        return dataList;
    }

    protected BatchResult<Map<String, Object>> handleData(DataBatch<Map<String, Object>> dataBatch) {
        List dataList = dataBatch.getDataList();
        try {
            int startIndex = dataBatch.getStartIndex();
            for (int i = 0; i < dataList.size(); ++i) {
                ((Map)dataList.get(i)).put("fseq", startIndex + i + 1);
            }
            ExcelHelper.writeData((WorkbookInfo)this.workbookInfo, dataBatch, (ExportResult)this.exportResult);
        }
        catch (Exception e) {
            this.exportResult.addMessage(e.getMessage());
            return new BatchResult(false, dataList);
        }
        return new BatchResult(true, Collections.emptyList());
    }

    protected BaseResult<Map<String, Object>> afterHandleDataBatch(int status) {
        HashMap<String, String> cond = new HashMap<String, String>(2);
        if (status == 0 && this.workbookInfo.getWorkbook() != null) {
            this.writeSumData();
            String billFormId = ((IListView)this.view).getBillFormId();
            String url = ExcelHelper.storeFileAndGetSafeURL((String)this.view.getFormShowParameter().getAppId(), (String)billFormId, (Workbook)this.workbookInfo.getWorkbook(), (String)this.workbookInfo.fullName());
            cond.put("url", url);
            this.exportLog(this.getTotalSize(), url, this.exportResult.generateMessage(255));
        } else {
            this.exportLog(0, "", this.exportResult.generateMessage(255));
            this.closeTask();
        }
        this.releaseSocialTaskMutexLock();
        this.processHandler.close(cond);
        GlobalParam.remove();
        return BaseResult.success(null);
    }

    protected void appendLog(String msg) {
        this.logger.info(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void calSumValue(String key, List<Map<String, Object>> dataList) {
        Object value;
        String itemIdStr;
        HashMap<String, Object> batchSumValueMap = new HashMap<String, Object>(16);
        Set<String> fields = this.sumFieldsMap.get(key);
        for (Map<String, Object> data : dataList) {
            for (Map.Entry<String, Object> entry : data.entrySet()) {
                itemIdStr = entry.getKey();
                if (!fields.contains(itemIdStr) || (value = entry.getValue()) == null) continue;
                this.addValueToMap(batchSumValueMap, itemIdStr, value);
            }
        }
        Object object = this;
        synchronized (object) {
            Map sumData = this.sumValueMap.computeIfAbsent(key, taskId -> new HashMap(16));
            for (Map.Entry<String, Object> entry : batchSumValueMap.entrySet()) {
                itemIdStr = entry.getKey();
                value = entry.getValue();
                this.addValueToMap(sumData, itemIdStr, value);
            }
        }
    }

    private void addValueToMap(Map<String, Object> batchSumValueMap, String key, Object value) {
        Object oldValue = batchSumValueMap.get(key);
        BigDecimal itemValue = new BigDecimal(String.valueOf(value));
        if (oldValue != null) {
            batchSumValueMap.put(key, new BigDecimal(String.valueOf(oldValue)).add(itemValue));
        } else {
            batchSumValueMap.put(key, itemValue);
        }
    }

    private void writeSumData() {
        for (Map.Entry<String, Map<String, Object>> entry : this.sumValueMap.entrySet()) {
            String key = entry.getKey();
            Map<String, Object> value = entry.getValue();
            DataItem dataItem = (DataItem)this.dataItemMap.get(key);
            long num = dataItem.handleNum();
            AssignDataBatch dataBatch = new AssignDataBatch(key, 0, Integer.parseInt(String.valueOf(num)));
            value.put("fseq", ResManager.loadKDString((String)"\u5408\u8ba1", (String)"SocialDetailDownLoadTask_3", (String)"sit-hcsi-business", (Object[])new Object[0]));
            ArrayList<Map<String, Object>> sumData = new ArrayList<Map<String, Object>>();
            sumData.add(value);
            dataBatch.setDataList(sumData);
            ExcelHelper.writeData((WorkbookInfo)this.workbookInfo, (DataBatch)dataBatch, (ExportResult)this.exportResult);
        }
    }

    private Map<String, Object> packageData(List<InsuredSumItem> sumItemList, String key, DynamicObject detail) {
        HashMap<String, Object> cond = new HashMap<String, Object>(16);
        if (this.propMap == null) {
            return cond;
        }
        List<String> propList = this.getCurTaskPropList(key);
        if (propList == null) {
            return cond;
        }
        List<InsuredStandard> insuredStandards = this.getCurTaskInsuredStandards(key);
        Set insuranceItemIds = insuredStandards.stream().map(insuredStandard -> String.valueOf(insuredStandard.getInsuredItemId())).collect(Collectors.toSet());
        for (String prop : propList) {
            if (this.ignoreProp.contains(prop) || insuranceItemIds.contains(prop)) continue;
            IDataEntityProperty property = this.desensitizeMap.get(prop);
            if (property != null) {
                Object desensitizeValue = PrivacyCenterServiceHelper.getDesensitizeValue((IDataEntityProperty)property, (String)Lang.get().toString(), (String)"EXPORT", (DynamicObject)detail, (Object)detail.get(prop));
                cond.put(prop, desensitizeValue);
                continue;
            }
            Object value = detail.get(prop);
            Map<String, String> combMap = this.combMapMap.get(prop);
            if (combMap != null) {
                value = combMap.get(String.valueOf(value));
            }
            value = ConvertUtils.convertBigDecimalZero((Object)value);
            cond.put(prop, value);
        }
        DynamicObjectCollection resultCol = detail.getDynamicObjectCollection("entryentity");
        for (DynamicObject itemResult : resultCol) {
            String insuranceItemId = itemResult.getString("insuranceitem.id");
            if (!insuranceItemIds.contains(insuranceItemId) || itemResult.getBoolean("isnull")) continue;
            String storageType = itemResult.getString("storagetype");
            Object value = "number".equals(storageType) ? itemResult.get("numvalue") : itemResult.get("amountvalue");
            value = ConvertUtils.convertBigDecimalZero((Object)value);
            cond.put(String.valueOf(insuranceItemId), value);
        }
        SocialInsuranceCalHelper.assembleSumItemData(sumItemList, cond, null, resultCol, "2");
        return cond;
    }

    protected List<String> getCurTaskPropList(String key) {
        return this.propMap.get(key);
    }

    protected List<InsuredStandard> getCurTaskInsuredStandards(String key) {
        return this.insuredItemGroupByTask.getOrDefault(key, new ArrayList(10));
    }

    private void exportLog(int complete, String url, String data) {
        MainEntityType objType = EntityMetadataCache.getDataEntityType((String)"bos_exportlog");
        DynamicObject dyn = BusinessDataReader.loadSingle((Object)this.exportLogId, (DynamicObjectType)objType);
        List successResult = this.finalResult.getSuccessResult();
        dyn.set("total", (Object)(successResult.size() + this.finalResult.getFailResultOriginal().size()));
        dyn.set("complete", (Object)successResult.size());
        dyn.set("downloadurl", (Object)url);
        dyn.set("logs", (Object)data);
        dyn.set("exportstatus", (Object)"1");
        dyn.set("finishtime", (Object)new Date());
        BusinessDataWriter.save((IDataEntityType)objType, (Object[])new Object[]{dyn});
    }

    private Map<Long, List<InsuredStandard>> getTaskAndInsuanceItemGroupByTask(Map<Long, Map<String, Object>> taskSchInfoMap) {
        HashMap<Long, List<InsuredStandard>> taskMap = new HashMap<Long, List<InsuredStandard>>(this.socialTaskIds.size());
        if (this.socialTaskMap == null) {
            this.socialTaskMap = new LinkedHashMap<String, DynamicObject>(16);
        }
        if (this.socialTaskDisSchRelMap == null) {
            this.socialTaskDisSchRelMap = new HashMap<String, Long>(0);
        }
        ArrayList<Long> noSchTaskIdList = new ArrayList<Long>(this.socialTaskIds.size());
        for (Long taskId : this.socialTaskIds) {
            Long displaySchId = this.socialTaskDisSchRelMap.get(taskId.toString());
            if (displaySchId == null) {
                noSchTaskIdList.add(taskId);
                continue;
            }
            Map<String, Object> resultMap = DisplaySchemeService.getDisplaySchemaDataById(displaySchId, null);
            this.dealDisplaySchemaData(taskMap, resultMap, taskId, taskSchInfoMap);
        }
        if (noSchTaskIdList.size() > 0) {
            taskMap.putAll(SocialInsuranceCalHelper.getInsuranceItemAndCombinedItemInfoGroupByTasks(noSchTaskIdList, true));
        }
        List<DynamicObject> tasks = this.getTask(this.socialTaskIds);
        Map tempTaskMap = tasks.stream().collect(Collectors.toMap(task -> task.getString("id"), task -> task, (oldVal, newVal) -> oldVal, LinkedHashMap::new));
        this.socialTaskMap.putAll(tempTaskMap);
        return taskMap;
    }

    private void dealDisplaySchemaData(Map<Long, List<InsuredStandard>> taskMap, Map<String, Object> resultMap, Long taskId, Map<Long, Map<String, Object>> taskSchInfoMap) {
        ArrayList itemList = new ArrayList(10);
        List insuranceItemList = (List)resultMap.remove("insuranceItemList");
        List sumItemList = (List)resultMap.remove("sumItemList");
        itemList.addAll(insuranceItemList);
        itemList.addAll(sumItemList);
        taskMap.put(taskId, itemList);
        resultMap.remove("freezeColSet");
        taskSchInfoMap.put(taskId, resultMap);
    }

    private List<DynamicObject> getTask(List<Long> socialTaskIds) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hcsi_sinsurtask");
        DynamicObject[] taskDys = helper.query("id,mulsinsurstd,mulsinsurstdcfg,number", new QFilter("id", "in", socialTaskIds).toArray(), "number desc");
        if (taskDys == null || taskDys.length == 0) {
            return Collections.emptyList();
        }
        return Arrays.asList(taskDys);
    }

    private Map<Long, List<Long>> getStandardGroupByTask(List<DynamicObject> taskDys) {
        LinkedHashMap<Long, List<Long>> standardGroupByTask = new LinkedHashMap<Long, List<Long>>(taskDys.size());
        for (DynamicObject taskDy : taskDys) {
            DynamicObjectCollection standardDysInTask = taskDy.getDynamicObjectCollection("mulsinsurstd");
            List insuranceStandardIds = standardDysInTask.stream().map(baseData -> baseData.getLong("fbasedataid.id")).collect(Collectors.toList());
            standardGroupByTask.put(taskDy.getLong("id"), insuranceStandardIds);
        }
        return standardGroupByTask;
    }

    public boolean releaseSocialTaskMutexLock() {
        boolean isRelease = true;
        for (Long taskId : this.socialTaskIds) {
            BaseResult baseResult = MutexServiceHelper.release((String)"hcsi_sinsurtask", (String)String.valueOf(taskId), (String)SocialOperationEnum.OP_EXPORTDETAIL.getOperationKey());
            isRelease = baseResult.isSuccess() && isRelease;
        }
        return isRelease;
    }

    public void closeTask() {
        if (this.workbookInfo != null && this.workbookInfo.getWorkbook() != null) {
            try {
                this.workbookInfo.getWorkbook().close();
            }
            catch (IOException exception) {
                this.logger.error("SocialDetailDownLoadTask#closeTask error:", (Throwable)exception);
            }
        }
    }

    private List<ColumnEntity> getDisplaySchColumnList(Map<String, Object> displaySchInfoMap, Map<String, ColumnEntity> columnEntityGroupByListFieldKey, Map.Entry<Long, List<InsuredStandard>> entry) {
        List<InsuredStandard> itemList = entry.getValue();
        HashMap<String, Object> taskSchInfoMap = new HashMap<String, Object>(16);
        Long taskId = entry.getKey();
        ArrayList<ColumnEntity> columnEntityList = new ArrayList<ColumnEntity>(10);
        ArrayList selectPropList = new ArrayList(10);
        columnEntityList.add(columnEntityGroupByListFieldKey.get("fseq"));
        List schInfoDataList = (List)displaySchInfoMap.get("schInfoDataList");
        Map<String, InsuredStandard> itemMap = itemList.stream().collect(Collectors.toMap(obj -> obj.getInsuredItemName() + "@;@" + obj.getType(), obj -> obj, (k1, k2) -> k1));
        ColumnEntity tempEntity = null;
        HashSet<Long> sumItemIdSet = new HashSet<Long>(16);
        HashSet<Long> insuranceItemIdSet = new HashSet<Long>(16);
        String fieldType = null;
        String showName = null;
        InsuredStandard temItem = null;
        for (Map tempMap : schInfoDataList) {
            fieldType = (String)tempMap.get("fieldtype");
            showName = (String)tempMap.get("showname");
            if ("3".equals(fieldType) || "4".equals(fieldType)) {
                String type = fieldType.equals("4") ? "2" : "1";
                temItem = itemMap.get((String)tempMap.get("fieldname") + "@;@" + type);
                if (temItem == null) continue;
                tempEntity = ExportDetailHelper.convertDynamicItemToColumnEntity(temItem);
                if (SITStringUtils.isNotEmpty((String)showName)) {
                    tempEntity.setListFieldName(showName);
                }
                columnEntityList.add(tempEntity);
                if ("2".equals(type)) {
                    sumItemIdSet.add(temItem.getInsuredItemId());
                    continue;
                }
                insuranceItemIdSet.add(temItem.getInsuredItemId());
                continue;
            }
            tempEntity = columnEntityGroupByListFieldKey.get(tempMap.get("field"));
            selectPropList.add(tempMap.get("field"));
            if (tempEntity != null) {
                ColumnEntity copyEntity = tempEntity.clone();
                if (SITStringUtils.isNotEmpty((String)showName)) {
                    copyEntity.setListFieldName(showName);
                }
                columnEntityList.add(copyEntity);
                continue;
            }
            columnEntityList.add(this.buildEntity(tempMap));
        }
        String fields = String.join((CharSequence)",", selectPropList) + ",";
        taskSchInfoMap.put("selectProperties", fields);
        taskSchInfoMap.put("orderBy", displaySchInfoMap.get("orderBy"));
        taskSchInfoMap.put("sumItemIdSet", sumItemIdSet);
        taskSchInfoMap.put("insuranceItemIdSet", insuranceItemIdSet);
        this.taskDisplaySchInfoMap.put(taskId, taskSchInfoMap);
        return columnEntityList;
    }

    private ColumnEntity buildEntity(Map<String, String> tempMap) {
        ColumnEntity columnEntity = new ColumnEntity();
        String field = tempMap.get("field");
        columnEntity.setListFieldKey(field);
        if (SITStringUtils.isNotEmpty((String)tempMap.get("showname"))) {
            columnEntity.setListFieldName(tempMap.get("showname"));
        } else {
            columnEntity.setListFieldName(tempMap.get("fieldname"));
        }
        if ("sinsurfilev.bsed".equals(field) || "sinsurfilev.bsled".equals(field)) {
            columnEntity.setDataType(SitDataTypeEnum.DATE.getDataType());
            columnEntity.setDisplayFormatString("yyyy-MM-dd");
        } else {
            columnEntity.setDataType(SitDataTypeEnum.TEXT.getDataType());
        }
        return columnEntity;
    }
}

