/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.business.cal.export;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.sit.sitbp.business.helper.excel.model.HeadCellBar;
import kd.sit.sitbp.business.helper.excel.model.HeadCellInfo;
import kd.sit.sitbp.business.helper.excel.model.SheetInfo;
import kd.sit.sitbp.business.helper.excel.model.WorkbookInfo;
import kd.sit.sitbp.business.helper.excel.model.WorkbookInfoGenerator;
import kd.sit.sitbp.business.helper.listpage.ColumnEntity;
import kd.sit.sitbp.common.constants.SITEntityConstants;
import kd.sit.sitbp.common.util.datatype.DataTypeEnum;

public class SocialDetailWorkbookMultiTaskBillList
implements WorkbookInfoGenerator,
SITEntityConstants {
    private static final Log LOGGER = LogFactory.getLog(SocialDetailWorkbookMultiTaskBillList.class);

    public WorkbookInfo generate(Map<String, Object> param) {
        WorkbookInfo workbookInfo = new WorkbookInfo();
        try {
            LinkedHashMap socialTaskMap = (LinkedHashMap)param.get("socialTaskMap");
            Map sortedColumnEntitiesGroupByTask = (Map)param.get("socialTaskItemMap");
            String fileName = (String)param.get("fileName");
            workbookInfo.setFileName(fileName);
            ArrayList sheetInfoList = new ArrayList(socialTaskMap.size());
            socialTaskMap.forEach((taskId, socialTask) -> {
                SheetInfo sheetInfo = new SheetInfo();
                sheetInfoList.add(sheetInfo);
                sheetInfo.setName(socialTask.getString("number"));
                sheetInfo.setDataKey(taskId);
                HeadCellBar headCellBar = new HeadCellBar();
                sheetInfo.setHeadCellBar(headCellBar);
                List columnEntities = null;
                if (sortedColumnEntitiesGroupByTask != null && sortedColumnEntitiesGroupByTask.get(taskId) != null) {
                    columnEntities = (List)sortedColumnEntitiesGroupByTask.get(taskId);
                    int index = 0;
                    for (ColumnEntity columnEntity : columnEntities) {
                        String listFieldKey = columnEntity.getListFieldKey();
                        columnEntity.setSeq(index++);
                        HeadCellInfo headCellInfo = new HeadCellInfo();
                        headCellInfo.setDefaultDesc(columnEntity.getListFieldName());
                        headCellInfo.setValueProp(listFieldKey);
                        DataTypeEnum dataType = columnEntity.getDataType();
                        headCellInfo.setDataType(dataType.name());
                        if (DataTypeEnum.DATE == dataType) {
                            headCellInfo.setBaseFormat(columnEntity.getDisplayFormatString());
                        } else if (DataTypeEnum.LONG == dataType) {
                            headCellInfo.setDataType(DataTypeEnum.STRING.name());
                            headCellInfo.setBaseFormat("@");
                        } else {
                            headCellInfo.setBaseFormat(columnEntity.getDisplayFormatString());
                        }
                        if (columnEntity.getScale() != null) {
                            headCellInfo.setScale(columnEntity.getScale().intValue());
                        }
                        headCellBar.addHeadCellInfos(new HeadCellInfo[]{headCellInfo});
                    }
                }
                LOGGER.info("SocialDetailWorkbookMultiTaskBillList.generate:, taskId is {}, columnEntities is {}", taskId, (Object)JSONObject.toJSONString(columnEntities));
            });
            workbookInfo.setSheetInfoList(sheetInfoList);
            workbookInfo.ready();
        }
        catch (Exception e) {
            LOGGER.error("SocialDetailWorkbookMultiTaskBillList.generate error info: ", (Throwable)e);
        }
        return workbookInfo;
    }
}

