/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.business.cal.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.sit.hcsi.business.cal.SocialInsuranceCalHelper;
import kd.sit.hcsi.business.cal.errInfo.CalApiResultErrInfoEnum;
import kd.sit.hcsi.business.cal.service.ICalService;
import kd.sit.hcsi.business.cal.service.SocialCalCertService;
import kd.sit.hcsi.business.cal.service.SocialInsuranceCalFilterHelper;
import kd.sit.sitbp.business.servicehelper.MutexServiceHelper;
import kd.sit.sitbp.common.cache.ISITAppCache;
import kd.sit.sitbp.common.cache.SITAppCache;
import kd.sit.sitbp.common.entity.social.CalSocialDetailDTO;
import kd.sit.sitbp.common.entity.social.InsuredParamConfigDTO;
import kd.sit.sitbp.common.entity.social.InsuredStandardDTO;
import kd.sit.sitbp.common.entity.social.PreCalCfgDTO;

public abstract class AbsCalService
implements ICalService {
    protected static final Log log = LogFactory.getLog(AbsCalService.class);
    protected String pageId;
    protected String recordId;
    protected Set<Long> periodIds;
    protected Set<Long> insuredCompanyIds;
    protected ApiResult apiResult;
    protected String opKey;
    protected Map<String, Object> extendParams;
    protected Table<Long, Long, List<DynamicObject>> periodIdAndCompanyIdTaskDyTable = HashBasedTable.create();
    protected Table<Long, Long, List<DynamicObject>> periodIdAndCompanyIdToHisFileMap = HashBasedTable.create();
    protected String calType;
    protected int fileTotalAdd = 0;
    protected int taskNums = 0;

    public AbsCalService(String pageId, Set<Long> periodIdSet, Set<Long> insuredCompanyIdSet, Map<String, Object> extendParams) {
        this.pageId = pageId;
        this.recordId = UUID.randomUUID().toString();
        this.periodIds = periodIdSet;
        this.insuredCompanyIds = insuredCompanyIdSet;
        this.extendParams = extendParams;
        this.apiResult = ApiResult.success(null);
        this.initRecordId();
        this.initExtendParams();
    }

    private void initExtendParams() {
        HashSet<Long> welfareTypeIdSet;
        log.info("start to init extendParams");
        if (this.extendParams == null) {
            this.extendParams = new HashMap<String, Object>(1);
        }
        if ((welfareTypeIdSet = (HashSet<Long>)this.extendParams.get("welfaretype")) == null) {
            List<Long> welfareTypeIdList = SocialInsuranceCalHelper.getAllChineseWelfareTypeIdList();
            if (!CollectionUtils.isEmpty(welfareTypeIdList)) {
                welfareTypeIdSet = new HashSet<Long>(welfareTypeIdList);
            }
        } else {
            HashSet<Long> newWelfareTypeIdSet = new HashSet<Long>(welfareTypeIdSet.size());
            for (Object e : welfareTypeIdSet) {
                if (e instanceof Integer) {
                    newWelfareTypeIdSet.add(Long.valueOf(((Integer)e).intValue()));
                    continue;
                }
                newWelfareTypeIdSet.add((Long)e);
            }
            welfareTypeIdSet = newWelfareTypeIdSet;
        }
        this.extendParams.put("welfaretype", welfareTypeIdSet);
        if (this.extendParams.get("recordId") != null) {
            this.recordId = (String)this.extendParams.get("recordId");
        }
    }

    @Override
    public final ApiResult updatePersonAndCal() {
        try {
            this.clearCache();
            LinkedHashMap<Long, DynamicObject> periodIdAndInfoMap = new LinkedHashMap<Long, DynamicObject>(16);
            LinkedHashMap<Long, DynamicObject> insuredCompanyIdAndInfoMap = new LinkedHashMap<Long, DynamicObject>(16);
            log.info("AbsCalService.updatePersonAndCal: start checkDataForBase");
            Set<Long> needReleaseLockTaskIds = this.checkDataForBase(periodIdAndInfoMap, insuredCompanyIdAndInfoMap);
            HashMap<Long, Collection<PreCalCfgDTO>> taskIdAndPreCalCfgDTOMap = new HashMap<Long, Collection<PreCalCfgDTO>>(this.periodIdAndCompanyIdTaskDyTable.size());
            HashMap<Long, List<DynamicObject>> taskIdAndHisFileListMap = new HashMap<Long, List<DynamicObject>>(this.periodIdAndCompanyIdTaskDyTable.size());
            HashMap<Long, Map<Long, Long>> taskToFileToWelfarePayerMap = new HashMap<Long, Map<Long, Long>>(this.periodIdAndCompanyIdTaskDyTable.size());
            log.info("AbsCalService.updatePersonAndCal: start checkDataForCal");
            this.checkDataForCal(taskIdAndPreCalCfgDTOMap, taskIdAndHisFileListMap, needReleaseLockTaskIds, taskToFileToWelfarePayerMap);
            ArrayList<DynamicObject> taskList = new ArrayList<DynamicObject>(this.periodIdAndCompanyIdTaskDyTable.size());
            for (List tasks : this.periodIdAndCompanyIdTaskDyTable.values()) {
                if (CollectionUtils.isEmpty((Collection)tasks)) continue;
                taskList.addAll(tasks);
            }
            log.info("AbsCalService.updatePersonAndCal: start generateReport,and the size of task is {}", (Object)taskList.size());
            Map<Long, Long> taskIdReportIdMap = SocialInsuranceCalHelper.genTaskIdReportIdMap(taskList);
            HashMap<String, List<String>> taskBatchIdMap = new HashMap<String, List<String>>(this.periodIdAndCompanyIdTaskDyTable.size());
            log.info("AbsCalService.updatePersonAndCal: start packageData");
            this.packageData(taskIdAndPreCalCfgDTOMap, taskIdAndHisFileListMap, needReleaseLockTaskIds, taskIdReportIdMap, taskBatchIdMap, taskToFileToWelfarePayerMap);
            log.info("AbsCalService.updatePersonAndCal: start pushData");
            this.pushData(needReleaseLockTaskIds, taskIdReportIdMap, taskBatchIdMap);
            return this.apiResult;
        }
        catch (Exception exception) {
            log.error("updatePersonAndCal error", (Throwable)exception);
            return ApiResult.fail((String)CalApiResultErrInfoEnum.SYSTEM_ERROR.getErrCode());
        }
    }

    public boolean checkCert(Map<Long, DynamicObject> periodIdAndInfoMap) {
        SocialCalCertService certService = new SocialCalCertService();
        HashBasedTable tmpPeriodIdAndCompanyIdTaskDyTable = HashBasedTable.create();
        for (Long periodId : this.periodIds) {
            for (Long insuredCompanyId : this.insuredCompanyIds) {
                tmpPeriodIdAndCompanyIdTaskDyTable.put((Object)periodId, (Object)insuredCompanyId, new ArrayList(0));
            }
        }
        for (Long periodId : this.periodIds) {
            DynamicObject period = periodIdAndInfoMap.get(periodId);
            boolean isDependonOnTheoryPayer = SocialInsuranceCalHelper.isDependonOnTheoryPayer();
            String welfarePayerIdKey = isDependonOnTheoryPayer ? "welfarepayertheory.id" : "welfarepayer.id";
            Date periodEndDate = SocialInsuranceCalHelper.getDayDate(period.getDate("enddate"));
            ArrayList<DynamicObject> hisFileList = new ArrayList<DynamicObject>(10);
            DynamicObject[] currentFileArray = SocialInsuranceCalHelper.getCurrentFiles(periodEndDate, this.insuredCompanyIds, hisFileList, this.calType);
            Map<Long, List<DynamicObject>> currentFileMap = Arrays.stream(currentFileArray).collect(Collectors.groupingBy(currentFile -> currentFile.getLong(welfarePayerIdKey)));
            for (Long insuredCompanyId : this.insuredCompanyIds) {
                boolean isCertInvalid;
                List<DynamicObject> currentFileList = currentFileMap.get(insuredCompanyId);
                if (CollectionUtils.isEmpty(currentFileList)) continue;
                boolean bl = isCertInvalid = !certService.checkCert(currentFileList.toArray(new DynamicObject[currentFileList.size()]), "hcsi_sinsurtask");
                if (isCertInvalid) {
                    SocialInsuranceCalFilterHelper.checkCertValid((Table<Long, Long, List<DynamicObject>>)tmpPeriodIdAndCompanyIdTaskDyTable, certService.getResultMsg(), this.apiResult, CalApiResultErrInfoEnum.CERT_CHECK_ERROR);
                    return true;
                }
                HashBasedTable singlePeriodIdAndCompanyIdTaskDyTable = HashBasedTable.create();
                singlePeriodIdAndCompanyIdTaskDyTable.put((Object)periodId, (Object)insuredCompanyId, new ArrayList(0));
                SocialInsuranceCalFilterHelper.checkCertValid((Table<Long, Long, List<DynamicObject>>)singlePeriodIdAndCompanyIdTaskDyTable, certService.getResultMsg(), this.apiResult, CalApiResultErrInfoEnum.CERT_CHECK_ERROR);
                this.periodIdAndCompanyIdToHisFileMap.put((Object)periodId, (Object)insuredCompanyId, hisFileList);
            }
        }
        return false;
    }

    private void initRecordId() {
        JSONObject data = (JSONObject)this.apiResult.getData();
        if (data == null) {
            data = new JSONObject(2);
        }
        data.put("recordId", (Object)this.recordId);
        this.apiResult.setData((Object)data);
    }

    @Override
    public void clearCache() {
        this.periodIdAndCompanyIdTaskDyTable.clear();
        this.fileTotalAdd = 0;
        this.taskNums = 0;
    }

    @Override
    public void checkDataForCal(Map<Long, Collection<PreCalCfgDTO>> taskIdAndPreCalCfgDTOMap, Map<Long, List<DynamicObject>> taskIdAndHisFileListMap, Set<Long> needReleaseLockTaskIds, Map<Long, Map<Long, Long>> taskToFileToWelfarePayerMap) {
        SocialCalCertService certService = new SocialCalCertService();
        Iterator iterator = this.periodIdAndCompanyIdTaskDyTable.cellSet().iterator();
        while (iterator.hasNext()) {
            Table.Cell periodIdAndCompanyIdTaskDyCell = (Table.Cell)iterator.next();
            List taskDyList = (List)periodIdAndCompanyIdTaskDyCell.getValue();
            if (CollectionUtils.isEmpty((Collection)taskDyList)) continue;
            for (DynamicObject taskDy : taskDyList) {
                Map<Long, PreCalCfgDTO> preCalCfgDTOMap;
                ArrayList<DynamicObject> hisFileList;
                DynamicObject periodDy = taskDy.getDynamicObject("sinsurperiod");
                Long periodId = periodDy.getLong("id");
                long insuredCompanyId = taskDy.getLong("welfarepayer.id");
                Date periodEndDate = SocialInsuranceCalHelper.getDayDate(taskDy.getDate("sinsurperiod.enddate"));
                HashSet<String> errorNameSet = new HashSet<String>(16);
                if ("3".equals(this.calType)) {
                    hisFileList = new ArrayList(10);
                    HashSet<Long> insuredCompanyIdSet = new HashSet<Long>(1);
                    insuredCompanyIdSet.add(insuredCompanyId);
                    DynamicObject[] currentFileArray = SocialInsuranceCalHelper.getCurrentFiles(periodEndDate, insuredCompanyIdSet, hisFileList, this.calType);
                    if (CollectionUtils.isEmpty(hisFileList)) {
                        long taskId = taskDy.getLong("id");
                        taskIdAndPreCalCfgDTOMap.put(taskId, new ArrayList(0));
                        taskIdAndHisFileListMap.put(taskId, new ArrayList(0));
                        continue;
                    }
                    if (this.checkCertInvalid(needReleaseLockTaskIds, certService, (Table.Cell<Long, Long, List<DynamicObject>>)periodIdAndCompanyIdTaskDyCell, currentFileArray)) {
                        return;
                    }
                    preCalCfgDTOMap = SocialInsuranceCalHelper.getPreCalCfgDTOMap(hisFileList, periodEndDate, errorNameSet);
                    if (preCalCfgDTOMap.size() == 0) {
                        StringBuilder welfarePayerNameBuilder = new StringBuilder();
                        errorNameSet.forEach(errorName -> {
                            if (welfarePayerNameBuilder.length() > 0) {
                                welfarePayerNameBuilder.append('\u3001');
                            }
                            welfarePayerNameBuilder.append((String)errorName);
                        });
                        String errMsg = CalApiResultErrInfoEnum.NOT_EXISTS_STANDARD_FOR_PERIOD_AND_COMPANY_COMBINED.getErrInfo(welfarePayerNameBuilder.toString(), periodDy.getString("name"));
                        SocialInsuranceCalFilterHelper.setApiResult(this.apiResult, errMsg, CalApiResultErrInfoEnum.NOT_EXISTS_STANDARD_FOR_PERIOD_AND_COMPANY_COMBINED, "error", periodId, insuredCompanyId);
                        if (needReleaseLockTaskIds != null) {
                            needReleaseLockTaskIds.add(taskDy.getLong("id"));
                        }
                        iterator.remove();
                        continue;
                    }
                } else {
                    hisFileList = (List)this.periodIdAndCompanyIdToHisFileMap.get((Object)periodId, (Object)insuredCompanyId);
                    preCalCfgDTOMap = SocialInsuranceCalHelper.getPreCalCfgDTOMap(hisFileList, periodEndDate, errorNameSet);
                }
                long taskId = taskDy.getLong("id");
                taskIdAndPreCalCfgDTOMap.put(taskId, preCalCfgDTOMap.values());
                taskIdAndHisFileListMap.put(taskId, hisFileList);
                if (CollectionUtils.isEmpty(hisFileList)) continue;
                Map fileToWelfarePayerMap = taskToFileToWelfarePayerMap.computeIfAbsent(taskId, key -> new HashMap(16));
                hisFileList.forEach(hisFile -> fileToWelfarePayerMap.put(hisFile.getLong("boid"), hisFile.getLong("welfarepayer.id")));
            }
        }
    }

    @Override
    public void packageData(Map<Long, Collection<PreCalCfgDTO>> taskIdAndPreCalCfgDTOMap, Map<Long, List<DynamicObject>> taskIdAndHisFileListMap, Set<Long> needReleaseLockTaskIds, Map<Long, Long> taskIdReportIdMap, Map<String, List<String>> taskBatchIdMap, Map<Long, Map<Long, Long>> taskToFileToWelfarePayerMap) {
        ISITAppCache iSitAppCache = SITAppCache.get((String)this.recordId);
        Iterator iterator = this.periodIdAndCompanyIdTaskDyTable.cellSet().iterator();
        while (iterator.hasNext()) {
            Table.Cell periodIdAndCompanyIdTaskCell = (Table.Cell)iterator.next();
            List taskDyList = (List)periodIdAndCompanyIdTaskCell.getValue();
            if (CollectionUtils.isEmpty((Collection)taskDyList)) continue;
            for (DynamicObject taskDy : taskDyList) {
                Long taskId = taskDy.getLong("id");
                long reportId = taskIdReportIdMap.get(taskId);
                Collection<PreCalCfgDTO> preCalCfgDTOs = taskIdAndPreCalCfgDTOMap.get(taskId);
                List<DynamicObject> hisFileList = taskIdAndHisFileListMap.get(taskId);
                this.updateStandards(taskDy, preCalCfgDTOs);
                Map<Long, CalSocialDetailDTO> fileIdAndDetailDtoMap = this.updateTaskAndReport(taskDy, reportId, hisFileList);
                if (fileIdAndDetailDtoMap == null || fileIdAndDetailDtoMap.size() == 0) {
                    if (fileIdAndDetailDtoMap != null) {
                        SocialInsuranceCalFilterHelper.setApiResultForFile(taskDy, this.apiResult);
                    }
                    if (needReleaseLockTaskIds != null) {
                        needReleaseLockTaskIds.add(taskId);
                    }
                    iterator.remove();
                    continue;
                }
                this.fileTotalAdd += fileIdAndDetailDtoMap.size();
                ++this.taskNums;
                List<String> batchStrIds = SocialInsuranceCalHelper.writeCache(iSitAppCache, fileIdAndDetailDtoMap, preCalCfgDTOs, taskDy, reportId, taskToFileToWelfarePayerMap.getOrDefault(taskId, new HashMap(0)));
                if (!"1".equals(this.calType)) {
                    Set welfareTypeIdSet = taskDy.getDynamicObjectCollection("welfaretype").stream().map(welfareType -> welfareType.getLong("fbasedataid.id")).collect(Collectors.toSet());
                    if (CollectionUtils.isEmpty(welfareTypeIdSet)) {
                        iSitAppCache.put(MessageFormat.format("welfareTypeIdSet_{0}", taskId), this.extendParams.get("welfaretype"));
                    } else {
                        iSitAppCache.put(MessageFormat.format("welfareTypeIdSet_{0}", taskId), welfareTypeIdSet);
                    }
                } else {
                    iSitAppCache.put(MessageFormat.format("welfareTypeIdSet_{0}", taskId), this.extendParams.get("welfaretype"));
                }
                taskBatchIdMap.put(String.valueOf(taskId), batchStrIds);
            }
        }
    }

    @Override
    public void pushData(Set<Long> needReleaseLockTaskIds, Map<Long, Long> taskIdReportIdMap, Map<String, List<String>> taskBatchIdMap) {
        if (this.periodIdAndCompanyIdTaskDyTable.isEmpty()) {
            this.releaseLock(needReleaseLockTaskIds);
            return;
        }
        if ("1".equals(this.calType) || "3".equals(this.calType)) {
            SocialInsuranceCalHelper.cacheProgressInfoAndOpenFloatingBall(this.pageId, this.recordId, this.fileTotalAdd, this.opKey, this.taskNums);
        }
        ArrayList<Long> reportIds = new ArrayList<Long>(this.periodIdAndCompanyIdTaskDyTable.size());
        for (List taskDyList : this.periodIdAndCompanyIdTaskDyTable.values()) {
            if (CollectionUtils.isEmpty((Collection)taskDyList)) continue;
            for (DynamicObject taskDy : taskDyList) {
                Long reportId;
                List<String> batchStrIds = taskBatchIdMap.get(taskDy.getString("id"));
                if (batchStrIds != null && !batchStrIds.isEmpty()) {
                    SocialInsuranceCalHelper.publishMsgByPublisher(this.recordId, batchStrIds);
                }
                if ((reportId = taskIdReportIdMap.get(taskDy.getLong("id"))) == null) continue;
                reportIds.add(reportId);
            }
        }
        log.info("AbsCalService.pushData: this recordId is {}, and calType is {}.", (Object)JSON.toJSONString((Object)this.recordId), (Object)this.calType);
        ISITAppCache iSitAppCache = SITAppCache.get((String)this.recordId);
        iSitAppCache.put("reportIds", reportIds);
        iSitAppCache.put("extendParams", this.extendParams);
        this.releaseLock(needReleaseLockTaskIds);
    }

    @Override
    public ApiResult getApiResult() {
        return this.apiResult;
    }

    private boolean checkCertInvalid(Set<Long> needReleaseLockTaskIds, SocialCalCertService certService, Table.Cell<Long, Long, List<DynamicObject>> periodIdAndCompanyIdTaskDyCell, DynamicObject[] currentFileArray) {
        boolean isCertInvalid;
        long beginTime = System.currentTimeMillis();
        log.info("AbsCalService.checkCertInvalid: begin to check cert, current time is {}", (Object)System.currentTimeMillis());
        boolean bl = isCertInvalid = !certService.checkCert(currentFileArray, "hcsi_sinsurtask");
        if (isCertInvalid) {
            if (needReleaseLockTaskIds != null) {
                for (List taskObjList : this.periodIdAndCompanyIdTaskDyTable.values()) {
                    if (CollectionUtils.isEmpty((Collection)taskObjList)) continue;
                    taskObjList.forEach(taskObj -> needReleaseLockTaskIds.add(taskObj.getLong("id")));
                }
            }
            SocialInsuranceCalFilterHelper.checkCertValid(this.periodIdAndCompanyIdTaskDyTable, certService.getResultMsg(), this.apiResult, CalApiResultErrInfoEnum.CERT_CHECK_ERROR);
            this.periodIdAndCompanyIdTaskDyTable.clear();
            return true;
        }
        HashBasedTable tmPeriodIdAndCompanyIdTaskDyTable = HashBasedTable.create();
        tmPeriodIdAndCompanyIdTaskDyTable.put(periodIdAndCompanyIdTaskDyCell.getRowKey(), periodIdAndCompanyIdTaskDyCell.getColumnKey(), periodIdAndCompanyIdTaskDyCell.getValue());
        SocialInsuranceCalFilterHelper.checkCertValid((Table<Long, Long, List<DynamicObject>>)tmPeriodIdAndCompanyIdTaskDyTable, certService.getResultMsg(), this.apiResult, CalApiResultErrInfoEnum.CERT_CHECK_WARN);
        long cost = System.currentTimeMillis() - beginTime;
        log.info("AbsCalService.checkCertInvalid: end to check cert, cost time is {}", (Object)cost);
        return false;
    }

    protected Map<Long, CalSocialDetailDTO> updateTaskAndReport(DynamicObject taskDy, long reportId, List<DynamicObject> hisFileList) {
        return SocialInsuranceCalHelper.updateTaskReportAndCalPerson(taskDy, reportId, hisFileList, this.calType);
    }

    protected void addMutexLock(DynamicObject taskDy) {
    }

    private void updateStandards(DynamicObject taskDy, Collection<PreCalCfgDTO> preCalCfgDTOs) {
        HashSet stdVIdSet = new HashSet(preCalCfgDTOs.size());
        HashSet cfgVIdSet = new HashSet(preCalCfgDTOs.size());
        for (PreCalCfgDTO preCalCfgDTO : preCalCfgDTOs) {
            List stdVIds = preCalCfgDTO.getInsuredStandardMap().values().stream().filter(Objects::nonNull).map(InsuredStandardDTO::getVid).collect(Collectors.toList());
            List cfgVIds = preCalCfgDTO.getInsuredParamConfigMap().values().stream().filter(Objects::nonNull).map(InsuredParamConfigDTO::getId).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(stdVIds)) {
                stdVIdSet.addAll(stdVIds);
            }
            if (CollectionUtils.isEmpty(cfgVIds)) continue;
            cfgVIdSet.addAll(cfgVIds);
        }
        DynamicObjectCollection mulSinsurStds = taskDy.getDynamicObjectCollection("mulsinsurstd");
        DynamicObjectCollection mulSinsurStdCfgs = taskDy.getDynamicObjectCollection("mulsinsurstdcfg");
        Set existStdIdSet = mulSinsurStds.stream().map(sinsurStd -> sinsurStd.getLong("fbasedataid_id")).collect(Collectors.toSet());
        Set existCfgIdSet = mulSinsurStdCfgs.stream().map(sinsurStdCfg -> sinsurStdCfg.getLong("fbasedataid_id")).collect(Collectors.toSet());
        if (!CollectionUtils.isEmpty(existStdIdSet)) {
            stdVIdSet.removeAll(existStdIdSet);
        }
        if (!CollectionUtils.isEmpty(existCfgIdSet)) {
            cfgVIdSet.removeAll(existCfgIdSet);
        }
        stdVIdSet.remove(null);
        cfgVIdSet.remove(null);
        for (Long stdVId : stdVIdSet) {
            mulSinsurStds.addNew().set("fbasedataid_id", (Object)stdVId);
        }
        for (Long cfgVId : cfgVIdSet) {
            mulSinsurStdCfgs.addNew().set("fbasedataid_id", (Object)cfgVId);
        }
    }

    private void releaseLock(Set<Long> needReleaseLockTaskIds) {
        if (needReleaseLockTaskIds != null) {
            needReleaseLockTaskIds.forEach(taskId -> MutexServiceHelper.release((String)"hcsi_sinsurtask", (String)String.valueOf(taskId), (String)this.opKey));
            log.info("AbsCalService.releaseLock: Mutex error, needReleaseLockTaskIds is {}", (Object)JSON.toJSONString(needReleaseLockTaskIds));
        }
    }
}

