/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.business.cal.service;

import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sit.hcsi.business.cal.service.AbsCalService;
import kd.sit.hcsi.business.cal.service.SocialInsuranceCalFilterHelper;
import org.apache.commons.collections.CollectionUtils;

public class CalServiceImplForViewUpdate
extends AbsCalService {
    protected static final Log log = LogFactory.getLog(CalServiceImplForViewUpdate.class);
    private Set<Long> taskIds;

    public CalServiceImplForViewUpdate(String pageId, Set<Long> taskIds, Map<String, Object> extendParams, String opKey) {
        super(pageId, new HashSet<Long>(0), new HashSet<Long>(0), extendParams);
        this.calType = "4";
        this.opKey = opKey;
        this.taskIds = taskIds;
    }

    @Override
    public Set<Long> checkDataForBase(Map<Long, DynamicObject> periodIdAndInfoMap, Map<Long, DynamicObject> insuredCompanyIdAndInfoMap) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hcsi_sinsurtask");
        QFilter filter = new QFilter("id", "in", this.taskIds);
        DynamicObject[] taskDys = helper.loadDynamicObjectArray(filter.toArray());
        Map calTaskToFileMap = (Map)this.extendParams.get("calTaskToFileMap");
        HashSet allFileIdSet = new HashSet(16);
        for (Set idSet : calTaskToFileMap.values()) {
            if (!CollectionUtils.isNotEmpty((Collection)idSet)) continue;
            allFileIdSet.addAll(idSet);
        }
        helper.setEntityName("hcsi_sinsurfile");
        DynamicObjectCollection files = helper.queryOriginalCollection("id,boid,welfarepayertheory.id,welfarepayer.id,welfarepayertheory.name,welfarepayer.name", new QFilter[]{new QFilter("id", "in", allFileIdSet)});
        Map<Long, DynamicObject> fileMap = files.stream().collect(Collectors.toMap(file -> file.getLong("id"), file -> file));
        for (DynamicObject taskDy : taskDys) {
            DynamicObject periodDy = taskDy.getDynamicObject("sinsurperiod");
            DynamicObject insuredCompanyDy = taskDy.getDynamicObject("welfarepayer");
            ArrayList<DynamicObject> taskList = (ArrayList<DynamicObject>)this.periodIdAndCompanyIdTaskDyTable.get((Object)periodDy.getLong("id"), (Object)insuredCompanyDy.getLong("id"));
            if (taskList == null) {
                taskList = new ArrayList<DynamicObject>(10);
                this.periodIdAndCompanyIdTaskDyTable.put((Object)periodDy.getLong("id"), (Object)insuredCompanyDy.getLong("id"), taskList);
            }
            taskList.add(taskDy);
            periodIdAndInfoMap.put(periodDy.getLong("id"), taskDy.getDynamicObject("sinsurperiod"));
            insuredCompanyIdAndInfoMap.put(insuredCompanyDy.getLong("id"), taskDy.getDynamicObject("welfarepayer"));
            Set fileIdSet = (Set)calTaskToFileMap.get(taskDy.getLong("id"));
            ArrayList<DynamicObject> fileList = new ArrayList<DynamicObject>(fileIdSet.size());
            for (Long fileId : fileIdSet) {
                DynamicObject file2 = fileMap.get(fileId);
                if (file2 == null) continue;
                fileList.add(file2);
            }
            this.periodIdAndCompanyIdToHisFileMap.put((Object)taskDy.getLong("sinsurperiod.id"), (Object)taskDy.getLong("welfarepayer.id"), fileList);
        }
        return SocialInsuranceCalFilterHelper.filterCallingTask((Table<Long, Long, List<DynamicObject>>)this.periodIdAndCompanyIdTaskDyTable, this.apiResult);
    }
}

