/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.business.cal.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sdk.sit.hcsi.common.entity.cal.InsuredStandard;
import kd.sit.hcsi.business.cal.SocialInsuranceCalHelper;
import kd.sit.sitbp.common.cache.SITPageCache;
import kd.sit.sitbp.common.util.SITStringUtils;

public class DisplaySchemeService {
    private static final Log log = LogFactory.getLog(DisplaySchemeService.class);
    public static final String FIELDTYPE_PERSON = "1";
    public static final String FIELDTYPE_FILE = "2";
    public static final String FIELDTYPE_INSURANCEITEM = "3";
    public static final String FIELDTYPE_SUMITEM = "4";
    public static final String NO_ORDER = "0";
    public static final String DESC_ORDER = "2";

    public static Long getDisplaySchemaIdByTaskId(Long taskId) {
        DynamicObject taskObj = DisplaySchemeService.getSinsurTask(taskId);
        if (taskObj == null) {
            return null;
        }
        QFilter filter = new QFilter("welfarepayer.fbasedataid_id", "=", (Object)taskObj.getLong("welfarepayer.id"));
        filter.and("status", "=", (Object)"C");
        filter.and("enable", "=", (Object)FIELDTYPE_PERSON);
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hcsi_displayscheme");
        DynamicObjectCollection result = helper.queryOriginalCollection("id,number,isdefaulttpl", new QFilter[]{filter}, "isdefaulttpl desc,number desc");
        if (result.size() == 0) {
            return null;
        }
        return ((DynamicObject)result.get(0)).getLong("id");
    }

    public static DynamicObject getSinsurTask(Long taskId) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hcsi_sinsurtask");
        return helper.queryOriginalOne("id,welfarepayer.id", (Object)taskId);
    }

    public static int count(QFilter filter) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hcsi_displayscheme");
        return helper.count("hcsi_displayscheme", new QFilter[]{filter});
    }

    public static Map<String, Object> getDisplaySchemaInfoListFromCacheOrDB(Long displaySchId, IFormView view) {
        log.info("getDisplaySchemaInfoListFromCacheOrDB start,displaySchId = {}", (Object)displaySchId);
        SITPageCache pageCache = new SITPageCache(view);
        HashMap<String, Object> resultMap = new HashMap(5);
        String schJsonStr = (String)pageCache.get("schInfoDataList_" + displaySchId, String.class);
        if (SITStringUtils.isNotEmpty((String)schJsonStr)) {
            List schInfoDataList = SerializationUtils.fromJsonStringToList((String)schJsonStr, Map.class);
            String orderBy = (String)pageCache.get("orderBy_" + displaySchId, String.class);
            String freezeJsonStr = (String)pageCache.get("freezeColSet_" + displaySchId, String.class);
            Set freezeColSet = new HashSet(16);
            if (SITStringUtils.isNotEmpty((String)freezeJsonStr)) {
                freezeColSet = (Set)SerializationUtils.fromJsonString((String)freezeJsonStr, Set.class);
            }
            String insuranceItemJsonStr = (String)pageCache.get("insuranceItemList_" + displaySchId, String.class);
            ArrayList insuranceItemList = null;
            insuranceItemList = SITStringUtils.isNotEmpty((String)insuranceItemJsonStr) ? SerializationUtils.fromJsonStringToList((String)insuranceItemJsonStr, InsuredStandard.class) : new ArrayList(0);
            String sumItemJsonStr = (String)pageCache.get("sumItemList_" + displaySchId, String.class);
            ArrayList sumItemList = null;
            sumItemList = SITStringUtils.isNotEmpty((String)sumItemJsonStr) ? SerializationUtils.fromJsonStringToList((String)sumItemJsonStr, InsuredStandard.class) : new ArrayList(0);
            String orderByFieldSetStr = (String)pageCache.get("orderByFieldSet_" + displaySchId, String.class);
            Set orderByFieldSet = new HashSet(16);
            if (SITStringUtils.isNotEmpty((String)orderByFieldSetStr)) {
                orderByFieldSet = (Set)SerializationUtils.fromJsonString((String)orderByFieldSetStr, Set.class);
            }
            resultMap.put("orderBy", orderBy);
            resultMap.put("freezeColSet", freezeColSet);
            resultMap.put("insuranceItemList", insuranceItemList);
            resultMap.put("sumItemList", sumItemList);
            resultMap.put("schInfoDataList", schInfoDataList);
            resultMap.put("orderByFieldSet", orderByFieldSet);
            String highlightColor = (String)pageCache.get("highlightColor_" + displaySchId, String.class);
            resultMap.put("highlightColor", highlightColor);
        } else {
            resultMap = DisplaySchemeService.getDisplaySchemaDataById(displaySchId, pageCache);
        }
        log.info("getDisplaySchemaInfoListFromCacheOrDB end,displaySchId = {}", (Object)displaySchId);
        return resultMap;
    }

    public static Map<String, Object> getDisplaySchemaDataById(Long displaySchId, SITPageCache pageCache) {
        DynamicObject obj;
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hcsi_displayscheme");
        QFilter filter = new QFilter("id", "=", (Object)displaySchId);
        filter.and("entryentity.ishide", "=", (Object)Boolean.FALSE);
        String fields = "id,ishighlight,highlightcolor,entryentity.fieldname,entryentity.showname,entryentity.field,entryentity.isfreeze,entryentity.order,entryentity.priority,entryentity.fieldtype";
        DynamicObjectCollection result = helper.queryOriginalCollection(fields, new QFilter[]{filter}, "entryentity.seq asc");
        ArrayList schInfoDataList = new ArrayList(result.size());
        HashMap<String, String> itemMap = null;
        HashSet<String> itemFreezeColSet = new HashSet<String>(16);
        HashSet<String> sumItemFreezeColSet = new HashSet<String>(16);
        ArrayList<Map<String, String>> sortList = new ArrayList<Map<String, String>>(5);
        HashSet<String> insuranceItemSet = new HashSet<String>(16);
        HashSet<String> sumItemSet = new HashSet<String>(16);
        HashSet<String> freezeColSet = new HashSet<String>(16);
        for (DynamicObject entry : result) {
            itemMap = new HashMap<String, String>(6);
            itemMap.put("fieldtype", entry.getString("entryentity.fieldtype"));
            itemMap.put("field", entry.getString("entryentity.field"));
            itemMap.put("fieldname", entry.getString("entryentity.fieldname"));
            itemMap.put("showname", entry.getString("entryentity.showname"));
            itemMap.put("order", entry.getString("entryentity.order"));
            itemMap.put("priority", entry.getString("entryentity.priority"));
            schInfoDataList.add(itemMap);
            if (FIELDTYPE_INSURANCEITEM.equals(entry.getString("entryentity.fieldtype"))) {
                insuranceItemSet.add(entry.getString("entryentity.field"));
                if (entry.getBoolean("entryentity.isfreeze")) {
                    itemFreezeColSet.add(entry.getString("entryentity.fieldname"));
                }
            } else if (FIELDTYPE_SUMITEM.equals(entry.getString("entryentity.fieldtype"))) {
                sumItemSet.add(entry.getString("entryentity.field"));
                if (entry.getBoolean("entryentity.isfreeze")) {
                    sumItemFreezeColSet.add(entry.getString("entryentity.fieldname"));
                }
            } else if (entry.getBoolean("entryentity.isfreeze")) {
                freezeColSet.add(entry.getString("entryentity.field"));
            }
            if (NO_ORDER.equals(entry.getString("entryentity.order"))) continue;
            sortList.add(itemMap);
        }
        freezeColSet.add("fseq");
        HashSet<String> orderByFieldSet = new HashSet<String>(16);
        String orderBy = DisplaySchemeService.getOrderBy(sortList, orderByFieldSet);
        QFilter itemFilter = new QFilter("number", "in", insuranceItemSet);
        List<InsuredStandard> insuranceItemList = SocialInsuranceCalHelper.getInsureItemData(itemFilter);
        QFilter sumItemFilter = new QFilter("number", "in", sumItemSet);
        sumItemFilter.and("iscurrentversion", "=", (Object)FIELDTYPE_PERSON);
        List<InsuredStandard> sumItemList = SocialInsuranceCalHelper.getInsuredSumItemList(sumItemFilter);
        String highlightColor = null;
        if (result.size() > 0 && (obj = (DynamicObject)result.get(0)).getBoolean("ishighlight")) {
            highlightColor = obj.getString("highlightcolor");
        }
        DisplaySchemeService.addItemFreezeCol(itemFreezeColSet, insuranceItemList, freezeColSet);
        DisplaySchemeService.addItemFreezeCol(sumItemFreezeColSet, sumItemList, freezeColSet);
        HashMap<String, Object> resultMap = new HashMap<String, Object>(8);
        resultMap.put("orderBy", orderBy);
        resultMap.put("freezeColSet", freezeColSet);
        resultMap.put("insuranceItemList", insuranceItemList);
        resultMap.put("sumItemList", sumItemList);
        resultMap.put("schInfoDataList", schInfoDataList);
        resultMap.put("highlightColor", highlightColor);
        resultMap.put("orderByFieldSet", orderByFieldSet);
        if (pageCache != null) {
            pageCache.put("orderBy_" + displaySchId, (Object)orderBy);
            pageCache.put("orderByFieldSet_" + displaySchId, (Object)SerializationUtils.toJsonString(orderByFieldSet));
            pageCache.put("freezeColSet_" + displaySchId, (Object)SerializationUtils.toJsonString(freezeColSet));
            pageCache.put("insuranceItemList_" + displaySchId, (Object)SerializationUtils.toJsonString(insuranceItemList));
            pageCache.put("sumItemList_" + displaySchId, (Object)SerializationUtils.toJsonString(sumItemList));
            pageCache.put("schInfoDataList_" + displaySchId, (Object)SerializationUtils.toJsonString(schInfoDataList));
            pageCache.put("highlightColor_" + displaySchId, (Object)highlightColor);
        }
        return resultMap;
    }

    private static void addItemFreezeCol(Set<String> itemFreezeColSet, List<InsuredStandard> itemList, Set<String> freezeColSet) {
        if (itemFreezeColSet.size() == 0 || itemList.size() == 0) {
            return;
        }
        Map<String, InsuredStandard> itemMap = itemList.stream().collect(Collectors.toMap(InsuredStandard::getInsuredItemName, obj -> obj, (key1, key2) -> key1));
        InsuredStandard temp = null;
        for (String name : itemFreezeColSet) {
            temp = itemMap.get(name);
            if (temp == null) continue;
            freezeColSet.add(String.valueOf(temp.getInsuredItemId()));
        }
    }

    private static String getOrderBy(List<Map<String, String>> sortList, Set<String> orderByFieldSet) {
        if (sortList == null || sortList.size() == 0) {
            return null;
        }
        Collections.sort(sortList, new Comparator<Map<String, String>>(){

            @Override
            public int compare(Map<String, String> map1, Map<String, String> map2) {
                return Integer.parseInt(map1.get("priority")) - Integer.parseInt(map2.get("priority"));
            }
        });
        StringBuilder orderSb = new StringBuilder();
        for (Map<String, String> tempMap : sortList) {
            orderByFieldSet.add(tempMap.get("field"));
            orderSb.append(tempMap.get("field"));
            if ("2".equals(tempMap.get("order"))) {
                orderSb.append(' ').append("desc");
            } else {
                orderSb.append(' ').append("asc");
            }
            orderSb.append(',');
        }
        return orderSb.substring(0, orderSb.length() - 1);
    }

    public static void clearPageCache(SITPageCache pageCache, Long displaySchId) {
        if (pageCache == null) {
            return;
        }
        pageCache.remove("orderBy_" + displaySchId);
        pageCache.remove("freezeColSet_" + displaySchId);
        pageCache.remove("insuranceItemList_" + displaySchId);
        pageCache.remove("sumItemList_" + displaySchId);
        pageCache.remove("schInfoDataList_" + displaySchId);
        pageCache.remove("highlightColor_" + displaySchId);
    }
}

