/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.business.cal.service;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sit.hcsi.business.cal.SocialInsuranceCalHelper;
import kd.sit.hcsi.business.caladjust.helper.AdjustDataHelper;
import kd.sit.hcsi.business.declare.dto.DclPersonCacheDTO;
import kd.sit.hcsi.business.declare.helper.DclRecordHelper;

public class InsuranceStandardService {
    public static List<Long> getInsurStdVIdsOfCalPerson(Map<String, Object> customMap) {
        Long taskId = Long.parseLong(String.valueOf(customMap.get("taskId")));
        return SocialInsuranceCalHelper.getStandardVIdsBy(taskId);
    }

    public static DclPersonCacheDTO getDclPersonCacheDTO(Map<String, Object> customMap) {
        Long recordId = Long.parseLong(String.valueOf(customMap.get("dclRecordId")));
        List<DynamicObject> dclRecordDys = DclRecordHelper.queryDclRecordsByQFilter(new QFilter("id", "=", (Object)recordId));
        DclPersonCacheDTO dclPersonCacheDTO = new DclPersonCacheDTO();
        if (dclRecordDys == null || dclRecordDys.size() == 0 || HRObjectUtils.isEmpty((Object)dclRecordDys.get(0))) {
            return dclPersonCacheDTO;
        }
        DynamicObject dclRecordDy = dclRecordDys.get(0);
        dclPersonCacheDTO.setDclRecordName(dclRecordDy.getString("name"));
        dclPersonCacheDTO.setDclRecordId(dclRecordDy.getLong("id"));
        dclPersonCacheDTO.setDclStatus(dclRecordDy.getString("dclstatus"));
        dclPersonCacheDTO.setInsuredCompanyName(dclRecordDy.getString("insuredcompany.name"));
        dclPersonCacheDTO.setInsuredCompanyId(dclRecordDy.getLong("insuredcompany.id"));
        dclPersonCacheDTO.setPeriodName(dclRecordDy.getString("period.name"));
        dclPersonCacheDTO.setPeriodId(dclRecordDy.getLong("period.id"));
        dclPersonCacheDTO.setModifyType(dclRecordDy.getString("modifytype"));
        dclPersonCacheDTO.setDclDisplayScmVId(dclRecordDy.getLong("dcldisplayscmv.id"));
        dclPersonCacheDTO.setInsuredStandardVIds(SocialInsuranceCalHelper.getStandardVIdsInTask(dclRecordDy));
        dclPersonCacheDTO.setDclBizName(dclRecordDy.getString("dclbusinessname"));
        dclPersonCacheDTO.setDclRuleId(dclRecordDy.getLong("sinsurdclrule.id"));
        dclPersonCacheDTO.setDclRuleVId(dclRecordDy.getLong("sinsurdclrule.sourcevid"));
        dclPersonCacheDTO.setDclRuleVIdInRecord(dclRecordDy.getLong("sinsurdclrulev.id"));
        return dclPersonCacheDTO;
    }

    public static Table<Long, Long, String> getInsuranceStandardBy(Collection<Long> stdVIds, Map<Long, String> insurItemIdAndNameInStdMap) {
        HashBasedTable stdIdAndInsurItemIdAndRoundTypeInStdTable = HashBasedTable.create();
        DynamicObject[] insuranceStandardVDys = InsuranceStandardService.getInsuranceStandardEntryEntity(stdVIds);
        Map stdVIdAndDyMap = Optional.ofNullable(insuranceStandardVDys).map(stdVDys -> Arrays.stream(stdVDys).collect(Collectors.toMap(stdDy -> stdDy.getLong("id"), stdDy -> stdDy, (oldVal, newVal) -> oldVal))).orElseGet(() -> Collections.emptyMap());
        for (Long stdVId : stdVIds) {
            DynamicObject stdVDy = (DynamicObject)stdVIdAndDyMap.get(stdVId);
            if (stdVDy == null) continue;
            for (DynamicObject stdEntity : stdVDy.getDynamicObjectCollection("stdentryentity")) {
                InsuranceStandardService.getInsurItemInfoInSubEntity(stdVId, stdEntity, (Table<Long, Long, String>)stdIdAndInsurItemIdAndRoundTypeInStdTable, insurItemIdAndNameInStdMap);
            }
        }
        return stdIdAndInsurItemIdAndRoundTypeInStdTable;
    }

    private static DynamicObject[] getInsuranceStandardEntryEntity(Collection<Long> insurStdVIds) {
        String selectInsuranceStandardInfo = "id,insurtype.id,insuritem.id,insuritem.name,roundtype";
        return AdjustDataHelper.queryInsuranceStandardInfo(selectInsuranceStandardInfo, AdjustDataHelper.getInsuranceStandardFilter(insurStdVIds));
    }

    private static void getInsurItemInfoInSubEntity(long stdVId, DynamicObject stdEntity, Table<Long, Long, String> stdVIdAndInsurItemIdAndRoundTypeInStdTable, Map<Long, String> insurItemIdAndNameInStdMap) {
        DynamicObjectCollection subentryentity = stdEntity.getDynamicObjectCollection("subentryentity");
        for (DynamicObject subEntity : subentryentity) {
            if (!HRStringUtils.isNotEmpty((String)subEntity.getString("roundtype"))) continue;
            stdVIdAndInsurItemIdAndRoundTypeInStdTable.put((Object)stdVId, (Object)subEntity.getLong("insuritem.id"), (Object)subEntity.getString("roundtype"));
            if (insurItemIdAndNameInStdMap == null) continue;
            insurItemIdAndNameInStdMap.putIfAbsent(subEntity.getLong("insuritem.id"), subEntity.getString("insuritem.name"));
        }
    }
}

