/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.business.cal.service;

import com.google.common.collect.Lists;
import java.util.List;
import kd.bos.dlock.DLock;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.orm.util.CollectionUtils;
import kd.sit.hcsi.business.cal.errInfo.CalApiResultErrInfoEnum;
import kd.sit.hcsi.business.caladjust.errinfo.HCSIErrInfoEnum;
import kd.sit.sitbp.business.servicehelper.SITShowFormServiceHelper;

public class SinSurCalLaunchMsgHelper {
    public void addMessage(String recordId, CalApiResultErrInfoEnum msg, Object ... param) {
        String msgStr = msg.getErrInfo(param);
        this.addMessage(recordId, msgStr);
    }

    public void addMessage(String recordId, String msg) {
        try (DLock dLock = DLock.create((String)this.lockKey(recordId));){
            dLock.lock();
            String cacheKey = this.cacheKey(recordId);
            IAppCache cache = SinSurCalLaunchMsgHelper.cache();
            List msgList = (List)cache.get(cacheKey, List.class);
            if (msgList == null) {
                msgList = Lists.newArrayList((Object[])new String[]{msg});
            } else {
                msgList.add(msg);
            }
            cache.put(cacheKey, (Object)msgList);
        }
    }

    public void showMessage(String recordId, String operateName, String title, IFormView formView) {
        List<String> messageList = this.findMessage(recordId);
        if (CollectionUtils.isEmpty(messageList)) {
            return;
        }
        FormShowParameter formShowParameter = SITShowFormServiceHelper.getOperationResultParameter((String)operateName, (String)title, messageList);
        formShowParameter.setCustomParam("head", (Object)HCSIErrInfoEnum.CAL_TASK_PRE_CAL_CHECK_TITLE.getErrInfo());
        formView.showForm(formShowParameter);
    }

    public boolean hasMessage(String recordId) {
        return this.findMessage(recordId) != null;
    }

    public List<String> findMessage(String recordId) {
        return (List)SinSurCalLaunchMsgHelper.cache().get(this.cacheKey(recordId), List.class);
    }

    public void clearMessage(String recordId) {
        SinSurCalLaunchMsgHelper.cache().remove(this.cacheKey(recordId));
    }

    private String cacheKey(String recordId) {
        return "SinSurCalLaunchMsgHelper_CK_" + recordId;
    }

    private String lockKey(String recordId) {
        return "SinSurCalLaunchMsgHelper_DL_" + recordId;
    }

    private static IAppCache cache() {
        return AppCache.get((String)"hcsi");
    }
}

