/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.business.cal.service;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.HashBasedTable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.sit.sitbp.business.servicehelper.SITCertCommonHelper;
import kd.sit.sitbp.common.constants.SITBaseConstants;
import kd.sit.sitbp.common.util.SITStringUtils;

public class SocialCalCertService
implements SITBaseConstants {
    private static final Log LOGGER = LogFactory.getLog(SocialCalCertService.class);
    public static Map<String, Integer> INFOLEVELMAP = new HashMap<String, Integer>(4);
    private static final String HCSI_APPID = "2AXKDRPJUQ77";
    private Map<String, Object> resultMap = new HashMap<String, Object>(16);

    public boolean checkCert(DynamicObject[] insuranceFileArray, String formKey) {
        DynamicObject[] certDetails;
        HashBasedTable fileTable = HashBasedTable.create();
        LinkedHashSet<Long> fileIdsWithEmptyPerson = new LinkedHashSet<Long>(insuranceFileArray.length);
        for (DynamicObject insuranceFile : insuranceFileArray) {
            fileTable.put((Object)insuranceFile.getLong("id"), (Object)insuranceFile.getLong("person.personindexid"), (Object)insuranceFile);
            if (insuranceFile.getLong("person.personindexid") != 0L) continue;
            fileIdsWithEmptyPerson.add(insuranceFile.getLong("id"));
        }
        if (!fileIdsWithEmptyPerson.isEmpty()) {
            LOGGER.error("SocialCalCertService.checkCert: hr person is empty, such as {}", (Object)JSON.toJSONString(fileIdsWithEmptyPerson));
        }
        Set personIndexIds = fileTable.columnKeySet();
        ArrayList<Long> existPidList = new ArrayList<Long>(personIndexIds.size());
        try {
            certDetails = SITCertCommonHelper.queryCertDetail((String)HCSI_APPID, (String)formKey, new ArrayList(personIndexIds));
        }
        catch (Exception e) {
            this.buildErrorResultMap(e.getMessage());
            return false;
        }
        for (DynamicObject certDetail : certDetails) {
            existPidList.add(certDetail.getLong("pid"));
        }
        personIndexIds.removeAll(existPidList);
        for (Long pid : personIndexIds) {
            Map fileMap = fileTable.column((Object)pid);
            for (Map.Entry fileEntry : fileMap.entrySet()) {
                DynamicObject file = (DynamicObject)fileEntry.getValue();
                if ("seal".equals(file.getString("sinsurstatus"))) continue;
                String error = MessageFormat.format(ResManager.loadKDString((String)"{0}\uff08{1}\uff09\u8bb8\u53ef\u6821\u9a8c\u5f02\u5e38\uff0c\u65e0\u6cd5\u8ba1\u7b97\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u786e\u8ba4\u8bb8\u53ef\u4fe1\u606f\u3002", (String)"SocialCalCertService_1", (String)"sit-hcsi-business", (Object[])new Object[0]), file.getString("person.name"), file.getString("person.number"));
                this.buildErrorResultMap(error);
                return false;
            }
        }
        try {
            Map calCertResult = SITCertCommonHelper.verifyCert((String)HCSI_APPID, (String)formKey, existPidList);
            return this.handleCheckCertResult(calCertResult);
        }
        catch (Exception e) {
            String error = ResManager.loadKDString((String)"\u8bb8\u53ef\u6821\u9a8c\u5f02\u5e38\uff0c\u65e0\u6cd5\u8ba1\u7b97\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u786e\u8ba4\u8bb8\u53ef\u4fe1\u606f\u3002", (String)"SocialCalCertService_0", (String)"sit-hcsi-business", (Object[])new Object[0]);
            this.buildErrorResultMap(error);
            return false;
        }
    }

    public Map<String, Object> getResultMsg() {
        return this.resultMap;
    }

    private boolean handleCheckCertResult(Map<String, Object> certResult) {
        Map msg = (Map)certResult.get("msg");
        Boolean isForbidden = (Boolean)certResult.get("isforbidden");
        Boolean needShowMessage = Boolean.valueOf((String)msg.get("showMessage"));
        String message = (String)msg.get("message");
        String infoType = (String)msg.get("infoType");
        if (isForbidden.booleanValue()) {
            this.buildResultMap(this.resultMap, msg);
            return false;
        }
        if (needShowMessage.booleanValue()) {
            List messageList;
            int compareResult = this.compareInfoLevel((String)this.resultMap.get("infoType"), infoType);
            if (compareResult < 0) {
                this.buildResultMap(this.resultMap, msg);
            } else if (compareResult == 0 && !(messageList = (List)this.resultMap.getOrDefault("messageList", new ArrayList(10))).contains(message)) {
                messageList.add(message);
                this.resultMap.put("messageList", messageList);
            }
        }
        return true;
    }

    private void buildResultMap(Map<String, Object> resultMap, Map<String, Object> msg) {
        String message = (String)msg.get("message");
        String showMessageType = (String)msg.get("showMessageType");
        String infoType = (String)msg.get("infoType");
        resultMap.put("showMessageType", showMessageType);
        resultMap.put("infoType", infoType);
        ArrayList<String> messageList = new ArrayList<String>(10);
        if (INFOLEVELMAP.get(infoType) > 1) {
            messageList.add(message);
        }
        resultMap.put("messageList", messageList);
    }

    private void buildErrorResultMap(String error) {
        this.resultMap.put("showMessageType", "1");
        this.resultMap.put("infoType", "ERROR");
        ArrayList<String> messageList = new ArrayList<String>(10);
        messageList.add(error);
        this.resultMap.put("messageList", messageList);
    }

    private int compareInfoLevel(String infoType1, String infoType2) {
        Integer infoLevel1 = INFOLEVELMAP.get(infoType1);
        Integer infoLevel2 = INFOLEVELMAP.get(infoType2);
        if (SITStringUtils.isEmpty((String)infoType1) || infoLevel1 == null) {
            return -1;
        }
        if (SITStringUtils.isEmpty((String)infoType2) || infoLevel2 == null) {
            return 1;
        }
        return infoLevel1.compareTo(infoLevel2);
    }

    static {
        INFOLEVELMAP.put("ERROR", 5);
        INFOLEVELMAP.put("FORBIDDEN", 4);
        INFOLEVELMAP.put("EXCEED", 3);
        INFOLEVELMAP.put("WARNING", 2);
        INFOLEVELMAP.put("NORMAL", 1);
    }
}

