/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.business.cal.service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.sit.hcsi.common.entity.cal.InsuredStandard;
import kd.sdk.sit.hcsi.common.entity.cal.InsuredSumItem;
import kd.sit.hcsi.business.cal.SocialInsuranceCalHelper;
import kd.sit.hcsi.business.cal.errInfo.CalApiResultErrInfoEnum;
import kd.sit.sitbp.business.helper.field.GetEntityDataHelper;
import kd.sit.sitbp.business.servicehelper.SITMultithreadedQueryHelper;
import kd.sit.sitbp.common.enums.SitDataTypeEnum;

public class SocialDetailResultService {
    public static final String DATASRC_RESULTCOVER = "R";
    private final Log log = LogFactory.getLog(SocialDetailResultService.class);
    private static final String SELECTPROPERTIES = "id,insuranceitem.id,numvalue,amountvalue,isnull,currency.id,storagetype,datasrc";
    private static final HRBaseServiceHelper SINSUR_FILE_HELPER = new HRBaseServiceHelper("hcsi_sinsurfile");
    private static final HRBaseServiceHelper SINSUR_TASK_HELPER = new HRBaseServiceHelper("hcsi_sinsurtask");
    private static final HRBaseServiceHelper SINSUR_PERSON_HELPER = new HRBaseServiceHelper("hcsi_calperson");

    public static SocialDetailResultService getInstance() {
        return SocialDetailResultServiceHolder.SERVICE;
    }

    public List<InsuredStandard> getInsuredStandardInfo(Long calTaskId, List<Long> insuredStandardVIds) {
        if (CollectionUtils.isEmpty(insuredStandardVIds) || calTaskId == null) {
            return Collections.emptyList();
        }
        HashMap<Long, List<Long>> taskIdAndStandardVIdsInTask = new HashMap<Long, List<Long>>(2);
        taskIdAndStandardVIdsInTask.put(calTaskId, insuredStandardVIds);
        ArrayList<InsuredStandard> itemList = this.getInsuredItemGroupByTaskFormDB(taskIdAndStandardVIdsInTask).get(calTaskId);
        itemList = itemList == null ? new ArrayList<InsuredStandard>(10) : itemList;
        return itemList;
    }

    public List<InsuredStandard> getInsuredItemInfoByCfg(Long calTaskId, List<Long> cfgIdList) {
        if (CollectionUtils.isEmpty(cfgIdList) || calTaskId == null) {
            return Collections.emptyList();
        }
        HashMap<Long, List<Long>> taskIdToCfgIdListMap = new HashMap<Long, List<Long>>(1);
        taskIdToCfgIdListMap.put(calTaskId, cfgIdList);
        return this.getInsuredItemGroupByTaskWithCfgFormDB(taskIdToCfgIdListMap).getOrDefault(calTaskId, Collections.emptyList());
    }

    public Map<Long, List<InsuredStandard>> getInsuredItemGroupByTaskWithCfgFormDB(Map<Long, List<Long>> taskIdToCfgIdListMap) {
        List<Long> cfgVidList = taskIdToCfgIdListMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        Map<Long, List<InsuredStandard>> insuredStandardFromDB = this.getInsuredStandardWithCfgFormDB(cfgVidList);
        return this.combineAndOrderItemByTask(insuredStandardFromDB, taskIdToCfgIdListMap);
    }

    public Map<Long, List<InsuredStandard>> getInsuredItemGroupByTaskFormDB(Map<Long, List<Long>> standardIdGroupByTask) {
        List<Long> insuranceStandardVIds = standardIdGroupByTask.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        Map<Long, List<InsuredStandard>> insuredStandardFormDB = this.getInsuredStandardFormDB(insuranceStandardVIds);
        return this.combineAndOrderItemByTask(insuredStandardFormDB, standardIdGroupByTask);
    }

    private Map<Long, List<InsuredStandard>> combineAndOrderItemByTask(Map<Long, List<InsuredStandard>> insuredStandardFromDB, Map<Long, List<Long>> taskIdToGroupIdListMap) {
        Map<Long, Set<Long>> insuredItemMap = SocialInsuranceCalHelper.getInsuredItemForTsak(taskIdToGroupIdListMap.keySet());
        LinkedHashMap<Long, Map<Long, InsuredStandard>> insuredItemGroupByTask = new LinkedHashMap<Long, Map<Long, InsuredStandard>>(taskIdToGroupIdListMap.size());
        for (Map.Entry<Long, List<Long>> entry : taskIdToGroupIdListMap.entrySet()) {
            HashSet existsItemIds = new HashSet(16);
            Set<Long> effetctiveInsuredItemSet = insuredItemMap.get(entry.getKey());
            List insuredStandards = entry.getValue().stream().flatMap(groupVId -> Optional.ofNullable(insuredStandardFromDB.get(groupVId)).orElseGet(() -> Collections.emptyList()).stream()).filter(insuredStandard -> existsItemIds.add(insuredStandard.getInsuredItemId())).collect(Collectors.toList());
            this.log.info("before filter, item size is {}", (Object)insuredStandards.size());
            insuredStandards.removeIf(insuredStandard -> !CollectionUtils.isEmpty((Collection)effetctiveInsuredItemSet) && !effetctiveInsuredItemSet.contains(insuredStandard.getInsuredItemId()));
            this.log.info("after filter, item size is {}", (Object)insuredStandards.size());
            Map itemDtoGroupByPkId = insuredStandards.stream().collect(Collectors.toMap(InsuredStandard::getInsuredItemId, itemDTO -> itemDTO, (oldVal, newVal) -> oldVal, LinkedHashMap::new));
            insuredItemGroupByTask.put(entry.getKey(), itemDtoGroupByPkId);
        }
        Map<Long, List<InsuredStandard>> orderedInsuredItemGroupByTask = this.orderInsuranceItem(insuredItemGroupByTask);
        this.handleCombineItems(orderedInsuredItemGroupByTask);
        return orderedInsuredItemGroupByTask;
    }

    private Map<Long, List<InsuredStandard>> orderInsuranceItem(Map<Long, Map<Long, InsuredStandard>> insuredItemGroupByTask) {
        Set insureItemIds = insuredItemGroupByTask.values().stream().flatMap(itemDtoGroupByPkId -> Optional.ofNullable(itemDtoGroupByPkId.keySet()).orElseGet(() -> Collections.emptySet()).stream()).collect(Collectors.toSet());
        LinkedHashMap<Long, List<InsuredStandard>> orderedInsuredItemGroupByTask = new LinkedHashMap<Long, List<InsuredStandard>>(16);
        HRBaseServiceHelper helper = new HRBaseServiceHelper("sitbs_insuranceitem");
        DynamicObjectCollection sinsurItemDys = helper.queryOriginalCollection("id", new QFilter("id", "in", insureItemIds).toArray(), "group.number asc,number asc");
        for (DynamicObject sinsurItemDy : sinsurItemDys) {
            for (Map.Entry<Long, Map<Long, InsuredStandard>> entry : insuredItemGroupByTask.entrySet()) {
                InsuredStandard insuredStandard = entry.getValue().get(sinsurItemDy.getLong("id"));
                if (insuredStandard == null) continue;
                orderedInsuredItemGroupByTask.computeIfAbsent(entry.getKey(), key -> new ArrayList(10)).add(insuredStandard);
            }
        }
        return orderedInsuredItemGroupByTask;
    }

    private void handleCombineItems(Map<Long, List<InsuredStandard>> orderedInsuredItemGroupByTask) {
        List<InsuredStandard> sumItemList = SocialInsuranceCalHelper.getInsuredSumItemList();
        for (Map.Entry<Long, List<InsuredStandard>> entry : orderedInsuredItemGroupByTask.entrySet()) {
            ArrayList<InsuredStandard> dataList = new ArrayList<InsuredStandard>(10);
            dataList.addAll(sumItemList);
            dataList.addAll((Collection)entry.getValue());
            entry.setValue(dataList);
        }
    }

    private Map<Long, List<InsuredStandard>> getInsuredStandardWithCfgFormDB(List<Long> cfgIdList) {
        long start = System.currentTimeMillis();
        HRBaseServiceHelper helper = new HRBaseServiceHelper("sitbs_sinsurstdcfg");
        String queryField = "id,number,insurtype.id,rentryentity.insuritem.id,rentryentity.insuritem.number,rentryentity.insuritem.name,rentryentity.insuritem.datatype.id";
        QFilter filter = new QFilter("id", "in", cfgIdList);
        DynamicObjectCollection items = helper.queryOriginalCollection(queryField, new QFilter[]{filter}, "number asc,rentryentity.insuritem.number asc");
        if (CollectionUtils.isEmpty((Collection)items)) {
            return new HashMap<Long, List<InsuredStandard>>(0);
        }
        LinkedHashMap<Long, List<InsuredStandard>> cfgIdToItemListMap = new LinkedHashMap<Long, List<InsuredStandard>>(cfgIdList.size());
        HashSet<Long> allInsurItemIdSet = new HashSet<Long>(cfgIdList.size());
        HashSet<Long> insurTypeIds = new HashSet<Long>(cfgIdList.size());
        for (DynamicObject item : items) {
            allInsurItemIdSet.add(item.getLong("rentryentity.insuritem.id"));
            insurTypeIds.add(item.getLong("insurtype.id"));
        }
        HashMap<Long, Set> insuredItemIdSetMap = new HashMap<Long, Set>(16);
        Map<Long, Integer> insurItemPrecisionMap = SocialDetailResultService.getInsurItemPrecisionMap(allInsurItemIdSet, insurTypeIds);
        for (DynamicObject item : items) {
            Long cfgId = item.getLong("id");
            Long itemId = item.getLong("rentryentity.insuritem.id");
            Set insuredItemIdSet = insuredItemIdSetMap.computeIfAbsent(cfgId, key -> new HashSet(16));
            if (insuredItemIdSet.contains(itemId)) continue;
            insuredItemIdSet.add(itemId);
            List insuredStandardList = cfgIdToItemListMap.computeIfAbsent(cfgId, key -> new ArrayList(10));
            String insuredItemName = item.getString("rentryentity.insuritem.name");
            Long dataTypeId = item.getLong("rentryentity.insuritem.datatype.id");
            InsuredStandard insuredStandard = new InsuredStandard(itemId, insuredItemName, dataTypeId);
            insuredStandard.setScale(insurItemPrecisionMap.get(itemId));
            insuredStandardList.add(insuredStandard);
        }
        this.log.info("getInsuredStandardWithCfgFormDB finish,cost:{} ms", (Object)(System.currentTimeMillis() - start));
        return cfgIdToItemListMap;
    }

    private Map<Long, List<InsuredStandard>> getInsuredStandardFormDB(List<Long> insuredStandardIdList) {
        LinkedHashMap<Long, List<InsuredStandard>> tempMap = new LinkedHashMap<Long, List<InsuredStandard>>(16);
        HRBaseServiceHelper helper = new HRBaseServiceHelper("sitbs_sinsurstd");
        String queryField = "id,number,stdentryentity.insurtype.id,stdentryentity.subentryentity.insuritem.id,stdentryentity.subentryentity.insuritem.name,stdentryentity.subentryentity.insuritem.datatype.id,stdentryentity.subentryentity.registertype.id,stdentryentity.subentryentity.category.id";
        QFilter filter = new QFilter("id", "in", insuredStandardIdList);
        DynamicObjectCollection insuredItemDataCol = helper.queryOriginalCollection(queryField, new QFilter[]{filter}, "stdentryentity.seq asc,stdentryentity.subentryentity.seq asc");
        if (insuredItemDataCol == null) {
            return tempMap;
        }
        HashMap<Long, Set> insuredItemIdMap = new HashMap<Long, Set>(16);
        Set<Long> allInsurItemIdSet = insuredItemDataCol.stream().map(insuredItemData -> insuredItemData.getLong("stdentryentity.subentryentity.insuritem.id")).collect(Collectors.toSet());
        Set<Long> insurTypeIds = insuredItemDataCol.stream().map(insuredItemData -> insuredItemData.getLong("stdentryentity.insurtype.id")).collect(Collectors.toSet());
        Map<Long, Integer> insurItemPrecisionMap = SocialDetailResultService.getInsurItemPrecisionMap(allInsurItemIdSet, insurTypeIds);
        for (DynamicObject insuredItemData2 : insuredItemDataCol) {
            Long insuredStandardId = insuredItemData2.getLong("id");
            List tempList = tempMap.getOrDefault(insuredStandardId, new ArrayList(10));
            Long insuredItemId = insuredItemData2.getLong("stdentryentity.subentryentity.insuritem.id");
            Set insuredItemIdSet = insuredItemIdMap.getOrDefault(insuredStandardId, new HashSet(16));
            if (insuredItemIdSet.contains(insuredItemId)) continue;
            String insuredItemName = insuredItemData2.getString("stdentryentity.subentryentity.insuritem.name");
            Long dataTypeId = insuredItemData2.getLong("stdentryentity.subentryentity.insuritem.datatype.id");
            InsuredStandard insuredStandard = new InsuredStandard(insuredItemId, insuredItemName, dataTypeId);
            insuredStandard.setScale(insurItemPrecisionMap.get(insuredItemId));
            tempList.add(insuredStandard);
            insuredItemIdSet.add(insuredItemId);
            insuredItemIdMap.put(insuredStandardId, insuredItemIdSet);
            tempMap.put(insuredStandardId, tempList);
        }
        return tempMap;
    }

    public void inputDetailResultToDetailCol(DynamicObjectCollection detailDataCol, List<InsuredStandard> insuredStandardList, String entityName, Map<Integer, Set<String>> resultCoverMap) {
        if (detailDataCol == null || detailDataCol.size() == 0) {
            return;
        }
        Map<Long, DynamicObject> detailIdDetailMap = detailDataCol.stream().collect(Collectors.toMap(detail -> detail.getLong("id"), detail -> detail));
        HashSet<Long> insuredItemIdSet = new HashSet<Long>(insuredStandardList.size());
        HashSet<Long> sumItemIdSet = new HashSet<Long>(insuredStandardList.size());
        for (InsuredStandard item : insuredStandardList) {
            insuredItemIdSet.add(item.getInsuredItemId());
            if (!"2".equals(item.getType())) continue;
            sumItemIdSet.add(item.getInsuredItemId());
        }
        long startTime = System.currentTimeMillis();
        DynamicObject[] resultCol = this.getDetailResultFormMultiThread(new ArrayList<Long>(detailIdDetailMap.keySet()), entityName);
        this.log.info("get result finish,cost:{} ms", (Object)(System.currentTimeMillis() - startTime));
        startTime = System.currentTimeMillis();
        QFilter sumItemFilter = new QFilter("id", "in", sumItemIdSet);
        List<InsuredSumItem> sumItemList = SocialInsuranceCalHelper.getSumItemList(sumItemFilter);
        for (DynamicObject result : resultCol) {
            this.buildDetailResult(sumItemList, detailIdDetailMap, insuredItemIdSet, result, resultCoverMap);
        }
        this.log.info("build result finish,cost:{} ms", (Object)(System.currentTimeMillis() - startTime));
    }

    private DynamicObject[] getDetailResultFormMultiThread(List<Long> detailIdList, String entityName) {
        try {
            return SITMultithreadedQueryHelper.getInstance().getData(entityName, SELECTPROPERTIES, detailIdList, "");
        }
        catch (InterruptedException e) {
            this.log.error((Throwable)e);
            return new DynamicObject[0];
        }
    }

    private void buildDetailResult(List<InsuredSumItem> sumItemList, Map<Long, DynamicObject> detailIdDetailMap, Set<Long> insuredItemIdSet, DynamicObject result, Map<Integer, Set<String>> resultCoverMap) {
        Long detailId = result.getLong("id");
        DynamicObject detailDy = detailIdDetailMap.get(detailId);
        if (detailDy == null) {
            return;
        }
        int seq = detailDy.getInt("fseq") - 1;
        Set<String> itemIdSet = resultCoverMap.get(seq);
        if (itemIdSet == null) {
            itemIdSet = new HashSet<String>(16);
            resultCoverMap.put(seq, itemIdSet);
        }
        DynamicObjectCollection resultCol = result.getDynamicObjectCollection("entryentity");
        for (DynamicObject itemResult : resultCol) {
            Long insuranceItemId = itemResult.getLong("insuranceitem.id");
            if (!insuredItemIdSet.contains(insuranceItemId) || itemResult.getBoolean("isnull")) continue;
            String storageType = itemResult.getString("storagetype");
            Object value = "number".equals(storageType) ? itemResult.get("numvalue") : itemResult.get("amountvalue");
            detailDy.set(String.valueOf(insuranceItemId), value);
            if (!DATASRC_RESULTCOVER.equals(itemResult.getString("datasrc"))) continue;
            itemIdSet.add(String.valueOf(insuranceItemId));
        }
        SocialInsuranceCalHelper.assembleSumItemData(sumItemList, null, detailDy, resultCol, "1");
    }

    public static Map<Long, Integer> getInsurItemPrecisionMap(Set<Long> allInsurItemIdSet, Collection<Long> insurTypeIds) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("sitbs_welfaretype");
        QFilter filter = new QFilter("id", "in", insurTypeIds);
        filter.and("enable", "=", (Object)"1");
        filter.and("status", "=", (Object)"C");
        DynamicObjectCollection insurTypeInfoColl = helper.queryOriginalCollection("id, name, number, currency.amtprecision", filter.toArray(), "number asc");
        Map<Long, Integer> insurTypeIdAndCurrencyMap = insurTypeInfoColl.stream().collect(Collectors.toMap(insurTypeDy -> insurTypeDy.getLong("id"), insurTypeDy -> insurTypeDy.getInt("currency.amtprecision")));
        DynamicObjectCollection insurItemInfoDyColl = SocialDetailResultService.queryInsurItemInfoById(allInsurItemIdSet, null);
        LinkedHashMap<Long, Integer> insurItemPrecisionMap = new LinkedHashMap<Long, Integer>(insurItemInfoDyColl.size());
        for (DynamicObject insurItemInfoDy : insurItemInfoDyColl) {
            int precision = SitDataTypeEnum.AMOUNT.getId() == insurItemInfoDy.getLong("datatype.id") ? insurTypeIdAndCurrencyMap.getOrDefault(insurItemInfoDy.getLong("group"), 0).intValue() : insurItemInfoDy.getInt("dataprecision.scale");
            insurItemPrecisionMap.put(insurItemInfoDy.getLong("id"), precision);
        }
        return insurItemPrecisionMap;
    }

    private static DynamicObjectCollection queryInsurItemInfoById(Collection<Long> insurItemIds, Long countryId) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("sitbs_insuranceitem");
        QFilter filter = new QFilter("id", "in", insurItemIds);
        filter.and("country.id", "=", (Object)1000001L);
        String selectFields = "id, group,insurancetypeattr.id,insurancetypeattr.name,insurancetypeattr.number,datatype.id,datatype.number,dataprecision.id,dataprecision.number,dataprecision.scale";
        return helper.queryOriginalCollection(selectFields, filter.toArray());
    }

    public ApiResult getSocInsurancePersons(Collection<Long> periodIds, Collection<Long> sinsurFileIds, String selectFields) {
        HashSet sinsurFileIdSet;
        HashSet periodIdSet = periodIds == null ? new HashSet(0) : (Set)periodIds.stream().filter(Objects::nonNull).collect(Collectors.toCollection(LinkedHashSet::new));
        Set set = sinsurFileIdSet = sinsurFileIds == null ? new HashSet(0) : (Set)sinsurFileIds.stream().filter(Objects::nonNull).collect(Collectors.toCollection(LinkedHashSet::new));
        if (periodIdSet.isEmpty() || sinsurFileIdSet.isEmpty() || HRStringUtils.isEmpty((String)selectFields)) {
            return ApiResult.fail((String)CalApiResultErrInfoEnum.PARAMS_ERROR_OF_QUERY_PERSON.getErrInfo());
        }
        if (periodIdSet.size() > 1000 || sinsurFileIdSet.size() > 1000) {
            return ApiResult.fail((String)CalApiResultErrInfoEnum.PERIOD_ID_OR_SINSUR_FILE_ID_MORE_THAN_1000.getErrInfo());
        }
        QFilter filter = new QFilter("sinsurperiod.id", "in", periodIdSet);
        filter.and("sinsurfilev.id", "in", sinsurFileIdSet);
        List entityData = GetEntityDataHelper.getEntityData((String)"hcsi_calperson", (String)selectFields, (QFilter)filter, (String)"sinsurtask.id asc");
        return ApiResult.success((Object)entityData);
    }

    /*
     * Exception decompiling
     */
    public Map<Long, BigDecimal> getSumValue(List<QFilter> qFilters) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static class SocialDetailResultServiceHolder {
        private static final SocialDetailResultService SERVICE = new SocialDetailResultService();

        private SocialDetailResultServiceHolder() {
        }
    }
}

