/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.business.cal.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.api.ApiResult;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sit.hcsi.business.cal.SocialInsuranceCalHelper;
import kd.sit.hcsi.business.cal.errInfo.CalApiResultErrInfoEnum;
import kd.sit.hcsi.business.cal.service.AbsCalService;
import kd.sit.sitbp.business.servicehelper.MutexServiceHelper;
import kd.sit.sitbp.common.entity.social.PreCalCfgDTO;
import kd.sit.sitbp.common.util.BaseResult;
import kd.sit.sitbp.common.util.SITStringUtils;

public class SocialInsuranceCalFilterHelper {
    private static final Log log = LogFactory.getLog(AbsCalService.class);
    private static final HRBaseServiceHelper PERIOD_HELPER = new HRBaseServiceHelper("sitbs_sinsurperiod");
    private static final HRBaseServiceHelper INSURED_COMPANY_HELPER = new HRBaseServiceHelper("sitbs_welfarepayer");
    private static final HRBaseServiceHelper INSURED_TASK_HELPER = new HRBaseServiceHelper("hcsi_sinsurtask");

    private SocialInsuranceCalFilterHelper() {
    }

    public static void setApiResult(ApiResult apiResult, String errMsg, CalApiResultErrInfoEnum calApiResultErrInfoEnum, String errorLevelError, Long periodId, Long insuredCompanyId) {
        JSONObject detailInfo = SocialInsuranceCalFilterHelper.getDetailErrorInfo(calApiResultErrInfoEnum.getErrCode(), errMsg, errorLevelError, periodId, insuredCompanyId);
        SocialInsuranceCalFilterHelper.setApiResult(apiResult, detailInfo);
    }

    public static JSONObject getDetailErrorInfo(String errorCode, String errorMsg, String errorLevel, Long periodId, Long companyId) {
        return SocialInsuranceCalFilterHelper.getDetailErrorInfo(errorCode, Collections.singletonList(errorMsg), errorLevel, periodId, companyId);
    }

    public static JSONObject getDetailErrorInfo(String errorCode, List<String> errorMsgs, String errorLevel, Long periodId, Long companyId) {
        JSONObject detailInfo = new JSONObject();
        detailInfo.put("errorCode", (Object)errorCode);
        detailInfo.put("errorMsgs", errorMsgs);
        detailInfo.put("errorLevel", (Object)errorLevel);
        detailInfo.put("periodId", (Object)periodId);
        detailInfo.put("companyId", (Object)companyId);
        return detailInfo;
    }

    private static void setApiResult(ApiResult apiResult, JSONObject detailInfo) {
        apiResult.setSuccess(false);
        apiResult.setMessage("");
        apiResult.setErrorCode("fail");
        JSONObject data = (JSONObject)apiResult.getData();
        if (data == null) {
            data = new JSONObject();
        }
        apiResult.setData((Object)data);
        JSONArray errInfo = data.getJSONArray("errInfo");
        if (errInfo == null) {
            errInfo = new JSONArray(10);
        }
        errInfo.add((Object)detailInfo);
        data.put("errInfo", (Object)errInfo);
    }

    public static void filterValidPeriods(String calType, Collection<Long> periodIds, Map<Long, DynamicObject> periodIdAndInfoMap, ApiResult apiResult) {
        if (CollectionUtils.isEmpty(periodIds)) {
            return;
        }
        QFilter filter = new QFilter("id", "in", periodIds);
        SocialInsuranceCalFilterHelper.filterEnableAndAuditedData(calType, filter);
        filter.and("periodtype", "=", (Object)1010L);
        DynamicObject[] periodDys = PERIOD_HELPER.loadDynamicObjectArray(filter.toArray());
        Arrays.stream(periodDys).forEach(periodDy -> periodIdAndInfoMap.put(periodDy.getLong("id"), (DynamicObject)periodDy));
        HashSet<Long> invalidPeriodIdSet = new HashSet<Long>(periodIds.size());
        invalidPeriodIdSet.addAll(periodIds);
        invalidPeriodIdSet.removeAll(periodIdAndInfoMap.keySet());
        periodIds.removeAll(invalidPeriodIdSet);
        if (!"2".equals(calType) && !invalidPeriodIdSet.isEmpty()) {
            invalidPeriodIdSet.forEach(periodId -> {
                JSONObject detailInfo = SocialInsuranceCalFilterHelper.getDetailErrorInfo(CalApiResultErrInfoEnum.PERIOD_ID_INVALID.getErrCode(), CalApiResultErrInfoEnum.PERIOD_ID_INVALID.getErrInfo(), "error", periodId, null);
                SocialInsuranceCalFilterHelper.setApiResult(apiResult, detailInfo);
            });
        }
    }

    private static void filterEnableAndAuditedData(String calType, QFilter filter) {
        if (!"3".equals(calType)) {
            filter.and("enable", "=", (Object)"1");
            filter.and("status", "=", (Object)"C");
        }
    }

    public static void filterValidInsuredCompanies(String calType, Collection<Long> insureCompanyIds, Map<Long, DynamicObject> insureCompanyIdAndInfoMap, ApiResult apiResult) {
        if (CollectionUtils.isEmpty(insureCompanyIds)) {
            return;
        }
        QFilter filter = new QFilter("id", "in", insureCompanyIds);
        SocialInsuranceCalFilterHelper.filterEnableAndAuditedData(calType, filter);
        DynamicObject[] insuredCompanyDys = INSURED_COMPANY_HELPER.loadDynamicObjectArray(filter.toArray());
        Arrays.stream(insuredCompanyDys).forEach(insuredCompanyDy -> insureCompanyIdAndInfoMap.put(insuredCompanyDy.getLong("id"), (DynamicObject)insuredCompanyDy));
        HashSet<Long> invalidCompanyIdSet = new HashSet<Long>(insureCompanyIds.size());
        invalidCompanyIdSet.addAll(insureCompanyIds);
        invalidCompanyIdSet.removeAll(insureCompanyIdAndInfoMap.keySet());
        insureCompanyIds.removeAll(invalidCompanyIdSet);
        if (!"2".equals(calType) && !invalidCompanyIdSet.isEmpty()) {
            invalidCompanyIdSet.forEach(insureCompanyId -> {
                JSONObject detailInfo = SocialInsuranceCalFilterHelper.getDetailErrorInfo(CalApiResultErrInfoEnum.COMPANY_ID_ERROR.getErrCode(), CalApiResultErrInfoEnum.COMPANY_ID_ERROR.getErrInfo(), "error", null, insureCompanyId);
                SocialInsuranceCalFilterHelper.setApiResult(apiResult, detailInfo);
            });
        }
    }

    public static void filterValidWelfareTypes(String calType, Map<String, Object> extendParams, Collection<Long> periodIds, Collection<Long> insureCompanyIds, ApiResult apiResult) {
        Set welfareTypeIdSet = (Set)extendParams.get("welfaretype");
        if (!CollectionUtils.isEmpty((Collection)welfareTypeIdSet)) {
            QFilter filter = new QFilter("id", "in", (Object)welfareTypeIdSet);
            SocialInsuranceCalFilterHelper.filterEnableAndAuditedData(calType, filter);
            HRBaseServiceHelper welfareTypeHelper = new HRBaseServiceHelper("sitbs_welfaretype");
            DynamicObjectCollection welfareTypes = welfareTypeHelper.queryOriginalCollection("id", filter.toArray());
            Set existWelfareTypeIdSet = welfareTypes.stream().map(welfareType -> welfareType.getLong("id")).collect(Collectors.toSet());
            welfareTypeIdSet.clear();
            welfareTypeIdSet.addAll(existWelfareTypeIdSet);
        }
        if (CollectionUtils.isEmpty((Collection)welfareTypeIdSet)) {
            for (Long periodId : periodIds) {
                for (Long insureCompanyId : insureCompanyIds) {
                    JSONObject detailInfo = SocialInsuranceCalFilterHelper.getDetailErrorInfo(CalApiResultErrInfoEnum.WELFARE_TYPE_INVALID.getErrCode(), CalApiResultErrInfoEnum.WELFARE_TYPE_INVALID.getErrInfo(), "error", periodId, insureCompanyId);
                    SocialInsuranceCalFilterHelper.setApiResult(apiResult, detailInfo);
                }
            }
        }
    }

    public static void filterPeriodAndCompanyForTask(Map<Long, DynamicObject> periodIdAndInfoMap, Map<Long, DynamicObject> insureCompanyIdAndInfoMap, Table<Long, Long, List<DynamicObject>> periodIdAndCompanyIdTable, Table<Long, Long, List<DynamicObject>> periodIdAndCompanyIdToHisFileMap, String calType, ApiResult apiResult, Set<Long> welfareTypeIdSet) {
        if (periodIdAndInfoMap.isEmpty() || insureCompanyIdAndInfoMap.isEmpty() || SITStringUtils.isEmpty((String)calType)) {
            return;
        }
        HashBasedTable taskTable = HashBasedTable.create();
        if ("1".equals(calType)) {
            SocialInsuranceCalFilterHelper.tryCreateCalTaskForPRC(periodIdAndInfoMap, insureCompanyIdAndInfoMap, welfareTypeIdSet, periodIdAndCompanyIdTable, periodIdAndCompanyIdToHisFileMap, apiResult);
        } else if ("3".equals(calType)) {
            List<String> numberList;
            Table<Long, Long, List<DynamicObject>> periodIdCompanyIdAndTaskDyTable = SocialInsuranceCalFilterHelper.getInsurTasksBy(periodIdAndInfoMap.keySet(), insureCompanyIdAndInfoMap.keySet());
            for (Map.Entry<Long, DynamicObject> periodEntry : periodIdAndInfoMap.entrySet()) {
                for (Map.Entry<Long, DynamicObject> companyEntry : insureCompanyIdAndInfoMap.entrySet()) {
                    List insurTaskDys = (List)periodIdCompanyIdAndTaskDyTable.get((Object)periodEntry.getKey(), (Object)companyEntry.getKey());
                    if (CollectionUtils.isEmpty((Collection)insurTaskDys)) {
                        numberList = (List)taskTable.get((Object)periodEntry.getKey(), (Object)companyEntry.getKey());
                        if (numberList == null) {
                            numberList = new ArrayList<String>(10);
                            taskTable.put((Object)periodEntry.getKey(), (Object)companyEntry.getKey(), numberList);
                        }
                        numberList.add("");
                        continue;
                    }
                    SocialInsuranceCalFilterHelper.getTaskList(periodIdAndCompanyIdTable, periodEntry, companyEntry, insurTaskDys);
                }
            }
            CalApiResultErrInfoEnum calApiResultErrInfoEnum = CalApiResultErrInfoEnum.NOT_EXISTS_TASK_FOR_PERIOD_AND_COMPANY_COMBINED;
            for (Table.Cell periodAndCompanyCombinedCell : taskTable.cellSet()) {
                String periodName = periodIdAndInfoMap.get(periodAndCompanyCombinedCell.getRowKey()).getString("name");
                String insuredCompanyName = insureCompanyIdAndInfoMap.get(periodAndCompanyCombinedCell.getColumnKey()).getString("name");
                numberList = (ArrayList<String>)periodAndCompanyCombinedCell.getValue();
                if (CollectionUtils.isEmpty((Collection)numberList)) continue;
                for (String number : numberList) {
                    String errMsg = calApiResultErrInfoEnum.getErrInfo(periodName, insuredCompanyName, number);
                    SocialInsuranceCalFilterHelper.setApiResult(apiResult, errMsg, calApiResultErrInfoEnum, "error", (Long)periodAndCompanyCombinedCell.getRowKey(), (Long)periodAndCompanyCombinedCell.getColumnKey());
                }
            }
        }
    }

    private static void getTaskList(Table<Long, Long, List<DynamicObject>> periodIdAndCompanyIdTable, Map.Entry<Long, DynamicObject> periodEntry, Map.Entry<Long, DynamicObject> companyEntry, List<DynamicObject> insurTaskDys) {
        for (DynamicObject insurTaskDy : insurTaskDys) {
            ArrayList<DynamicObject> taskList = (ArrayList<DynamicObject>)periodIdAndCompanyIdTable.get((Object)periodEntry.getKey(), (Object)companyEntry.getKey());
            if (taskList == null) {
                taskList = new ArrayList<DynamicObject>(10);
                periodIdAndCompanyIdTable.put((Object)periodEntry.getKey(), (Object)companyEntry.getKey(), taskList);
            }
            taskList.add(insurTaskDy);
        }
    }

    private static void tryCreateCalTaskForPRC(Map<Long, DynamicObject> periodIdAndInfoMap, Map<Long, DynamicObject> insureCompanyIdAndInfoMap, Set<Long> welfareTypeIdSet, Table<Long, Long, List<DynamicObject>> periodIdAndCompanyIdTable, Table<Long, Long, List<DynamicObject>> periodIdAndCompanyIdToHisFileMap, ApiResult apiResult) {
        DynamicObject[] insuranceTaskDys;
        ArrayList<Long> calTaskIdList = new ArrayList<Long>(10);
        try (TXHandle txHandle = TX.required();){
            try {
                for (Map.Entry<Long, DynamicObject> periodEntry : periodIdAndInfoMap.entrySet()) {
                    Date periodEndDate = SocialInsuranceCalHelper.getDayDate(periodEntry.getValue().getDate("enddate"));
                    for (Map.Entry<Long, DynamicObject> companyEntry : insureCompanyIdAndInfoMap.entrySet()) {
                        List fileList = (List)periodIdAndCompanyIdToHisFileMap.get((Object)periodEntry.getKey(), (Object)companyEntry.getKey());
                        if (CollectionUtils.isEmpty((Collection)fileList)) {
                            String errMsg = CalApiResultErrInfoEnum.NOT_EXISTS_FILE_FOR_PERIOD_AND_COMPANY_COMBINED.getErrInfo(companyEntry.getValue().getString("name"), periodEntry.getValue().getString("name"));
                            SocialInsuranceCalFilterHelper.setApiResult(apiResult, errMsg, CalApiResultErrInfoEnum.NOT_EXISTS_FILE_FOR_PERIOD_AND_COMPANY_COMBINED, "error", periodEntry.getKey(), companyEntry.getKey());
                            continue;
                        }
                        HashSet<String> errorNameSet = new HashSet<String>(16);
                        Map<Long, PreCalCfgDTO> preCalCfgDTOMap = SocialInsuranceCalHelper.getPreCalCfgDTOMap(fileList, periodEndDate, errorNameSet);
                        if (preCalCfgDTOMap.size() == 0) {
                            StringBuilder welfarePayerNameBuilder = new StringBuilder();
                            errorNameSet.forEach(errorName -> {
                                if (welfarePayerNameBuilder.length() > 0) {
                                    welfarePayerNameBuilder.append('\u3001');
                                }
                                welfarePayerNameBuilder.append((String)errorName);
                            });
                            String errMsg = CalApiResultErrInfoEnum.NOT_EXISTS_STANDARD_FOR_PERIOD_AND_COMPANY_COMBINED.getErrInfo(welfarePayerNameBuilder.toString(), periodEntry.getValue().getString("name"));
                            SocialInsuranceCalFilterHelper.setApiResult(apiResult, errMsg, CalApiResultErrInfoEnum.NOT_EXISTS_STANDARD_FOR_PERIOD_AND_COMPANY_COMBINED, "error", periodEntry.getKey(), companyEntry.getKey());
                            continue;
                        }
                        DynamicObject calTaskDy = SocialInsuranceCalHelper.checkAndCreateTask(companyEntry.getValue(), 0, periodEntry.getValue(), welfareTypeIdSet, apiResult, null);
                        if (calTaskDy == null) continue;
                        calTaskIdList.add(calTaskDy.getLong("id"));
                    }
                }
            }
            catch (Exception exception) {
                txHandle.markRollback();
                periodIdAndCompanyIdTable.clear();
            }
        }
        QFilter qFilter = new QFilter("id", "in", calTaskIdList);
        for (DynamicObject insuranceTask : insuranceTaskDys = INSURED_TASK_HELPER.loadDynamicObjectArray(qFilter.toArray())) {
            Long sinsurPeriodId = insuranceTask.getLong("sinsurperiod.id");
            Long welfarePayerId = insuranceTask.getLong("welfarepayer.id");
            ArrayList<DynamicObject> calTaskList = new ArrayList<DynamicObject>(1);
            calTaskList.add(insuranceTask);
            periodIdAndCompanyIdTable.put((Object)sinsurPeriodId, (Object)welfarePayerId, calTaskList);
            SocialInsuranceCalFilterHelper.addMutexLock(sinsurPeriodId, welfarePayerId, insuranceTask.getLong("id"), "donothing_launchcal", apiResult);
        }
    }

    public static Set<Long> filterCallingTask(Table<Long, Long, List<DynamicObject>> periodIdAndCompanyIdTaskTable, ApiResult apiResult) {
        HashSet<Long> invalidTaskIds = new HashSet<Long>(10);
        Iterator iterator = periodIdAndCompanyIdTaskTable.cellSet().iterator();
        while (iterator.hasNext()) {
            Table.Cell periodIdAndCompanyIdTaskCell = (Table.Cell)iterator.next();
            List taskDys = (List)periodIdAndCompanyIdTaskCell.getValue();
            if (CollectionUtils.isEmpty((Collection)taskDys)) continue;
            Iterator taskIterator = taskDys.iterator();
            while (taskIterator.hasNext()) {
                DynamicObject taskDy = (DynamicObject)taskIterator.next();
                if (!"1".equals(taskDy.getString("taskstatus"))) continue;
                SocialInsuranceCalFilterHelper.setApiResult(apiResult, CalApiResultErrInfoEnum.CAL_TASK_CLOSED.getErrInfo(taskDy.getString("number")), CalApiResultErrInfoEnum.CAL_TASK_CLOSED, "error", (Long)periodIdAndCompanyIdTaskCell.getRowKey(), (Long)periodIdAndCompanyIdTaskCell.getColumnKey());
                invalidTaskIds.add(taskDy.getLong("id"));
                taskIterator.remove();
            }
            if (!CollectionUtils.isEmpty((Collection)taskDys)) continue;
            iterator.remove();
        }
        return invalidTaskIds;
    }

    public static Table<Long, Long, List<DynamicObject>> getInsurTasksBy(Collection<Long> periodIds, Collection<Long> insureCompanyIds) {
        DynamicObject[] insuranceTaskDys;
        HashBasedTable periodIdCompanyIdAndTaskDyTable = HashBasedTable.create();
        QFilter qFilter = new QFilter("welfarepayer", "in", insureCompanyIds);
        qFilter.and("sinsurperiod", "in", periodIds);
        for (DynamicObject insuranceTaskDy : insuranceTaskDys = INSURED_TASK_HELPER.loadDynamicObjectArray(qFilter.toArray())) {
            ArrayList<DynamicObject> taskList = (ArrayList<DynamicObject>)periodIdCompanyIdAndTaskDyTable.get((Object)insuranceTaskDy.getLong("sinsurperiod.id"), (Object)insuranceTaskDy.getLong("welfarepayer.id"));
            if (taskList == null) {
                taskList = new ArrayList<DynamicObject>(10);
                periodIdCompanyIdAndTaskDyTable.put((Object)insuranceTaskDy.getLong("sinsurperiod.id"), (Object)insuranceTaskDy.getLong("welfarepayer.id"), taskList);
            }
            taskList.add(insuranceTaskDy);
        }
        return periodIdCompanyIdAndTaskDyTable;
    }

    public static boolean checkCertValid(Table<Long, Long, List<DynamicObject>> periodIdAndCompanyIdTaskDyTable, Map<String, Object> resultMap, ApiResult apiResult, CalApiResultErrInfoEnum calApiResultErrInfoEnum) {
        boolean valid;
        List errMsgs = resultMap == null ? null : (List)resultMap.get("messageList");
        boolean bl = valid = periodIdAndCompanyIdTaskDyTable == null || periodIdAndCompanyIdTaskDyTable.isEmpty() || resultMap == null || CollectionUtils.isEmpty((Collection)errMsgs) || calApiResultErrInfoEnum == null;
        if (valid) {
            return true;
        }
        String errorLevel = "1".equals(resultMap.get("showMessageType")) ? "error" : "tips";
        for (Table.Cell periodIdAndCompanyCell : periodIdAndCompanyIdTaskDyTable.cellSet()) {
            JSONObject detailInfo = SocialInsuranceCalFilterHelper.getDetailErrorInfo(calApiResultErrInfoEnum.getErrCode(), errMsgs, errorLevel, (Long)periodIdAndCompanyCell.getRowKey(), (Long)periodIdAndCompanyCell.getColumnKey());
            SocialInsuranceCalFilterHelper.setApiResult(apiResult, detailInfo);
        }
        resultMap.clear();
        return CollectionUtils.isEmpty((Collection)errMsgs);
    }

    public static boolean checkStandardValid(String taskNumber, PreCalCfgDTO preCalCfgDTO, DynamicObject periodDy, DynamicObject insuredCompanyDy, ApiResult apiResult) {
        if (preCalCfgDTO == null || preCalCfgDTO.getInsuredStandardMap() == null || preCalCfgDTO.getInsuredStandardMap().isEmpty()) {
            String errMsg;
            CalApiResultErrInfoEnum calApiResultErrInfoEnum;
            if (HRStringUtils.isNotEmpty((String)taskNumber)) {
                calApiResultErrInfoEnum = CalApiResultErrInfoEnum.NOT_EXISTS_STANDARD_FOR_TASK;
                errMsg = calApiResultErrInfoEnum.getErrInfo(taskNumber, insuredCompanyDy.getString("name"), periodDy.getString("name"));
            } else {
                calApiResultErrInfoEnum = CalApiResultErrInfoEnum.NOT_EXISTS_STANDARD_FOR_PERIOD_AND_COMPANY_COMBINED;
                errMsg = calApiResultErrInfoEnum.getErrInfo(insuredCompanyDy.getString("name"), periodDy.getString("name"));
            }
            SocialInsuranceCalFilterHelper.setApiResult(apiResult, errMsg, calApiResultErrInfoEnum, "error", periodDy.getLong("id"), insuredCompanyDy.getLong("id"));
            return false;
        }
        return true;
    }

    public static void setApiResultForFile(DynamicObject taskDy, ApiResult apiResult) {
        String errMsg;
        CalApiResultErrInfoEnum calApiResultErrInfoEnum;
        DynamicObject periodDy = taskDy.getDynamicObject("sinsurperiod");
        DynamicObject insuredCompanyDy = taskDy.getDynamicObject("welfarepayer");
        String taskNumber = taskDy.getString("number");
        if (HRStringUtils.isEmpty((String)taskNumber)) {
            calApiResultErrInfoEnum = CalApiResultErrInfoEnum.NOT_EXISTS_FILE_FOR_PERIOD_AND_COMPANY_COMBINED;
            errMsg = calApiResultErrInfoEnum.getErrInfo(insuredCompanyDy.getString("name"), periodDy.getString("name"));
        } else {
            calApiResultErrInfoEnum = CalApiResultErrInfoEnum.NOT_EXISTS_FILE_FOR_TASK;
            errMsg = calApiResultErrInfoEnum.getErrInfo(taskNumber, insuredCompanyDy.getString("name"), periodDy.getString("name"));
        }
        SocialInsuranceCalFilterHelper.setApiResult(apiResult, errMsg, calApiResultErrInfoEnum, "error", periodDy.getLong("id"), insuredCompanyDy.getLong("id"));
    }

    public static void setApiResultForCodeRule(DynamicObject taskDy, ApiResult apiResult, String codeRuleInfo) {
        if (taskDy != null && apiResult != null && codeRuleInfo != null) {
            DynamicObject periodDy = taskDy.getDynamicObject("sinsurperiod");
            DynamicObject insuredCompanyDy = taskDy.getDynamicObject("welfarepayer");
            JSONObject detailInfo = SocialInsuranceCalFilterHelper.getDetailErrorInfo(CalApiResultErrInfoEnum.CODE_RULE_GEN_ERROR.getErrCode(), codeRuleInfo, "error", (Long)periodDy.getLong("id"), (Long)insuredCompanyDy.getLong("id"));
            SocialInsuranceCalFilterHelper.setApiResult(apiResult, detailInfo);
        }
    }

    public static boolean addMutexLock(Long periodId, Long insuredCompanyId, Long taskId, String opKey, ApiResult apiResult) {
        BaseResult require = MutexServiceHelper.require((String)"hcsi_sinsurtask", (String)String.valueOf(taskId), (String)opKey);
        if (!require.isSuccess()) {
            log.info("SocialInsuranceCalFilterHelper.addMutexLock: Mutex error, taskId is {}", (Object)taskId);
            SocialInsuranceCalFilterHelper.setApiResult(apiResult, require.getMessage(), CalApiResultErrInfoEnum.EXISTS_MUTEX_LOCK, "tips", periodId, insuredCompanyId);
        }
        return !require.isSuccess();
    }

    public static IFormView getCurrView(String pageId) {
        if (SITStringUtils.isNotEmpty((String)pageId)) {
            SessionManager sm = SessionManager.getCurrent();
            sm.setRequestThread(true);
            return sm.getView(pageId);
        }
        return null;
    }
}

