/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.business.cal.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sit.hcsi.business.cal.SocialInsuranceCalHelper;
import kd.sit.hcsi.business.cal.SocialTaskAuditOrUnauditService;
import kd.sit.hcsi.business.cal.SocialTaskAuditProgressDTO;
import kd.sit.hcsi.business.cal.service.AbsCalService;
import kd.sit.hcsi.business.cal.service.CalServiceImplForCalPersonViewUpdate;
import kd.sit.hcsi.business.cal.service.CalServiceImplForRpcAdd;
import kd.sit.hcsi.business.cal.service.CalServiceImplForRpcUpdate;
import kd.sit.hcsi.business.cal.service.CalServiceImplForViewUpdate;
import kd.sit.hcsi.business.cal.service.ICalService;
import kd.sit.hcsi.business.caladjust.errinfo.HCSIErrInfoEnum;
import kd.sit.hcsi.common.enums.SocialOperationEnum;
import kd.sit.sitbp.business.servicehelper.MutexServiceHelper;
import kd.sit.sitbp.common.cache.ISITAppCache;
import kd.sit.sitbp.common.cache.SITAppCache;
import kd.sit.sitbp.common.util.BaseResult;
import kd.sit.sitbp.common.util.SITStringUtils;

public class SocialInsuranceCalService {
    private static final Log log = LogFactory.getLog(SocialInsuranceCalService.class);
    private static final String CAN_AUDIT = "can_audit";
    private static final HRBaseServiceHelper SINSUR_TASK_HELPER = new HRBaseServiceHelper("hcsi_sinsurtask");
    private static final HRBaseServiceHelper CAL_PERSON_HELPER = new HRBaseServiceHelper("hcsi_calperson");

    public static ICalService calServiceFactory(String pageId, Set<Long> periodIdSet, Set<Long> insuredCompanyIdSet, String calType, Set<Long> taskIds, Map<String, Object> extendParams) {
        AbsCalService absCalService = null;
        if (HRStringUtils.isEmpty((String)calType)) {
            return absCalService;
        }
        switch (calType) {
            case "1": {
                absCalService = new CalServiceImplForRpcAdd(pageId, periodIdSet, insuredCompanyIdSet, extendParams);
                break;
            }
            case "5": {
                absCalService = new CalServiceImplForCalPersonViewUpdate(pageId, taskIds, extendParams, SocialOperationEnum.OP_CAL_PERSON_RECAL.getOperationKey());
                break;
            }
            case "2": {
                absCalService = new CalServiceImplForViewUpdate(pageId, taskIds, extendParams, "donothing_launchcal");
                break;
            }
            case "4": {
                absCalService = new CalServiceImplForViewUpdate(pageId, taskIds, extendParams, "donothing_updatecal");
                break;
            }
            case "3": {
                absCalService = new CalServiceImplForRpcUpdate(pageId, periodIdSet, insuredCompanyIdSet, extendParams);
                break;
            }
        }
        return absCalService;
    }

    public void auditOrUnauditInSinsurTask(List<Long> taskIds, IFormView view, SocialOperationEnum operationEnum, String recordId) {
        int totalCount = taskIds.size();
        ArrayList errorList = Lists.newArrayListWithExpectedSize((int)10);
        ArrayList<Map<String, Object>> errorResults = new ArrayList<Map<String, Object>>(taskIds.size());
        Set<Long> successTaskIds = this.validate(taskIds, operationEnum, "pageView", errorResults);
        HashSet<String> errorCoeds = new HashSet<String>(errorResults.size());
        for (Map map : errorResults) {
            String code = (String)map.get("code");
            errorCoeds.add(code);
        }
        if (successTaskIds.size() == 0 && errorCoeds.size() == 1) {
            String code = (String)((Map)errorResults.get(0)).get("code");
            if (HRStringUtils.equals((String)code, (String)HCSIErrInfoEnum.CALCULATING_TASK_WHEN_AUDIT_AND_UNAUDIT.getErrCode())) {
                String string = MessageFormat.format(ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u6240\u6709\u793e\u4fdd\u4efb\u52a1\u6b63\u5728\u8ba1\u7b97\u4e2d\uff0c\u4e0d\u80fd\u8fdb\u884c{0}\u64cd\u4f5c\u3002", (String)"SocialInsuranceCalService_0", (String)"sit-hcsi-business", (Object[])new Object[0]), operationEnum.getOperationName());
                view.showTipNotification(string);
            } else if (HRStringUtils.equals((String)code, (String)HCSIErrInfoEnum.CLOSED_TASK_WHEN_AUDIT_AND_UNAUDIT.getErrCode())) {
                String string = MessageFormat.format(ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u6240\u6709\u793e\u4fdd\u4efb\u52a1\u5747\u5df2\u5173\u95ed\uff0c\u4e0d\u80fd\u8fdb\u884c{0}\u64cd\u4f5c\u3002", (String)"SocialInsuranceCalService_1", (String)"sit-hcsi-business", (Object[])new Object[0]), operationEnum.getOperationName());
                view.showTipNotification(string);
            } else if (HRStringUtils.equals((String)code, (String)HCSIErrInfoEnum.UNAUTHORIZED_TASK_WHEN_AUDIT_AND_UNAUDIT.getErrCode())) {
                String string = MessageFormat.format(HCSIErrInfoEnum.CAL_PERSON_IS_EMPTY_WHEN_AUDIT_AND_UNAUDIT.getErrInfo(), operationEnum.getOperationName());
                view.showTipNotification(string);
            } else if (HRStringUtils.equals((String)code, (String)HCSIErrInfoEnum.CAL_TASK_IS_EMPTY.getErrCode())) {
                String string = MessageFormat.format(HCSIErrInfoEnum.ALL_CAL_TASK_IS_EMPTY.getErrInfo(), operationEnum.getOperationName());
                view.showTipNotification(string);
            }
            return;
        }
        for (Map map : errorResults) {
            String message = (String)map.get("message");
            errorList.add(message);
        }
        if (errorList.size() == totalCount) {
            String titleMSG = ResManager.loadKDString((String)"\u5171{0}\u4e2a\u793e\u4fdd\u4efb\u52a1\uff0c\u8df3\u8fc7{1}\u4e2a\u3002", (String)"SocialInsuranceCalService_4", (String)"sit-hcsi-business", (Object[])new Object[0]);
            String string = MessageFormat.format(titleMSG, totalCount, totalCount);
            SocialInsuranceCalHelper.errorShowStyle(view, errorList, totalCount, operationEnum.getOperationName(), string, "yellow");
        } else {
            Long userId = RequestContext.get().getCurrUserId();
            String string = String.format(Locale.ROOT, "openResultWindowsParam_%s", userId);
            ISITAppCache userAppCache = SITAppCache.get((String)string);
            userAppCache.put("taskIds", taskIds);
            userAppCache.put("opKey", (Object)operationEnum.getOperationKey());
            this.auditOrUnauditSinsurCalPerson(successTaskIds, view, recordId, operationEnum.getOperationKey());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> auditOrUnauditInSinsurTask(List<Long> taskIds, SocialOperationEnum operationEnum) {
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        result.put("success", Boolean.TRUE);
        result.put("message", "success");
        result.put("data", null);
        if (taskIds == null || taskIds.size() == 0) {
            result.put("message", "success");
            return result;
        }
        ArrayList<Map<String, Object>> errorResults = new ArrayList<Map<String, Object>>(taskIds.size());
        Set<Object> successTaskIds = new HashSet(16);
        try {
            successTaskIds = this.validate(taskIds, operationEnum, "interface", errorResults);
            QFilter detailFilter = new QFilter("sinsurtask.id", "in", successTaskIds);
            DynamicObject[] dynamicObjectArray = CAL_PERSON_HELPER.query("id,sinsurtask,calstatus,pushstatus,sinsurfilev.id,sinsurfilev.number", detailFilter.toArray());
            List<DynamicObject> calPersons = Arrays.asList(dynamicObjectArray);
            String recordId = UUID.randomUUID().toString();
            SocialTaskAuditOrUnauditService socialTaskAuditOrUnauditService = new SocialTaskAuditOrUnauditService(calPersons, recordId, operationEnum.getOperationKey());
            Map<String, List<String>> failFileNumbersBySinSurTaskNumber = socialTaskAuditOrUnauditService.auditOrUnauditDetailByMultiThread();
            result.put("success", failFileNumbersBySinSurTaskNumber.size() == 0);
            result.put("message", String.valueOf(failFileNumbersBySinSurTaskNumber.size() == 0));
            this.dealErrorMsg(errorResults, calPersons, failFileNumbersBySinSurTaskNumber, operationEnum);
            SocialInsuranceCalHelper.updateSinsurTaskCalStatus(successTaskIds);
        }
        catch (Exception exception) {
            log.error((Throwable)exception);
            result.put("success", Boolean.FALSE);
            result.put("message", exception.getMessage());
        }
        finally {
            for (Long l : successTaskIds) {
                MutexServiceHelper.release((String)"hcsi_sinsurtask", (String)String.valueOf(l), (String)operationEnum.getOperationKey());
            }
        }
        if (errorResults.size() > 0) {
            result.put("data", errorResults);
        }
        return result;
    }

    private Set<Long> validate(List<Long> taskIds, SocialOperationEnum operationEnum, String invokeType, List<Map<String, Object>> errorResults) {
        Set<Long> successTaskIds = this.repeat(taskIds, errorResults);
        Map<Long, DynamicObject> sinSurTaskById = this.exist(errorResults, successTaskIds, operationEnum);
        this.validateCalculating(errorResults, successTaskIds, sinSurTaskById);
        this.validateClosedTask(errorResults, successTaskIds, sinSurTaskById, operationEnum);
        if (HRStringUtils.equals((String)invokeType, (String)"pageView")) {
            this.validateAuthorized(errorResults, successTaskIds, sinSurTaskById);
        }
        if (HRStringUtils.equals((String)invokeType, (String)"interface")) {
            this.validateMutexLock(operationEnum, errorResults, successTaskIds, sinSurTaskById);
        }
        return successTaskIds;
    }

    private Set<Long> repeat(List<Long> taskIds, List<Map<String, Object>> errorResults) {
        HashSet<Long> successTaskIds = new HashSet<Long>(taskIds.size());
        for (Long taskId : taskIds) {
            if (successTaskIds.add(taskId)) continue;
            log.info("param repeat taskId is {}", (Object)taskId);
            Map<String, Object> taskResult = this.genErrorMsg(taskId, HCSIErrInfoEnum.COMMON_REPEAT_FAILED.getErrCode(), HCSIErrInfoEnum.COMMON_REPEAT_FAILED.getErrInfo(taskId));
            errorResults.add(taskResult);
        }
        return successTaskIds;
    }

    private Map<Long, DynamicObject> exist(List<Map<String, Object>> errorResults, Set<Long> successTaskIds, SocialOperationEnum operationEnum) {
        DynamicObjectCollection taskDys = SINSUR_TASK_HELPER.queryOriginalCollection("id,number,personcount", new QFilter("id", "in", successTaskIds).toArray());
        Map<Long, DynamicObject> sinSurTaskById = taskDys.stream().collect(Collectors.toMap(task -> task.getLong("id"), task -> task));
        Iterator<Long> iterator = successTaskIds.iterator();
        while (iterator.hasNext()) {
            Map<String, Object> taskResult;
            Long taskId = iterator.next();
            DynamicObject dynamicObject = sinSurTaskById.get(taskId);
            if (dynamicObject == null) {
                log.info("data cannot be queried, taskId is {}", (Object)taskId);
                taskResult = this.genErrorMsg(taskId, HCSIErrInfoEnum.CAL_TASK_NOT_EXIST.getErrCode(), HCSIErrInfoEnum.CAL_TASK_NOT_EXIST.getErrInfo(taskId));
                errorResults.add(taskResult);
                iterator.remove();
                continue;
            }
            if (dynamicObject.getInt("personcount") != 0) continue;
            taskResult = this.genErrorMsg(taskId, HCSIErrInfoEnum.CAL_TASK_IS_EMPTY.getErrCode(), HCSIErrInfoEnum.CAL_TASK_IS_EMPTY.getErrInfo(dynamicObject.getString("number"), operationEnum.getOperationName()));
            errorResults.add(taskResult);
            iterator.remove();
        }
        return sinSurTaskById;
    }

    private void validateMutexLock(SocialOperationEnum operationEnum, List<Map<String, Object>> errorResults, Set<Long> successTaskIds, Map<Long, DynamicObject> sinSurTaskById) {
        Iterator<Long> iterator = successTaskIds.iterator();
        while (iterator.hasNext()) {
            Long successTaskId = iterator.next();
            BaseResult require = MutexServiceHelper.require((String)"hcsi_sinsurtask", (String)String.valueOf(successTaskId), (String)operationEnum.getOperationKey());
            if (require.isSuccess()) continue;
            log.info("addMutexLock: Mutex error, taskId is {}", (Object)successTaskId);
            Map<String, Object> taskResult = this.genErrorMsg(successTaskId, HCSIErrInfoEnum.CAL_TASK_OTHER_OPERATION.getErrCode(), HCSIErrInfoEnum.CAL_TASK_OTHER_OPERATION.getErrInfo(sinSurTaskById.get(successTaskId).get("number")));
            errorResults.add(taskResult);
            iterator.remove();
        }
    }

    private void validateCalculating(List<Map<String, Object>> errorResults, Set<Long> successTaskIds, Map<Long, DynamicObject> sinSurTaskById) {
        Set<Long> calculatingTaskIds = this.getCalculatingTaskIds(successTaskIds);
        for (Long calculatingTaskId : calculatingTaskIds) {
            log.info("task calculating, taskId is {}", (Object)calculatingTaskId);
            Map<String, Object> taskResult = this.genErrorMsg(calculatingTaskId, HCSIErrInfoEnum.CALCULATING_TASK_WHEN_AUDIT_AND_UNAUDIT.getErrCode(), HCSIErrInfoEnum.CALCULATING_TASK_WHEN_AUDIT_AND_UNAUDIT.getErrInfo(sinSurTaskById.get(calculatingTaskId).get("number")));
            errorResults.add(taskResult);
        }
        successTaskIds.removeAll(calculatingTaskIds);
    }

    private void validateClosedTask(List<Map<String, Object>> errorResults, Set<Long> successTaskIds, Map<Long, DynamicObject> sinSurTaskById, SocialOperationEnum operationEnum) {
        Set<Long> closedTaskIds = this.getClosedTaskIds(successTaskIds);
        for (Long closedTaskId : closedTaskIds) {
            log.info("task status is closed, taskId is {}", (Object)closedTaskId);
            Map<String, Object> taskResult = this.genErrorMsg(closedTaskId, HCSIErrInfoEnum.CLOSED_TASK_WHEN_AUDIT_AND_UNAUDIT.getErrCode(), MessageFormat.format(ResManager.loadKDString((String)"{0}\uff1a\u793e\u4fdd\u4efb\u52a1\u5df2\u5173\u95ed\uff0c\u4e0d\u80fd\u8fdb\u884c{1}\u64cd\u4f5c\u3002", (String)"SocialInsuranceCalService_20", (String)"sit-hcsi-business", (Object[])new Object[0]), sinSurTaskById.get(closedTaskId).get("number"), operationEnum.getOperationName()));
            errorResults.add(taskResult);
        }
        successTaskIds.removeAll(closedTaskIds);
    }

    private void validateAuthorized(List<Map<String, Object>> errorResults, Set<Long> successTaskIds, Map<Long, DynamicObject> sinSurTaskById) {
        Set<Long> authorizedTaskIds = this.getAuthorizedTaskIds(successTaskIds);
        Iterator<Long> iterator = successTaskIds.iterator();
        while (iterator.hasNext()) {
            Long successTaskId = iterator.next();
            if (authorizedTaskIds.contains(successTaskId)) continue;
            log.info("task no authorized, taskId is {}", (Object)successTaskId);
            Map<String, Object> taskResult = this.genErrorMsg(successTaskId, HCSIErrInfoEnum.UNAUTHORIZED_TASK_WHEN_AUDIT_AND_UNAUDIT.getErrCode(), HCSIErrInfoEnum.UNAUTHORIZED_TASK_WHEN_AUDIT_AND_UNAUDIT.getErrInfo(sinSurTaskById.get(successTaskId).get("number")));
            errorResults.add(taskResult);
            iterator.remove();
        }
    }

    private Map<String, Object> genErrorMsg(Long successTaskId, String code, String message) {
        HashMap<String, Object> taskResult = new HashMap<String, Object>(16);
        taskResult.put("sinSurTaskId", successTaskId);
        taskResult.put("code", code);
        taskResult.put("message", message);
        return taskResult;
    }

    private void dealErrorMsg(List<Map<String, Object>> errorResults, List<DynamicObject> calPersons, Map<String, List<String>> failFileNumbersBySinSurTaskNumber, SocialOperationEnum operationEnum) {
        Map<String, List<DynamicObject>> calPersonByTaskNumbers = calPersons.stream().collect(Collectors.groupingBy(calperson -> calperson.getString("sinsurtask.number")));
        for (Map.Entry<String, List<String>> entry : failFileNumbersBySinSurTaskNumber.entrySet()) {
            String sinSurTaskNumber = entry.getKey();
            List<DynamicObject> calPersonList = calPersonByTaskNumbers.get(sinSurTaskNumber);
            long sinSurTaskId = calPersonList.get(0).getLong("sinsurtask.id");
            HashMap<String, Object> taskResult = new HashMap<String, Object>(16);
            taskResult.put("sinSurTaskId", sinSurTaskId);
            taskResult.put("code", "2001");
            List<String> failFileNumbers = entry.getValue();
            for (String failFileNumber : failFileNumbers) {
                List calPersonFailMsgs = taskResult.getOrDefault("sinSurFileMessage", new ArrayList());
                HashMap<String, String> calPersonFailMsg = new HashMap<String, String>(16);
                calPersonFailMsg.put("sinSurFileNumber", failFileNumber);
                if (SocialOperationEnum.OP_AUDIT == operationEnum) {
                    calPersonFailMsg.put("errorMsg", operationEnum.getOperationName() + ResManager.loadKDString((String)"\u5931\u8d25", (String)"SocialInsuranceCalService_17", (String)"sit-hcsi-business", (Object[])new Object[0]) + '\uff0c' + ResManager.loadKDString((String)"\u53ea\u6709\u72b6\u6001\u4e3a\u5df2\u8ba1\u7b97\u7684\u793e\u4fdd\u6863\u6848\u624d\u80fd\u8fdb\u884c\u5ba1\u6838\u64cd\u4f5c", (String)"SocialInsuranceCalService_19", (String)"sit-hcsi-business", (Object[])new Object[0]));
                } else if (SocialOperationEnum.OP_UNAUDIT == operationEnum) {
                    calPersonFailMsg.put("errorMsg", operationEnum.getOperationName() + ResManager.loadKDString((String)"\u5931\u8d25", (String)"SocialInsuranceCalService_17", (String)"sit-hcsi-business", (Object[])new Object[0]) + '\uff0c' + ResManager.loadKDString((String)"\u53ea\u6709\u72b6\u6001\u4e3a\u5df2\u5ba1\u6838\u4e14\u672a\u63a8\u9001\u7b97\u85aa\u7684\u793e\u4fdd\u6863\u6848\u624d\u80fd\u8fdb\u884c\u53cd\u5ba1\u6838\u64cd\u4f5c\u3002", (String)"SocialInsuranceCalService_20", (String)"sit-hcsi-business", (Object[])new Object[0]));
                }
                calPersonFailMsgs.add(calPersonFailMsg);
                taskResult.put("sinSurFileMessage", calPersonFailMsgs);
            }
            errorResults.add(taskResult);
        }
    }

    private Set<Long> getAuthorizedTaskIds(Set<Long> taskIds) {
        QFilter detailFilter = new QFilter("sinsurtask.id", "in", taskIds);
        QFilter authorizedDataRuleQFilter = SocialInsuranceCalHelper.getAuthorizedDataRuleQFilterOf("hcsi_calperson", "4");
        detailFilter.and(authorizedDataRuleQFilter);
        DynamicObjectCollection detailDyColl = CAL_PERSON_HELPER.queryOriginalCollection("sinsurtask.id", detailFilter.toArray());
        return detailDyColl.stream().map(detailDy -> detailDy.getLong("sinsurtask.id")).collect(Collectors.toSet());
    }

    private void auditOrUnauditSinsurCalPerson(Set<Long> taskIds, IFormView view, String recordId, String opKey) {
        ISITAppCache recordAppCache = SITAppCache.get((String)recordId);
        List<DynamicObject> detailDys = this.getCalPersons(taskIds);
        SocialTaskAuditProgressDTO socialTaskAuditProgressDTO = new SocialTaskAuditProgressDTO();
        socialTaskAuditProgressDTO.setStatus(1);
        socialTaskAuditProgressDTO.setStartTime(new Date());
        socialTaskAuditProgressDTO.setTaskNum(taskIds.size());
        socialTaskAuditProgressDTO.setFileNum(detailDys.size());
        socialTaskAuditProgressDTO.setSuccess(0);
        socialTaskAuditProgressDTO.setFail(0);
        socialTaskAuditProgressDTO.setOpKey(opKey);
        recordAppCache.put(String.format(Locale.ROOT, "SocialTaskAuditProgress_%s", recordId), (Object)socialTaskAuditProgressDTO);
        recordAppCache.put("opKey", (Object)opKey);
        FormShowParameter taskAuditProgressForm = SocialInsuranceCalService.getTaskAuditProgressForm(recordId);
        view.showForm(taskAuditProgressForm);
        SocialTaskAuditOrUnauditService socialTaskAuditOrUnauditService = new SocialTaskAuditOrUnauditService(detailDys, recordId, opKey);
        Map<String, List<String>> failFileNumbers = socialTaskAuditOrUnauditService.auditOrUnauditDetailByMultiThread();
        SocialInsuranceCalHelper.updateSinsurTaskCalStatus(taskIds);
        Long userId = RequestContext.get().getCurrUserId();
        String cacheKey = String.format(Locale.ROOT, "openResultWindowsParam_%s", userId);
        ISITAppCache userAppCache = SITAppCache.get((String)cacheKey);
        userAppCache.put("failFileNumbers", failFileNumbers);
        userAppCache.put("opKey", (Object)opKey);
        userAppCache.put("fileNum", (Object)detailDys.size());
    }

    private List<DynamicObject> getCalPersons(Collection<Long> taskIds) {
        HRBaseServiceHelper detailHelper = new HRBaseServiceHelper("hcsi_calperson");
        QFilter detailFilter = new QFilter("sinsurtask.id", "in", taskIds);
        QFilter authorizedDataRuleQFilter = SocialInsuranceCalHelper.getAuthorizedDataRuleQFilterOf("hcsi_calperson", "4");
        detailFilter.and(authorizedDataRuleQFilter);
        DynamicObject[] detailDysArr = detailHelper.query("id,sinsurtask,calstatus,pushstatus,sinsurfilev.id,sinsurfilev.number", detailFilter.toArray());
        return Arrays.asList(detailDysArr);
    }

    public static FormShowParameter getTaskAuditProgressForm(String recordId) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("hcsi_sinsurcalaudit");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("recordId", (Object)recordId);
        formShowParameter.setCloseCallBack(new CloseCallBack("kd.sit.hcsi.formplugin.web.cal.task.SocialInsuranceTaskList", "audit_progress_callback_id"));
        return formShowParameter;
    }

    private Set<Long> getCalculatingTaskIds(Set<Long> taskIds) {
        DynamicObject[] recordDys;
        HashSet countedTaskIds = Sets.newHashSetWithExpectedSize((int)16);
        HashSet calculatingTaskIds = Sets.newHashSetWithExpectedSize((int)16);
        HRBaseServiceHelper recordHelper = new HRBaseServiceHelper("hcsi_sinsurgenrecord");
        QFilter recordFilters = new QFilter("sinsurtask.id", "in", taskIds);
        for (DynamicObject recordDy : recordDys = recordHelper.queryOriginalArray("sinsurtask.id,genstatus", recordFilters.toArray(), "starttime desc")) {
            long taskId = recordDy.getLong("sinsurtask.id");
            if (countedTaskIds.contains(taskId)) continue;
            if (SITStringUtils.equals((String)recordDy.getString("genstatus"), (String)"0")) {
                calculatingTaskIds.add(taskId);
            }
            countedTaskIds.add(taskId);
        }
        return calculatingTaskIds;
    }

    private Set<Long> getClosedTaskIds(Set<Long> taskIds) {
        QFilter taskFilter = new QFilter("id", "in", taskIds);
        taskFilter.and("taskstatus", "=", (Object)"1");
        DynamicObjectCollection taskDys = SINSUR_TASK_HELPER.queryOriginalCollection("id", taskFilter.toArray());
        return taskDys.stream().map(taskDy -> taskDy.getLong("id")).collect(Collectors.toSet());
    }

    public void openResultWindows(IFormView view, Map<String, List<String>> batchFailFileNumbers, String opKey, int fileNum) {
        int failNum = batchFailFileNumbers.size();
        String opName = "";
        switch (opKey) {
            case "donothing_audit": {
                opName = ResManager.loadKDString((String)"\u5ba1\u6838", (String)"SocialInsuranceCalService_12", (String)"sit-hcsi-business", (Object[])new Object[0]);
                break;
            }
            case "donothing_unaudit": {
                opName = ResManager.loadKDString((String)"\u53cd\u5ba1\u6838", (String)"SocialInsuranceCalService_13", (String)"sit-hcsi-business", (Object[])new Object[0]);
                break;
            }
        }
        if (failNum == 0) {
            String successMsg = MessageFormat.format(ResManager.loadKDString((String)"{0}\u6210\u529f\u3002", (String)"SocialInsuranceCalService_5", (String)"sit-hcsi-business", (Object[])new Object[0]), opName);
            view.showSuccessNotification(successMsg);
            return;
        }
        failNum = 0;
        for (Map.Entry<String, List<String>> entry : batchFailFileNumbers.entrySet()) {
            List<String> failFileNum = entry.getValue();
            failNum += failFileNum.size();
        }
        int successNum = fileNum - failNum;
        String titleMSG = "";
        String titleformat = "";
        ArrayList errorList = Lists.newArrayListWithExpectedSize((int)10);
        switch (opKey) {
            case "donothing_audit": {
                titleMSG = ResManager.loadKDString((String)"\u5171{0}\u6761\u6863\u6848\uff0c\u5ba1\u6838\u6210\u529f{1}\u6761\uff0c\u5931\u8d25{2}\u6761\u3002", (String)"SocialInsuranceCalService_7", (String)"sit-hcsi-business", (Object[])new Object[0]);
                titleformat = MessageFormat.format(titleMSG, fileNum, successNum, failNum);
                boolean flag = batchFailFileNumbers.size() > 1;
                for (Map.Entry<String, List<String>> entry : batchFailFileNumbers.entrySet()) {
                    String sinSurTaskNumber = entry.getKey();
                    List<String> failFileNumbers = entry.getValue();
                    for (String failFileNumber : failFileNumbers) {
                        String msg = flag ? MessageFormat.format(ResManager.loadKDString((String)"{0}&{1}\uff1a\u53ea\u6709\u72b6\u6001\u4e3a\u5df2\u8ba1\u7b97\u7684\u793e\u4fdd\u6863\u6848\u624d\u80fd\u8fdb\u884c\u5ba1\u6838\u64cd\u4f5c\u3002", (String)"SocialInsuranceCalService_15", (String)"sit-hcsi-business", (Object[])new Object[0]), sinSurTaskNumber, failFileNumber) : MessageFormat.format(ResManager.loadKDString((String)"{0}\uff1a\u53ea\u6709\u72b6\u6001\u4e3a\u5df2\u8ba1\u7b97\u7684\u793e\u4fdd\u6863\u6848\u624d\u80fd\u8fdb\u884c\u5ba1\u6838\u64cd\u4f5c\u3002", (String)"SocialInsuranceCalService_8", (String)"sit-hcsi-business", (Object[])new Object[0]), failFileNumber);
                        errorList.add(msg);
                    }
                }
                break;
            }
            case "donothing_unaudit": {
                titleMSG = ResManager.loadKDString((String)"\u5171{0}\u6761\u6863\u6848\uff0c\u53cd\u5ba1\u6838\u6210\u529f{1}\u6761\uff0c\u5931\u8d25{2}\u6761\u3002", (String)"SocialInsuranceCalService_9", (String)"sit-hcsi-business", (Object[])new Object[0]);
                titleformat = MessageFormat.format(titleMSG, fileNum, successNum, failNum);
                boolean unauditFlag = batchFailFileNumbers.size() > 1;
                for (Map.Entry<String, List<String>> entry : batchFailFileNumbers.entrySet()) {
                    String sinSurTaskNumber = entry.getKey();
                    List<String> failFileNumbers = entry.getValue();
                    for (String failFileNumber : failFileNumbers) {
                        String msg = unauditFlag ? MessageFormat.format(ResManager.loadKDString((String)"{0}&{1}\uff1a\u53ea\u6709\u72b6\u6001\u4e3a\u5df2\u5ba1\u6838\u4e14\u672a\u63a8\u9001\u7b97\u85aa\u7684\u793e\u4fdd\u6863\u6848\u624d\u80fd\u8fdb\u884c\u53cd\u5ba1\u6838\u64cd\u4f5c\u3002", (String)"SocialInsuranceCalService_16", (String)"sit-hcsi-business", (Object[])new Object[0]), sinSurTaskNumber, failFileNumber) : MessageFormat.format(ResManager.loadKDString((String)"{0}\uff1a\u53ea\u6709\u72b6\u6001\u4e3a\u5df2\u5ba1\u6838\u4e14\u672a\u63a8\u9001\u7b97\u85aa\u7684\u793e\u4fdd\u6863\u6848\u624d\u80fd\u8fdb\u884c\u53cd\u5ba1\u6838\u64cd\u4f5c\u3002", (String)"SocialInsuranceCalService_10", (String)"sit-hcsi-business", (Object[])new Object[0]), failFileNumber);
                        errorList.add(msg);
                    }
                }
                break;
            }
        }
        SocialInsuranceCalHelper.errorShowStyle(view, errorList, fileNum, opName, titleformat, "yellow");
    }

    public void auditOrUnauditBySelectedDetailIds(IFormView view, List<Long> detailIds, String opKey) {
        QFilter detailFilter = new QFilter("id", "in", detailIds);
        DynamicObject[] detailDys = CAL_PERSON_HELPER.query("id,sinsurtask,calstatus,pushstatus,sinsurfilev.id,sinsurfilev.number", detailFilter.toArray());
        HashMap batchFailFileNumbers = Maps.newHashMapWithExpectedSize((int)16);
        ArrayList successDetailIds = Lists.newArrayListWithExpectedSize((int)10);
        DynamicObjectCollection detailCollection = new DynamicObjectCollection();
        this.addAuditOrUnauditFailListAndSave(opKey, detailDys, detailCollection, batchFailFileNumbers, successDetailIds);
        this.openResultWindows(view, batchFailFileNumbers, opKey, detailDys.length);
    }

    public void addAuditOrUnauditFailListAndSave(String opKey, DynamicObject[] detailDys, DynamicObjectCollection detailCollection, Map<String, List<String>> failDetailFileNumbers, List<Long> successDetailIds) {
        for (DynamicObject detailDy : detailDys) {
            boolean valid;
            String calStatus = detailDy.getString("calstatus");
            String pushStatus = detailDy.getString("pushstatus");
            long filevId = detailDy.getLong("sinsurfilev.id");
            String fileNumber = detailDy.getString("sinsurfilev.number");
            if (SITStringUtils.equals((String)opKey, (String)"donothing_audit")) {
                if (SITStringUtils.equals((String)calStatus, (String)"0")) {
                    detailDy.set("calstatus", (Object)"2");
                    successDetailIds.add(filevId);
                    detailCollection.add((Object)detailDy);
                    continue;
                }
                List fileNumbers = failDetailFileNumbers.computeIfAbsent(detailDy.getString("sinsurtask.number"), key -> new ArrayList());
                fileNumbers.add(fileNumber);
                continue;
            }
            boolean bl = valid = SITStringUtils.equals((String)calStatus, (String)"2") && (SITStringUtils.equals((String)pushStatus, (String)"notpush") || SITStringUtils.isEmpty((String)pushStatus));
            if (valid) {
                detailDy.set("calstatus", (Object)"0");
                successDetailIds.add(filevId);
                detailCollection.add((Object)detailDy);
                continue;
            }
            List fileNumbers = failDetailFileNumbers.computeIfAbsent(detailDy.getString("sinsurtask.number"), key -> new ArrayList());
            fileNumbers.add(fileNumber);
        }
        CAL_PERSON_HELPER.save(detailCollection);
    }

    public boolean checkTaskIfShotDown(IFormView view, List<Long> taskIds, String opName) {
        DynamicObject[] taskDys;
        Long taskId;
        if (CollectionUtils.isEmpty(taskIds) || (taskId = taskIds.get(0)) == null) {
            return false;
        }
        QFilter taskFilter = new QFilter("id", "=", (Object)taskId);
        for (DynamicObject taskDy : taskDys = SINSUR_TASK_HELPER.query("taskstatus", taskFilter.toArray())) {
            String taskStatus = taskDy.getString("taskstatus");
            if (!SITStringUtils.equals((String)taskStatus, (String)"1")) continue;
            view.showTipNotification(MessageFormat.format(ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u793e\u4fdd\u4efb\u52a1\u5df2\u5173\u95ed\uff0c\u4e0d\u80fd\u8fdb\u884c{0}\u64cd\u4f5c\u3002", (String)"SocialInsuranceCalService_6", (String)"sit-hcsi-business", (Object[])new Object[0]), opName));
            return true;
        }
        return false;
    }
}

