/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.business.caladjust.helper;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sdk.sit.hcsi.common.entity.cal.InsuredStandard;
import kd.sit.hcsi.business.cal.SocialInsuranceCalHelper;
import kd.sit.hcsi.business.caladjust.constants.AdjustDataConstants;
import kd.sit.hcsi.common.enums.CalPersonStatusEnum;
import kd.sit.sitbp.business.servicehelper.SITPermissionServiceHelper;
import kd.sit.sitbp.common.cache.ISITAppCache;
import kd.sit.sitbp.common.cache.SITAppCache;
import kd.sit.sitbp.common.util.SITListUtil;
import kd.sit.sitbp.common.util.SITStringUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;

public class AdjustDataHelper {
    private static final Log logger = LogFactory.getLog(AdjustDataHelper.class);

    public static List<DynamicObject> queryCalPersonInfo(String selectInfo, QFilter filter) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hcsi_calperson");
        DynamicObject[] calPersonDys = helper.query(selectInfo, filter.toArray(), "filenumberdb asc");
        if (calPersonDys == null) {
            return new ArrayList<DynamicObject>(0);
        }
        return new ArrayList<DynamicObject>(Arrays.asList(calPersonDys));
    }

    public static List<DynamicObject> loadCalPersonInfo(QFilter filter) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hcsi_calperson");
        return Arrays.asList(helper.loadDynamicObjectArray(filter.toArray()));
    }

    public static QFilter getCalPersonFilter(List<Object> calPersons, Long taskId, boolean isView) {
        List<Long> personIdList = calPersons.stream().map(single -> Long.parseLong(single + "")).collect(Collectors.toList());
        return AdjustDataHelper.getValidCalPersonFilter(personIdList, taskId, isView);
    }

    public static QFilter getValidCalPersonFilter(List<Long> personIdList, Long taskId, boolean isView) {
        QFilter filter = new QFilter("sinsurtask.id", "=", (Object)taskId);
        if (!isView) {
            filter.and("calstatus", "=", (Object)"0");
        }
        if (!CollectionUtils.isEmpty(personIdList)) {
            QFilter calPersonFilter = new QFilter("id", "in", personIdList);
            calPersonFilter.and(filter);
            filter = calPersonFilter;
        }
        return filter;
    }

    public static QFilter getCalPersonFilterByFileNumberAndTaskId(Collection<String> sInsurFileNumbers, Long taskId) {
        return new QFilter("sinsurtask.id", "=", (Object)taskId).and("filenumberdb", "in", sInsurFileNumbers).and("calstatus", "=", (Object)"0");
    }

    public static QFilter getCalPersonFilterByFileBoIdAndTaskId(Collection<Long> sInsurFileBoIds, Long taskId) {
        return new QFilter("sinsurtask.id", "=", (Object)taskId).and("sinsurfilev.boid", "in", sInsurFileBoIds).and("calstatus", "=", (Object)"0");
    }

    public static QFilter getCalPersonFilterForAdjust(Collection<Object> calPersons) {
        return new QFilter("id", "in", calPersons);
    }

    public static QFilter getCalPersonFilterByTaskId(Collection<Long> calTaskIds) {
        return calTaskIds.size() == 1 ? new QFilter("sinsurtask.id", "=", (Object)calTaskIds.iterator().next()) : new QFilter("sinsurtask.id", "=", calTaskIds);
    }

    public static DynamicObject[] queryInsuranceStandardInfo(String selectInsuranceStandardInfo, QFilter insuranceStandardFilter) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("sitbs_sinsurstd");
        return helper.query(selectInsuranceStandardInfo, insuranceStandardFilter.toArray());
    }

    public static QFilter getInsuranceStandardFilter(Collection<Long> insurStdIds) {
        return new QFilter("id", "in", insurStdIds);
    }

    public static List<DynamicObject> queryInsuranceStandardCfgInfo(String selectInsuranceStandardCfgInfo, QFilter insuranceStandardCfgInfoFilter) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("sitbs_sinsurstdcfg");
        DynamicObject[] insuranceStandardCfgInfo = helper.query(selectInsuranceStandardCfgInfo, insuranceStandardCfgInfoFilter.toArray());
        return Arrays.asList(insuranceStandardCfgInfo);
    }

    public static List<DynamicObject> queryAdjustDataDetailRecord(String selectInfo, QFilter adjustDataDetailRecordQFilter) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hcsi_sinsuradjrec");
        return helper.queryOriginalCollection(selectInfo, adjustDataDetailRecordQFilter.toArray(), "entryentity.operatetime desc, entryentity.insuranceitem.id desc");
    }

    public static QFilter getInsuranceStandardCfgInfoFilter(Collection<Long> insurTypeIdLinedSet) {
        return new QFilter("insurtype.id", "in", insurTypeIdLinedSet).and("enable", "=", (Object)"1").and("rentryentity.datasrc", "=", (Object)"C");
    }

    public static QFilter getAdjustDataDetailRecordQFilter(Long adjustDataId) {
        return new QFilter("id", "=", (Object)adjustDataId);
    }

    public static List<DynamicObject> querySocInsuranceAdjustDataRecordInfo(QFilter filter) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hcsi_sinsuradjrec");
        return Arrays.asList(helper.loadDynamicObjectArray(filter.toArray()));
    }

    public static QFilter sInsureAdjustDataRecordQFilter(Collection<Object> socInsuranceFileIdColl, Long calTaskId) {
        return new QFilter("sinsurfile.id", "in", socInsuranceFileIdColl).and("sinsurtask.id", "=", (Object)calTaskId);
    }

    public static QFilter getInsuranceItemQFilter(Collection<Long> insurItemIds, Collection<Long> insurTypeIds, Collection<Long> insurTypeAttrIds) {
        return new QFilter("id", "in", insurItemIds).and("insurancetypeattr.id", "in", insurTypeAttrIds).and("group.id", "in", insurTypeIds);
    }

    public static List<Long> getAdjustItemIdByTask(Long taskId) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hcsi_sinsuradjdata");
        QFilter filter = new QFilter("sinsurtask.id", "=", (Object)taskId);
        DynamicObjectCollection dynamicObjects = helper.queryOriginalCollection("insuranceitem.id", new QFilter[]{filter});
        if (SITListUtil.isEmpty((List)dynamicObjects)) {
            return new ArrayList<Long>(0);
        }
        Set itemIdSet = dynamicObjects.stream().map(obj -> obj.getLong("insuranceitem.id")).collect(Collectors.toSet());
        return new ArrayList<Long>(itemIdSet);
    }

    public static List<DynamicObject> queryInsuranceItemInfo(String selectInfo, QFilter insuranceItemQFilter) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("sitbs_insuranceitem");
        return helper.queryOriginalCollection(selectInfo, insuranceItemQFilter.toArray());
    }

    public static List<DynamicObject> queryInsurPropBy(Collection<Long> pkIds) {
        if (CollectionUtils.isEmpty(pkIds)) {
            return new ArrayList<DynamicObject>(0);
        }
        HRBaseServiceHelper helper = new HRBaseServiceHelper("sitbs_insuranceprop");
        DynamicObject[] insurancePropDys = helper.loadDynamicObjectArray(new QFilter("id", "in", pkIds).toArray());
        return Arrays.asList(insurancePropDys);
    }

    public static int getPageData(String searchText, int pageRows, DynamicObjectCollection entryEntities, Integer pageIndex, Long taskId, String personPageId) {
        HashMap<String, String> rowsIdMap = new HashMap<String, String>(16);
        long start = System.currentTimeMillis();
        Map<Long, Map<String, Object>> itemMap = AdjustDataHelper.getCacheItemMap(taskId, personPageId);
        LinkedHashMap matchPersonDataMap = Maps.newLinkedHashMapWithExpectedSize((int)pageRows);
        HashMap<Long, Map<Long, Object>> itemDataMap = new HashMap<Long, Map<Long, Object>>(16);
        pageIndex = AdjustDataHelper.assemblePersonAdjustDataMap(new ArrayList<Long>(0), itemDataMap, matchPersonDataMap, taskId, personPageId, pageRows, pageIndex, searchText);
        logger.info("assemblePersonAdjustDataMap end cost:{} ms", (Object)(System.currentTimeMillis() - start));
        if (matchPersonDataMap.size() == 0) {
            return 1;
        }
        List<Long> personIdList = matchPersonDataMap.keySet().stream().map(single -> Long.parseLong(single)).collect(Collectors.toList());
        AdjustDataHelper.addAdjustEntryData(rowsIdMap, pageRows, entryEntities, pageIndex, itemMap.keySet(), matchPersonDataMap, personIdList, itemDataMap);
        return pageIndex;
    }

    public static void loadGridData(Long taskId, String personPageId, IDataModel model, int pageIndex, int pageRows, IPageCache pageCache) {
        DynamicObject dataEntity = model.getDataEntity(true);
        DynamicObjectCollection entryEntities = model.getEntryEntity("entryentity");
        entryEntities.clear();
        String searchText = AdjustDataHelper.getCacheSearchText(taskId, personPageId);
        int newPageIndex = AdjustDataHelper.getPageData(searchText, pageRows, entryEntities, pageIndex, taskId, personPageId);
        int rowCount = AdjustDataHelper.getCacheAdjustDataCount(taskId, personPageId);
        logger.info("rowCount:{},entryEntities.size:{}", (Object)rowCount, (Object)entryEntities.size());
        int startRowIndex = (newPageIndex - 1) * pageRows;
        pageCache.put("currentPageIndex", newPageIndex + "");
        dataEntity.getDataEntityState().setEntryRowCount("entryentity", rowCount);
        dataEntity.getDataEntityState().setEntryStartRowIndex("entryentity", startRowIndex);
        dataEntity.getDataEntityState().setEntryPageSize("entryentity", pageRows);
    }

    public static int getCacheAdjustDataCount(Long taskId, String personPageId) {
        ISITAppCache appCache = SITAppCache.get((String)String.format(Locale.ROOT, "viewadjustdata_%s", taskId));
        String cacheKey = String.format(Locale.ROOT, "viewadjustdatacount_%d_%s", taskId, personPageId);
        if (appCache == null) {
            return 0;
        }
        Integer count = (Integer)appCache.get(cacheKey, Integer.class);
        return count == null ? 0 : count;
    }

    public static String getCacheSearchText(Long taskId, String pageId) {
        ISITAppCache appCache = SITAppCache.get((String)String.format(Locale.ROOT, "viewadjustdata_%s", taskId));
        if (appCache == null) {
            return "";
        }
        String cacheKey = String.format(Locale.ROOT, "curSearchText_%d_%s", taskId, pageId);
        String searchText = (String)appCache.get(cacheKey, String.class);
        if (SITStringUtils.isEmpty((String)searchText)) {
            searchText = "";
        }
        return searchText;
    }

    public static void cacheSearchText(String searchText, Long taskId, String pageId) {
        ISITAppCache appCache = SITAppCache.get((String)String.format(Locale.ROOT, "viewadjustdata_%s", taskId));
        if (appCache == null) {
            return;
        }
        String cacheKey = String.format(Locale.ROOT, "curSearchText_%d_%s", taskId, pageId);
        appCache.put(cacheKey, (Object)searchText);
    }

    public static void clearCache(Long taskId, String pageId) {
        ISITAppCache appCache = SITAppCache.get((String)String.format(Locale.ROOT, "viewadjustdata_%s", taskId));
        if (appCache == null) {
            return;
        }
        String cacheKey = String.format(Locale.ROOT, "curSearchText_%d_%s", taskId, pageId);
        String cacheKey1 = String.format(Locale.ROOT, "viewadjustdatacount_%d_%s", taskId, pageId);
        appCache.remove(cacheKey);
        appCache.remove(cacheKey1);
    }

    public static int assemblePersonAdjustDataMap(List<Long> fileIdList, Map<Long, Map<Long, Object>> itemDataMap, Map<String, Map<String, String>> matchPersonDataMap, Long taskId, String personPageId, int pageSize, int pageIndex, String searchText) {
        List<Long> adjustDataFileIdList = AdjustDataHelper.getAdjustDataFileIdList(taskId, fileIdList);
        if (SITListUtil.isEmpty(adjustDataFileIdList)) {
            AdjustDataHelper.cacheAdjustDataCount(taskId, personPageId, 0);
            return 1;
        }
        long start = System.currentTimeMillis();
        int count = AdjustDataHelper.getCalPersonDyObjCount(adjustDataFileIdList, searchText, taskId);
        logger.info("getCalPersonDyObjCount cost:{} ms", (Object)(System.currentTimeMillis() - start));
        AdjustDataHelper.cacheAdjustDataCount(taskId, personPageId, count);
        if (count < pageSize) {
            pageIndex = 1;
        }
        start = System.currentTimeMillis();
        List<DynamicObject> calPersonDyObjList = AdjustDataHelper.getCalPersonDyObjListByPageSize(adjustDataFileIdList, taskId, searchText, pageSize, pageIndex);
        logger.info("getCalPersonDyObjListByPageSize cost:{} ms", (Object)(System.currentTimeMillis() - start));
        while (SITListUtil.isEmpty(calPersonDyObjList)) {
            if (pageIndex > 0) {
                calPersonDyObjList = AdjustDataHelper.getCalPersonDyObjListByPageSize(adjustDataFileIdList, taskId, searchText, pageSize, --pageIndex);
                continue;
            }
            pageIndex = 1;
            break;
        }
        logger.info("calPersonDyObjList.size:{}", (Object)calPersonDyObjList.size());
        start = System.currentTimeMillis();
        Map<String, Map<String, String>> personDataMap = AdjustDataHelper.assemblePersonDataMap(itemDataMap, calPersonDyObjList, taskId, personPageId);
        logger.info("assemblePersonDataMap cost:{} ms", (Object)(System.currentTimeMillis() - start));
        matchPersonDataMap.putAll(personDataMap);
        return pageIndex;
    }

    private static Map<String, Map<String, String>> assemblePersonDataMap(Map<Long, Map<Long, Object>> itemDataMap, List<DynamicObject> calPersonDyObjList, Long taskId, String personPageId) {
        LinkedHashMap<String, Map<String, String>> calPersonSimpleDataMap = new LinkedHashMap<String, Map<String, String>>(calPersonDyObjList.size());
        if (SITListUtil.isEmpty(calPersonDyObjList)) {
            return calPersonSimpleDataMap;
        }
        List<Long> fileIdList = calPersonDyObjList.stream().map(single -> single.getLong("sinsurfilev.boid")).collect(Collectors.toList());
        Map<Long, String> memoMap = AdjustDataHelper.assembleAdjustMemoMap(fileIdList, taskId);
        for (DynamicObject obj : calPersonDyObjList) {
            long personId = obj.getLong("id");
            String fileId = obj.getString("sinsurfilev.boid");
            Map dataMap = calPersonSimpleDataMap.getOrDefault(personId + "", new HashMap(7));
            dataMap.put("id", obj.getString("id"));
            dataMap.put("name", obj.getString("namedb"));
            dataMap.put("filenumber", obj.getString("filenumberdb"));
            dataMap.put("empnumber", obj.getString("empnumberdb"));
            dataMap.put("calstatus", obj.getString("calstatus"));
            dataMap.put("calstatusname", CalPersonStatusEnum.getDescByCode((String)obj.getString("calstatus")));
            dataMap.put("sinsurfile", fileId);
            dataMap.put("sinsurstd", obj.getString("sinsurstdv.name"));
            dataMap.put("memo", memoMap.get(Long.parseLong(fileId)));
            calPersonSimpleDataMap.put(personId + "", dataMap);
        }
        Map<Long, Map<String, Object>> itemMap = AdjustDataHelper.getCacheItemMap(taskId, personPageId);
        if (itemMap == null || itemMap.size() == 0) {
            return calPersonSimpleDataMap;
        }
        List<Long> itemIds = itemMap.keySet().stream().collect(Collectors.toList());
        Map<Long, Map<Long, Object>> itemDataMapTemp = AdjustDataHelper.assembleAdjustDataMap(taskId, fileIdList, itemIds);
        itemDataMap.putAll(itemDataMapTemp);
        return calPersonSimpleDataMap;
    }

    private static Map<Long, String> assembleAdjustMemoMap(List<Long> fileIdList, Long taskId) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hcsi_sinsuradjrec");
        QFilter filter = new QFilter("sinsurtask.id", "=", (Object)taskId);
        filter.and("sinsurfile.id", "in", fileIdList);
        DynamicObjectCollection adjustRecordObjs = helper.queryOriginalCollection("sinsurfile.id,memo", new QFilter[]{filter});
        if (SITListUtil.isEmpty((List)adjustRecordObjs)) {
            return new HashMap<Long, String>(0);
        }
        return adjustRecordObjs.stream().collect(Collectors.toMap(v1 -> v1.getLong("sinsurfile.id"), v2 -> v2.getString("memo")));
    }

    private static Map<String, Map<String, String>> assembleItemDataMap(Map<Long, Map<Long, Object>> itemDataMap, Map<String, Map<String, String>> calPersonSimpleDataMap) {
        LinkedHashMap<String, Map<String, String>> resultDataMap = new LinkedHashMap<String, Map<String, String>>(16);
        for (Map.Entry<String, Map<String, String>> entry : calPersonSimpleDataMap.entrySet()) {
            boolean isEmpty;
            String fileId = entry.getValue().get("sinsurfile");
            Map<Long, Object> dataMap = itemDataMap.get(Long.parseLong(fileId));
            if (dataMap == null || dataMap.size() == 0 || (isEmpty = AdjustDataHelper.checkItemDataEmpty(dataMap))) continue;
            resultDataMap.put(entry.getKey(), entry.getValue());
        }
        return resultDataMap;
    }

    public static Map<Long, Map<Long, Object>> assembleAdjustDataMap(Long taskId, Collection<Long> fileBoIds, Collection<Long> itemIds) {
        long st = System.currentTimeMillis();
        if (taskId == null || fileBoIds == null || itemIds == null) {
            return new HashMap<Long, Map<Long, Object>>(0);
        }
        LinkedHashMap<Long, Map<Long, Object>> coverResultMap = new LinkedHashMap<Long, Map<Long, Object>>(16);
        for (Long fileId : fileBoIds) {
            coverResultMap.put(fileId, new HashMap(16));
        }
        AdjustDataHelper.initEmptyItemValue(coverResultMap, itemIds);
        QFilter filter = new QFilter("sinsurtask.id", "=", (Object)taskId);
        filter.and("sinsurfile.id", "in", fileBoIds);
        filter.and("insuranceitem.id", "in", itemIds);
        String fields = "sinsurfile.id,insuranceitem.id,adjvalue,sinsurtask.id";
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"hcsi_sinsuradjdata", (String)fields, (QFilter[])new QFilter[]{filter});
        logger.info("querycalresultcoverdata_finish,cost:{} ms", (Object)(System.currentTimeMillis() - st));
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            return coverResultMap;
        }
        for (DynamicObject obj : dynamicObjects) {
            Map itemMap = (Map)coverResultMap.get(obj.getLong("sinsurfile.id"));
            BigDecimal value = obj.getBigDecimal("adjvalue");
            itemMap.put(obj.getLong("insuranceitem.id"), value);
        }
        return coverResultMap;
    }

    public static void initEmptyItemValue(Map<Long, Map<Long, Object>> itemResultMap, Collection<Long> itemIds) {
        for (Map.Entry<Long, Map<Long, Object>> entry : itemResultMap.entrySet()) {
            Map<Long, Object> itemMap = entry.getValue();
            for (Long itemId : itemIds) {
                itemMap.put(itemId, null);
            }
        }
    }

    private static List<DynamicObject> getCalPersonDyObjListByPageSize(List<Long> fileIdList, Long taskId, String searchText, int pageSize, int pageIndex) {
        List<QFilter> calPersonFilters = AdjustDataHelper.getCalPersonFilters(fileIdList, searchText, taskId);
        StringBuilder fields = new StringBuilder("id,filenumberdb,namedb,empnumberdb,calstatus,sinsurfilev.boid,sinsurstdv.name");
        String orderByStr = "filenumberdb asc";
        QFilter[] filters = calPersonFilters.toArray(new QFilter[calPersonFilters.size()]);
        DynamicObject[] personObjs = BusinessDataServiceHelper.load((String)"hcsi_calperson", (String)fields.toString(), (QFilter[])filters, (String)orderByStr, (int)(pageIndex - 1), (int)pageSize);
        if (personObjs == null || personObjs.length == 0) {
            return new ArrayList<DynamicObject>(0);
        }
        return new ArrayList<DynamicObject>(Arrays.asList(personObjs));
    }

    public static int getCalPersonDyObjCount(List<Long> fileIdList, String searchText, Long taskId) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hcsi_calperson");
        List<QFilter> calPersonFilters = AdjustDataHelper.getCalPersonFilters(fileIdList, searchText, taskId);
        return helper.count("hcsi_calperson", calPersonFilters.toArray(new QFilter[calPersonFilters.size()]));
    }

    public static List<QFilter> getCalPersonFilters(List<Long> fileIdList, String searchText, Long taskId) {
        List authorizedDataRuleQFilter;
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(10);
        QFilter personFilter = new QFilter("sinsurtask.id", "=", (Object)taskId);
        if (!SITListUtil.isEmpty(fileIdList)) {
            personFilter.and("sinsurfilev.boid", "in", fileIdList);
        }
        if ((authorizedDataRuleQFilter = SITPermissionServiceHelper.getAuthorizedDataRuleQFilter((String)"2AXKDRPJUQ77", (String)"hcsi_calperson", (String)"47150e89000000ac")) != null) {
            filterList.addAll(authorizedDataRuleQFilter);
        } else {
            filterList.add(new QFilter("1", "!=", (Object)1));
        }
        if (SITStringUtils.isNotEmpty((String)searchText)) {
            QFilter filterLike = new QFilter("filenumberdb", "like", (Object)("%" + searchText + "%"));
            filterLike.or("namedb", "like", (Object)("%" + searchText + "%"));
            filterLike.or("empnumberdb", "like", (Object)("%" + searchText + "%"));
            filterList.add(filterLike);
        }
        filterList.add(personFilter);
        return filterList;
    }

    public static List<Long> getAdjustDataFileIdList(Long taskId, List<Long> fileIdList) {
        DynamicObjectCollection dynamicObjects;
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hcsi_sinsuradjdata");
        QFilter filter = new QFilter("sinsurtask.id", "=", (Object)taskId);
        if (!SITListUtil.isEmpty(fileIdList)) {
            filter.and("sinsurfile.id", "in", fileIdList);
        }
        if (SITListUtil.isEmpty((List)(dynamicObjects = helper.queryOriginalCollection("sinsurfile.id", new QFilter[]{filter})))) {
            return new ArrayList<Long>(0);
        }
        Set fileIdSet = dynamicObjects.stream().map(obj -> obj.getLong("sinsurfile.id")).collect(Collectors.toSet());
        return new ArrayList<Long>(fileIdSet);
    }

    public static List<Long> getCalPersonFileIdList(List<Long> personIdList) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hcsi_calperson");
        QFilter filter = new QFilter("id", "in", personIdList);
        DynamicObjectCollection personObjs = helper.queryOriginalCollection("sinsurfilev.boid", new QFilter[]{filter});
        if (SITListUtil.isEmpty((List)personObjs)) {
            return new ArrayList<Long>(0);
        }
        return personObjs.stream().map(obj -> obj.getLong("sinsurfilev.boid")).collect(Collectors.toList());
    }

    private static void addAdjustEntryData(Map<String, String> rowsIdMap, int pageRows, DynamicObjectCollection entryEntities, int pageIndex, Set<Long> itemIdSet, Map<String, Map<String, String>> matchPersonDataMap, List<Long> personIdList, Map<Long, Map<Long, Object>> itemDataMap) {
        int rowIndex = pageRows * (pageIndex - 1) - 1;
        for (Long personId : personIdList) {
            boolean isEmpty;
            Map<String, String> personMap = matchPersonDataMap.get(personId + "");
            String fileId = personMap.get("sinsurfile");
            Map<Long, Object> itemMap = itemDataMap.get(Long.parseLong(fileId));
            if (itemMap == null || itemMap.size() == 0 || (isEmpty = AdjustDataHelper.checkItemDataEmpty(itemMap))) continue;
            ++rowIndex;
            DynamicObject singleEntry = entryEntities.addNew();
            String fielNumber = personMap.get("filenumber");
            String name = personMap.get("name");
            String empNumber = personMap.get("empnumber");
            String sinsurstd = personMap.get("sinsurstd");
            String memo = personMap.get("memo");
            String status = personMap.get("calstatusname");
            singleEntry.set("idstr", (Object)fileId);
            singleEntry.set("personid", (Object)personId);
            singleEntry.set("filenumber", (Object)fielNumber);
            singleEntry.set("name", (Object)name);
            singleEntry.set("empnumber", (Object)empNumber);
            singleEntry.set("sinsurstd", (Object)sinsurstd);
            singleEntry.set("memo", (Object)memo);
            singleEntry.set("status", (Object)status);
            AdjustDataHelper.addItemFieldData(singleEntry, itemIdSet, itemMap);
            rowsIdMap.put(rowIndex + "", personId + "");
        }
    }

    private static void addItemFieldData(DynamicObject singleEntry, Set<Long> itemIdSet, Map<Long, Object> itemDataMap) {
        try {
            for (Long itemId : itemIdSet) {
                String key = "key_" + itemId;
                Object value = itemDataMap.get(itemId);
                if (value == null) continue;
                singleEntry.set(key, (Object)new BigDecimal(value.toString()).toPlainString());
            }
        }
        catch (Exception exception) {
            logger.error("date parse error", (Throwable)exception);
        }
    }

    private static boolean checkItemDataEmpty(Map<Long, Object> itemData) {
        boolean isEmpty = true;
        for (Map.Entry<Long, Object> data : itemData.entrySet()) {
            if (ObjectUtils.isEmpty((Object)data.getValue())) continue;
            isEmpty = false;
            break;
        }
        return isEmpty;
    }

    public static Map<Long, Map<String, Object>> getCacheItemMap(Long taskId, String personPageId) {
        ISITAppCache appCache = SITAppCache.get((String)String.format(Locale.ROOT, "viewadjustdata_%s", taskId));
        if (appCache == null) {
            return new HashMap<Long, Map<String, Object>>(0);
        }
        String cacheKey = String.format(Locale.ROOT, "adjustdataitem_%d_%s", taskId, personPageId);
        String itemMapStr = (String)appCache.get(cacheKey, String.class);
        return (Map)SerializationUtils.deSerializeFromBase64((String)itemMapStr);
    }

    public static void assembleAndCacheItemMap(Long taskId, String pageId) {
        LinkedHashMap<Long, Map<String, Object>> itemMap = new LinkedHashMap<Long, Map<String, Object>>(16);
        List<InsuredStandard> insuredStandards = SocialInsuranceCalHelper.getInsuranceItemInfoGroupByTask(taskId);
        for (InsuredStandard insuredStandard : insuredStandards) {
            if (!AdjustDataConstants.ADJUST_DATA_SRC.contains(insuredStandard.getDataSrc())) continue;
            Map dataMap = itemMap.computeIfAbsent(insuredStandard.getInsuredItemId(), map -> new HashMap(16));
            dataMap.put("itemId", insuredStandard.getInsuredItemId());
            dataMap.put("itemName", insuredStandard.getInsuredItemName());
            dataMap.put("dataType", insuredStandard.getDataTypeId());
            dataMap.put("scale", insuredStandard.getScale());
            dataMap.put("roundType", insuredStandard.getDataRound());
        }
        AdjustDataHelper.cacheItemMap(itemMap, taskId, pageId);
    }

    public static void cacheItemMap(Map<Long, Map<String, Object>> itemMap, Long taskId, String personPageId) {
        ISITAppCache appCache = SITAppCache.get((String)String.format(Locale.ROOT, "viewadjustdata_%s", taskId));
        if (appCache == null) {
            return;
        }
        String cacheKey = String.format(Locale.ROOT, "adjustdataitem_%d_%s", taskId, personPageId);
        appCache.put(cacheKey, (Object)SerializationUtils.serializeToBase64(itemMap));
    }

    private static void cacheAdjustDataCount(Long taskId, String personPageId, int count) {
        ISITAppCache appCache = SITAppCache.get((String)String.format(Locale.ROOT, "viewadjustdata_%s", taskId));
        String cacheKey = String.format(Locale.ROOT, "viewadjustdatacount_%d_%s", taskId, personPageId);
        appCache.put(cacheKey, (Object)count);
    }

    public static void deleteAdjustData(Long taskId, List<String> selectedFileIdList) {
        List<Long> fileIdList = selectedFileIdList.stream().map(single -> Long.parseLong(single)).collect(Collectors.toList());
        DynamicObjectCollection validPersonList = AdjustDataHelper.getValidDeletePersonObjList(fileIdList, taskId);
        ArrayList<Long> validPersonIdList = new ArrayList<Long>(validPersonList.size());
        ArrayList<Long> validFileIdList = new ArrayList<Long>(validPersonList.size());
        for (DynamicObject personObj : validPersonList) {
            validPersonIdList.add(personObj.getLong("id"));
            validFileIdList.add(personObj.getLong("sinsurfilev.boid"));
        }
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hcsi_sinsuradjdata");
        QFilter filter = new QFilter("sinsurtask.id", "=", (Object)taskId);
        filter.and("sinsurfile.id", "in", validFileIdList);
        HashMap<Long, List> fileItemMap = new HashMap<Long, List>(validFileIdList.size());
        HashMap<Long, Map> oldAdjDataMap = new HashMap<Long, Map>(16);
        DynamicObjectCollection fileAdjDataObjs = helper.queryOriginalCollection("sinsurfile.id,insuranceitem.id,adjvalue", new QFilter[]{filter});
        for (DynamicObject adjDataObj : fileAdjDataObjs) {
            long fileId = adjDataObj.getLong("sinsurfile.id");
            long itemId = adjDataObj.getLong("insuranceitem.id");
            Iterator<DynamicObject> adjValue = adjDataObj.get("adjvalue");
            List itemIdList = fileItemMap.computeIfAbsent(fileId, single -> new ArrayList(0));
            Map oldDataMap = oldAdjDataMap.computeIfAbsent(fileId, single -> new HashMap(0));
            oldDataMap.put(itemId, adjValue);
            itemIdList.add(itemId);
        }
        helper.deleteByFilter(new QFilter[]{filter});
        QFilter recFilter = new QFilter("sinsurfile.id", "in", validFileIdList).and("sinsurtask.id", "=", (Object)taskId);
        List<DynamicObject> adjDataRecordDyList = AdjustDataHelper.querySocInsuranceAdjustDataRecordInfo(recFilter);
        Map adjDataRecordDyMap = adjDataRecordDyList.stream().collect(Collectors.toMap(v1 -> v1.getLong("sinsurfile.id"), Function.identity()));
        String selectCalPersonInfo = "id,sinsurfilev.boid,sinsurstdv.id,employee.id,namedb,empnumberdb,sinsurperiod.id,welfarepayer.id,storagetype,insuranceitem.id,amountvalue,numvalue,isnull,datasrc";
        List<DynamicObject> calPeronInfoList = AdjustDataHelper.queryCalPersonInfo(selectCalPersonInfo, AdjustDataHelper.getValidCalPersonFilter(validPersonIdList, taskId, false));
        Date nowDate = new Date();
        for (DynamicObject calPeronInfo : calPeronInfoList) {
            long fileId = calPeronInfo.getLong("sinsurfilev.boid");
            List itemIdList = (List)fileItemMap.get(fileId);
            if (SITListUtil.isEmpty((List)itemIdList)) continue;
            DynamicObjectCollection resultEntryEntity = calPeronInfo.getDynamicObjectCollection("entryentity");
            DynamicObject recordDyObj = (DynamicObject)adjDataRecordDyMap.get(fileId);
            DynamicObjectCollection recordDetails = recordDyObj.getDynamicObjectCollection("entryentity");
            recordDyObj.set("modifier", (Object)RequestContext.get().getCurrUserId());
            recordDyObj.set("modifytime", (Object)nowDate);
            for (DynamicObject resultEntry : resultEntryEntity) {
                Long insuranceItemId = resultEntry.getLong("insuranceitem.id");
                if (!itemIdList.contains(insuranceItemId)) continue;
                DynamicObject adjRecordObj = recordDetails.addNew();
                boolean isNumber = "number".equals(resultEntry.getString("storagetype"));
                if (isNumber) {
                    resultEntry.set("numvalue", null);
                } else {
                    resultEntry.set("amountvalue", null);
                }
                resultEntry.set("amountvalue", null);
                resultEntry.set("isnull", (Object)Boolean.TRUE);
                Map adjDataMap = (Map)oldAdjDataMap.get(fileId);
                adjRecordObj.set("insuranceitem", (Object)insuranceItemId);
                adjRecordObj.set("oldvalue", adjDataMap.get(insuranceItemId));
                adjRecordObj.set("oldvalueisnull", (Object)Boolean.FALSE);
                adjRecordObj.set("newvalue", null);
                adjRecordObj.set("operator", (Object)RequestContext.get().getCurrUserId());
                adjRecordObj.set("operatetime", (Object)nowDate);
            }
            calPeronInfo.set("entryentity", (Object)resultEntryEntity);
        }
        helper = new HRBaseServiceHelper("hcsi_calperson");
        helper.update(calPeronInfoList.toArray(new DynamicObject[0]));
        Collection<DynamicObject> recordObjs = adjDataRecordDyMap.values();
        helper = new HRBaseServiceHelper("hcsi_sinsuradjrec");
        helper.save(recordObjs.toArray(new DynamicObject[0]));
    }

    public static DynamicObjectCollection getValidDeletePersonObjList(List<Long> fileIdList, Long taskId) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hcsi_calperson");
        QFilter filter = new QFilter("sinsurtask.id", "=", (Object)taskId);
        filter.and("sinsurfilev.boid", "in", fileIdList);
        filter.and("calstatus", "=", (Object)"0");
        return helper.queryOriginalCollection("id,sinsurfilev.boid", new QFilter[]{filter});
    }

    public static List<Object> getPersonIdByFileId(List<String> selectedFileIdList, Long taskId) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hcsi_calperson");
        QFilter filter = new QFilter("sinsurtask.id", "=", (Object)taskId);
        filter.and("calstatus", "=", (Object)"0");
        List fileIdList = selectedFileIdList.stream().map(single -> Long.parseLong(single)).collect(Collectors.toList());
        filter.and("sinsurfilev.boid", "in", fileIdList);
        DynamicObjectCollection personObjs = helper.queryOriginalCollection("id", new QFilter[]{filter});
        if (SITListUtil.isEmpty((List)personObjs)) {
            return new ArrayList<Object>(0);
        }
        return personObjs.stream().map(single -> single.getLong("id")).collect(Collectors.toList());
    }

    public static Map<Long, Map<Long, BigDecimal>> queryItemAdjustData(LinkedHashSet<Object> calPersonIdLinkedSet, Long taskId, String personPageId) {
        HashMap<Long, Map<Long, BigDecimal>> adjustDataMap = new HashMap<Long, Map<Long, BigDecimal>>(16);
        Map<Long, Map<String, Object>> itemMap = AdjustDataHelper.getCacheItemMap(taskId, personPageId);
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hcsi_calperson");
        QFilter filter = new QFilter("sinsurtask.id", "=", (Object)taskId);
        filter.and("id", "in", calPersonIdLinkedSet);
        DynamicObjectCollection personObjs = helper.queryOriginalCollection("id,sinsurfilev.boid", new QFilter[]{filter});
        if (SITListUtil.isEmpty((List)personObjs)) {
            return adjustDataMap;
        }
        Map<Long, Long> filePersonIdMap = personObjs.stream().collect(Collectors.toMap(v1 -> v1.getLong("sinsurfilev.boid"), v2 -> v2.getLong("id")));
        helper = new HRBaseServiceHelper("hcsi_sinsuradjdata");
        QFilter adjDataFilter = new QFilter("sinsurtask.id", "=", (Object)taskId);
        adjDataFilter.and("sinsurfile.id", "in", filePersonIdMap.keySet());
        adjDataFilter.and("insuranceitem.id", "in", itemMap.keySet());
        DynamicObjectCollection adjDataDys = helper.queryOriginalCollection("sinsurfile.id,insuranceitem.id,adjvalue", new QFilter[]{adjDataFilter});
        if (SITListUtil.isEmpty((List)adjDataDys)) {
            return adjustDataMap;
        }
        for (DynamicObject adjDataDy : adjDataDys) {
            Map adjDataMap = adjustDataMap.computeIfAbsent(filePersonIdMap.get(adjDataDy.getLong("sinsurfile.id")), value -> new HashMap(16));
            adjDataMap.put(adjDataDy.getLong("insuranceitem.id"), adjDataDy.getBigDecimal("adjvalue"));
        }
        return adjustDataMap;
    }

    public static int querySelectAdjustData(Long taskId, List<Long> fileIdList) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hcsi_sinsuradjdata");
        QFilter adjDataFilter = new QFilter("sinsurtask.id", "=", (Object)taskId);
        adjDataFilter.and("sinsurfile.id", "in", fileIdList);
        return helper.count("hcsi_sinsuradjdata", new QFilter[]{adjDataFilter});
    }

    public static List<Object> getCalPersonIdsWithAdjustAuthor(List<Object> personIdList, String operateKey) {
        if (personIdList == null || personIdList.isEmpty()) {
            return new ArrayList<Object>(0);
        }
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hcsi_calperson");
        QFilter idFilter = new QFilter("id", "in", personIdList);
        QFilter filter = AdjustDataHelper.getAdjustFilter(operateKey);
        idFilter.and(filter);
        DynamicObjectCollection personObjs = helper.queryOriginalCollection("id", new QFilter[]{idFilter});
        if (SITListUtil.isEmpty((List)personObjs)) {
            return new ArrayList<Object>(0);
        }
        return personObjs.stream().map(calPersonDy -> calPersonDy.getLong("id")).distinct().collect(Collectors.toList());
    }

    public static QFilter getAdjustFilter(String operateKey) {
        QFilter filter = new QFilter("calstatus", "=", (Object)"0");
        filter.and("isadjust", "=", (Object)Boolean.TRUE);
        List exportAdjustDataFilter = SITPermissionServiceHelper.getAuthorizedDataRuleQFilterByOpKey((String)"2AXKDRPJUQ77", (String)"hcsi_calperson", (String)operateKey);
        if (exportAdjustDataFilter == null) {
            filter.and("1", "!=", (Object)1);
        } else {
            exportAdjustDataFilter.forEach(arg_0 -> ((QFilter)filter).and(arg_0));
        }
        return filter;
    }

    public static List<Long> queryCalPersonFileIds(QFilter filter) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hcsi_calperson");
        DynamicObjectCollection personObjs = helper.queryOriginalCollection("sinsurfilev.boid", new QFilter[]{filter});
        if (SITListUtil.isEmpty((List)personObjs)) {
            return new ArrayList<Long>(0);
        }
        return personObjs.stream().map(single -> single.getLong("sinsurfilev.boid")).collect(Collectors.toList());
    }
}

