/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.business.caladjust.service;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.cache.IHRAppCache;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hies.common.dto.AbstractEventArgs;
import kd.sdk.sit.hcsi.common.entity.cal.InsuredStandard;
import kd.sit.hcsi.business.cal.SocialInsuranceCalHelper;
import kd.sit.hcsi.business.cal.service.InsuranceStandardService;
import kd.sit.hcsi.business.caladjust.constants.AdjustDataConstants;
import kd.sit.hcsi.business.caladjust.dto.AdjustDataDTO;
import kd.sit.hcsi.business.caladjust.errinfo.HCSIErrInfoEnum;
import kd.sit.hcsi.business.caladjust.helper.AdjustDataHelper;
import kd.sit.hcsi.common.vo.InsuranceItemVo;
import kd.sit.sitbp.business.helper.SITLogServiceHelper;
import kd.sit.sitbp.business.helper.excel.ExcelHelper;
import kd.sit.sitbp.business.servicehelper.SITPermissionServiceHelper;
import kd.sit.sitbp.common.cache.ISITAppCache;
import kd.sit.sitbp.common.cache.SITAppCache;
import kd.sit.sitbp.common.entity.social.InsurTypeAttrEntity;
import kd.sit.sitbp.common.enums.DataRoundEnum;
import kd.sit.sitbp.common.enums.InsurTypeAttrEnum;
import kd.sit.sitbp.common.enums.SITShowType;
import kd.sit.sitbp.common.enums.SitDataTypeEnum;
import kd.sit.sitbp.common.util.SITDateTimeUtils;
import kd.sit.sitbp.common.util.SITListUtil;
import kd.sit.sitbp.common.util.SITStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFDrawing;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;

public class AdjustDataService {
    private static final Log logger = LogFactory.getLog(AdjustDataService.class);
    private static final String SYSTEM_TYPE = "sit-hcsi-business";

    public static AdjustDataDTO getAdjustDataDTO(String parentPageId) {
        return AdjustDataService.getAdjustDataDTOFromCache(parentPageId);
    }

    public static AdjustDataDTO getAdjustDataDTOFromCache(String pageId) {
        IHRAppCache appCache = HRAppCache.get((String)("adjust_data_cache_key" + pageId));
        AdjustDataDTO adjustDataDTO = null;
        String adjustDataDTOStr = (String)appCache.get("adjust_data_cache_key", String.class);
        if (adjustDataDTOStr != null) {
            adjustDataDTO = (AdjustDataDTO)SerializationUtils.deSerializeFromBase64((String)adjustDataDTOStr);
        }
        return AdjustDataDTO.updateInstance(adjustDataDTO);
    }

    public static void updateAdjustDataDTOToCache(AdjustDataDTO adjustDataDTO, String parentPageId) {
        IHRAppCache appCache = HRAppCache.get((String)("adjust_data_cache_key" + parentPageId));
        appCache.put("adjust_data_cache_key", (Object)SerializationUtils.serializeToBase64((Object)adjustDataDTO));
    }

    public static void clearCache(String pageId) {
        ISITAppCache appCache = SITAppCache.get((String)("adjust_data_cache_key" + pageId));
        appCache.clear();
    }

    public static AdjustDataDTO getAdjustDataDTOByCalPerson(List<Object> calPersons, Long taskId, boolean isView) {
        String selectCalPersonInfo = "id,sinsurfilev.boid,sinsurfilev.id,sinsurstdv.id,employee.id,namedb,empnumberdb,sinsurperiod.id,welfarepayer.id,insuranceitem.id,amountvalue,isnull,datasrc";
        QFilter filter = AdjustDataHelper.getCalPersonFilter(calPersons, taskId, isView);
        filter.and("isadjust", "=", (Object)Boolean.TRUE);
        List<DynamicObject> calPeronDys = AdjustDataHelper.queryCalPersonInfo(selectCalPersonInfo, filter);
        if (calPeronDys.isEmpty()) {
            return null;
        }
        LinkedHashSet<Long> calPersonIdLinkedSet = new LinkedHashSet<Long>(calPeronDys.size());
        Set<Long> validItemIds = AdjustDataService.filterCalPersonAndGetAllValidItemId(calPeronDys, calPersonIdLinkedSet);
        Map<Long, InsuredStandard> itemInfo = SocialInsuranceCalHelper.getItemInfo(validItemIds);
        AdjustDataDTO adjustDataDTO = AdjustDataDTO.updateInstance(null);
        ArrayList<Long> fileBoIds = new ArrayList<Long>(calPeronDys.size());
        HashSet<Long> insurStdVIds = new HashSet<Long>(16);
        calPeronDys.forEach(calPeronDy -> {
            fileBoIds.add(calPeronDy.getLong("sinsurfilev.boid"));
            insurStdVIds.add(calPeronDy.getLong("sinsurstdv.id"));
        });
        Table<Long, Long, String> stdIdAndInsurItemIdAndRoundTypeInStdTable = InsuranceStandardService.getInsuranceStandardBy(insurStdVIds, null);
        logger.info("AdjustDataService.getAdjustDataDTOByCalPerson, stdIdAndInsurItemIdAndRoundTypeInStdTable info is {}", (Object)JSON.toJSONString(stdIdAndInsurItemIdAndRoundTypeInStdTable));
        Map<Long, Map<Long, Object>> itemDataMapTemp = AdjustDataHelper.assembleAdjustDataMap(taskId, fileBoIds, itemInfo.keySet());
        for (DynamicObject calPeronDy2 : calPeronDys) {
            HashBasedTable<Object, String, Object> calPersonIdAndDetailInfoBasedTable = adjustDataDTO.getCalPersonIdAndDetailInfoBasedTable();
            Long calPersonId = calPeronDy2.getLong("id");
            AdjustDataService.initFixedColumns(calPersonIdAndDetailInfoBasedTable, calPeronDy2, calPersonId);
            long fileBoId = calPeronDy2.getLong("sinsurfilev.boid");
            Map<Long, Object> personAdjDataMap = itemDataMapTemp.get(fileBoId);
            DynamicObjectCollection resultEntryEntity = calPeronDy2.getDynamicObjectCollection("entryentity");
            List resultItemList = resultEntryEntity.stream().map(single -> single.getLong("insuranceitem.id")).collect(Collectors.toList());
            ArrayList<String> validItemIdList = new ArrayList<String>(10);
            long tmpStdVID = calPeronDy2.getLong("sinsurstdv.id");
            for (Long itemId : resultItemList) {
                validItemIdList.add(itemId + "");
                String roundTypeStr = itemId + "roundtype";
                Object roundType = stdIdAndInsurItemIdAndRoundTypeInStdTable.get((Object)tmpStdVID, (Object)itemId);
                if (roundType != null && String.valueOf(roundType).length() > 0) {
                    roundTypeStr = roundTypeStr + "_1";
                } else {
                    InsuredStandard insuredStandard = itemInfo.get(itemId);
                    if (insuredStandard != null) {
                        roundType = insuredStandard.getDataRound();
                        roundTypeStr = roundTypeStr + "_2";
                    }
                }
                if (roundType == null) {
                    logger.info("AdjustDataService.getAdjustDataDTOByCalPerson, itemId:{}, roundType is null", (Object)itemId);
                    continue;
                }
                if (personAdjDataMap != null && personAdjDataMap.get(itemId) != null) {
                    calPersonIdAndDetailInfoBasedTable.put((Object)calPersonId, (Object)String.valueOf(itemId), personAdjDataMap.get(itemId));
                }
                calPersonIdAndDetailInfoBasedTable.put((Object)calPersonId, (Object)roundTypeStr, roundType);
            }
            calPersonIdAndDetailInfoBasedTable.put((Object)calPersonId, (Object)"validItemIdList", validItemIdList);
        }
        adjustDataDTO.setCalTaskId(taskId);
        adjustDataDTO.getSearchedCalPersonIdLinkedSet().addAll(new LinkedHashSet<Object>(calPersons));
        adjustDataDTO.getSearchedCalPersonIdLinkedSet().retainAll(calPersonIdLinkedSet);
        LinkedHashMap<String, Map<String, Object>> dynamicFieldIdAndAttrMap = adjustDataDTO.getDynamicFieldIdAndAttrMap();
        for (InsuredStandard insuredStandard : itemInfo.values()) {
            Map itemAttMap = dynamicFieldIdAndAttrMap.computeIfAbsent(String.valueOf(insuredStandard.getInsuredItemId()), key -> new HashMap(4));
            itemAttMap.put("name", insuredStandard.getInsuredItemName());
            if (insuredStandard.isScaleEmpty()) {
                itemAttMap.put("scale", 2);
                itemAttMap.put("round", 4);
                continue;
            }
            itemAttMap.put("scale", insuredStandard.getScale());
            itemAttMap.put("round", insuredStandard.getDataRound());
        }
        return adjustDataDTO;
    }

    private static Set<Long> filterCalPersonAndGetAllValidItemId(List<DynamicObject> calPeronInfoList, Set<Long> calPersonIds) {
        if (calPeronInfoList == null || calPeronInfoList.size() == 0) {
            return new HashSet<Long>(0);
        }
        HashSet<Long> validItemIds = new HashSet<Long>(16);
        ArrayList<DynamicObject> removeCalPersonDys = new ArrayList<DynamicObject>(10);
        for (DynamicObject calPersonDy : calPeronInfoList) {
            DynamicObjectCollection entryEntity = calPersonDy.getDynamicObjectCollection("entryentity");
            ArrayList<DynamicObject> removeEntities = new ArrayList<DynamicObject>(10);
            for (DynamicObject entity : entryEntity) {
                if (AdjustDataConstants.ADJUST_DATA_SRC.contains(entity.getString("datasrc"))) {
                    validItemIds.add(entity.getLong("insuranceitem.id"));
                    continue;
                }
                removeEntities.add(entity);
            }
            entryEntity.removeAll(removeEntities);
            if (entryEntity.isEmpty()) {
                removeCalPersonDys.add(calPersonDy);
                continue;
            }
            if (calPersonIds == null) continue;
            calPersonIds.add(calPersonDy.getLong("id"));
        }
        calPeronInfoList.removeAll(removeCalPersonDys);
        return validItemIds;
    }

    public static void getCalPersonInfo(Long taskId, Set<String> sInsurFileNumbers, Table<Object, String, Object> calPersonIdAndDetailInfoInDbBasedTable, Map<String, Long> sInsurFileNumberAndCalPersonIdMap, Table<Long, Long, String> stdIdAndInsurItemIdAndRoundTypeInStdTable) {
        String selectCalPersonInfo = "id,sinsurfilev.boid,sinsurfilev.number,sinsurfilev.number,sinsurstdv.id,employee.id,namedb,empnumberdb,sinsurperiod.id,welfarepayer.id,insuranceitem.id,amountvalue,isnull,datasrc,storagetype,numvalue";
        QFilter filter = AdjustDataHelper.getCalPersonFilterByFileNumberAndTaskId(sInsurFileNumbers, taskId);
        filter.and("isadjust", "=", (Object)Boolean.TRUE);
        List<DynamicObject> calPeronInfoList = AdjustDataHelper.queryCalPersonInfo(selectCalPersonInfo, filter);
        for (DynamicObject calPeronInfoDy : calPeronInfoList) {
            Long calPersonId = calPeronInfoDy.getLong("id");
            sInsurFileNumberAndCalPersonIdMap.put(calPeronInfoDy.getString("sinsurfilev.number"), calPersonId);
            DynamicObjectCollection resultEntryEntity = calPeronInfoDy.getDynamicObjectCollection("entryentity");
            resultEntryEntity.removeIf(entity -> !AdjustDataConstants.ADJUST_DATA_SRC.contains(entity.getString("datasrc")));
            if (resultEntryEntity.isEmpty()) continue;
            AdjustDataService.initFixedColumns(calPersonIdAndDetailInfoInDbBasedTable, calPeronInfoDy, calPersonId);
            long standardVId = calPeronInfoDy.getLong("sinsurstdv.id");
            for (DynamicObject resultEntity : resultEntryEntity) {
                Long insuranceItemId = resultEntity.getLong("insuranceitem.id");
                BigDecimal itemAmountValue = AdjustDataService.getCalPersonItemVal(resultEntity);
                String roundType = insuranceItemId + "roundtype";
                String roundTypeVal = (String)stdIdAndInsurItemIdAndRoundTypeInStdTable.get((Object)standardVId, (Object)insuranceItemId);
                if (roundTypeVal != null) {
                    calPersonIdAndDetailInfoInDbBasedTable.put((Object)calPersonId, (Object)roundType, (Object)roundTypeVal);
                }
                calPersonIdAndDetailInfoInDbBasedTable.put((Object)calPersonId, (Object)String.valueOf(insuranceItemId), (Object)itemAmountValue);
            }
        }
    }

    public static BigDecimal getCalPersonItemVal(DynamicObject resultEntity) {
        boolean isNull = resultEntity.getBoolean("isnull");
        boolean isNumber = "number".equals(resultEntity.getString("storagetype"));
        return isNull ? BigDecimal.ZERO : (isNumber ? resultEntity.getBigDecimal("numvalue") : resultEntity.getBigDecimal("amountvalue"));
    }

    private static void initFixedColumns(Table<Object, String, Object> calPersonIdAndDetailInfoInDbBasedTable, DynamicObject calPeronInfoDy, Long calPersonId) {
        calPersonIdAndDetailInfoInDbBasedTable.put((Object)calPersonId, (Object)"hcsi_sinsurfile", (Object)calPeronInfoDy.getLong("sinsurfilev.boid"));
        calPersonIdAndDetailInfoInDbBasedTable.put((Object)calPersonId, (Object)"hrpi_employee", (Object)calPeronInfoDy.getLong("employee.id"));
        String personName = calPeronInfoDy.getString("namedb");
        personName = personName == null ? " " : personName;
        String personNum = calPeronInfoDy.getString("empnumberdb");
        personNum = personNum == null ? " " : personNum;
        calPersonIdAndDetailInfoInDbBasedTable.put((Object)calPersonId, (Object)"name", (Object)personName);
        calPersonIdAndDetailInfoInDbBasedTable.put((Object)calPersonId, (Object)"empnumber", (Object)personNum);
        calPersonIdAndDetailInfoInDbBasedTable.put((Object)calPersonId, (Object)"sitbs_sinsurstd", (Object)calPeronInfoDy.getLong("sinsurstdv.id"));
    }

    public static void saveAdjustData(Long taskId, Table<Object, String, Object> currPersonIdAndDetailInfoBasedTable, Table<Object, String, Object> preCalPersonIdAndDetailInfoBasedTable) {
        if (currPersonIdAndDetailInfoBasedTable.cellSet().isEmpty() || preCalPersonIdAndDetailInfoBasedTable.cellSet().isEmpty()) {
            return;
        }
        List<Object> socInsuranceFileIdColl = currPersonIdAndDetailInfoBasedTable.rowKeySet().stream().map(calPersonId -> preCalPersonIdAndDetailInfoBasedTable.row(calPersonId).get("hcsi_sinsurfile")).collect(Collectors.toList());
        List<DynamicObject> socInsuranceAdjustDataRecordDys = AdjustDataHelper.querySocInsuranceAdjustDataRecordInfo(AdjustDataHelper.sInsureAdjustDataRecordQFilter(socInsuranceFileIdColl, taskId));
        HashMap sInsurFileIdAndAdjustDataRecordInfoMap = new HashMap(socInsuranceAdjustDataRecordDys.size());
        socInsuranceAdjustDataRecordDys.forEach(adjustDataRecordDy -> sInsurFileIdAndAdjustDataRecordInfoMap.put(adjustDataRecordDy.getLong("sinsurfile.id"), adjustDataRecordDy));
        List<DynamicObject> calPersonInfoDys = AdjustDataHelper.loadCalPersonInfo(AdjustDataHelper.getCalPersonFilterForAdjust(currPersonIdAndDetailInfoBasedTable.rowKeySet()));
        HashBasedTable calPersonIdAndItemIdAndDyBasedTable = HashBasedTable.create((int)16, (int)16);
        Map calPersonObjMap = calPersonInfoDys.stream().collect(Collectors.toMap(key1 -> key1.getLong("id"), Function.identity()));
        calPersonInfoDys.forEach(calPersonInfoDy -> {
            Object calPersonIdObj = calPersonInfoDy.getPkValue();
            DynamicObjectCollection insuranceItemEntryEntity = calPersonInfoDy.getDynamicObjectCollection("entryentity");
            insuranceItemEntryEntity.forEach(insuranceItemEntity -> {
                DynamicObject cfr_ignored_0 = (DynamicObject)calPersonIdAndItemIdAndDyBasedTable.put(calPersonIdObj, (Object)insuranceItemEntity.getString("insuranceitem.id"), insuranceItemEntity);
            });
        });
        HRBaseServiceHelper insuranceAdjustDataRecordHelper = new HRBaseServiceHelper("hcsi_sinsuradjrec");
        HRBaseServiceHelper adjustDataHelper = new HRBaseServiceHelper("hcsi_sinsuradjdata");
        Date nowDate = new Date();
        int size = currPersonIdAndDetailInfoBasedTable.rowMap().size() - socInsuranceAdjustDataRecordDys.size();
        ArrayList<DynamicObject> newInsuranceAdjustDataRecords = new ArrayList<DynamicObject>(10);
        long[] pkIdArr = AdjustDataService.getPkIdArr(size);
        int index = 0;
        ArrayList<DynamicObject> personAdjustDataList = new ArrayList<DynamicObject>(10);
        HashMap<Long, List<Long>> personAdjustItemMap = new HashMap<Long, List<Long>>(16);
        Set changedPersonIds = preCalPersonIdAndDetailInfoBasedTable.rowKeySet();
        for (Map.Entry currPersonIdAndDetailInfoMapLinkedEntry : currPersonIdAndDetailInfoBasedTable.rowMap().entrySet()) {
            boolean isContinue;
            Object calPersonIdObj = currPersonIdAndDetailInfoMapLinkedEntry.getKey();
            if (!changedPersonIds.contains(calPersonIdObj)) continue;
            Long insuranceFileId = ((DynamicObject)calPersonObjMap.get(calPersonIdObj)).getLong("sinsurfilev.boid");
            Long employeeId = ((DynamicObject)calPersonObjMap.get(calPersonIdObj)).getLong("employee.id");
            DynamicObject adjustDataRecordDy2 = (DynamicObject)sInsurFileIdAndAdjustDataRecordInfoMap.get(insuranceFileId);
            LinkedHashMap<String, Object> personDetailInfoMap = new LinkedHashMap<String, Object>((Map)currPersonIdAndDetailInfoMapLinkedEntry.getValue());
            Object memo = personDetailInfoMap.get("memo");
            boolean isNew = false;
            if (adjustDataRecordDy2 == null && pkIdArr != null && size > 0) {
                adjustDataRecordDy2 = insuranceAdjustDataRecordHelper.generateEmptyDynamicObject();
                newInsuranceAdjustDataRecords.add(adjustDataRecordDy2);
                isNew = true;
            }
            if (!Objects.isNull(memo) && SITStringUtils.isNotEmpty((String)(memo + "")) && adjustDataRecordDy2 != null) {
                adjustDataRecordDy2.set("memo", memo);
            }
            personDetailInfoMap.remove("memo");
            boolean hasSaveItem = AdjustDataService.getHasSaveItem(personDetailInfoMap);
            boolean bl = isContinue = !hasSaveItem || adjustDataRecordDy2 == null || isNew && pkIdArr != null && index >= pkIdArr.length;
            if (isContinue) {
                logger.error("AdjustDataService.saveAdjustData: calPersonId is {}, insuranceFileId is {}, and {}", new Object[]{calPersonIdObj, insuranceFileId, adjustDataRecordDy2 == null ? "adjustDataRecordDy is null" : "index out of range."});
                continue;
            }
            if (isNew && pkIdArr != null && index < pkIdArr.length) {
                long pkId = pkIdArr[index];
                adjustDataRecordDy2.set("id", (Object)pkId);
                adjustDataRecordDy2.set("sinsurfile", (Object)insuranceFileId);
                adjustDataRecordDy2.set("sinsurtask", (Object)taskId);
                adjustDataRecordDy2.set("employee", (Object)employeeId);
                adjustDataRecordDy2.set("sinsurperiod", (Object)((DynamicObject)calPersonObjMap.get(calPersonIdObj)).getLong("sinsurperiod.id"));
                adjustDataRecordDy2.set("welfarepayer", (Object)((DynamicObject)calPersonObjMap.get(calPersonIdObj)).getLong("welfarepayer.id"));
                adjustDataRecordDy2.set("creator", (Object)RequestContext.get().getCurrUserId());
                adjustDataRecordDy2.set("createtime", (Object)nowDate);
                ++index;
            } else {
                adjustDataRecordDy2.set("modifier", (Object)RequestContext.get().getCurrUserId());
                adjustDataRecordDy2.set("modifytime", (Object)nowDate);
            }
            DynamicObjectCollection adjustDataRecordEntryEntity = adjustDataRecordDy2.getDynamicObjectCollection("entryentity");
            List waitDeleteItemIdList = (List)personDetailInfoMap.get("waitDeleteItemIdList");
            for (Map.Entry entry : personDetailInfoMap.entrySet()) {
                if (SITStringUtils.equals((String)"validItemIdList", (String)((String)entry.getKey())) || SITStringUtils.equals((String)"waitDeleteItemIdList", (String)((String)entry.getKey()))) continue;
                Object newValue = entry.getValue();
                String insuranceItemIdStr = (String)entry.getKey();
                AdjustDataService.handelWaitDeleteItem(waitDeleteItemIdList, insuranceItemIdStr);
                DynamicObject calPersonItemEntity = (DynamicObject)calPersonIdAndItemIdAndDyBasedTable.get(calPersonIdObj, (Object)insuranceItemIdStr);
                if (calPersonItemEntity == null) continue;
                String storageType = (String)calPersonItemEntity.get("storagetype");
                String fieldKey = SITStringUtils.equals((String)"number", (String)storageType) ? "numvalue" : "amountvalue";
                calPersonItemEntity.set(fieldKey, newValue);
                calPersonItemEntity.set("isnull", (Object)Objects.equals(newValue, 0));
                calPersonItemEntity.set("datasrc", (Object)"R");
                DynamicObject adjustDataDetailRecordDy = adjustDataRecordEntryEntity.addNew();
                adjustDataDetailRecordDy.set("insuranceitem", (Object)Long.valueOf(insuranceItemIdStr));
                Object preInsuranceItemVal = preCalPersonIdAndDetailInfoBasedTable.get(calPersonIdObj, (Object)insuranceItemIdStr);
                boolean isNull = Boolean.TRUE.equals(preCalPersonIdAndDetailInfoBasedTable.get(calPersonIdObj, (Object)(insuranceItemIdStr + "isnull")));
                AdjustDataService.setAdjustDetailDataItemValue(adjustDataDetailRecordDy, preInsuranceItemVal, isNull);
                adjustDataDetailRecordDy.set("newvalue", newValue);
                adjustDataDetailRecordDy.set("operator", (Object)RequestContext.get().getCurrUserId());
                adjustDataDetailRecordDy.set("operatetime", (Object)nowDate);
                AdjustDataService.assemblePersonAdjustDataObjs(taskId, adjustDataHelper, insuranceFileId, newValue, Long.valueOf(insuranceItemIdStr), personAdjustDataList, personAdjustItemMap);
            }
            AdjustDataService.deleteItemLater(preCalPersonIdAndDetailInfoBasedTable, (Table<Object, String, DynamicObject>)calPersonIdAndItemIdAndDyBasedTable, nowDate, personAdjustItemMap, calPersonIdObj, insuranceFileId, adjustDataRecordEntryEntity, waitDeleteItemIdList);
        }
        AdjustDataService.updateData(taskId, socInsuranceAdjustDataRecordDys, calPersonInfoDys, newInsuranceAdjustDataRecords, personAdjustDataList, personAdjustItemMap);
    }

    private static void handelWaitDeleteItem(List<String> waitDeleteItemIdList, String insuranceItemIdStr) {
        if (!SITListUtil.isEmpty(waitDeleteItemIdList) && waitDeleteItemIdList.contains(insuranceItemIdStr)) {
            waitDeleteItemIdList.remove(insuranceItemIdStr);
        }
    }

    private static long[] getPkIdArr(int size) {
        long[] pkIdArr = null;
        if (size > 0) {
            pkIdArr = DB.genLongIds((String)"hcsi_sinsuradjrec", (int)size);
        }
        return pkIdArr;
    }

    private static void setAdjustDetailDataItemValue(DynamicObject adjustDataDetailRecordDy, Object preInsuranceItemVal, boolean isNull) {
        if (isNull || preInsuranceItemVal == null) {
            adjustDataDetailRecordDy.set("oldvalue", (Object)new BigDecimal(0));
            adjustDataDetailRecordDy.set("oldvalueisnull", (Object)Boolean.TRUE);
        } else if (preInsuranceItemVal instanceof BigDecimal) {
            adjustDataDetailRecordDy.set("oldvalue", preInsuranceItemVal);
            adjustDataDetailRecordDy.set("oldvalueisnull", (Object)Boolean.FALSE);
        }
    }

    private static void deleteItemLater(Table<Object, String, Object> preCalPersonIdAndDetailInfoBasedTable, Table<Object, String, DynamicObject> calPersonIdAndItemIdAndDyBasedTable, Date nowDate, Map<Long, List<Long>> personAdjustItemMap, Object calPersonIdObj, Long insuranceFileId, DynamicObjectCollection adjustDataRecordEntryEntity, List<String> waitDeleteItemIdList) {
        if (!SITListUtil.isEmpty(waitDeleteItemIdList)) {
            for (String itemId : waitDeleteItemIdList) {
                DynamicObject adjustDataDetailRecordDy = adjustDataRecordEntryEntity.addNew();
                adjustDataDetailRecordDy.set("insuranceitem", (Object)Long.valueOf(itemId));
                DynamicObject calPersonItemEntity = (DynamicObject)calPersonIdAndItemIdAndDyBasedTable.get(calPersonIdObj, (Object)itemId);
                String storageType = (String)calPersonItemEntity.get("storagetype");
                if (SITStringUtils.equals((String)"number", (String)storageType)) {
                    calPersonItemEntity.set("numvalue", null);
                } else {
                    calPersonItemEntity.set("amountvalue", null);
                }
                calPersonItemEntity.set("isnull", (Object)Boolean.TRUE);
                calPersonItemEntity.set("datasrc", (Object)"R");
                Object preInsuranceItemVal = preCalPersonIdAndDetailInfoBasedTable.get(calPersonIdObj, (Object)itemId);
                if (preInsuranceItemVal == null) {
                    adjustDataDetailRecordDy.set("oldvalue", (Object)new BigDecimal(0));
                    adjustDataDetailRecordDy.set("oldvalueisnull", (Object)Boolean.TRUE);
                } else if (preInsuranceItemVal instanceof BigDecimal) {
                    adjustDataDetailRecordDy.set("oldvalue", preInsuranceItemVal);
                    adjustDataDetailRecordDy.set("oldvalueisnull", (Object)Boolean.FALSE);
                }
                adjustDataDetailRecordDy.set("newvalue", null);
                adjustDataDetailRecordDy.set("operator", (Object)RequestContext.get().getCurrUserId());
                adjustDataDetailRecordDy.set("operatetime", (Object)nowDate);
            }
            List itemIdList = personAdjustItemMap.computeIfAbsent(insuranceFileId, list -> new ArrayList(10));
            itemIdList.addAll(waitDeleteItemIdList.stream().map(Long::valueOf).collect(Collectors.toList()));
        }
    }

    private static boolean getHasSaveItem(Map<String, Object> personDetailInfoMap) {
        int count = 0;
        List<String> fixKeyList = Arrays.asList("roundtype", "waitDeleteItemIdList", "validItemIdList", "memo");
        for (String key : personDetailInfoMap.keySet()) {
            if (fixKeyList.contains(key)) continue;
            ++count;
        }
        List waitDeleteItemIdList = (List)personDetailInfoMap.get("waitDeleteItemIdList");
        return count > 0 || !SITListUtil.isEmpty((List)waitDeleteItemIdList);
    }

    private static void assemblePersonAdjustDataObjs(Long taskId, HRBaseServiceHelper adjustDataHelper, Long insuranceFileId, Object value, Long itemId, List<DynamicObject> personAdjustDataList, Map<Long, List<Long>> personAdjustItemMap) {
        if (value != null && !Objects.equals(value, 0)) {
            DynamicObject adjustDataObj = adjustDataHelper.generateEmptyDynamicObject();
            adjustDataObj.set("sinsurfile", (Object)insuranceFileId);
            adjustDataObj.set("sinsurtask", (Object)taskId);
            adjustDataObj.set("insuranceitem", (Object)itemId);
            adjustDataObj.set("adjvalue", value);
            personAdjustDataList.add(adjustDataObj);
        }
        List itemIdList = personAdjustItemMap.computeIfAbsent(insuranceFileId, list -> new ArrayList(10));
        itemIdList.add(itemId);
    }

    private static void updateData(Long taskId, List<DynamicObject> socInsuranceAdjustDataRecordDys, List<DynamicObject> calPersonInfoDys, List<DynamicObject> newInsuranceAdjustDataRecords, List<DynamicObject> personAdjustDataList, Map<Long, List<Long>> personAdjustItemMap) {
        try (TXHandle txHandle = TX.requiresNew();){
            HRBaseServiceHelper socInsuranceAdjRecordHelper = new HRBaseServiceHelper("hcsi_sinsuradjrec");
            HRBaseServiceHelper adjustDataHelper = new HRBaseServiceHelper("hcsi_sinsuradjdata");
            if (!CollectionUtils.isEmpty(calPersonInfoDys)) {
                socInsuranceAdjRecordHelper.save(calPersonInfoDys.toArray(new DynamicObject[0]));
            }
            if (newInsuranceAdjustDataRecords != null && !newInsuranceAdjustDataRecords.isEmpty()) {
                socInsuranceAdjRecordHelper.save(newInsuranceAdjustDataRecords.toArray(new DynamicObject[0]));
            }
            socInsuranceAdjRecordHelper.update(socInsuranceAdjustDataRecordDys.toArray(new DynamicObject[0]));
            AdjustDataService.deleteExistAdjustData(taskId, adjustDataHelper, personAdjustItemMap);
            adjustDataHelper.save(personAdjustDataList.toArray(new DynamicObject[0]));
            logger.info("AdjustDataService.saveAdjustData: save successfully.");
            txHandle.commit();
            SITLogServiceHelper.addLog((String)"hcsi", (String)"hcsi_calperson", (String)HCSIErrInfoEnum.ADJUST_DATA_OPERATE_NAME.getErrInfo(), (String)HCSIErrInfoEnum.COMMON_OPERATE_SUCCESSFULLY.getErrInfo(HCSIErrInfoEnum.ADJUST_DATA_OPERATE_NAME.getErrInfo()));
        }
    }

    private static void deleteExistAdjustData(Long sinsurtask, HRBaseServiceHelper adjustDataHelper, Map<Long, List<Long>> personAdjustItemMap) {
        Set<Long> salaryFileIdList = personAdjustItemMap.keySet();
        HashSet<Long> itemIdSet = new HashSet<Long>(16);
        for (List<Long> items : personAdjustItemMap.values()) {
            itemIdSet.addAll(items);
        }
        QFilter filter = new QFilter("sinsurtask.id", "=", (Object)sinsurtask);
        filter.and("sinsurfile.id", "in", salaryFileIdList);
        filter.and("insuranceitem.id", "in", itemIdSet);
        DynamicObjectCollection adjustDataObjs = adjustDataHelper.queryOriginalCollection("id,sinsurfile.id,insuranceitem.id", new QFilter[]{filter});
        if (SITListUtil.isEmpty((List)adjustDataObjs)) {
            return;
        }
        ArrayList<Long> existAdjustDataIdList = new ArrayList<Long>(10);
        for (DynamicObject adjustDataObj : adjustDataObjs) {
            long salaryFileId = adjustDataObj.getLong("sinsurfile.id");
            long itemId = adjustDataObj.getLong("insuranceitem.id");
            long id = adjustDataObj.getLong("id");
            List<Long> itemIdList = personAdjustItemMap.get(salaryFileId);
            if (SITListUtil.isEmpty(itemIdList) || !itemIdList.contains(itemId)) continue;
            existAdjustDataIdList.add(id);
        }
        adjustDataHelper.delete(existAdjustDataIdList.toArray());
    }

    public static Map<String, InsurTypeAttrEntity> getInsurTypeAttrFieldKeyAndEntityMap() {
        Map<Long, String> insurTypeAttrIdAndFieldKeyMap = AdjustDataService.getInsurTypeIdAndAttFieldKeyInTmpMap();
        List<DynamicObject> insurancePropDys = AdjustDataHelper.queryInsurPropBy(insurTypeAttrIdAndFieldKeyMap.keySet());
        HashMap<String, InsurTypeAttrEntity> insurTypeAttrFieldKeyAndEntityMap = new HashMap<String, InsurTypeAttrEntity>(8);
        for (DynamicObject insurancePropDy : insurancePropDys) {
            InsurTypeAttrEntity insurTypeAttrEntity = new InsurTypeAttrEntity(Long.valueOf(insurancePropDy.getLong("id")), insurancePropDy.getString("number"), insurancePropDy.getString("name"));
            String fieldKey = insurTypeAttrIdAndFieldKeyMap.get(insurTypeAttrEntity.getId());
            if (fieldKey == null) continue;
            insurTypeAttrEntity.setFieldKey(fieldKey);
            insurTypeAttrFieldKeyAndEntityMap.put(fieldKey, insurTypeAttrEntity);
        }
        return insurTypeAttrFieldKeyAndEntityMap;
    }

    private static Map<Long, String> getInsurTypeIdAndAttFieldKeyInTmpMap() {
        BiMap<Long, String> insurTypeAttrIdAndFieldKeyMap = HashBiMap.create((int)16);
        HRBaseServiceHelper helper = new HRBaseServiceHelper("sitbs_insurfieldcfg");
        QFilter filter = new QFilter("id", "=", (Object)1010L);
        DynamicObject cfgDy = helper.loadDynamicObject(filter.toArray());
        if (cfgDy != null) {
            DynamicObjectCollection dynamicObjectCollection = cfgDy.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : dynamicObjectCollection) {
                String cfgField = entry.getString("cfgfield");
                long insurTypeAttrId = entry.getLong("insurancetypeattr.id");
                boolean isNeedAdd = HRStringUtils.isNotEmpty((String)cfgField) && insurTypeAttrId != 0L && !insurTypeAttrIdAndFieldKeyMap.containsKey((Object)insurTypeAttrId) && !insurTypeAttrIdAndFieldKeyMap.containsValue((Object)cfgField.trim());
                if (!isNeedAdd) continue;
                insurTypeAttrIdAndFieldKeyMap.put((Object)insurTypeAttrId, (Object)cfgField.trim());
            }
        }
        if (insurTypeAttrIdAndFieldKeyMap.isEmpty()) {
            insurTypeAttrIdAndFieldKeyMap = AdjustDataService.getDefaultInsurTypeAttrIdAndFieldKeyMap();
        }
        DataEntityPropertyCollection properties = EntityMetadataCache.getDataEntityType((String)"hcsi_sinsuradjrecmd").getProperties();
        insurTypeAttrIdAndFieldKeyMap.values().removeIf(fieldKey -> !properties.containsKey(fieldKey));
        return insurTypeAttrIdAndFieldKeyMap;
    }

    private static BiMap<Long, String> getDefaultInsurTypeAttrIdAndFieldKeyMap() {
        HashBiMap insurTypeAttrIdAndFieldKeyMap = HashBiMap.create((int)16);
        insurTypeAttrIdAndFieldKeyMap.put((Object)InsurTypeAttrEnum.PAY_AMOUNT_OF_EMPLOYEE.getId(), (Object)"paybyemployee");
        insurTypeAttrIdAndFieldKeyMap.put((Object)InsurTypeAttrEnum.PAY_AMOUNT_OF_COMPANY.getId(), (Object)"paybycompany");
        insurTypeAttrIdAndFieldKeyMap.put((Object)InsurTypeAttrEnum.COMP_AMOUNT_OF_EMPLOYEE.getId(), (Object)"compbyemployee");
        insurTypeAttrIdAndFieldKeyMap.put((Object)InsurTypeAttrEnum.COMP_AMOUNT_OF_COMPANY.getId(), (Object)"compbycompany");
        return insurTypeAttrIdAndFieldKeyMap;
    }

    public void exportAdjustData(Long taskId, String pageId, IFormView view, List<String> idStrList) {
        try (SXSSFWorkbook wb = new SXSSFWorkbook(500);){
            String searchText = AdjustDataHelper.getCacheSearchText(taskId, pageId);
            List<Long> fileIdList = idStrList.stream().map(single -> Long.valueOf(single)).collect(Collectors.toList());
            Map<Long, Map<String, Object>> itemMap = AdjustDataHelper.getCacheItemMap(taskId, pageId);
            List<Long> adjustDataFileIdList = AdjustDataHelper.getAdjustDataFileIdList(taskId, fileIdList);
            if (SITListUtil.isEmpty(adjustDataFileIdList)) {
                return;
            }
            int count = AdjustDataHelper.getCalPersonDyObjCount(fileIdList, searchText, taskId);
            LinkedHashMap matchPersonDataMap = Maps.newLinkedHashMapWithExpectedSize((int)count);
            HashMap<Long, Map<Long, Object>> itemDataMap = new HashMap<Long, Map<Long, Object>>(16);
            logger.info("getPersonDataMap begin");
            long start = System.currentTimeMillis();
            AdjustDataHelper.assemblePersonAdjustDataMap(fileIdList, itemDataMap, matchPersonDataMap, taskId, pageId, count, 1, searchText);
            logger.info("assemblePersonAdjustDataMap end cost:{} ms", (Object)(System.currentTimeMillis() - start));
            if (matchPersonDataMap.size() == 0) {
                return;
            }
            String dd = SITDateTimeUtils.format((Date)new Date(), (String)"yyyyMMdd").substring(4);
            String exportFileName = MessageFormat.format(ResManager.loadKDString((String)"\u793e\u4fdd\u8c03\u6574\u6570\u636e_{0}.xlsx", (String)"AdjustDataService_0", (String)SYSTEM_TYPE, (Object[])new Object[0]), dd);
            this.createAdjustDataSheet(wb, itemMap, itemDataMap, matchPersonDataMap);
            this.flushAllAndDownload(wb, exportFileName, view);
        }
        catch (Exception exception) {
            logger.error("CalResultCoverImportService  error ", (Throwable)exception);
            String str = ResManager.loadKDString((String)"\u5bfc\u51fa\u5931\u8d25", (String)"AdjustDataService_1", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            view.showErrorNotification(str + exception.getMessage());
        }
    }

    private void flushAllAndDownload(SXSSFWorkbook wb, String fileName, IFormView view) throws IOException {
        String url = ExcelHelper.storeFile((Workbook)wb, (String)fileName);
        if (SITStringUtils.isNotEmpty((String)url)) {
            view.download(url);
        }
    }

    private void createAdjustDataSheet(SXSSFWorkbook wb, Map<Long, Map<String, Object>> itemMap, Map<Long, Map<Long, Object>> itemDataMap, Map<String, Map<String, String>> matchPersonDataMap) {
        String sheetName = ResManager.loadKDString((String)"\u8c03\u6574\u6570\u636e", (String)"AdjustDataService_2", (String)SYSTEM_TYPE, (Object[])new Object[0]);
        SXSSFSheet sheet = wb.createSheet(sheetName);
        sheet.setRandomAccessWindowSize(-1);
        this.setSheetColumnWidth(sheet, itemMap);
        this.writeExportHeadRow(sheet, itemMap);
        if (matchPersonDataMap.size() > 0) {
            this.writeAdjustData(sheet, matchPersonDataMap, itemDataMap, itemMap);
        }
    }

    public void writeAdjustData(SXSSFSheet sheet, Map<String, Map<String, String>> matchPersonDataMap, Map<Long, Map<Long, Object>> itemDataMap, Map<Long, Map<String, Object>> itemMap) {
        int dataIndex = 1;
        for (Map.Entry<String, Map<String, String>> entry : matchPersonDataMap.entrySet()) {
            Map<String, String> personMap = entry.getValue();
            Long fileId = Long.parseLong(personMap.get("sinsurfile"));
            Map<Long, Object> valueMap = itemDataMap.get(fileId);
            SXSSFRow row = sheet.createRow(dataIndex++);
            String fileNumber = personMap.get("filenumber");
            String name = personMap.get("name");
            String empNumber = personMap.get("empnumber");
            String sinsurstd = personMap.get("sinsurstd");
            String calstatusname = personMap.get("calstatusname");
            String memo = personMap.get("memo");
            this.createCell(row, 0, fileNumber, name, empNumber, sinsurstd, calstatusname, memo);
            this.addItemRowData(row, itemMap, valueMap);
        }
    }

    private void addItemRowData(SXSSFRow row, Map<Long, Map<String, Object>> itemMap, Map<Long, Object> value) {
        int index = 6;
        for (Map.Entry<Long, Map<String, Object>> itemEntry : itemMap.entrySet()) {
            SXSSFCell itemCell = row.createCell(index++);
            Long itemId = itemEntry.getKey();
            Map<String, Object> itemInfo = itemEntry.getValue();
            int scale = (Integer)itemInfo.get("scale");
            if (value == null || value.get(itemId) == null) continue;
            BigDecimal showValue = new BigDecimal(value.get(itemId).toString()).setScale(scale, 1);
            itemCell.setCellValue(showValue.toPlainString());
        }
    }

    public void writeExportHeadRow(SXSSFSheet sheet, Map<Long, Map<String, Object>> itemMap) {
        SXSSFDrawing drawingPatriarch = sheet.createDrawingPatriarch();
        SXSSFRow headRow = sheet.createRow(0);
        CellStyle headColumnStyle = AdjustDataService.getColumnStyle(2, SITShowType.TEXT.getCode(), HorizontalAlignment.LEFT, sheet.getWorkbook(), HSSFColor.HSSFColorPredefined.GREY_25_PERCENT.getIndex(), true);
        Font font = sheet.getWorkbook().createFont();
        font.setColor((short)10);
        SXSSFCell salaryFileNumberCell = this.createCell(0, headRow, ResManager.loadKDString((String)"\u6863\u6848\u7f16\u53f7", (String)"AdjustDataService_3", (String)SYSTEM_TYPE, (Object[])new Object[0]), drawingPatriarch, headColumnStyle, SITShowType.TEXT.getCode());
        SXSSFCell nameCell = this.createCell(1, headRow, ResManager.loadKDString((String)"\u59d3\u540d", (String)"AdjustDataService_4", (String)SYSTEM_TYPE, (Object[])new Object[0]), drawingPatriarch, headColumnStyle, SITShowType.TEXT.getCode());
        SXSSFCell empNumberCell = this.createCell(2, headRow, ResManager.loadKDString((String)"\u5de5\u53f7", (String)"AdjustDataService_5", (String)SYSTEM_TYPE, (Object[])new Object[0]), drawingPatriarch, headColumnStyle, SITShowType.TEXT.getCode());
        SXSSFCell welfarepayerCell = this.createCell(3, headRow, ResManager.loadKDString((String)"\u53c2\u4fdd\u6807\u51c6", (String)"AdjustDataService_6", (String)SYSTEM_TYPE, (Object[])new Object[0]), drawingPatriarch, headColumnStyle, SITShowType.TEXT.getCode());
        SXSSFCell statusCell = this.createCell(4, headRow, ResManager.loadKDString((String)"\u72b6\u6001", (String)"AdjustDataService_7", (String)SYSTEM_TYPE, (Object[])new Object[0]), drawingPatriarch, headColumnStyle, SITShowType.TEXT.getCode());
        SXSSFCell memoCell = this.createCell(5, headRow, ResManager.loadKDString((String)"\u5907\u6ce8", (String)"AdjustDataService_8", (String)SYSTEM_TYPE, (Object[])new Object[0]), drawingPatriarch, headColumnStyle, SITShowType.TEXT.getCode());
        int index = 6;
        for (Map.Entry<Long, Map<String, Object>> itemEntry : itemMap.entrySet()) {
            this.createCell(index++, headRow, itemEntry.getValue().get("itemName") + "", drawingPatriarch, headColumnStyle, itemEntry.getValue().get("dataType") + "");
        }
    }

    private SXSSFCell createCell(int index, SXSSFRow headRow, String name, SXSSFDrawing drawingPatriarch, CellStyle columnStyle, String dataType) {
        SXSSFCell cell = headRow.createCell(index);
        cell.setCellValue(name);
        cell.setCellComment(this.getComment(drawingPatriarch, cell, dataType));
        cell.setCellStyle(columnStyle);
        return cell;
    }

    private void createCell(SXSSFRow row, int startIndex, String ... values) {
        for (String value : values) {
            SXSSFCell cell = row.createCell(startIndex++);
            cell.setCellValue(value);
        }
    }

    private Comment getComment(SXSSFDrawing drawingPatriarch, SXSSFCell cell, String datatype) {
        Comment comment = drawingPatriarch.createCellComment((ClientAnchor)new XSSFClientAnchor(cell.getColumnIndex(), cell.getRowIndex(), cell.getColumnIndex() + 1, cell.getRowIndex() + 2, cell.getColumnIndex(), cell.getRowIndex(), cell.getColumnIndex() + 1, cell.getRowIndex() + 2));
        String text = this.assembleCommentText(datatype);
        comment.setString((RichTextString)new XSSFRichTextString(text));
        return comment;
    }

    private String assembleCommentText(String dataType) {
        String text = SITShowType.AMOUNT.getCode().equals(dataType) || SITShowType.NUM.getCode().equals(dataType) ? ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6570\u5b57\u683c\u5f0f\u3002", (String)"CalResultCoverImportService_59", (String)SYSTEM_TYPE, (Object[])new Object[0]) : (SITShowType.DATE.getCode().equals(dataType) ? ResManager.loadKDString((String)"\u8bf7\u586b\u5199YYYY-MM-DD\u683c\u5f0f\u7684\u65e5\u671f\u3002", (String)"CalResultCoverImportService_60", (String)SYSTEM_TYPE, (Object[])new Object[0]) : ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6587\u672c\u683c\u5f0f\u3002", (String)"CalResultCoverImportService_61", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        return text;
    }

    public static CellStyle getColumnStyle(int precision, String columnType, HorizontalAlignment alignment, SXSSFWorkbook wb, short colorIndex, boolean needBoard) {
        short format;
        CellStyle headColumnStyle = wb.createCellStyle();
        DataFormat dataFormat = wb.createDataFormat();
        if (SITStringUtils.equals((String)SITShowType.AMOUNT.getCode(), (String)columnType)) {
            String amountFormat = AdjustDataService.getAmountFormat(precision);
            format = dataFormat.getFormat(amountFormat);
        } else {
            format = dataFormat.getFormat("text");
        }
        headColumnStyle.setDataFormat(format);
        if (needBoard) {
            headColumnStyle.setBorderBottom(BorderStyle.HAIR);
            headColumnStyle.setBorderTop(BorderStyle.HAIR);
            headColumnStyle.setBorderLeft(BorderStyle.HAIR);
            headColumnStyle.setBorderRight(BorderStyle.HAIR);
        }
        headColumnStyle.setFillForegroundColor(colorIndex);
        headColumnStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        headColumnStyle.setAlignment(alignment);
        headColumnStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        headColumnStyle.setHidden(true);
        return headColumnStyle;
    }

    private static String getAmountFormat(int precision) {
        StringBuilder format = new StringBuilder("0");
        if (precision > 0) {
            format.append('.');
            for (int i = 0; i < precision; ++i) {
                format.append('0');
            }
        }
        return format.toString();
    }

    private void setSheetColumnWidth(SXSSFSheet sheet, Map<Long, Map<String, Object>> itemMap) {
        for (int i = 0; i < 6; ++i) {
            int columnWidth = sheet.getColumnWidth(i);
            sheet.setColumnWidth(i, columnWidth * 2);
        }
        int itemIndex = 6;
        for (Map.Entry<Long, Map<String, Object>> item : itemMap.entrySet()) {
            String itemName = item.getValue().get("itemName") + "";
            sheet.setColumnWidth(itemIndex++, AdjustDataService.calcColumnWidth(itemName));
        }
    }

    private static int calcColumnWidth(String caption) {
        return 256 * caption.getBytes(StandardCharsets.UTF_8).length;
    }

    public static Map<String, Object> getExtParams(String pageId, String opKey) {
        IFormView calPersonListView = SessionManager.getCurrent().getViewNoPlugin(pageId);
        if (calPersonListView != null) {
            List<Long> insuredStandardVIds = InsuranceStandardService.getInsurStdVIdsOfCalPerson(calPersonListView.getFormShowParameter().getCustomParams());
            Long taskId = (Long)calPersonListView.getFormShowParameter().getCustomParam("taskId");
            HRBaseServiceHelper helper = HRBaseServiceHelper.create((String)"hcsi_sinsurtask");
            DynamicObject taskDy = helper.loadSingle((Object)taskId);
            Set<Long> insuranceItemIds = SocialInsuranceCalHelper.getMulBaseDataIdsInTask(taskDy, "mulinsuranceitem");
            HashMap<String, Object> extParamMap = new HashMap<String, Object>(16);
            if (!insuranceItemIds.isEmpty()) {
                extParamMap.put("insuranceItemIds", insuranceItemIds);
                extParamMap.put("insuredStandardVIds", insuredStandardVIds);
                extParamMap.put("taskId", taskId);
                extParamMap.put("opKey", opKey);
            }
            extParamMap.put("parentPageId", pageId);
            return extParamMap;
        }
        return Collections.emptyMap();
    }

    public static void createExcelDynamicColumn(Map<String, InsuranceItemVo> itemInfoMap, List<String> fields, Map<String, Map<String, Object>> properties) {
        if (itemInfoMap == null || fields == null || properties == null) {
            return;
        }
        for (Map.Entry<String, InsuranceItemVo> insuranceItemEntry : itemInfoMap.entrySet()) {
            String number = insuranceItemEntry.getKey();
            InsuranceItemVo insuranceItemVo = insuranceItemEntry.getValue();
            if (insuranceItemVo == null) continue;
            String name = insuranceItemVo.getName();
            fields.add(number);
            HashMap<String, Object> property = new HashMap<String, Object>(10);
            property.put("DisplayName", name);
            property.put("InputType", "decimal");
            HashMap<String, Integer> decimalMap = new HashMap<String, Integer>(2);
            Integer scale = insuranceItemVo.getScale();
            scale = scale == null ? Integer.valueOf(2) : scale;
            decimalMap.put("scale", scale);
            decimalMap.put("precision", scale);
            property.put("DecimalFormat", decimalMap);
            property.put("PropType", null);
            property.put("MustInput", Boolean.FALSE);
            property.put("InputDesc", HCSIErrInfoEnum.ADJUST_DATA_IMPORT_EXT_FIELD_DESC.getErrInfo());
            properties.put(number, property);
        }
    }

    public static Map<String, InsuranceItemVo> getSInsuranceItemDys(AbstractEventArgs args) {
        return AdjustDataService.getExtParamMap(args).getOrDefault("itemInfoMap", Collections.emptyMap());
    }

    public static Map<String, InsuranceItemVo> getItemInfoMap(Map<String, Object> extParamMap) {
        DynamicObjectCollection itemDys;
        HRBaseServiceHelper helper = HRBaseServiceHelper.create((String)"sitbs_insuranceitem");
        QFilter filter = new QFilter("insurancetypeattr.datasrc", "in", AdjustDataConstants.ADJUST_DATA_SRC);
        if (extParamMap != null) {
            Optional<Collection<Long>> itemIdsOp = AdjustDataService.getInsuranceItemIds(extParamMap.get("taskId"), (String)extParamMap.get("opKey"));
            if (itemIdsOp.isPresent()) {
                filter.and("id", "in", itemIdsOp.get());
            } else {
                Set insuranceItemIds = extParamMap.getOrDefault("insuranceItemIds", Collections.emptySet());
                filter.and("id", "in", insuranceItemIds);
            }
        }
        if ((itemDys = helper.queryOriginalCollection("id,name,number,dataround.id,datatype.id,dataprecision.scale,group.currency.amtprecision", filter.toArray(), "group.number asc,number asc")) == null || itemDys.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, InsuranceItemVo> itemInfoMap = new LinkedHashMap<String, InsuranceItemVo>(itemDys.size());
        for (DynamicObject itemDy : itemDys) {
            long dataTypeId = itemDy.getLong("datatype.id");
            int itemScale = itemDy.getInt("dataprecision.scale");
            int typeScale = itemDy.getInt("group.currency.amtprecision");
            Integer scale = SitDataTypeEnum.AMOUNT.getId() == dataTypeId ? typeScale : itemScale;
            long roundId = itemDy.getLong("dataround.id");
            Integer round = DataRoundEnum.roundById((long)roundId);
            InsuranceItemVo insuranceItemVo = new InsuranceItemVo(Long.valueOf(itemDy.getLong("id")), itemDy.getString("name"), itemDy.getString("number"), round, scale);
            itemInfoMap.put(itemDy.getString("number"), insuranceItemVo);
        }
        return itemInfoMap;
    }

    private static Optional<Collection<Long>> getInsuranceItemIds(Object taskId, String opKey) {
        List authorizedCalPersonQFilters = SITPermissionServiceHelper.getAuthorizedDataRuleQFilterByOpKey((String)"2AXKDRPJUQ77", (String)"hcsi_calperson", (String)opKey);
        if (authorizedCalPersonQFilters == null || authorizedCalPersonQFilters.size() == 0) {
            return Optional.empty();
        }
        QFilter filter = new QFilter("sinsurtask", "=", taskId);
        authorizedCalPersonQFilters.forEach(arg_0 -> ((QFilter)filter).and(arg_0));
        HRBaseServiceHelper helper = HRBaseServiceHelper.create((String)"hcsi_calperson");
        int calPersonSize = helper.count("hcsi_calperson", filter.toArray());
        if (calPersonSize <= 1000 && calPersonSize > 0) {
            Set itemIds;
            filter.and("entryentity.datasrc", "in", AdjustDataConstants.ADJUST_DATA_SRC);
            DynamicObjectCollection calPersonDys = helper.queryOriginalCollection("entryentity.insuranceitem.id,entryentity.datasrc", filter.toArray());
            if (calPersonDys != null && calPersonDys.size() > 0 && (itemIds = calPersonDys.stream().filter(calPersonDy -> AdjustDataConstants.ADJUST_DATA_SRC.contains(calPersonDy.getString("entryentity.datasrc"))).map(calPersonDy -> calPersonDy.getLong("entryentity.insuranceitem.id")).collect(Collectors.toSet())).size() > 0) {
                return Optional.of(itemIds);
            }
        }
        return Optional.empty();
    }

    public static Map<String, Object> getExtParamMap(String extParams) {
        HashMap<String, Object> extParamMap = !StringUtils.isEmpty((CharSequence)extParams) ? (HashMap<String, Object>)SerializationUtils.deSerializeFromBase64((String)extParams) : new HashMap<String, Object>(0);
        return extParamMap;
    }

    public static Map<String, Object> getExtParamMap(AbstractEventArgs args) {
        String extParams = args.getExtParams();
        Map<String, Object> extParamMap = AdjustDataService.getExtParamMap(extParams);
        Map<String, InsuranceItemVo> itemInfoMap = (Map<String, InsuranceItemVo>)extParamMap.get("itemInfoMap");
        if (itemInfoMap != null) {
            return extParamMap;
        }
        itemInfoMap = AdjustDataService.getItemInfoMap(extParamMap);
        extParamMap.put("itemInfoMap", itemInfoMap);
        extParams = SerializationUtils.serializeToBase64(extParamMap);
        args.setExtParams(extParams);
        return extParamMap;
    }

    public static void rebuildExportedData(List<Map<Integer, Map<String, Object>>> tplDataRows, Map<String, InsuranceItemVo> allItemVoMap, Map<String, BigDecimal> calPersonItemInfoMap, Map<String, String> sinsurFileNumberAndRefMemo, Map<String, CellStyle> itemStyleMap) {
        for (Map<Integer, Map<String, Object>> row : tplDataRows) {
            String fileNumberVal = null;
            Map<String, Object> memoMap = null;
            LinkedHashMap<String, Map<String, Object>> itemNumAndColInfo = new LinkedHashMap<String, Map<String, Object>>(16);
            for (Map.Entry<Integer, Map<String, Object>> next : row.entrySet()) {
                Map<String, Object> map = next.getValue();
                if (map == null || map.isEmpty()) continue;
                String colKey = (String)map.get("key");
                if ("filenumberdb".equals(colKey)) {
                    fileNumberVal = (String)map.get("val");
                    continue;
                }
                if ("memo".equals(colKey)) {
                    memoMap = map;
                    continue;
                }
                if (!allItemVoMap.containsKey(colKey)) continue;
                itemNumAndColInfo.put(colKey, map);
            }
            if (fileNumberVal == null || fileNumberVal.trim().length() == 0) continue;
            if (memoMap != null && !memoMap.isEmpty()) {
                memoMap.put("val", sinsurFileNumberAndRefMemo.get(fileNumberVal));
            }
            for (Map.Entry entry : itemNumAndColInfo.entrySet()) {
                Map itemMap = (Map)entry.getValue();
                String insuranceItemNumber = (String)entry.getKey();
                BigDecimal itemVal = calPersonItemInfoMap.get(fileNumberVal + "," + insuranceItemNumber);
                InsuranceItemVo insuranceItemVo = allItemVoMap.get(insuranceItemNumber);
                if (itemMap == null) continue;
                if (itemVal != null) {
                    itemVal = insuranceItemVo != null && insuranceItemVo.getScale() != null ? itemVal.setScale((int)insuranceItemVo.getScale(), insuranceItemVo.getRound()) : itemVal.setScale(2, 4);
                    itemMap.put("val", String.valueOf(itemVal));
                }
                itemMap.put("isNumber", "Y");
                CellStyle newCellStyle = itemStyleMap.get(insuranceItemNumber);
                if (newCellStyle == null) continue;
                itemMap.put("style", newCellStyle);
            }
        }
    }
}

