/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.business.common.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sdk.sit.hcsi.common.entity.cal.InsuredStandard;
import kd.sit.sitbp.common.enums.SitDataTypeEnum;

public abstract class AbsDetailResultService {
    public Map<Long, List<InsuredStandard>> getInsuredItemGroupByTaskFormDB(Map<Long, List<Long>> standardIdGroupByTask) {
        List<Long> insuranceStandardVIds = standardIdGroupByTask.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        Map<Long, List<InsuredStandard>> insuredStandardFormDB = this.getInsuredStandardFormDB(insuranceStandardVIds);
        LinkedHashMap<Long, Map<Long, InsuredStandard>> insuredItemGroupByTask = new LinkedHashMap<Long, Map<Long, InsuredStandard>>(standardIdGroupByTask.size());
        HashMap insurItemIdAndStdDtoMap = new HashMap(16);
        for (Map.Entry<Long, List<Long>> standardIdGroupByTaskEntity : standardIdGroupByTask.entrySet()) {
            HashSet existsItemIds = new HashSet(16);
            List<InsuredStandard> insuredStandards = standardIdGroupByTaskEntity.getValue().stream().flatMap(standardVId -> Optional.ofNullable(insuredStandardFormDB.get(standardVId)).orElseGet(() -> Collections.emptyList()).stream()).filter(insuredStandard -> existsItemIds.add(insuredStandard.getInsuredItemId())).collect(Collectors.toList());
            Map itemDtoGroupByPkId = insuredStandards.stream().collect(Collectors.toMap(InsuredStandard::getInsuredItemId, itemDTO -> itemDTO, (oldVal, newVal) -> oldVal, LinkedHashMap::new));
            insuredItemGroupByTask.put(standardIdGroupByTaskEntity.getKey(), itemDtoGroupByPkId);
            insuredStandards.forEach(insuredStandard -> insurItemIdAndStdDtoMap.put(insuredStandard.getInsuredItemId(), insuredStandard));
        }
        Map<Long, List<InsuredStandard>> orderedInsuredItemGroupByTask = this.orderInsuranceItem(insuredItemGroupByTask);
        this.handleDataAtLast(orderedInsuredItemGroupByTask);
        return orderedInsuredItemGroupByTask;
    }

    private Map<Long, List<InsuredStandard>> orderInsuranceItem(Map<Long, Map<Long, InsuredStandard>> insuredItemGroupByTask) {
        Set insureItemIds = insuredItemGroupByTask.values().stream().flatMap(itemDtoGroupByPkId -> Optional.ofNullable(itemDtoGroupByPkId.keySet()).orElseGet(() -> Collections.emptySet()).stream()).collect(Collectors.toSet());
        LinkedHashMap<Long, List<InsuredStandard>> orderedInsuredItemGroupByTask = new LinkedHashMap<Long, List<InsuredStandard>>(16);
        HRBaseServiceHelper helper = new HRBaseServiceHelper("sitbs_insuranceitem");
        DynamicObjectCollection sinsurItemDys = helper.queryOriginalCollection("id", new QFilter("id", "in", insureItemIds).toArray(), "group.number asc,number asc");
        for (DynamicObject sinsurItemDy : sinsurItemDys) {
            for (Map.Entry<Long, Map<Long, InsuredStandard>> entry : insuredItemGroupByTask.entrySet()) {
                InsuredStandard insuredStandard = entry.getValue().get(sinsurItemDy.getLong("id"));
                if (insuredStandard == null) continue;
                orderedInsuredItemGroupByTask.computeIfAbsent(entry.getKey(), key -> new ArrayList(10)).add(insuredStandard);
            }
        }
        return orderedInsuredItemGroupByTask;
    }

    protected void handleDataAtLast(Map<Long, List<InsuredStandard>> orderedInsuredItemGroupByTask) {
    }

    private Map<Long, List<InsuredStandard>> getInsuredStandardFormDB(List<Long> insuredStandardIdList) {
        LinkedHashMap<Long, List<InsuredStandard>> tempMap = new LinkedHashMap<Long, List<InsuredStandard>>(16);
        HRBaseServiceHelper helper = new HRBaseServiceHelper("sitbs_sinsurstd");
        String queryField = "id,number,stdentryentity.insurtype.id,stdentryentity.subentryentity.insuritem.id,stdentryentity.subentryentity.insuritem.name,stdentryentity.subentryentity.insuritem.datatype.id,stdentryentity.subentryentity.insuritem.insurancetypeattr.id,stdentryentity.subentryentity.registertype.id,stdentryentity.subentryentity.category.id";
        QFilter filter = new QFilter("id", "in", insuredStandardIdList);
        DynamicObjectCollection insuredItemDataCol = helper.queryOriginalCollection(queryField, new QFilter[]{filter}, "stdentryentity.seq asc,stdentryentity.subentryentity.seq asc");
        if (insuredItemDataCol == null) {
            return tempMap;
        }
        this.filterInsuredItemDataCol(insuredItemDataCol);
        HashMap<Long, Set> insuredItemIdMap = new HashMap<Long, Set>(16);
        Set<Long> allInsurItemIdSet = insuredItemDataCol.stream().map(insuredItemData -> insuredItemData.getLong("stdentryentity.subentryentity.insuritem.id")).collect(Collectors.toSet());
        Set<Long> insurTypeIds = insuredItemDataCol.stream().map(insuredItemData -> insuredItemData.getLong("stdentryentity.insurtype.id")).collect(Collectors.toSet());
        Map<Long, Integer> insurItemPrecisionMap = AbsDetailResultService.getInsurItemPrecisionMap(allInsurItemIdSet, insurTypeIds);
        for (DynamicObject insuredItemData2 : insuredItemDataCol) {
            Long insuredStandardId = insuredItemData2.getLong("id");
            List tempList = tempMap.getOrDefault(insuredStandardId, new ArrayList(10));
            Long insuredItemId = insuredItemData2.getLong("stdentryentity.subentryentity.insuritem.id");
            Set insuredItemIdSet = insuredItemIdMap.getOrDefault(insuredStandardId, new HashSet(16));
            if (insuredItemIdSet.contains(insuredItemId)) continue;
            String insuredItemName = insuredItemData2.getString("stdentryentity.subentryentity.insuritem.name");
            Long dataTypeId = insuredItemData2.getLong("stdentryentity.subentryentity.insuritem.datatype.id");
            InsuredStandard insuredStandard = new InsuredStandard(insuredItemId, insuredItemName, dataTypeId);
            insuredStandard.setScale(insurItemPrecisionMap.get(insuredItemId));
            tempList.add(insuredStandard);
            insuredItemIdSet.add(insuredItemId);
            insuredItemIdMap.put(insuredStandardId, insuredItemIdSet);
            tempMap.put(insuredStandardId, tempList);
        }
        return tempMap;
    }

    protected void filterInsuredItemDataCol(DynamicObjectCollection insuredItemDataCol) {
    }

    public static Map<Long, Integer> getInsurItemPrecisionMap(Set<Long> allInsurItemIdSet, Collection<Long> insurTypeIds) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("sitbs_welfaretype");
        QFilter filter = new QFilter("id", "in", insurTypeIds);
        filter.and("enable", "=", (Object)"1");
        filter.and("status", "=", (Object)"C");
        DynamicObjectCollection insurTypeInfoColl = helper.queryOriginalCollection("id, name, number, currency.amtprecision", filter.toArray(), "number asc");
        Map<Long, Integer> insurTypeIdAndCurrencyMap = insurTypeInfoColl.stream().collect(Collectors.toMap(insurTypeDy -> insurTypeDy.getLong("id"), insurTypeDy -> insurTypeDy.getInt("currency.amtprecision")));
        DynamicObjectCollection insurItemInfoDyColl = AbsDetailResultService.queryInsurItemInfoById(allInsurItemIdSet, null);
        LinkedHashMap<Long, Integer> insurItemPrecisionMap = new LinkedHashMap<Long, Integer>(insurItemInfoDyColl.size());
        for (DynamicObject insurItemInfoDy : insurItemInfoDyColl) {
            int precision = SitDataTypeEnum.AMOUNT.getId() == insurItemInfoDy.getLong("datatype.id") ? insurTypeIdAndCurrencyMap.getOrDefault(insurItemInfoDy.getLong("group"), 0).intValue() : insurItemInfoDy.getInt("dataprecision.scale");
            insurItemPrecisionMap.put(insurItemInfoDy.getLong("id"), precision);
        }
        return insurItemPrecisionMap;
    }

    private static DynamicObjectCollection queryInsurItemInfoById(Collection<Long> insurItemIds, Long countryId) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("sitbs_insuranceitem");
        QFilter filter = new QFilter("id", "in", insurItemIds);
        filter.and("country.id", "=", (Object)1000001L);
        String selectFields = "id, group,insurancetypeattr.id,insurancetypeattr.name,insurancetypeattr.number,datatype.id,datatype.number,dataprecision.id,dataprecision.number,dataprecision.scale";
        return helper.queryOriginalCollection(selectFields, filter.toArray());
    }
}

