/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.business.declare.dto;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.sit.sitbp.common.entity.declare.DclRecordCalDTO;

public class DclRecordDTO
extends DclRecordCalDTO
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 8990376042083905938L;
    private DynamicObject dclRecordDy;
    private DynamicObject currPeriodDy;
    private DynamicObject companyDy;
    private List<Long> standardVIds;
    private DynamicObject dclRecordRuleDy;
    private DynamicObject dclRecordRuleVDy;
    private ErrMsg errMsg;
    private String errCode;
    private String opKey;
    private boolean isFileEmpty = false;

    public DclRecordDTO clone() {
        try {
            Date lastPeriodEndDate;
            Date periodEndDate;
            DclRecordDTO dclRecordDTO = (DclRecordDTO)super.clone();
            Date periodStartDate = dclRecordDTO.getPeriodStartDate();
            if (periodStartDate != null) {
                dclRecordDTO.setPeriodStartDate((Date)periodStartDate.clone());
            }
            if ((periodEndDate = dclRecordDTO.getPeriodEndDate()) != null) {
                dclRecordDTO.setPeriodEndDate((Date)periodEndDate.clone());
            }
            if ((lastPeriodEndDate = dclRecordDTO.getLastPeriodEndDate()) != null) {
                dclRecordDTO.setLastPeriodEndDate((Date)lastPeriodEndDate.clone());
            }
            dclRecordDTO.setStandardBoIds(new ArrayList(dclRecordDTO.getStandardBoIds()));
            dclRecordDTO.setInsurTypes(new ArrayList(dclRecordDTO.getInsurTypes()));
            dclRecordDTO.setStandardVIds(new ArrayList<Long>(dclRecordDTO.getStandardVIds()));
            this.initDynamicDy(this.dclRecordDy, dclRecordDTO);
            this.initDynamicDy(this.currPeriodDy, dclRecordDTO);
            this.initDynamicDy(this.companyDy, dclRecordDTO);
            this.initDynamicDy(this.dclRecordRuleDy, dclRecordDTO);
            this.initDynamicDy(this.dclRecordRuleVDy, dclRecordDTO);
            ErrMsg errMsg = dclRecordDTO.getErrMsg().clone();
            dclRecordDTO.setErrMsg(errMsg);
            return dclRecordDTO;
        }
        catch (CloneNotSupportedException ex) {
            throw new KDBizException((Throwable)ex, new ErrorCode("", ex.toString()), new Object[0]);
        }
    }

    private void initDynamicDy(DynamicObject srcDynamicObject, DclRecordDTO dclRecordDTO) {
        if (srcDynamicObject != null) {
            DynamicObject newDclRecordDy = (DynamicObject)srcDynamicObject.getDynamicObjectType().createInstance();
            HRDynamicObjectUtils.copy((DynamicObject)srcDynamicObject, (DynamicObject)newDclRecordDy);
            dclRecordDTO.setDclRecordDy(newDclRecordDy);
        }
    }

    public ErrMsg getErrMsg() {
        if (this.errMsg == null) {
            this.errMsg = new ErrMsg();
        }
        return this.errMsg;
    }

    public void setErrMsg(ErrMsg errMsg) {
        this.errMsg = errMsg;
    }

    public String getErrCode() {
        return this.errCode;
    }

    public void setErrCode(String errCode) {
        this.errCode = errCode;
    }

    public DynamicObject getCurrPeriodDy() {
        return this.currPeriodDy;
    }

    public void setCurrPeriodDy(DynamicObject currPeriodDy) {
        this.currPeriodDy = currPeriodDy;
    }

    public DynamicObject getCompanyDy() {
        return this.companyDy;
    }

    public void setCompanyDy(DynamicObject companyDy) {
        this.companyDy = companyDy;
    }

    public DynamicObject getDclRecordRuleDy() {
        return this.dclRecordRuleDy;
    }

    public void setDclRecordRuleDy(DynamicObject dclRecordRuleDy) {
        this.dclRecordRuleDy = dclRecordRuleDy;
    }

    public DynamicObject getDclRecordRuleVDy() {
        return this.dclRecordRuleVDy;
    }

    public void setDclRecordRuleVDy(DynamicObject dclRecordRuleVDy) {
        this.dclRecordRuleVDy = dclRecordRuleVDy;
    }

    public DynamicObject getDclRecordDy() {
        return this.dclRecordDy;
    }

    public void setDclRecordDy(DynamicObject dclRecordDy) {
        this.dclRecordDy = dclRecordDy;
    }

    public List<Long> getStandardVIds() {
        if (this.standardVIds == null) {
            return Collections.emptyList();
        }
        return this.standardVIds;
    }

    public void setStandardVIds(List<Long> standardVIds) {
        this.standardVIds = standardVIds;
    }

    public String getOpKey() {
        return this.opKey;
    }

    public void setOpKey(String opKey) {
        this.opKey = opKey;
    }

    public boolean isFileEmpty() {
        return this.isFileEmpty;
    }

    public void setFileEmpty(boolean fileEmpty) {
        this.isFileEmpty = fileEmpty;
    }

    public void clearUnusedData() {
        this.dclRecordDy = null;
        this.currPeriodDy = null;
        this.companyDy = null;
        this.standardVIds = null;
        this.dclRecordRuleDy = null;
        this.dclRecordRuleVDy = null;
        this.errMsg = null;
    }

    public void convertDclRecordDyToDto(DynamicObject dclRecordDy) {
        super.convertDclRecordDyToDto(dclRecordDy);
        this.setDclRecordDy(dclRecordDy);
        this.setCurrPeriodDy(dclRecordDy.getDynamicObject("period"));
        this.setCompanyDy(dclRecordDy.getDynamicObject("insuredcompany"));
        List<Long> stdVIds = dclRecordDy.getDynamicObjectCollection("mulsinsurstd").stream().map(baseDy -> baseDy.getLong("fbasedataid.id")).collect(Collectors.toList());
        this.setStandardVIds(stdVIds);
        this.setDclRecordRuleDy(dclRecordDy.getDynamicObject("sinsurdclrule"));
        this.setDclRecordRuleVDy(dclRecordDy.getDynamicObject("sinsurdclrulev"));
    }

    public static class ErrMsg
    implements Serializable,
    Cloneable {
        private static final long serialVersionUID = -297585968425240165L;
        private boolean invalid = false;
        private String periodMsg;
        private String companyMsg;
        private String dclRuleMsg;
        private String dclRecordMsg;
        private String standardMsg;
        private String mutexLockMsg;
        private String codeRuleMsg;
        private String nameRepeatedMsg;
        private String generateDclRecordMsg;
        private String existOtherDclRuleForSamePeriodAndCompanyMsg;
        private String dclPersonRuleVIdInvalidMsg;

        private ErrMsg() {
        }

        public ErrMsg clone() {
            try {
                return (ErrMsg)super.clone();
            }
            catch (CloneNotSupportedException ex) {
                throw new KDBizException((Throwable)ex, new ErrorCode("", ex.toString()), new Object[0]);
            }
        }

        public String getPeriodMsg() {
            return this.periodMsg;
        }

        public void setPeriodMsg(String periodMsg) {
            this.invalid = true;
            this.periodMsg = periodMsg;
        }

        public String getCompanyMsg() {
            return this.companyMsg;
        }

        public void setCompanyMsg(String companyMsg) {
            this.invalid = true;
            this.companyMsg = companyMsg;
        }

        public boolean isInvalid() {
            return this.invalid;
        }

        public String getDclRuleMsg() {
            return this.dclRuleMsg;
        }

        public void setDclRuleMsg(String dclRuleMsg) {
            this.invalid = true;
            this.dclRuleMsg = dclRuleMsg;
        }

        public String getDclRecordMsg() {
            return this.dclRecordMsg;
        }

        public void setDclRecordMsg(String dclRecordMsg) {
            this.invalid = true;
            this.dclRecordMsg = dclRecordMsg;
        }

        public String getStandardMsg() {
            return this.standardMsg;
        }

        public void setStandardMsg(String standardMsg) {
            this.invalid = true;
            this.standardMsg = standardMsg;
        }

        public String getMutexLockMsg() {
            return this.mutexLockMsg;
        }

        public void setMutexLockMsg(String mutexLockMsg) {
            this.invalid = true;
            this.mutexLockMsg = mutexLockMsg;
        }

        public String getCodeRuleMsg() {
            return this.codeRuleMsg;
        }

        public void setCodeRuleMsg(String codeRuleMsg) {
            this.invalid = true;
            this.codeRuleMsg = codeRuleMsg;
        }

        public String getNameRepeatedMsg() {
            return this.nameRepeatedMsg;
        }

        public void setNameRepeatedMsg(String nameRepeatedMsg) {
            this.invalid = true;
            this.nameRepeatedMsg = nameRepeatedMsg;
        }

        public String getGenerateDclRecordMsg() {
            return this.generateDclRecordMsg;
        }

        public void setGenerateDclRecordMsg(String generateDclRecordMsg) {
            this.invalid = true;
            this.generateDclRecordMsg = generateDclRecordMsg;
        }

        public String getDclPersonRuleVIdInvalidMsg() {
            return this.dclPersonRuleVIdInvalidMsg;
        }

        public void setDclPersonRuleVIdInvalidMsg(String dclPersonRuleVIdInvalidMsg) {
            this.invalid = true;
            this.dclPersonRuleVIdInvalidMsg = dclPersonRuleVIdInvalidMsg;
        }

        public String getExistOtherDclRuleForSamePeriodAndCompanyMsg() {
            return this.existOtherDclRuleForSamePeriodAndCompanyMsg;
        }

        public void setExistOtherDclRuleForSamePeriodAndCompanyMsg(String existOtherDclRuleForSamePeriodAndCompanyMsg) {
            this.invalid = true;
            this.existOtherDclRuleForSamePeriodAndCompanyMsg = existOtherDclRuleForSamePeriodAndCompanyMsg;
        }
    }
}

