/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.business.declare.export;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.data.BusinessDataReader;
import kd.bos.data.BusinessDataWriter;
import kd.bos.data.ExportLogHelper;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.form.IFormView;
import kd.bos.lang.Lang;
import kd.bos.list.IListView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.privacy.PrivacyCenterServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sit.hcsi.business.caladjust.errinfo.HCSIErrInfoEnum;
import kd.sit.hcsi.business.declare.dto.DclPersonFieldDTO;
import kd.sit.hcsi.business.declare.helper.DclRecordHelper;
import kd.sit.hcsi.business.declare.service.DclPersonService;
import kd.sit.hcsi.common.util.ConvertUtils;
import kd.sit.sitbp.business.handler.BaseProcessHandler;
import kd.sit.sitbp.business.helper.excel.ExcelHelper;
import kd.sit.sitbp.business.helper.excel.model.ExportResult;
import kd.sit.sitbp.business.helper.excel.model.HeadCellInfo;
import kd.sit.sitbp.business.helper.excel.model.SheetInfo;
import kd.sit.sitbp.business.helper.excel.model.WorkbookInfo;
import kd.sit.sitbp.business.helper.excel.model.WorkbookInfoGenerator;
import kd.sit.sitbp.business.helper.listpage.ColumnEntity;
import kd.sit.sitbp.business.helper.listpage.ListPageHelper;
import kd.sit.sitbp.business.servicehelper.MutexServiceHelper;
import kd.sit.sitbp.business.servicehelper.SitDataServiceHelper;
import kd.sit.sitbp.common.api.DataBatch;
import kd.sit.sitbp.common.api.ProcessHandler;
import kd.sit.sitbp.common.constants.SITEntityConstants;
import kd.sit.sitbp.common.util.BaseResult;
import kd.sit.sitbp.common.util.BatchResult;
import kd.sit.sitbp.common.util.GlobalParam;
import kd.sit.sitbp.common.util.SITDateTimeUtils;
import kd.sit.sitbp.common.util.async.enums.MultiThreadCase;
import kd.sit.sitbp.common.util.async.model.assign.AssignMultiThreadTask;
import org.apache.poi.ss.usermodel.Workbook;

public class DclPersonDownLoadTask
extends AssignMultiThreadTask<Map<String, Object>>
implements SITEntityConstants {
    private static final Pattern PATTERN = Pattern.compile("[^(0-9)]");
    private Map<String, WorkbookInfo> workBookInfoMap = new LinkedHashMap<String, WorkbookInfo>(16);
    private Map<String, Workbook> workBookMap = new LinkedHashMap<String, Workbook>(16);
    private Map<String, List<String>> propMap = new HashMap<String, List<String>>(16);
    private Map<String, IDataEntityProperty> desensitizeMap;
    private Map<String, Map<String, String>> combMapMap;
    private ExportResult exportResult;
    private Map<Long, Long> recordIdAndScmIdMap;
    private Object exportLogId;
    private IFormView view;
    private Map<String, DynamicObject> dclRecordMap;
    private Map<String, List<DclPersonFieldDTO>> dclRecordItemMap;
    private Map<Set<Long>, String> recordIdsAndPropsMap = new LinkedHashMap<Set<Long>, String>(16);
    private Map<Long, Set<Long>> recordIdAndGroupMap = new LinkedHashMap<Long, Set<Long>>(16);

    public DclPersonDownLoadTask(Map<Long, Long> recordIdAndScmIdMap, IFormView view) {
        this.recordIdAndScmIdMap = recordIdAndScmIdMap;
        this.view = view;
        this.setHandleCase(MultiThreadCase.BY_ACTION);
    }

    protected ProcessHandler openProcessHandler() {
        this.processHandler = new BaseProcessHandler();
        HashMap<String, Object> cond = new HashMap<String, Object>(2);
        HashMap fieldVal = new HashMap(2);
        cond.put("fieldVal", fieldVal);
        cond.put("callback", "downloadClose");
        HashMap<String, String> labelVal = new HashMap<String, String>(2);
        cond.put("labelVal", labelVal);
        labelVal.put("title", ResManager.loadKDString((String)"\u6b63\u5728\u5bfc\u51fa\u793e\u4fdd\u7533\u62a5\u540d\u5355\uff0c\u5b8c\u6210\u540e\u5c06\u81ea\u52a8\u4e0b\u8f7d", (String)"DclPersonDownLoadTask_1", (String)"sit-hcsi-business", (Object[])new Object[0]));
        this.processHandler.open(this.view, HCSIErrInfoEnum.COMMON_EXPORT_PROGRESS_TITLE.getErrInfo(), cond);
        return this.processHandler;
    }

    protected BaseResult<?> beforePrepareDataBatch() {
        Object fieldKeys;
        this.exportResult = new ExportResult(Integer.valueOf(0));
        this.getTaskAndInsuanceItemGroupByRecord();
        Map<Long, Map<String, String>> dclScmAndRefFieldKeysMap = DclPersonService.getFieldKeysOfScm(this.recordIdAndScmIdMap.values());
        List columnEntities = ListPageHelper.getColumnEntitiesOf((String)"hcsi_dclperson");
        Map<String, ColumnEntity> fieldKeyAndColumnEntityMap = columnEntities.stream().collect(Collectors.toMap(ColumnEntity::getListFieldKey, columnEntity -> columnEntity, (oldVal, newVal) -> oldVal));
        HashMap recordIdAndColumnEntitiesMap = new HashMap(this.recordIdAndScmIdMap.size());
        for (Map.Entry<Long, Long> entry : this.recordIdAndScmIdMap.entrySet()) {
            Long l = entry.getKey();
            fieldKeys = dclScmAndRefFieldKeysMap.getOrDefault(entry.getValue(), Collections.emptyMap());
            for (Map.Entry fieldEntry : fieldKeys.entrySet()) {
                ColumnEntity newColumnEntity;
                ColumnEntity oldColumnEntity = fieldKeyAndColumnEntityMap.get(fieldEntry.getKey());
                if (oldColumnEntity == null || (newColumnEntity = oldColumnEntity.clone()) == null) continue;
                if (fieldEntry.getValue() != null) {
                    newColumnEntity.setListFieldName((String)fieldEntry.getValue());
                }
                recordIdAndColumnEntitiesMap.computeIfAbsent(l, key -> new ArrayList(fieldKeys.size())).add(newColumnEntity);
            }
            List<DclPersonFieldDTO> dclPersonFieldDTOS = this.dclRecordItemMap.get(String.valueOf(l));
            List itemColumnEntities = dclPersonFieldDTOS.stream().map(DclPersonService::convertDynamicItemToColumnEntity).collect(Collectors.toList());
            recordIdAndColumnEntitiesMap.computeIfAbsent(l, key -> new ArrayList(fieldKeys.size())).addAll(itemColumnEntities);
        }
        this.workBookInfoMap.clear();
        this.propMap.clear();
        for (Map.Entry<Object, Long> entry : this.dclRecordMap.entrySet()) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>(4);
            hashMap.put("recordDy", entry.getValue());
            hashMap.put("columnEntities", recordIdAndColumnEntitiesMap.getOrDefault(((DynamicObject)entry.getValue()).getLong("id"), Collections.emptyList()));
            WorkbookInfo workbookInfo = WorkbookInfoGenerator.generateWith((String)"dclPersonExport", hashMap);
            if (workbookInfo != null && workbookInfo.getSheetInfoList() != null) {
                for (SheetInfo sheetInfo : workbookInfo.getSheetInfoList()) {
                    if (sheetInfo.getHeadCellBar() == null || sheetInfo.getHeadCellBar().getContentHeadCellInfoList() == null) continue;
                    List props = sheetInfo.getHeadCellBar().getContentHeadCellInfoList().stream().map(HeadCellInfo::getValueProp).collect(Collectors.toList());
                    this.propMap.put(sheetInfo.getDataKey(), props);
                }
            }
            this.workBookInfoMap.put((String)entry.getKey(), workbookInfo);
        }
        LinkedHashMap<Long, Set> scmIdAndRecordsMap = new LinkedHashMap<Long, Set>(16);
        for (Map.Entry<Long, Long> entry : this.recordIdAndScmIdMap.entrySet()) {
            if (entry.getValue() == null) continue;
            scmIdAndRecordsMap.computeIfAbsent(entry.getValue(), key -> new LinkedHashSet(16)).add(entry.getKey());
        }
        for (Map.Entry entry : scmIdAndRecordsMap.entrySet()) {
            fieldKeys = dclScmAndRefFieldKeysMap.getOrDefault(entry.getKey(), Collections.emptyMap()).keySet();
            String propSj = String.join((CharSequence)",", (Iterable<? extends CharSequence>)fieldKeys);
            this.recordIdsAndPropsMap.put((Set<Long>)entry.getValue(), propSj);
            ((Set)entry.getValue()).forEach(recordId -> this.recordIdAndGroupMap.put((Long)recordId, (Set<Long>)entry.getValue()));
        }
        HashSet hashSet = new HashSet(16);
        this.desensitizeMap = SitDataServiceHelper.generateDesensitizeMap((EntityType)EntityMetadataCache.getDataEntityType((String)"hcsi_calperson"), hashSet);
        List list = columnEntities.stream().filter(ColumnEntity::getComboListColumn).map(ColumnEntity::getListFieldKey).collect(Collectors.toList());
        this.combMapMap = SitDataServiceHelper.resolveCombAndBooleanValues((String)"hcsi_dclperson", list, (boolean)true);
        this.exportLogId = ExportLogHelper.create((Object)"", (String)"hcsi_calperson", (int)this.getTotalSize(), (String)"1");
        return BaseResult.success(null);
    }

    protected List<Map<String, Object>> queryData(String key, List<?> ids) {
        ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>(10);
        QFilter filter = new QFilter("id", "in", ids);
        List<DynamicObject> personDys = DclRecordHelper.queryDclPersonsByQFilter("id,dclrecord.id", filter, "sinsurfilev.number asc");
        LinkedHashMap<Set, List> recordIdsAndPersonIdsMap = new LinkedHashMap<Set, List>(this.recordIdsAndPropsMap.size());
        for (DynamicObject dynamicObject : personDys) {
            Set<Long> recordIds = this.recordIdAndGroupMap.get(dynamicObject.getLong("dclrecord.id"));
            if (CollectionUtils.isEmpty(recordIds)) continue;
            recordIdsAndPersonIdsMap.computeIfAbsent(recordIds, personIds -> new ArrayList(10)).add(dynamicObject.getLong("id"));
        }
        for (Map.Entry entry : recordIdsAndPersonIdsMap.entrySet()) {
            filter = new QFilter("id", "in", entry.getValue());
            String dclScmProperties = this.recordIdsAndPropsMap.get(entry.getKey());
            String selectProps = HRStringUtils.isNotEmpty((String)dclScmProperties) ? dclScmProperties + "," + "id,dclstatus,entryentitytype.insurtypeprop,entryentitytype.insurtype,entryentityitem.insuranceitem,entryentityitem.numvalue" : "id,dclstatus,entryentitytype.insurtypeprop,entryentitytype.insurtype,entryentityitem.insuranceitem,entryentityitem.numvalue";
            List<DynamicObject> dclDys = DclRecordHelper.queryDclPersonsByQFilter(selectProps, filter, "sinsurfilev.number asc");
            for (DynamicObject detail : dclDys) {
                dataList.add(this.packageData(key, detail));
            }
        }
        return dataList;
    }

    protected BatchResult<Map<String, Object>> handleData(DataBatch<Map<String, Object>> dataBatch) {
        List dataList = dataBatch.getDataList();
        try {
            WorkbookInfo workbookInfo;
            int startIndex = dataBatch.getStartIndex();
            for (int i = 0; i < dataList.size(); ++i) {
                ((Map)dataList.get(i)).put("fseq", startIndex + i + 1);
            }
            DynamicObject recordDy = this.dclRecordMap.get(dataBatch.getDataKey());
            if (recordDy != null && (workbookInfo = this.workBookInfoMap.get(recordDy.getString("id"))) != null) {
                Workbook sheets = ExcelHelper.writeData((WorkbookInfo)workbookInfo, dataBatch, (ExportResult)this.exportResult);
                this.workBookMap.put(recordDy.getString("id"), sheets);
            }
        }
        catch (Exception e) {
            this.exportResult.addMessage(e.getMessage());
            return new BatchResult(false, dataList);
        }
        return new BatchResult(true, Collections.emptyList());
    }

    protected BaseResult<Map<String, Object>> afterHandleDataBatch(int status) {
        HashMap<String, String> cond = new HashMap<String, String>(2);
        if (!this.workBookMap.isEmpty() && status == 0) {
            String date = SITDateTimeUtils.format((Date)new Date(), (String)"MM/dd HH:mm:ss");
            date = PATTERN.matcher(date).replaceAll("").trim();
            date = "_" + date;
            String url = null;
            String billFormId = ((IListView)this.view).getBillFormId();
            String appId = this.view.getFormShowParameter().getAppId();
            if (this.workBookMap.size() > 1) {
                LinkedHashMap<String, Workbook> currWorkBookMap = new LinkedHashMap<String, Workbook>(this.workBookMap.size());
                for (Map.Entry<String, Workbook> entry : this.workBookMap.entrySet()) {
                    DynamicObject recordDy = this.dclRecordMap.get(entry.getKey());
                    if (recordDy == null) continue;
                    String fileName = recordDy.getString("name") + date + ".xlsx";
                    currWorkBookMap.put(fileName, entry.getValue());
                }
                if (!currWorkBookMap.isEmpty()) {
                    String fileName = HCSIErrInfoEnum.DCL_PERSON_EXPORT_DATA.getErrInfo(date) + ".zip";
                    url = ExcelHelper.writeZipFileAndGetSafeURL((String)appId, (String)billFormId, currWorkBookMap, (String)fileName);
                    cond.put("url", url);
                }
            } else {
                Map.Entry<String, Workbook> entry = this.workBookMap.entrySet().iterator().next();
                DynamicObject recordDy = this.dclRecordMap.get(entry.getKey());
                if (recordDy != null) {
                    String fileName = recordDy.getString("name") + date + ".xlsx";
                    url = ExcelHelper.storeFileAndGetSafeURL((String)appId, (String)billFormId, (Workbook)entry.getValue(), (String)fileName);
                    cond.put("url", url);
                }
            }
            this.exportLog(this.getTotalSize(), url, this.exportResult.generateMessage(255));
        } else {
            this.exportLog(0, "", this.exportResult.generateMessage(255));
        }
        this.releaseDclRecordMutexLock();
        this.processHandler.close(cond);
        GlobalParam.remove();
        return BaseResult.success(null);
    }

    private void getTaskAndInsuanceItemGroupByRecord() {
        List<DynamicObject> records = this.getRecords();
        Map currRecordMap = records.stream().collect(Collectors.toMap(record -> record.getLong("id"), record -> record, (oldVal, newVal) -> oldVal, LinkedHashMap::new));
        Map<Long, List<Long>> standardGroupByTask = this.getStandardGroupByTask(records);
        Map<Long, List<DclPersonFieldDTO>> dclPersonFieldsByRecordIdFormDB = DclPersonService.getInstance().getDclPersonFieldsByRecordIdFormDB(standardGroupByTask);
        this.dclRecordMap = new LinkedHashMap<String, DynamicObject>(records.size());
        this.dclRecordItemMap = new LinkedHashMap<String, List<DclPersonFieldDTO>>(records.size());
        currRecordMap.forEach((dclRecordId, dclRecordDy) -> {
            ArrayList<DclPersonFieldDTO> dclPersonFieldDTOS = new ArrayList<DclPersonFieldDTO>(10);
            if (!HRObjectUtils.isEmpty((Object)dclRecordDy)) {
                DclPersonService.createInsureType(dclPersonFieldDTOS, dclRecordDy.getString("modifytype"));
            }
            dclPersonFieldDTOS.addAll(dclPersonFieldsByRecordIdFormDB.computeIfAbsent((Long)dclRecordId, key -> new ArrayList(10)));
            this.dclRecordMap.put(String.valueOf(dclRecordId), (DynamicObject)dclRecordDy);
            this.dclRecordItemMap.put(String.valueOf(dclRecordId), dclPersonFieldDTOS);
        });
    }

    private List<DynamicObject> getRecords() {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hcsi_dclrecord");
        DynamicObject[] taskDys = helper.query("id,mulsinsurstd,name,number,modifytype", new QFilter("id", "in", this.recordIdAndScmIdMap.keySet()).toArray(), "number desc");
        if (taskDys == null || taskDys.length == 0) {
            return Collections.emptyList();
        }
        return Arrays.asList(taskDys);
    }

    private Map<Long, List<Long>> getStandardGroupByTask(List<DynamicObject> taskDys) {
        LinkedHashMap<Long, List<Long>> standardGroupByTask = new LinkedHashMap<Long, List<Long>>(taskDys.size());
        for (DynamicObject taskDy : taskDys) {
            DynamicObjectCollection standardDysInTask = taskDy.getDynamicObjectCollection("mulsinsurstd");
            List insuranceStandardIds = standardDysInTask.stream().map(baseData -> baseData.getLong("fbasedataid.id")).collect(Collectors.toList());
            standardGroupByTask.put(taskDy.getLong("id"), insuranceStandardIds);
        }
        return standardGroupByTask;
    }

    private Map<String, Object> packageData(String key, DynamicObject detail) {
        HashMap<String, Object> cond = new HashMap<String, Object>(16);
        List<String> propList = this.propMap.get(key);
        if (propList == null || propList.isEmpty()) {
            return cond;
        }
        List dclPersonExtendFieldDtos = this.dclRecordItemMap.getOrDefault(key, new ArrayList(10));
        Set dclPersonExtendFieldSet = dclPersonExtendFieldDtos.stream().map(dclPersonExtendFieldDto -> String.valueOf(dclPersonExtendFieldDto.getFieldKey())).collect(Collectors.toSet());
        for (String prop : propList) {
            if ("fseq".equals(prop) || dclPersonExtendFieldSet.contains(prop)) continue;
            IDataEntityProperty property = this.desensitizeMap.get(prop);
            if (property != null) {
                Object desensitizeValue = PrivacyCenterServiceHelper.getDesensitizeValue((IDataEntityProperty)property, (String)Lang.get().toString(), (String)"EXPORT", (DynamicObject)detail, (Object)detail.get(prop));
                cond.put(prop, desensitizeValue);
                continue;
            }
            Object value = detail.get(prop);
            Map<String, String> combMap = this.combMapMap.get(prop);
            if (combMap != null) {
                value = combMap.get(String.valueOf(value));
            }
            value = ConvertUtils.convertBigDecimalZero((Object)value);
            cond.put(prop, value);
        }
        Map<String, StringJoiner> insurTypePropMap = DclPersonService.getInsureTypeData(detail);
        insurTypePropMap.forEach((insurTypeProp, val) -> {
            if (dclPersonExtendFieldSet.contains(insurTypeProp)) {
                cond.put((String)insurTypeProp, val.toString());
            }
        });
        DynamicObjectCollection resultCol = detail.getDynamicObjectCollection("entryentityitem");
        for (DynamicObject itemResult : resultCol) {
            String insuranceItemId = itemResult.getString("insuranceitem.id");
            if (!dclPersonExtendFieldSet.contains(insuranceItemId)) continue;
            String value = itemResult.getString("numvalue");
            cond.put(String.valueOf(insuranceItemId), value);
        }
        return cond;
    }

    private void exportLog(int complete, String url, String data) {
        MainEntityType objType = EntityMetadataCache.getDataEntityType((String)"bos_exportlog");
        DynamicObject dyn = BusinessDataReader.loadSingle((Object)this.exportLogId, (DynamicObjectType)objType);
        List successResult = this.finalResult.getSuccessResult();
        dyn.set("total", (Object)(successResult.size() + this.finalResult.getFailResultOriginal().size()));
        dyn.set("complete", (Object)successResult.size());
        dyn.set("downloadurl", (Object)url);
        dyn.set("logs", (Object)data);
        dyn.set("exportstatus", (Object)"1");
        dyn.set("finishtime", (Object)new Date());
        BusinessDataWriter.save((IDataEntityType)objType, (Object[])new Object[]{dyn});
    }

    public boolean releaseDclRecordMutexLock() {
        boolean isRelease = true;
        for (Long taskId : this.recordIdAndScmIdMap.keySet()) {
            BaseResult baseResult = MutexServiceHelper.release((String)"hcsi_dclrecord", (String)String.valueOf(taskId), (String)"donothing_export_person");
            isRelease = baseResult.isSuccess() && isRelease;
        }
        return isRelease;
    }
}

