/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.business.declare.export;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.sit.hcsi.business.caladjust.errinfo.HCSIErrInfoEnum;
import kd.sit.sitbp.business.helper.excel.model.HeadCellBar;
import kd.sit.sitbp.business.helper.excel.model.HeadCellInfo;
import kd.sit.sitbp.business.helper.excel.model.SheetInfo;
import kd.sit.sitbp.business.helper.excel.model.WorkbookInfo;
import kd.sit.sitbp.business.helper.excel.model.WorkbookInfoGenerator;
import kd.sit.sitbp.business.helper.listpage.ColumnEntity;
import kd.sit.sitbp.common.constants.SITEntityConstants;
import kd.sit.sitbp.common.util.datatype.DataTypeEnum;

public class DclPersonWorkbookMultiTaskBillList
implements WorkbookInfoGenerator,
SITEntityConstants {
    private static final Log LOGGER = LogFactory.getLog(DclPersonWorkbookMultiTaskBillList.class);

    public WorkbookInfo generate(Map<String, Object> param) {
        WorkbookInfo workbookInfo = new WorkbookInfo();
        try {
            DynamicObject recordDy = (DynamicObject)param.get("recordDy");
            List columnEntities = (List)param.get("columnEntities");
            String dclRecordNum = recordDy.getString("number");
            workbookInfo.setFileName(dclRecordNum);
            String recordId = recordDy.getString("id");
            SheetInfo sheetInfo = new SheetInfo();
            sheetInfo.setName(dclRecordNum);
            sheetInfo.setDataKey(recordId);
            HeadCellBar headCellBar = new HeadCellBar();
            sheetInfo.setHeadCellBar(headCellBar);
            this.setFSeq(headCellBar);
            int index = 0;
            for (ColumnEntity columnEntity : columnEntities) {
                String listFieldKey = columnEntity.getListFieldKey();
                columnEntity.setSeq(index++);
                HeadCellInfo headCellInfo = new HeadCellInfo();
                headCellInfo.setDefaultDesc(columnEntity.getListFieldName());
                headCellInfo.setValueProp(listFieldKey);
                DataTypeEnum dataType = columnEntity.getDataType();
                headCellInfo.setDataType(dataType.name());
                if (DataTypeEnum.DATE == dataType) {
                    headCellInfo.setBaseFormat(columnEntity.getDisplayFormatString());
                } else if (DataTypeEnum.LONG == dataType) {
                    headCellInfo.setDataType(DataTypeEnum.STRING.name());
                    headCellInfo.setBaseFormat("@");
                } else {
                    headCellInfo.setBaseFormat(columnEntity.getDisplayFormatString());
                }
                if (columnEntity.getScale() != null) {
                    headCellInfo.setScale(columnEntity.getScale().intValue());
                }
                headCellBar.addHeadCellInfos(new HeadCellInfo[]{headCellInfo});
            }
            workbookInfo.setSheetInfoList(Collections.singletonList(sheetInfo));
            workbookInfo.ready();
        }
        catch (Exception e) {
            LOGGER.error("DclDetailWorkbookMultiTaskBillList.generate, error info:", (Throwable)e);
        }
        return workbookInfo;
    }

    private void setFSeq(HeadCellBar headCellBar) {
        HeadCellInfo headCellInfo = new HeadCellInfo();
        headCellInfo.setDefaultDesc(HCSIErrInfoEnum.COMMON_SEQ.getErrInfo());
        headCellInfo.setValueProp("fseq");
        headCellInfo.setDataType(DataTypeEnum.INTEGER.name());
        headCellBar.addHeadCellInfos(new HeadCellInfo[]{headCellInfo});
    }
}

