/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.business.declare.helper;

import com.alibaba.fastjson.JSON;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.service.metadata.HttpUtils;
import kd.hr.hbp.business.bgtask.HRBackgroundTaskHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sit.hcsi.business.caladjust.errinfo.HCSIErrInfoEnum;
import kd.sit.hcsi.business.declare.dto.DclRecordDTO;
import kd.sit.hcsi.business.declare.mq.BatchDclRecordPublisher;
import kd.sit.sitbp.business.servicehelper.MutexServiceHelper;
import kd.sit.sitbp.business.servicehelper.SITPermissionServiceHelper;
import kd.sit.sitbp.common.cache.ISITAppCache;
import kd.sit.sitbp.common.cache.SITAppCache;
import kd.sit.sitbp.common.entity.social.CalTaskProgressInfoDTO;
import kd.sit.sitbp.common.model.MutexLockInfo;
import kd.sit.sitbp.common.model.Pair;
import kd.sit.sitbp.common.util.BaseResult;
import kd.sit.sitbp.common.util.SITListUtil;
import org.apache.commons.lang.StringUtils;

public class DclRecordHelper {
    private static final Log log = LogFactory.getLog(DclRecordHelper.class);
    public static final HRBaseServiceHelper DCL_RECORD_HELPER = new HRBaseServiceHelper("hcsi_dclrecord");
    public static final HRBaseServiceHelper DCL_PERSON_HELPER = new HRBaseServiceHelper("hcsi_dclperson");
    public static final HRBaseServiceHelper SINSUR_FILE_HELPER = new HRBaseServiceHelper("hcsi_sinsurfile");
    public static final Integer TOTAL_BATCH_SIZE = 2000;

    private DclRecordHelper() {
    }

    public static List<DynamicObject> queryDclRecordsByQFilter(QFilter filter) {
        DynamicObject[] recordDys = DCL_RECORD_HELPER.loadDynamicObjectArray(filter.toArray());
        if (recordDys == null || recordDys.length == 0) {
            return Collections.emptyList();
        }
        return Arrays.asList(recordDys);
    }

    public static List<DynamicObject> queryNormalDclRecordsByQFilter(QFilter filter) {
        QFilter currFilter = new QFilter("dclstatus", "!=", (Object)"D");
        currFilter.and(filter);
        return DclRecordHelper.queryDclRecordsByQFilter(currFilter);
    }

    public static List<DynamicObject> queryDclPersonsByQFilter(String properties, QFilter filter, String orderBy) {
        DynamicObject[] dclPersonDys = DCL_PERSON_HELPER.query(properties, filter.toArray(), orderBy);
        if (dclPersonDys == null) {
            return new ArrayList<DynamicObject>(0);
        }
        return Arrays.asList(dclPersonDys);
    }

    public static Map<String, String> getComboPropAndNameMap(String entityName, String fieldKey) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityName);
        ComboProp taskTypeCombo = (ComboProp)dataEntityType.getProperties().get((Object)fieldKey);
        List comboItems = taskTypeCombo.getComboItems();
        return comboItems.stream().collect(Collectors.toMap(ValueMapItem::getValue, item -> item.getName().getLocaleValue(), (oldVal, newVa) -> oldVal));
    }

    public static List<DynamicObject> queryEntityDy(String entityNumber, Set<Long> entityPkIds, boolean updateDclRecordList) {
        if (entityPkIds == null || entityPkIds.size() == 0 || StringUtils.isEmpty((String)entityNumber)) {
            return Collections.emptyList();
        }
        HRBaseServiceHelper helper = HRBaseServiceHelper.create((String)entityNumber);
        QFilter filter = new QFilter("id", "in", entityPkIds);
        if (updateDclRecordList) {
            DclRecordHelper.filterEnableAndAuditedData(filter);
        }
        DynamicObject[] periodDys = helper.loadDynamicObjectArray(filter.toArray());
        return Optional.ofNullable(periodDys).map(Arrays::asList).orElseGet(() -> Collections.emptyList());
    }

    private static void filterEnableAndAuditedData(QFilter filter) {
        filter.and("enable", "=", (Object)"1");
        filter.and("status", "=", (Object)"C");
    }

    public static String getLockInfo(Long dclRecordId, String dclRecordNumber, String opKey, boolean isPersonForm) {
        BaseResult lockInfo = MutexServiceHelper.getMutexLockInfo((String)"hcsi_dclrecord", (String)String.valueOf(dclRecordId), (String)opKey);
        String errInfo = null;
        if (lockInfo.isSuccess()) {
            String operateName = MutexServiceHelper.getOperateName((String)"hcsi_dclrecord", (String)opKey);
            String lockedOperateName = MutexServiceHelper.getOperateName((String)"hcsi_dclrecord", (String)((MutexLockInfo)lockInfo.getData()).getOpKey());
            errInfo = isPersonForm ? HCSIErrInfoEnum.DCL_PERSON_LOCKED.getErrInfo(lockedOperateName, operateName) : HCSIErrInfoEnum.DCL_RECORD_LOCKED.getErrInfo(dclRecordNumber, lockedOperateName, operateName);
        }
        return errInfo;
    }

    public static void mutexLockOperateKey(Long dclRecordId, String opKey) {
        Set netCtrlOperateKeys = MutexServiceHelper.getDataEntityNetCtrlOperate((String)"hcsi_dclrecord");
        if (!netCtrlOperateKeys.isEmpty() && netCtrlOperateKeys.contains(opKey)) {
            MutexServiceHelper.require((String)"hcsi_dclrecord", (String)String.valueOf(dclRecordId), (String)opKey);
        }
    }

    public static void releaseLockOperateKey(Long dclRecordId, String opKey) {
        Set netCtrlOperateKeys = MutexServiceHelper.getDataEntityNetCtrlOperate((String)"hcsi_dclrecord");
        if (!netCtrlOperateKeys.isEmpty() && netCtrlOperateKeys.contains(opKey)) {
            MutexServiceHelper.release((String)"hcsi_dclrecord", (String)String.valueOf(dclRecordId), (String)opKey);
        }
    }

    public static List<Long> getFileBoIds(DclRecordDTO dclRecordDTO, String recordType) {
        QFilter filter = new QFilter("welfarepayer.id", "=", (Object)dclRecordDTO.getCompanyId());
        filter.and("status", "=", (Object)"C");
        filter.and("enable", "=", (Object)"1");
        filter.and("iscurrentversion", "=", (Object)"1");
        QFilter authorFilter = DclRecordHelper.getAuthorizedDataRuleQFilterOf("hcsi_sinsurfile", recordType);
        filter.and(authorFilter);
        DynamicObjectCollection sinsurFileDys = SINSUR_FILE_HELPER.queryOriginalCollection("boid", filter.toArray());
        if (sinsurFileDys == null || sinsurFileDys.size() == 0) {
            return Collections.emptyList();
        }
        return sinsurFileDys.stream().map(sinsurFileDy -> sinsurFileDy.getLong("boid")).collect(Collectors.toList());
    }

    public static QFilter getAuthorizedDataRuleQFilter() {
        return DclRecordHelper.getAuthorizedDataRuleQFilterOf("hcsi_dclperson", "2");
    }

    public static QFilter getAuthorizedDataRuleQFilterOf(String entityNumber, String recordType) {
        boolean needGetAuthorizedDataRuleQFilter;
        QFilter authorizedDataRuleQFilter = new QFilter("1", "=", (Object)1);
        boolean bl = needGetAuthorizedDataRuleQFilter = !(!"hcsi_sinsurfile".equals(entityNumber) && !"hcsi_dclperson".equals(entityNumber) || !"2".equals(recordType) && !"1".equals(recordType));
        if (needGetAuthorizedDataRuleQFilter) {
            List authorizedDataRuleQFilters = SITPermissionServiceHelper.getAuthorizedDataRuleQFilter((String)"2AXKDRPJUQ77", (String)entityNumber, (String)"47150e89000000ac");
            if (authorizedDataRuleQFilters == null) {
                authorizedDataRuleQFilter = new QFilter("1", "!=", (Object)1);
            } else {
                for (QFilter filter : authorizedDataRuleQFilters) {
                    authorizedDataRuleQFilter.and(filter);
                }
            }
        }
        return authorizedDataRuleQFilter;
    }

    public static boolean isNameRepeated(String name) {
        return DCL_RECORD_HELPER.isExists(new QFilter("name", "=", (Object)name).toArray());
    }

    public static List<String> splitDataAndWriteCache(ISITAppCache isitAppCache, DclRecordDTO dclRecordDTO, List<Long> fileBoIds) {
        List<String> batchIds;
        if (fileBoIds.isEmpty()) {
            String batchId = UUID.randomUUID().toString();
            batchIds = Collections.singletonList(batchId);
            isitAppCache.put(batchId, (Object)SerializationUtils.serializeToBase64(Collections.emptyList()));
        } else {
            List split = SITListUtil.split(fileBoIds, (int)TOTAL_BATCH_SIZE);
            batchIds = new ArrayList<String>(split.size());
            for (List subFileBoIds : split) {
                String batchId = UUID.randomUUID().toString();
                batchIds.add(batchId);
                isitAppCache.put(batchId, (Object)SerializationUtils.serializeToBase64((Object)subFileBoIds));
            }
        }
        dclRecordDTO.clearUnusedData();
        isitAppCache.put(String.valueOf(dclRecordDTO.getDclRecordId()), (Object)dclRecordDTO);
        isitAppCache.put(dclRecordDTO.getDclRecordId() + "fileSize", (Object)fileBoIds.size());
        return batchIds;
    }

    public static FormShowParameter getLoadingDclProgressForm(String cacheKey, boolean isDclRecordListView, int successfulDclRecordNum) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("hcsi_dclupdatelist");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("cacheKey", (Object)cacheKey);
        formShowParameter.setCustomParam("isDclRecordListView", (Object)isDclRecordListView);
        formShowParameter.setCustomParam("successfulDclRecordNum", (Object)successfulDclRecordNum);
        String callbackClassName = isDclRecordListView ? "kd.sit.hcsi.formplugin.web.declare.dclrecord.DclRecordList" : "kd.sit.hcsi.formplugin.web.declare.dclperson.DclPersonOpList";
        formShowParameter.setCloseCallBack(new CloseCallBack(callbackClassName, "hcsi_dclupdatelist"));
        return formShowParameter;
    }

    public static void writeFloatingProgress(String pageId, String cacheKey, int dclRecordNumbers, int totalFileSize, boolean isDclRecordListView) {
        ISITAppCache isitAppCache = SITAppCache.get((String)cacheKey);
        CalTaskProgressInfoDTO progressInfo = new CalTaskProgressInfoDTO();
        progressInfo.setTaskNum(dclRecordNumbers);
        progressInfo.setTotal(totalFileSize);
        progressInfo.setStatus(1);
        progressInfo.setStartTime(new Date());
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        params.put("cacheKey", cacheKey);
        params.put("successfulDclRecordNum", dclRecordNumbers);
        params.put("isDclRecordListView", isDclRecordListView);
        if (pageId != null) {
            String title = isDclRecordListView ? HCSIErrInfoEnum.DCL_RECORD_PROGRESS_TITLE.getErrInfo() : HCSIErrInfoEnum.DCL_PERSON_PROGRESS_TITLE.getErrInfo();
            try {
                String floatingDclRecordId = HRBackgroundTaskHelper.getInstance().createBaskgroundTask("sit_hcsi_dclrecordlist", title, true, pageId, params);
                isitAppCache.put("floatingDclRecordId", (Object)floatingDclRecordId);
            }
            catch (Exception exception) {
                log.error("DclRecordHelper.writeFloatingProgress, error info is: ", (Throwable)exception);
            }
        }
        isitAppCache.put(String.format(Locale.ROOT, "DclRecordProgress_%s", cacheKey), (Object)progressInfo);
    }

    public static void publishMsgByPublisher(String cacheKey, List<String> batchStrIds, Long dclRecordId) {
        try {
            for (String batchStrId : batchStrIds) {
                HashMap<String, Object> param = new HashMap<String, Object>(3);
                param.put("cacheKey", cacheKey);
                param.put("batchId", batchStrId);
                param.put("dclRecordId", dclRecordId);
                BatchDclRecordPublisher.publishBatchDclRecordMsg(param);
            }
        }
        catch (Exception ex) {
            log.error(MessageFormat.format("DclRecordHelper.publishMsgByPublisher: cacheKey is {0}, error info is ", cacheKey), (Throwable)ex);
        }
    }

    public static ListShowParameter showExpForm(Collection<Long> warnDclRecordIds) {
        QFilter authorizedDataRuleQFilter = DclRecordHelper.getAuthorizedDataRuleQFilterOf("hcsi_sinsurfile", "2");
        Set<Long> sinsurFileIds = HRBaseServiceHelper.create((String)"hcsi_sinsurfile").queryOriginalCollection("id", authorizedDataRuleQFilter.toArray()).stream().map(fileDy -> fileDy.getLong("id")).collect(Collectors.toSet());
        QFilter filter = DclRecordHelper.getDclFileExpFilter(warnDclRecordIds, sinsurFileIds);
        ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)"hcsi_dclfileexp", (boolean)true, (int)0, (boolean)true);
        listShowParameter.setAppId("2AXKDRPJUQ77");
        listShowParameter.setFormId("hcsi_dclfileexpf7");
        listShowParameter.getListFilterParameter().getQFilters().add(filter);
        listShowParameter.getListFilterParameter().setOrderBy("sinsurfilev.number asc");
        return listShowParameter;
    }

    public static QFilter getDclFileExpFilter(Collection<Long> warnDclRecordIds, Set<Long> authedSinsurFileIds) {
        if (warnDclRecordIds == null || warnDclRecordIds.size() == 0 || authedSinsurFileIds == null || authedSinsurFileIds.size() == 0) {
            return new QFilter("1", "!=", (Object)1);
        }
        QFilter filter = new QFilter("dclrecord", "in", warnDclRecordIds);
        if (authedSinsurFileIds.size() < 100000) {
            filter.and("sinsurfilev", "in", authedSinsurFileIds);
            return filter;
        }
        return DclRecordHelper.getDetailDclFileExpFilter(authedSinsurFileIds, filter);
    }

    public static QFilter getDetailDclFileExpFilter(Set<Long> authedSinsurFileIds, QFilter filter) {
        if (filter == null || authedSinsurFileIds == null || authedSinsurFileIds.size() == 0) {
            return new QFilter("1", "!=", (Object)1);
        }
        DynamicObjectCollection dclFileExpDys = HRBaseServiceHelper.create((String)"hcsi_dclfileexp").queryOriginalCollection("id,sinsurfilev.id", filter.toArray());
        HashSet<Long> lastDclFileExpIds = new HashSet<Long>(64);
        HashSet<Long> lastFileVIds = new HashSet<Long>(64);
        if (dclFileExpDys != null) {
            for (DynamicObject dclFileExpDy : dclFileExpDys) {
                if (!authedSinsurFileIds.contains(dclFileExpDy.getLong("sinsurfilev.id"))) continue;
                lastDclFileExpIds.add(dclFileExpDy.getLong("id"));
                lastFileVIds.add(dclFileExpDy.getLong("sinsurfilev.id"));
            }
        }
        if (lastDclFileExpIds.size() < 100000) {
            filter = new QFilter("id", "in", lastDclFileExpIds);
        } else {
            filter.and("sinsurfilev", "in", lastFileVIds);
        }
        log.info("DclRecordHelper.getDetailDclFileExpFilter: id size is {}, insurance file size is {}", (Object)lastDclFileExpIds.size(), (Object)lastFileVIds.size());
        return filter;
    }

    public static Optional<List<Long>> getDclRecordPermOrgs() {
        HasPermOrgResult permOrgs = SITPermissionServiceHelper.getPermOrgs((String)"31", (String)"2AXKDRPJUQ77", (String)"hcsi_dclrecord", (String)"47150e89000000ac");
        if (permOrgs != null && !permOrgs.hasAllOrgPerm()) {
            List hasPermOrgs = permOrgs.getHasPermOrgs();
            HttpUtils.logger.info("DclRecordHelper.getDclRecordPermOrgs: hasPermOrgs is {}", (Object)JSON.toJSONString((Object)hasPermOrgs));
            return Optional.ofNullable(hasPermOrgs);
        }
        return Optional.empty();
    }

    public static Optional<List<Long>> getDclPersonPermOrgs() {
        HasPermOrgResult permOrgs = SITPermissionServiceHelper.getPermOrgs((String)"31", (String)"2AXKDRPJUQ77", (String)"hcsi_dclperson", (String)"47150e89000000ac");
        if (permOrgs != null && !permOrgs.hasAllOrgPerm()) {
            List hasPermOrgs = permOrgs.getHasPermOrgs();
            HttpUtils.logger.info("DclRecordHelper.getDclPersonPermOrgs: hasPermOrgs is {}", (Object)JSON.toJSONString((Object)hasPermOrgs));
            return Optional.ofNullable(hasPermOrgs);
        }
        return Optional.empty();
    }

    public static Optional<Pair<String, String>> getLockedAndCurrOpName(String entityName, Object pkId, String operateKey) {
        BaseResult lockInfo = MutexServiceHelper.getMutexLockInfo((String)entityName, (String)String.valueOf(pkId), (String)operateKey);
        Set allLockKeys = MutexServiceHelper.getDataEntityNetCtrlOperate((String)entityName);
        if (lockInfo.isSuccess()) {
            String currOpName = MutexServiceHelper.getOperateName((String)entityName, (String)operateKey);
            if (lockInfo.getData() == null || !allLockKeys.contains(((MutexLockInfo)lockInfo.getData()).getOpKey())) {
                return Optional.of(new Pair(null, (Object)currOpName));
            }
            String lockedOpName = MutexServiceHelper.getOperateName((String)entityName, (String)((MutexLockInfo)lockInfo.getData()).getOpKey());
            return Optional.of(new Pair((Object)lockedOpName, (Object)currOpName));
        }
        return Optional.empty();
    }
}

