/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.business.declare.helper;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.ComboProp;
import kd.sit.hcsi.business.caladjust.errinfo.HCSIErrInfoEnum;

public class DclRuleHelper {
    private DclRuleHelper() {
    }

    public static String getInstructionsTxt(String modifyType, String hasInsurType, List<DynamicObject> insurTypeMul) {
        if (insurTypeMul == null) {
            insurTypeMul = Collections.emptyList();
        }
        String instructionsCombo = DclRuleHelper.getInstructionsCombo(modifyType, hasInsurType, insurTypeMul.size());
        LocaleString localeString = DclRuleHelper.getInstructions().get(instructionsCombo);
        if ("0".equals(instructionsCombo) || localeString == null) {
            return null;
        }
        String instructionsTxt = null;
        List insurTypeNames = insurTypeMul.stream().map(insurType -> insurType.getString("fbasedataid.name")).collect(Collectors.toList());
        String localeValue = localeString.getLocaleValue();
        if ("a11".equals(instructionsCombo) || "b11".equals(instructionsCombo)) {
            if (insurTypeNames.size() == 1) {
                instructionsTxt = MessageFormat.format(localeValue, insurTypeNames.get(0), insurTypeNames.get(0));
            }
        } else {
            String insurTypeNameStr = insurTypeNames.stream().collect(Collectors.joining(HCSIErrInfoEnum.COMMON_CHINA_COMMA.getErrInfo()));
            instructionsTxt = insurTypeNameStr.length() > 0 ? MessageFormat.format(localeValue, insurTypeNameStr) : localeValue;
        }
        return instructionsTxt;
    }

    public static String getInstructionsCombo(String modifyType, String hasInsurType, int insurTypeSize) {
        if (modifyType == null || hasInsurType == null) {
            return "0";
        }
        String instructionsComboVal = modifyType + hasInsurType + (insurTypeSize > 1 ? "n" : Integer.valueOf(insurTypeSize));
        instructionsComboVal = instructionsComboVal.toLowerCase(Locale.ROOT);
        if (!DclRuleHelper.getInstructions().containsKey(instructionsComboVal)) {
            instructionsComboVal = "0";
        }
        return instructionsComboVal;
    }

    public static Map<String, LocaleString> getInstructions() {
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)"hcsi_sinsurdclrule");
        EntryType entryEntity = (EntryType)mainType.getAllEntities().get("entryentity");
        ComboProp instructionsProp = (ComboProp)entryEntity.getProperties().get((Object)"instructions");
        if (instructionsProp != null && instructionsProp.getComboItems() != null) {
            return instructionsProp.getComboItems().stream().filter(comboItem -> comboItem.getValue() != null).collect(Collectors.toMap(ValueMapItem::getValue, ValueMapItem::getName, (oldVal, newVal) -> oldVal));
        }
        return new HashMap<String, LocaleString>(0);
    }
}

