/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.business.declare.service;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.FmtInfoUtils;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.sit.hcsi.common.entity.cal.InsuredStandard;
import kd.sit.hcsi.business.cal.export.ExportDetailHelper;
import kd.sit.hcsi.business.caladjust.errinfo.HCSIErrInfoEnum;
import kd.sit.hcsi.business.common.service.AbsDetailResultService;
import kd.sit.hcsi.business.declare.dto.DclPersonCacheDTO;
import kd.sit.hcsi.business.declare.dto.DclPersonFieldDTO;
import kd.sit.hcsi.business.declare.enums.DclModifyTypeEnum;
import kd.sit.hcsi.business.declare.enums.InsurTypePropEnum;
import kd.sit.hcsi.business.scheme.helper.DclScmHelper;
import kd.sit.hcsi.business.scheme.service.AbsDisplayScmService;
import kd.sit.sitbp.business.helper.listpage.ColumnEntity;
import kd.sit.sitbp.business.servicehelper.SITMultithreadedQueryHelper;
import kd.sit.sitbp.common.cache.SITPageCache;
import kd.sit.sitbp.common.enums.InsurTypeAttrEnum;
import kd.sit.sitbp.common.enums.SitDataTypeEnum;

public class DclPersonService
extends AbsDetailResultService {
    private static final Log log = LogFactory.getLog(DclPersonService.class);
    public static final String SELECT_PROPERTIES = "id,dclstatus,entryentitytype.insurtypeprop,entryentitytype.insurtype,entryentityitem.insuranceitem,entryentityitem.numvalue";
    private static final Set<Long> payBasePropIdSet = new HashSet<Long>(Arrays.asList(InsurTypeAttrEnum.PAY_BASE_OF_EMPLOYEE.getId(), InsurTypeAttrEnum.PAY_BASE_OF_COMPANY.getId()));

    private DclPersonService() {
    }

    public static DclPersonService getInstance() {
        return DclPersonServiceHolder.SERVICE;
    }

    public DclPersonService createInstance() {
        return new DclPersonService();
    }

    public static Map<Long, Map<String, String>> getFieldKeysOfScm(Collection<Long> dclDisplayScmIds) {
        List<DynamicObject> dclDisplayScmDys = DclScmHelper.querySchemeByFilter(new QFilter("id", "in", dclDisplayScmIds), "entryentity.displayname,entryentity.fieldvalue");
        Map<String, String> fieldValAndNameMap = AbsDisplayScmService.getFieldValAndNameMap("sitbs_schemecol", "1010_S");
        LinkedHashMap<Long, Map<String, String>> dclScmAndRefFieldKeys = new LinkedHashMap<Long, Map<String, String>>(dclDisplayScmDys.size());
        for (DynamicObject dclDisplayScmDy : dclDisplayScmDys) {
            DynamicObjectCollection entryEntity = dclDisplayScmDy.getDynamicObjectCollection("entryentity");
            if (CollectionUtils.isEmpty((Collection)entryEntity)) {
                return new HashMap<Long, Map<String, String>>(0);
            }
            long dclScmId = dclDisplayScmDy.getLong("id");
            Map fieldKeyAndFieldNameMap = dclScmAndRefFieldKeys.computeIfAbsent(dclScmId, key -> new LinkedHashMap(2));
            for (DynamicObject entity : entryEntity) {
                String fieldKey = entity.getString("fieldvalue");
                if (fieldKey == null || fieldKey.trim().length() <= 0) continue;
                fieldKey = fieldKey.trim();
                String displayname = entity.getString("displayname");
                if (displayname == null || displayname.trim().length() == 0) {
                    displayname = fieldValAndNameMap.get(fieldKey);
                }
                fieldKeyAndFieldNameMap.put(fieldKey, displayname);
            }
        }
        return dclScmAndRefFieldKeys;
    }

    public List<DclPersonFieldDTO> getExtendFieldInfoList(IFormView view, DclPersonCacheDTO dclPersonCacheDTO) {
        SITPageCache pageCache = new SITPageCache(view);
        String sortedStdVids = dclPersonCacheDTO.getInsuredStandardVIds().stream().sorted().map(String::valueOf).collect(Collectors.joining(","));
        String cacheKey = view.getPageId() + dclPersonCacheDTO.getDclRecordId() + sortedStdVids;
        String itemString = (String)pageCache.get(cacheKey, String.class);
        if (itemString != null) {
            return JSON.parseArray((String)itemString, DclPersonFieldDTO.class);
        }
        ArrayList<DclPersonFieldDTO> extendFieldInfoList = new ArrayList<DclPersonFieldDTO>(10);
        DclPersonService.createInsureType(extendFieldInfoList, dclPersonCacheDTO.getModifyType());
        HashMap<Long, List<Long>> recordIdAntItsStdVIdsMap = new HashMap<Long, List<Long>>(2);
        recordIdAntItsStdVIdsMap.put(dclPersonCacheDTO.getDclRecordId(), dclPersonCacheDTO.getInsuredStandardVIds());
        List dclPersonFieldDTOS = this.getDclPersonFieldsByRecordIdFormDB(recordIdAntItsStdVIdsMap).getOrDefault(dclPersonCacheDTO.getDclRecordId(), Collections.emptyList());
        extendFieldInfoList.addAll(dclPersonFieldDTOS);
        pageCache.put(cacheKey, (Object)JSON.toJSONString(extendFieldInfoList));
        log.info(SerializationUtils.toJsonString(extendFieldInfoList));
        return extendFieldInfoList;
    }

    public void inputDetailResultToDetailCol(DynamicObjectCollection detailDataCol, List<DclPersonFieldDTO> extendFieldInfoList) {
        DynamicObject[] resultCol;
        if (detailDataCol == null || detailDataCol.size() == 0) {
            return;
        }
        Map<Long, DynamicObject> detailIdDetailMap = detailDataCol.stream().collect(Collectors.toMap(detail -> detail.getLong("id"), detail -> detail));
        HashSet<Long> insuredItemIdSet = new HashSet<Long>(extendFieldInfoList.size());
        HashSet<String> insurTypePropSet = new HashSet<String>(2);
        extendFieldInfoList.forEach(extendFieldInfo -> {
            if (extendFieldInfo.getSpecifyInsurItem().booleanValue()) {
                insuredItemIdSet.add(extendFieldInfo.getInsuredItemId());
            } else {
                insurTypePropSet.add(extendFieldInfo.getFieldKey());
            }
        });
        for (DynamicObject result : resultCol = this.getDetailResultFormMultiThread(new ArrayList<Long>(detailIdDetailMap.keySet()))) {
            this.buildDetailResult(detailIdDetailMap, insuredItemIdSet, insurTypePropSet, result);
        }
    }

    private void buildDetailResult(Map<Long, DynamicObject> detailIdDetailMap, Set<Long> insuredItemIdSet, Set<String> insurTypePropSet, DynamicObject result) {
        Long detailId = result.getLong("id");
        DynamicObject detailDy = detailIdDetailMap.get(detailId);
        if (detailDy == null) {
            return;
        }
        DataEntityPropertyCollection properties = detailDy.getDynamicObjectType().getProperties();
        Map<String, StringJoiner> insurTypePropMap = DclPersonService.getInsureTypeData(result);
        insurTypePropMap.forEach((key, val) -> {
            if (properties.containsKey(key)) {
                detailDy.set(key, (Object)val.toString());
            }
        });
        DynamicObjectCollection insurItemEntryEntity = result.getDynamicObjectCollection("entryentityitem");
        for (DynamicObject insurItemEntry : insurItemEntryEntity) {
            Long insuranceItemId = insurItemEntry.getLong("insuranceitem.id");
            String itemIdStr = String.valueOf(insuranceItemId);
            if (!insuredItemIdSet.contains(insuranceItemId) || !properties.containsKey((Object)itemIdStr)) continue;
            String value = insurItemEntry.getString("numvalue");
            if (!HRStringUtils.isEmpty((String)value) && FmtInfoUtils.getMainCurrencyFmt().get("cs") != null) {
                BigDecimal bigDecimal = new BigDecimal(value);
                bigDecimal = bigDecimal.setScale(2, 1);
                value = FmtInfoUtils.getMainCurrencyFmt().get("cs") + String.valueOf(bigDecimal);
            }
            detailDy.set(itemIdStr, (Object)value);
        }
    }

    public static Map<String, StringJoiner> getInsureTypeData(DynamicObject result) {
        LinkedHashMap<String, StringJoiner> insurTypePropMap = new LinkedHashMap<String, StringJoiner>(16);
        DynamicObjectCollection insurTypeEntryEntity = result.getDynamicObjectCollection("entryentitytype");
        for (DynamicObject insurTypeEntry : insurTypeEntryEntity) {
            String insurTypePropVal = insurTypeEntry.getString("insurtypeprop");
            insurTypePropVal = insurTypePropVal != null ? insurTypePropVal.toLowerCase() : "";
            String insurTypeProp = "insurtypeprop" + insurTypePropVal;
            StringJoiner dispalayValSj = insurTypePropMap.computeIfAbsent(insurTypeProp, key -> new StringJoiner(HCSIErrInfoEnum.COMMON_CHINA_COMMA.getErrInfo()));
            dispalayValSj.add(insurTypeEntry.getString("insurtype.name"));
        }
        return insurTypePropMap;
    }

    public static void createInsureType(List<DclPersonFieldDTO> itemList, String modifyType) {
        if (DclModifyTypeEnum.DCL_ADD_NUMBER.getCode().equals(modifyType) || DclModifyTypeEnum.DCL_SUBTRACT_NUMBER.getCode().equals(modifyType)) {
            itemList.add(DclPersonService.getDclPersonExtendFieldDTO(InsurTypePropEnum.DCL_INSURED_TYPE));
        } else if (DclModifyTypeEnum.DCL_ADJUST_BASE.getCode().equals(modifyType)) {
            itemList.add(DclPersonService.getDclPersonExtendFieldDTO(InsurTypePropEnum.DCL_ADJUST_BASE_INSURE_TYPE));
        } else if (DclModifyTypeEnum.DCL_MODIFY_INSURE_TYPE.getCode().equals(modifyType)) {
            itemList.add(DclPersonService.getDclPersonExtendFieldDTO(InsurTypePropEnum.DCL_NEW_INSURE_TYPE));
            itemList.add(DclPersonService.getDclPersonExtendFieldDTO(InsurTypePropEnum.DCL_STOPPED_INSURE_TYPE));
        }
    }

    private static DclPersonFieldDTO getDclPersonExtendFieldDTO(InsurTypePropEnum insurTypePropEnum) {
        DclPersonFieldDTO fieldDTO = new DclPersonFieldDTO();
        String fieldKey = "insurtypeprop" + insurTypePropEnum.getCode().toLowerCase();
        fieldDTO.setFieldKey(fieldKey);
        fieldDTO.setInsuredItemName(insurTypePropEnum.getDescEnum().getErrInfo());
        fieldDTO.setDataLength(50);
        fieldDTO.setScale(2);
        fieldDTO.setDataTypeId(SitDataTypeEnum.TEXT.getId());
        fieldDTO.setSpecifyInsurItem(Boolean.FALSE);
        return fieldDTO;
    }

    public Map<Long, List<DclPersonFieldDTO>> getDclPersonFieldsByRecordIdFormDB(Map<Long, List<Long>> recordIdAntItsStdVIdsMap) {
        Map<Long, List<InsuredStandard>> insuredItemGroupByTaskFormDB = this.getInsuredItemGroupByTaskFormDB(recordIdAntItsStdVIdsMap);
        LinkedHashMap<Long, List<DclPersonFieldDTO>> insuredItemGroupByRecordFormDB = new LinkedHashMap<Long, List<DclPersonFieldDTO>>(insuredItemGroupByTaskFormDB.size());
        for (Map.Entry<Long, List<InsuredStandard>> entry : insuredItemGroupByTaskFormDB.entrySet()) {
            List<InsuredStandard> insuredStandards = entry.getValue();
            List dclPersonFieldDTOS = insuredStandards != null ? insuredStandards.stream().map(DclPersonService::convertToDclPersonFieldDTO).collect(Collectors.toList()) : Collections.emptyList();
            insuredItemGroupByRecordFormDB.put(entry.getKey(), dclPersonFieldDTOS);
        }
        return insuredItemGroupByRecordFormDB;
    }

    @Override
    protected void filterInsuredItemDataCol(DynamicObjectCollection insuredItemDataCol) {
        insuredItemDataCol.removeIf(insuredItemData -> !payBasePropIdSet.contains(insuredItemData.getLong("stdentryentity.subentryentity.insuritem.insurancetypeattr.id")));
    }

    public static DclPersonFieldDTO convertToDclPersonFieldDTO(InsuredStandard formDto) {
        DclPersonFieldDTO dclPersonFieldDTO = new DclPersonFieldDTO(formDto.getInsuredItemId(), formDto.getInsuredItemName(), formDto.getDataTypeId());
        dclPersonFieldDTO.setDataLength(formDto.getDataLength());
        dclPersonFieldDTO.setScale(formDto.getScale());
        return dclPersonFieldDTO;
    }

    public static ColumnEntity convertDynamicItemToColumnEntity(DclPersonFieldDTO dclPersonFieldDTO) {
        ColumnEntity columnEntity = ExportDetailHelper.convertDynamicItemToColumnEntity(dclPersonFieldDTO);
        columnEntity.setListFieldKey(dclPersonFieldDTO.getFieldKey());
        return columnEntity;
    }

    private DynamicObject[] getDetailResultFormMultiThread(List<Long> detailIdList) {
        try {
            return SITMultithreadedQueryHelper.getInstance().getData("hcsi_dclperson", SELECT_PROPERTIES, detailIdList, "");
        }
        catch (InterruptedException e) {
            log.error((Throwable)e);
            return new DynamicObject[0];
        }
    }

    private static class DclPersonServiceHolder {
        private static final DclPersonService SERVICE = new DclPersonService();

        private DclPersonServiceHolder() {
        }
    }
}

