/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.business.declare.service;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sit.hcsi.business.declare.dto.DclPersonCacheDTO;
import kd.sit.hcsi.business.declare.dto.DclRecordDTO;
import kd.sit.hcsi.business.declare.service.type.DclRecordType;
import kd.sit.hcsi.business.declare.service.type.IDclRecordType;
import kd.sit.hcsi.common.constants.SocialInsuranceDeclareConstants;

public class DclRecordService
implements SocialInsuranceDeclareConstants {
    private static final Log logger = LogFactory.getLog(DclRecordService.class);

    private DclRecordService() {
    }

    public static DclRecordService createInstance() {
        return new DclRecordService();
    }

    public static ListShowParameter getDcPersonListForm(Long taskId) {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setFormId("bos_list");
        showParameter.setBillFormId("hcsi_dclperson");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCustomParam("sinsurdclrecordId", (Object)taskId);
        return showParameter;
    }

    public static ListShowParameter getDclPersonListForm(Long dclRecordId) {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setFormId("hcsi_dclpersonlist");
        showParameter.setBillFormId("hcsi_dclperson");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCustomParam("dclRecordId", (Object)dclRecordId);
        return showParameter;
    }

    public static FormShowParameter getFormShowParam(String pluginName, String formId) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId(formId);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCloseCallBack(new CloseCallBack(pluginName, formId));
        formShowParameter.setHasRight(true);
        return formShowParameter;
    }

    public static FormShowParameter getLoadingRecordProgressForm(String recordId, boolean isLaunchCalculate, String pluginName) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("hcsi_loadingcalculation");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("RECORD_ID", (Object)recordId);
        formShowParameter.setCustomParam("IS_LAUNCH_CALCULATE", (Object)isLaunchCalculate);
        formShowParameter.setCloseCallBack(new CloseCallBack(pluginName, "hcsi_loadingcalculation"));
        return formShowParameter;
    }

    public static void writeBackDclRecordStatus(Long dclRecordId, String opNumber) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hcsi_dclperson");
        QFilter idFilter = new QFilter("dclrecord", "=", (Object)dclRecordId);
        String declareStatus = "";
        if ("donothing_mark_declare".equals(opNumber)) {
            declareStatus = "A";
        } else if ("donothing_undeclare".equals(opNumber)) {
            declareStatus = "C";
        }
        QFilter statusFilter = new QFilter("dclstatus", "=", (Object)declareStatus);
        int totalCount = helper.count("hcsi_dclperson", new QFilter[]{idFilter});
        int declaredCount = helper.count("hcsi_dclperson", new QFilter[]{idFilter, statusFilter});
        helper = new HRBaseServiceHelper("hcsi_dclrecord");
        DynamicObject dclRecordDy = helper.queryOne("id, dclstatus", new QFilter("id", "=", (Object)dclRecordId).toArray());
        if ("donothing_mark_declare".equals(opNumber)) {
            dclRecordDy.set("dclstatus", (Object)(totalCount == declaredCount ? "A" : "B"));
        } else if ("donothing_undeclare".equals(opNumber)) {
            dclRecordDy.set("dclstatus", (Object)(totalCount == declaredCount ? "C" : "B"));
        }
        helper.saveOne(dclRecordDy);
    }

    public static IDclRecordType getDclRecordListView(String pageId, Set<Long> periodIds, Set<Long> companyIds, String recordType, Map<String, Object> extendMaps) {
        DclRecordType dclRecordType = new DclRecordType(pageId, periodIds, companyIds, recordType, extendMaps);
        dclRecordType.getDclRecordDTOS().forEach(dclRecordDTO -> dclRecordDTO.setOpKey("donothing_gendcrecord"));
        return dclRecordType;
    }

    public static Optional<IDclRecordType> getDclPersonListView(String pageId, DclPersonCacheDTO dclPersonCacheDTO) {
        Set<Long> periodIds = Collections.singleton(dclPersonCacheDTO.getPeriodId());
        Set<Long> companyIds = Collections.singleton(dclPersonCacheDTO.getInsuredCompanyId());
        DclRecordType dclRecordType = new DclRecordType(pageId, periodIds, companyIds, "2", null);
        for (DclRecordDTO dclRecordDTO : dclRecordType.getDclRecordDTOS()) {
            dclRecordDTO.setUpdate(Boolean.TRUE);
            dclRecordDTO.setDclBizName(dclPersonCacheDTO.getDclBizName());
            dclRecordDTO.setDclRecordRuleId(dclPersonCacheDTO.getDclRuleId());
            dclRecordDTO.setDclRecordRuleVId(dclPersonCacheDTO.getDclRuleVId());
            dclRecordDTO.setOpKey("donothing_update_person");
        }
        return Optional.of(dclRecordType);
    }
}

