/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.business.declare.service.cal;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.kingscript.util.Tuple;
import kd.sit.hcsi.business.cal.service.SocialInsuranceCalFilterHelper;
import kd.sit.hcsi.business.caladjust.errinfo.HCSIErrInfoEnum;
import kd.sit.hcsi.business.declare.dto.DclRecordDTO;
import kd.sit.hcsi.business.declare.helper.DclRecordHelper;
import kd.sit.hcsi.business.declare.service.cal.IDclService;
import kd.sit.hcsi.business.declare.service.type.IDclRecordType;
import kd.sit.hcsi.business.declare.service.validator.DclRecordValidator;
import kd.sit.sitbp.business.coderule.CodeRuleHelper;
import kd.sit.sitbp.business.servicehelper.MutexServiceHelper;
import kd.sit.sitbp.business.servicehelper.SITBaseDataHelper;
import kd.sit.sitbp.business.servicehelper.SITShowFormServiceHelper;
import kd.sit.sitbp.common.cache.ISITAppCache;
import kd.sit.sitbp.common.cache.SITAppCache;

public class DclCalService
implements IDclService {
    protected static final Log log = LogFactory.getLog(DclCalService.class);
    protected IDclRecordType iDclRecordType;
    protected DclRecordValidator dclRecordValidator;
    private String cacheKey;
    private ISITAppCache iSitAppCache;
    private Map<String, List<String>> dclRecordBatchIdMap;
    private int successfulDclRecordNum;
    private int totalFileSize = 0;

    public DclCalService(IDclRecordType iDclRecordFactory) {
        this.iDclRecordType = iDclRecordFactory;
        this.dclRecordValidator = new DclRecordValidator(iDclRecordFactory);
    }

    @Override
    public boolean updateDclRecord() {
        this.checkDataForBase();
        return this.needConfirm();
    }

    @Override
    public boolean needConfirm() {
        if (this.iDclRecordType.isUpdateDclRecordList()) {
            return this.iDclRecordType.isDclRecordExists();
        }
        return false;
    }

    @Override
    public void checkDataForBase() {
        this.dclRecordValidator.checkPeriodValid();
        this.dclRecordValidator.checkCompanyValid();
        this.dclRecordValidator.checkCurrDclRuleValid();
        this.dclRecordValidator.checkPeriodAndCompanyValid();
        this.dclRecordValidator.checkStdRefCompanyValid();
        this.dclRecordValidator.checkDclRecordExists();
    }

    @Override
    public void prepareUpdateDcl() {
        this.cacheKey = UUID.randomUUID().toString();
        this.iSitAppCache = SITAppCache.get((String)this.cacheKey);
        this.iSitAppCache.put("isUpdateDclPersonList", (Object)this.iDclRecordType.isUpdateDclPersonList());
        this.dclRecordBatchIdMap = new HashMap<String, List<String>>(this.iDclRecordType.getDclRecordDTOS().size());
        for (DclRecordDTO dclRecordDTO : this.iDclRecordType.getDclRecordDTOS()) {
            if (dclRecordDTO.getErrMsg().isInvalid()) continue;
            this.prepareData(dclRecordDTO);
        }
        this.pushData();
        this.showCheckError();
        this.openProgressForm();
    }

    protected void prepareData(DclRecordDTO dclRecordDTO) {
        this.dclRecordValidator.checkDclRecordLockedAndLockIt(dclRecordDTO);
        if (!dclRecordDTO.getErrMsg().isInvalid()) {
            List<Long> fileBoIds = this.getFileBoIds(dclRecordDTO);
            dclRecordDTO.setFileEmpty(fileBoIds.isEmpty());
            if (dclRecordDTO.getUpdate().booleanValue()) {
                if (!this.iDclRecordType.isAddAndUpdateDclRecord()) {
                    return;
                }
                this.updateDclRecordData(dclRecordDTO);
                if (dclRecordDTO.getErrMsg().isInvalid()) {
                    return;
                }
            } else {
                this.addDclRecordData(dclRecordDTO);
                if (dclRecordDTO.isFileEmpty() || dclRecordDTO.getErrMsg().isInvalid()) {
                    return;
                }
                DclRecordHelper.mutexLockOperateKey(dclRecordDTO.getDclRecordId(), dclRecordDTO.getOpKey());
            }
            this.totalFileSize += fileBoIds.size();
            List<String> batchIds = DclRecordHelper.splitDataAndWriteCache(this.iSitAppCache, dclRecordDTO, fileBoIds);
            this.dclRecordBatchIdMap.put(String.valueOf(dclRecordDTO.getDclRecordId()), batchIds);
        }
        log.info("DclCalService.prepareData, end to prepare data, current total file size is {}", (Object)this.totalFileSize);
    }

    private List<Long> getFileBoIds(DclRecordDTO dclRecordDTO) {
        String recordType = this.iDclRecordType.getRecordType();
        List<Long> fileBoIds = DclRecordHelper.getFileBoIds(dclRecordDTO, recordType);
        Set<Long> hasBeenDeclaredFileBoIds = this.getAuthorDclRecordFile(dclRecordDTO, "A");
        fileBoIds.removeAll(hasBeenDeclaredFileBoIds);
        return fileBoIds;
    }

    private Set<Long> getAuthorDclRecordFile(DclRecordDTO dclRecordDTO, String dclStatus) {
        QFilter filter = new QFilter("dclrecord.id", "=", (Object)dclRecordDTO.getDclRecordId());
        filter.and("dclstatus", "=", (Object)dclStatus);
        List<DynamicObject> dclPersonDys = DclRecordHelper.queryDclPersonsByQFilter("sinsurfile.id", filter, "sinsurfile.id desc");
        return dclPersonDys.stream().map(personDy -> personDy.getLong("sinsurfile.id")).collect(Collectors.toSet());
    }

    @Override
    public void pushData() {
        List successfulDclRecordDTOs = this.iDclRecordType.getDclRecordDTOS().stream().filter(this::isValid).collect(Collectors.toList());
        this.successfulDclRecordNum = successfulDclRecordDTOs.size();
        this.releaseLockOfErrorDclRecord();
        if (this.successfulDclRecordNum == 0) {
            return;
        }
        if (this.iDclRecordType.getPageId() != null && this.totalFileSize > 0) {
            DclRecordHelper.writeFloatingProgress(this.iDclRecordType.getPageId(), this.cacheKey, this.successfulDclRecordNum, this.totalFileSize, this.iDclRecordType.isUpdateDclRecordList());
        }
        for (DclRecordDTO dclRecordDTo : successfulDclRecordDTOs) {
            List<String> batchIds = this.dclRecordBatchIdMap.get(String.valueOf(dclRecordDTo.getDclRecordId()));
            if (this.totalFileSize <= 0 || batchIds == null || batchIds.size() <= 0) continue;
            DclRecordHelper.publishMsgByPublisher(this.cacheKey, batchIds, dclRecordDTo.getDclRecordId());
        }
    }

    @Override
    public void openProgressForm() {
        IFormView currView;
        if ((this.iDclRecordType.isUpdateDclRecordList() || this.iDclRecordType.isUpdateDclPersonList()) && (currView = SocialInsuranceCalFilterHelper.getCurrView(this.iDclRecordType.getPageId())) != null) {
            if (this.iDclRecordType.isUpdateDclPersonList() && this.iDclRecordType.getDclRecordDTOS().size() > 0) {
                this.iSitAppCache.put("dclRecordId", (Object)this.iDclRecordType.getDclRecordDTOS().get(0).getDclRecordId());
            }
            if (this.successfulDclRecordNum > 0) {
                FormShowParameter formShowParameter = DclRecordHelper.getLoadingDclProgressForm(this.cacheKey, this.iDclRecordType.isUpdateDclRecordList(), this.successfulDclRecordNum);
                currView.showForm(formShowParameter);
            }
            currView.invokeOperation("refresh");
        }
    }

    private void showCheckError() {
        IFormView currView;
        int failedNum = this.iDclRecordType.getDclRecordDTOS().size() - this.successfulDclRecordNum;
        if ((this.iDclRecordType.isUpdateDclRecordList() || this.iDclRecordType.isUpdateDclPersonList()) && failedNum > 0 && (currView = SocialInsuranceCalFilterHelper.getCurrView(this.iDclRecordType.getPageId())) != null) {
            LinkedHashSet<String> errMsgs = new LinkedHashSet<String>(failedNum);
            String opName = null;
            HashSet<Long> totalCompanyIds = new HashSet<Long>(this.iDclRecordType.getDclRecordDTOS().size());
            HashSet<Long> invalidCompanyIds = new HashSet<Long>(this.iDclRecordType.getDclRecordDTOS().size());
            LinkedHashMap<Long, Tuple> companyIdAndLockedInfoMap = new LinkedHashMap<Long, Tuple>();
            for (DclRecordDTO dclRecordDTO : this.iDclRecordType.getDclRecordDTOS()) {
                totalCompanyIds.add(dclRecordDTO.getCompanyId());
                Tuple lockedCompanies = null;
                if (dclRecordDTO.getCompanyId() != null) {
                    lockedCompanies = companyIdAndLockedInfoMap.computeIfAbsent(dclRecordDTO.getCurrPeriodId(), key -> new Tuple((Object)0, new ArrayList(10)));
                    int count = (Integer)lockedCompanies.getKey();
                    lockedCompanies.setKey((Object)(++count));
                }
                if (!dclRecordDTO.getErrMsg().isInvalid()) continue;
                invalidCompanyIds.add(dclRecordDTO.getCompanyId());
                if (opName == null) {
                    opName = MutexServiceHelper.getOperateName((String)"hcsi_dclrecord", (String)dclRecordDTO.getOpKey());
                }
                DclRecordDTO.ErrMsg errMsg = dclRecordDTO.getErrMsg();
                errMsgs.add(errMsg.getPeriodMsg());
                errMsgs.add(errMsg.getCompanyMsg());
                errMsgs.add(errMsg.getDclRuleMsg());
                errMsgs.add(errMsg.getDclRecordMsg());
                errMsgs.add(errMsg.getStandardMsg());
                errMsgs.add(errMsg.getMutexLockMsg());
                errMsgs.add(errMsg.getCodeRuleMsg());
                errMsgs.add(errMsg.getNameRepeatedMsg());
                errMsgs.add(errMsg.getGenerateDclRecordMsg());
                errMsgs.add(errMsg.getDclPersonRuleVIdInvalidMsg());
                errMsgs.add(errMsg.getExistOtherDclRuleForSamePeriodAndCompanyMsg());
                if (!HRStringUtils.isNotEmpty((String)errMsg.getDclRecordMsg()) || lockedCompanies == null) continue;
                ((List)lockedCompanies.getValue()).add(errMsg.getDclRecordMsg());
            }
            for (Tuple lockedCompanies : companyIdAndLockedInfoMap.values()) {
                int totalSize = (Integer)lockedCompanies.getKey();
                int lockedSize = ((List)lockedCompanies.getValue()).size();
                if (lockedSize <= 0 || lockedSize >= totalSize) continue;
                errMsgs.remove(((List)lockedCompanies.getValue()).get(0));
            }
            errMsgs.removeIf(HRStringUtils::isEmpty);
            if (!errMsgs.isEmpty()) {
                if (this.iDclRecordType.isUpdateDclPersonList()) {
                    errMsgs.forEach(arg_0 -> ((IFormView)currView).showTipNotification(arg_0));
                } else {
                    String title = HCSIErrInfoEnum.DCL_RECORD_COMPANY_SUM_ERROR.getErrInfo(totalCompanyIds.size(), invalidCompanyIds.size());
                    currView.showForm(SITShowFormServiceHelper.getOperationResultParameter((String)opName, (String)title, new ArrayList(errMsgs)));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDclRecordData(DclRecordDTO dclRecordDTO) {
        DynamicObject dclRecordDy = this.createDclRecordDy(dclRecordDTO);
        if (dclRecordDTO.getErrMsg().isInvalid()) {
            return;
        }
        SITBaseDataHelper.setMulBaseDataFieldValue((DynamicObject)dclRecordDy, (String)"mulsinsurstd", dclRecordDTO.getStandardVIds());
        boolean saveSuccess = true;
        try (TXHandle txHandle = TX.required();){
            HRBaseServiceHelper.create((String)"hcsi_dclrecord").saveOne(dclRecordDy);
        }
        if (!saveSuccess) {
            dclRecordDTO.getErrMsg().setGenerateDclRecordMsg(HCSIErrInfoEnum.DCL_RECORD_ADD_ERROR.getErrInfo());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDclRecordData(DclRecordDTO dclRecordDTO) {
        DynamicObject dclRecordDy = this.updateDclRecordDy(dclRecordDTO);
        boolean saveSuccess = true;
        try (TXHandle txHandle = TX.required();){
            HRBaseServiceHelper.create((String)"hcsi_dclfileexp").deleteByFilter(new QFilter("dclrecord", "=", (Object)dclRecordDTO.getDclRecordId()).toArray());
            HRBaseServiceHelper.create((String)"hcsi_dclrecord").updateOne(dclRecordDy);
        }
        if (!saveSuccess) {
            String errMsg = this.iDclRecordType.isUpdateDclPersonList() ? HCSIErrInfoEnum.DCL_PERSON_UPDATE_ERROR.getErrInfo() : HCSIErrInfoEnum.DCL_RECORD_UPDATE_ERROR.getErrInfo();
            dclRecordDTO.getErrMsg().setGenerateDclRecordMsg(errMsg);
        }
    }

    private DynamicObject createDclRecordDy(DclRecordDTO dclRecordDTO) {
        MainEntityType dclRecordType = EntityMetadataCache.getDataEntityType((String)"hcsi_dclrecord");
        DynamicObject dclRecordDy = (DynamicObject)dclRecordType.createInstance();
        dclRecordDy.set("period", (Object)dclRecordDTO.getCurrPeriodDy());
        try {
            String number = CodeRuleHelper.getNumber((DynamicObject)dclRecordDy, null);
            dclRecordDy.set("number", (Object)number);
            dclRecordDTO.setDclRecordDy(dclRecordDy);
        }
        catch (Exception exception) {
            log.error("AbsDclService.addDclRecordData", (Throwable)exception);
            String codeRuleInfo = CodeRuleHelper.getCodeRuleExceptionInfo((Exception)exception);
            if (codeRuleInfo != null) {
                dclRecordDTO.getErrMsg().setMutexLockMsg(codeRuleInfo);
            }
            throw exception;
        }
        if (this.dclRecordValidator.checkNameRepeated(dclRecordDTO)) {
            return null;
        }
        dclRecordDy.set("id", (Object)dclRecordDTO.getDclRecordId());
        dclRecordDy.set("name", (Object)dclRecordDTO.getDclRecordName());
        dclRecordDy.set("insuredcompany", (Object)dclRecordDTO.getCompanyDy());
        dclRecordDy.set("sinsurdclrule", (Object)dclRecordDTO.getDclRecordRuleId());
        dclRecordDy.set("sinsurdclrulev", (Object)dclRecordDTO.getDclRecordRuleVId());
        dclRecordDy.set("dclbusinessname", (Object)dclRecordDTO.getDclBizName());
        dclRecordDy.set("modifytype", (Object)dclRecordDTO.getModifyType());
        dclRecordDy.set("haswelfaretype", (Object)(dclRecordDTO.isHasInsurType() ? "1" : "0"));
        long currUserId = RequestContext.get().getCurrUserId();
        dclRecordDy.set("creator", (Object)currUserId);
        Date date = new Date();
        dclRecordDy.set("createtime", (Object)date);
        dclRecordDy.set("modifier", (Object)currUserId);
        dclRecordDy.set("modifytime", (Object)date);
        if (dclRecordDTO.isHasInsurType()) {
            SITBaseDataHelper.setMulBaseDataFieldValue((DynamicObject)dclRecordDy, (String)"insurtypemul", (List)dclRecordDTO.getInsurTypes());
        }
        dclRecordDy.set("dclstatus", (Object)"E");
        dclRecordDy.set("lockstatus", (Object)"0");
        dclRecordDy.set("dcldisplayscmv", (Object)dclRecordDTO.getDclDisplayScmVId());
        dclRecordDy.set("fileexp", (Object)"0");
        return dclRecordDy;
    }

    private DynamicObject updateDclRecordDy(DclRecordDTO dclRecordDTO) {
        DynamicObject dclRecordDy = dclRecordDTO.getDclRecordDy();
        dclRecordDy.set("sinsurdclrule", (Object)dclRecordDTO.getDclRecordRuleId());
        dclRecordDy.set("sinsurdclrulev", (Object)dclRecordDTO.getDclRecordRuleVId());
        dclRecordDy.set("modifytype", (Object)dclRecordDTO.getModifyType());
        dclRecordDy.set("haswelfaretype", (Object)(dclRecordDTO.isHasInsurType() ? "1" : "0"));
        if (dclRecordDTO.isHasInsurType()) {
            SITBaseDataHelper.setMulBaseDataFieldValue((DynamicObject)dclRecordDy, (String)"insurtypemul", (List)dclRecordDTO.getInsurTypes());
        }
        SITBaseDataHelper.setMulBaseDataFieldValue((DynamicObject)dclRecordDy, (String)"mulsinsurstd", dclRecordDTO.getStandardVIds());
        dclRecordDy.set("dclstatus", (Object)"E");
        dclRecordDy.set("lockstatus", (Object)"0");
        dclRecordDy.set("dcldisplayscmv", (Object)dclRecordDTO.getDclDisplayScmVId());
        Date date = new Date();
        long currUserId = RequestContext.get().getCurrUserId();
        dclRecordDy.set("modifier", (Object)currUserId);
        dclRecordDy.set("modifytime", (Object)date);
        dclRecordDy.set("fileexp", (Object)"0");
        dclRecordDTO.setDclRecordName(dclRecordDy.getString("name"));
        return dclRecordDy;
    }

    private void releaseLockOfErrorDclRecord() {
        for (DclRecordDTO dclRecordDTO : this.iDclRecordType.getDclRecordDTOS()) {
            if (this.isValid(dclRecordDTO)) continue;
            DclRecordHelper.releaseLockOperateKey(dclRecordDTO.getDclRecordId(), dclRecordDTO.getOpKey());
        }
    }

    private boolean isValid(DclRecordDTO dclRecordDTO) {
        boolean isValid;
        boolean bl = isValid = !dclRecordDTO.getErrMsg().isInvalid();
        if (isValid && dclRecordDTO.getUpdate().booleanValue()) {
            isValid = this.iDclRecordType.isAddAndUpdateDclRecord();
        }
        return isValid;
    }
}

