/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.business.declare.service.type;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.sit.hcsi.business.declare.dto.DclRecordDTO;
import kd.sit.hcsi.business.declare.service.cal.DclCalService;
import kd.sit.hcsi.business.declare.service.type.IDclRecordType;

public class DclRecordType
implements IDclRecordType,
Serializable {
    private static final long serialVersionUID = -3789913414333696782L;
    private String pageId;
    private Set<Long> periodIds;
    private Set<Long> companyIds;
    private String recordType;
    private Map<String, Object> extendMaps;
    private List<DclRecordDTO> dclRecordDTOS;
    private boolean dclRecordExists = false;
    private boolean addAndUpdateDclRecord = true;

    public DclRecordType() {
    }

    public DclRecordType(String pageId, Set<Long> periodIds, Set<Long> companyIds, String recordType, Map<String, Object> extendMaps) {
        this.pageId = pageId;
        this.periodIds = periodIds;
        this.companyIds = companyIds;
        this.recordType = recordType;
        this.extendMaps = extendMaps;
        this.dclRecordDTOS = new ArrayList<DclRecordDTO>(10);
        this.initDclRecordDTOS();
    }

    private void initDclRecordDTOS() {
        for (Long periodId : this.getPeriodIds()) {
            for (Long companyId : this.getCompanyIds()) {
                DclRecordDTO dclRecordDTO = new DclRecordDTO();
                dclRecordDTO.setCurrPeriodId(periodId);
                dclRecordDTO.setCompanyId(companyId);
                this.dclRecordDTOS.add(dclRecordDTO);
            }
        }
    }

    @Override
    public void generateRecord() {
        DclCalService dclService = new DclCalService(this);
        boolean needOpSecond = dclService.updateDclRecord();
        if (needOpSecond) {
            return;
        }
        dclService.prepareUpdateDcl();
    }

    @Override
    public void generateRecordAgain() {
        DclCalService dclService = new DclCalService(this);
        dclService.prepareUpdateDcl();
    }

    @Override
    public String getPageId() {
        return this.pageId;
    }

    public void setPageId(String pageId) {
        this.pageId = pageId;
    }

    @Override
    public Set<Long> getPeriodIds() {
        if (this.periodIds == null) {
            return Collections.emptySet();
        }
        return this.periodIds;
    }

    public void setPeriodIds(Set<Long> periodIds) {
        this.periodIds = periodIds;
    }

    @Override
    public Set<Long> getCompanyIds() {
        if (this.companyIds == null) {
            return Collections.emptySet();
        }
        return this.companyIds;
    }

    public void setCompanyIds(Set<Long> companyIds) {
        this.companyIds = companyIds;
    }

    @Override
    public String getRecordType() {
        return this.recordType;
    }

    public void setRecordType(String recordType) {
        this.recordType = recordType;
    }

    @Override
    public Map<String, Object> getExtendMaps() {
        return this.extendMaps;
    }

    public void setExtendMaps(Map<String, Object> extendMaps) {
        this.extendMaps = extendMaps;
    }

    @Override
    public List<DclRecordDTO> getDclRecordDTOS() {
        if (this.dclRecordDTOS == null) {
            return Collections.emptyList();
        }
        return this.dclRecordDTOS;
    }

    @Override
    public void setDclRecordExists(boolean dclRecordExists) {
        this.dclRecordExists = dclRecordExists;
    }

    @Override
    public boolean isDclRecordExists() {
        return this.dclRecordExists;
    }

    @Override
    public boolean isAddAndUpdateDclRecord() {
        return this.addAndUpdateDclRecord;
    }

    @Override
    public void setAddAndUpdateDclRecord(boolean addAndUpdateDclRecord) {
        this.addAndUpdateDclRecord = addAndUpdateDclRecord;
    }

    @Override
    public boolean isUpdateDclRecordList() {
        return "1".equals(this.recordType);
    }

    @Override
    public boolean isUpdateDclPersonList() {
        return "2".equals(this.recordType);
    }
}

